// Dialog Tools
// (c) FiveWin IDE

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function DlgNew()

   local cDlgName
   local nStart := 1

   while File( cDlgName := ( "DIALOG" + SubStr( Str( nStart + 100, 3 ), 2 ) ;
                             + ".scr" ) )
      nStart++
   end

   if ! File( cDlgName )
      DbCreate( cDlgName, { { "CONTROL",  "C", 15, 0 },;
                            { "CAPTION",  "C", 40, 0 },;
                            { "ID",       "N",  4, 0 },;
                            { "TOP",      "N",  4, 0 },;
                            { "LEFT",     "N",  4, 0 },;
                            { "WIDTH",    "N",  4, 0 },;
                            { "HEIGHT",   "N",  4, 0 },;
                            { "STYLE",    "N", 15, 0 },;
                            { "CLRFORE",  "N",  8, 0 },;
                            { "CLRBACK",  "N",  8, 0 } } )
   endif

   DlgOpen( cDlgName )

return nil

//----------------------------------------------------------------------------//

function DlgOpen( cDlgName )

   local oWndDlg, oIco, oBar, oBrw, oBmp
   local cAlias

   DEFAULT cDlgName := cGetFile( "FiveWin IDE Dialog ( *.scr ) | *.scr",;
                                 "Select a Dialog" )

   DEFINE ICON oIco RESOURCE "Dialog"

   if Empty( cDlgName )
      MsgInfo( "I can't find that file!" )
      return nil
   endif

   USE ( cDlgName ) NEW SHARED
   cAlias = Alias()

   if RecCount() > 0
      DEFINE WINDOW oWndDlg PIXEL ;
         FROM ( cAlias )->Top, ( cAlias )->Left TO ;
              ( cAlias )->Top  + ( cAlias )->Height - 1,;
              ( cAlias )->Left + ( cAlias )->Width - 1 ;
         TITLE "Dialog: " + cNoPath( cDlgName ) MDICHILD ;
         ICON oIco COLOR ( cAlias )->ClrFore, ( cAlias )->ClrBack
   else
      DEFINE WINDOW oWndDlg FROM 2, 15 TO 20, 65 ;
         TITLE "Dialog: " + cNoPath( cDlgName ) MDICHILD ;
         ICON oIco
   endif

   oWndDlg:bKeyChar = { | nKey | MsgInfo( Str( nKey ) ) }

   DEFINE BUTTONBAR oBar OF oWndDlg

   DEFINE BUTTON OF oBar RESOURCE "Static" ;
      ACTION LabelAdd( oBmp, .t., cAlias )

   DEFINE BUTTON OF oBar RESOURCE "Btn1" ;
      ACTION BtnAdd( oBmp, .t., cAlias )

   DEFINE BUTTON OF oBar RESOURCE "Check" ;
      ACTION CheckAdd( oBmp, .t., cAlias )

   DEFINE BUTTON OF oBar RESOURCE "ListBox" ;
      ACTION LbxAdd( oBmp, .t., cAlias )

   DEFINE BUTTON OF oBar RESOURCE "Get" ;
      ACTION GetAdd( oBmp, .t., cAlias )

   DEFINE BUTTON OF oBar RESOURCE "Radio" ;
      ACTION RadioAdd( oBmp, .t., cAlias )

   DEFINE BUTTON GROUP OF oBar RESOURCE "Clr" ;
      ACTION oBmp:SelColor()

   DEFINE BUTTON OF oBar RESOURCE "PRG" ;
      ACTION ( oBmp:cGenPRG( "Dlg.prg" ), Tone( 900, 2 ) )

   DEFINE BUTTON GROUP OF oBar RESOURCE "ToDisk" ;
      ACTION lDlgSave( oWndDlg, cAlias )

   @ 0, 0 BITMAP oBmp OF oWndDlg

   oBmp:SetColor( oWndDlg:nClrText, oWndDlg:nClrPane )

   oWndDlg:SetControl( oBmp )

   while ! EoF()
      do case
         case AllTrim( ( cAlias )->Control ) == "TSAY"
              LabelAdd( oBmp, .f., cAlias )

         case AllTrim( ( cAlias )->Control ) == "TBUTTON"
              BtnAdd( oBmp, .f., cAlias )

         case AllTrim( ( cAlias )->Control ) == "TLISTBOX"
              LbxAdd( oBmp, .f., cAlias )
      endcase
      SKIP
   end

   USE

   ACTIVATE WINDOW oWndDlg ;
      VALID lDlgSave( oWndDlg, cAlias )

return nil

//----------------------------------------------------------------------------//

static function LabelAdd( oWnd, lNew, cAlias )

   local oSay

   DEFAULT lNew := .t.

   if lNew
      @ 2, 2 SAY oSay PROMPT "&Label" DESIGN SIZE 70, 28 OF oWnd
   else
      @ ( cAlias )->Top, ( cAlias )->Left SAY oSay PROMPT ( cAlias )->Caption ;
         DESIGN SIZE ( cAlias )->Width, ( cAlias )->Height PIXEL OF oWnd
   endif

   oSay:bRClicked = { || ThisInspect( oSay ) }

return nil

//----------------------------------------------------------------------------//

static function BtnAdd( oWnd, lNew, cAlias )

   local oBtn

   if lNew
      @ 2, 2 BUTTON oBtn PROMPT "&Button" SIZE 80, 27 DESIGN OF oWnd
   else
      @ ( cAlias )->Top, ( cAlias )->Left BUTTON oBtn ;
         PROMPT AllTrim( ( cAlias )->Caption ) ;
         DESIGN SIZE ( cAlias )->Width, ( cAlias )->Height PIXEL OF oWnd
   endif

   oBtn:bRClicked = { || ThisInspect( oBtn ) }

return nil

//----------------------------------------------------------------------------//

static function CheckAdd( oWnd )

   local oCheck
   local lStatus := .f.

   @ 2, 2 CHECKBOX oCheck VAR lStatus PROMPT "&CheckBox" ;
     SIZE 115, 24 COLOR "W+/B" OF oWnd

   oCheck:lDrag = .t.

return nil

//----------------------------------------------------------------------------//

static function LbxAdd( oWnd, lNew, cAlias )

   local oLbx
   local cItem := "One"

   if lNew
      @ 2, 2 LISTBOX oLbx VAR cItem ITEMS { "One", "Two", "Three", "", "", "" } ;
        SIZE 100, 100 DESIGN OF oWnd
   else
      @ ( cAlias )->Top, ( cAlias )->Left LISTBOX oLbx VAR cItem ;
         ITEMS { "One", "Two", "Three", "", "", "" } ;
          SIZE ( cAlias )->Width, ( cAlias )->Height PIXEL DESIGN OF oWnd
   endif

   oLbx:lDrag = .t.

return nil

//----------------------------------------------------------------------------//

static function GetAdd( oWnd )

   local oGet
   local cItem := ""

   @ 2, 2 GET oGet VAR cItem SIZE 115, 24 DESIGN OF oWnd

return nil

//----------------------------------------------------------------------------//

static function RadioAdd( oWnd )

   local nItem := 1

   @ 2, 2 RADIO nItem PROMPT "&One", "Two", "&Three" OF oWnd

return nil

//----------------------------------------------------------------------------//

static function lDlgSave( oWnd, cAlias )

   local n
   local aControls := oWnd:oControl:aControls
   local aPoint

   if MsgYesNo( "Do you wish to save this Dialog ?" )
      USE ( cAlias + ".scr" )
      ZAP

      oWnd:CoorsUpdate()
      ScreenToClient( oWnd:oWnd:oWndClient:hWnd,;
                      aPoint := { oWnd:nTop, oWnd:nLeft } )

      APPEND BLANK
      ( cAlias )->Control = "TDIALOG"
      ( cAlias )->Caption = oWnd:cTitle
      ( cAlias )->Top     = aPoint[ 1 ]
      ( cAlias )->Left    = aPoint[ 2 ]
      ( cAlias )->Width   = oWnd:nRight - oWnd:nLeft
      ( cAlias )->Height  = oWnd:nBottom - oWnd:nTop
      ( cAlias )->Style   = nValToN( oWnd:nStyle )
      ( cAlias )->ClrFore = oWnd:oControl:nClrText
      ( cAlias )->ClrBack = oWnd:oControl:nClrPane

      if aControls != nil
         for n = 1 to Len( aControls )
            aControls[ n ]:CoorsUpdate()
            ScreenToClient( oWnd:oControl:hWnd,;
               aPoint := { aControls[ n ]:nTop, aControls[ n ]:nLeft } )

            APPEND BLANK
            ( cAlias )->Control = aControls[ n ]:ClassName()
            ( cAlias )->Caption = aControls[ n ]:cCaption
            ( cAlias )->Top     = aPoint[ 1 ]
            ( cAlias )->Left    = aPoint[ 2 ]
            ( cAlias )->Width   = aControls[ n ]:nRight - aControls[ n ]:nLeft
            ( cAlias )->Height  = aControls[ n ]:nBottom - aControls[ n ]:nTop
            ( cAlias )->Style   = nValToN( aControls[ n ]:nStyle )
            ( cAlias )->ClrFore = nValToN( aControls[ n ]:nClrText )
            ( cAlias )->ClrBack = nValToN( aControls[ n ]:nClrPane )
         next
      endif

      USE
   endif

return .t.    // Close the Window

//----------------------------------------------------------------------------//

static function nValToN( uVal ) ; return If( ValType( uVal ) != "N", 0, uVal )

//----------------------------------------------------------------------------//
