#include "FiveWin.ch"

static aDDEs := {}

static nLastMsg

//----------------------------------------------------------------------------//

CLASS TDde

   DATA   nService, nTopic, nItem
   DATA   bAction
   DATA   oWndServer

   METHOD New( cService, cTopic, cItem, bAction ) CONSTRUCTOR
   METHOD Activate()
   METHOD Execute( cCommand )

   METHOD End() INLINE ::oWndServer:PostMsg( WM_DDE_TERMINATE )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( cService, cTopic, cItem, bAction ) CLASS TDde

   ::nService = GlobalAddAtom( cService )
   ::nTopic   = GlobalAddAtom( cTopic )
   ::nItem    = GlobalAddAtom( cItem )
   ::bAction  = bAction

   AAdd( aDDEs, Self )

return nil

//----------------------------------------------------------------------------//

METHOD Activate() CLASS TDde

   nLastMsg = WM_DDE_INITIATE

   SendMessage( -1, WM_DDE_INITIATE, GetActiveWindow(),;
                nMakeLong( ::nService, ::nTopic ) )

return nil

//----------------------------------------------------------------------------//

METHOD Execute( cCommand ) CLASS TDde

   nLastMsg = WM_DDE_EXECUTE

   ::oWndServer:PostMsg( WM_DDE_EXECUTE, GetActiveWindow(),;
                         DdeCommand( cCommand ) )
   SysRefresh()

return nil

//----------------------------------------------------------------------------//

function DdeAck( hWndServer, nLParam )

   local nService, nTopic
   local nDde, oDde

   do case
      case nLastMsg == WM_DDE_INITIATE
           nService = nLoWord( nLParam )
           ATail( aDDEs ):oWndServer = TWindow()
           ATail( aDDEs ):oWndServer:hWnd = hWndServer

      case nLastMsg == WM_DDE_EXECUTE
           DdeGetCommand( nLParam )
   endcase

return nil

//----------------------------------------------------------------------------//
