#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

BOOL pascal Ctl3dRegister( HANDLE hInstance );
BOOL pascal Ctl3dAutoSubClass( HANDLE hInstance );
BOOL pascal Ctl3dUnregister( HANDLE hInstance );

extern void _fwAddTerminator( PCLIPFUNC );  // FiveWin internal.

extern HANDLE __hInstance;

static BOOL bInstaled;

static BYTE bRegisterTerminator = FALSE;

//----------------------------------------------------------------------------//

static CLIPPER UnInstall( void )
{
   if( bInstaled )
   {
       Ctl3dUnregister( __hInstance );
       bInstaled = FALSE;
   }
}

//---------------------------------------------------------------------------//

static void CheckTerminator( void )
{
    if( ! bRegisterTerminator )
    {
        bRegisterTerminator = TRUE;
        _fwAddTerminator( UnInstall );
    }
}

//---------------------------------------------------------------------------//

static CLIPPER Install( void )
{
   if( ! bInstaled )
   {
       bInstaled = TRUE;
       Ctl3dRegister( __hInstance );
       Ctl3dAutoSubClass( __hInstance );
       CheckTerminator();
   }
}

//---------------------------------------------------------------------------//

CLIPPER Set3DLook()
{
   _retl( bInstaled );

   if( _parl( 1 ) )
   {
       Install();
   }
   else if( PCOUNT() )
   {
       UnInstall();
   }
   
}

//----------------------------------------------------------------------------//

/*

CLIPPER CTL3DREGIS()    // TER()
{
   _retl( Ctl3dRegister( __hInstance ) );
}

CLIPPER CTL3DUNREG()    // ISTER()
{
   _retl( Ctl3dUnregister( __hInstance ) );
}

CLIPPER CTL3DAUTOS()    // UBCLASS()
{
   _retl( Ctl3dAutoSubClass( __hInstance ) );
}

*/

//----------------------------------------------------------------------------//
