#include "FiveWin.ch"

#define CF_TEXT              1
#define CF_BITMAP            2
#define CF_METAFILEPICT      3
#define CF_SYLK              4
#define CF_DIF               5
#define CF_TIFF              6
#define CF_OEMTEXT           7
#define CF_DIB               8
#define CF_PALETTE           9
#define CF_PENDATA          10
#define CF_RIFF             11
#define CF_WAVE             12

//----------------------------------------------------------------------------//

CLASS TClipBoard

   DATA   nFormat, oWnd

   METHOD New( nFormat, oWnd ) CONSTRUCTOR

   METHOD Clear()   INLINE  ::Open(), ::Empty(), ::Close()
   METHOD Open()    INLINE  OpenClipboard( ::oWnd:hWnd )
   METHOD Empty()   INLINE  EmptyClipboard()
   METHOD Close()   INLINE  CloseClipboard()

   METHOD SetData( uData ) INLINE  SetClipboardData( ::nFormat, uData )

   METHOD GetData() INLINE  GetClpData( ::nFormat )

   METHOD SetText( cText )
   METHOD GetText()

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nFormat, oWnd ) CLASS TClipBoard

   DEFAULT nFormat := CF_TEXT

   ::nFormat = nFormat
   ::oWnd    = oWnd

return nil

//----------------------------------------------------------------------------//

METHOD SetText( cText ) CLASS TClipBoard

   local lResult := .f.

   if ::Open()
      lResult = SetClipboardData( CF_TEXT, cText )
      lResult = ::Close() .and. lResult
   endif

return lResult

//----------------------------------------------------------------------------//

METHOD GetText() CLASS TClipBoard

   local cText := ""

   if ::Open()
      cText = GetClpData( CF_TEXT )
      ::Close()
   endif

return cText

//----------------------------------------------------------------------------//
