#include "FiveWin.ch"

//----------------------------------------------------------------------------//

CLASS TButton FROM TControl

   DATA   bAction

   METHOD New( nRow, nCol, cCaption, oWnd, bAction, nWidth, nHeight,;
               nHelpId, oFont, lDefault, lPixel, lDesign ) CONSTRUCTOR

   METHOD ReDefine( nId, bAction, oWnd, nHelpId ) CONSTRUCTOR

   METHOD Click() INLINE If( ::bAction != nil, Eval( ::bAction ),)

   METHOD cGenPRG()

   METHOD MouseMove( nRow, nCol, nKeyFlags ) INLINE ;  // Standard Behavior
                     Super:MouseMove( nRow, nCol, nKeyFlags ), nil

   METHOD cToChar() INLINE Super:cToChar( "BUTTON" )

   METHOD Colors( hDC ) INLINE  0

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, cCaption, oWnd, bAction, nWidth, nHeight, ;
            nHelpId, oFont, lDefault, lPixel, lDesign ) CLASS TButton

   DEFAULT cCaption := "&Button",;
           oFont    := TFont():New( "System", 7, 10 ),;
           nWidth   := ( Len( cCaption ) + 2 ) * oFont:nWidth,;
           nHeight  := oFont:nHeight + Int( oFont:nHeight / 4 ),;
           nHelpId  := 100,;
           lDefault := .f., lPixel := .f., lDesign := .f.

   ::cCaption  = cCaption
   ::nTop      = nRow * If( ! lPixel, ( oFont:nHeight + Int( oFont:nHeight / 4 ) ), 1 )
   ::nLeft     = nCol * If( ! lPixel, oFont:nWidth, 1 )
   ::nBottom   = ::nTop  + nHeight
   ::nRight    = ::nLeft + nWidth
   ::nHelpId   = nHelpId
   ::bAction   = bAction
   ::oWnd      = oWnd
   ::oFont     = oFont
   ::nStyle    = nOR( WS_CHILD, WS_VISIBLE, WS_TABSTOP,;
                     If( lDefault, BS_DEFPUSHBUTTON, 0 ),;
                     If( lDesign, WS_THICKFRAME, 0 ) )
   ::nId       = ::GetNewId()
   ::lDrag     = lDesign
   ::lCaptured = .f.

   if oWnd:lVisible
      ::Create( "BUTTON" )
      oWnd:AddControl( Self )
   else
      oWnd:DefControl( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, bAction, oWnd, nHelpId ) CLASS TButton

   ::nId       = nId
   ::bAction   = bAction
   ::hWnd      = 0
   ::nHelpId   = nHelpId
   ::oWnd      = oWnd
   ::lCaptured = .f.
   ::lDrag     = .f.

   oWnd:DefControl( Self )

return nil

//----------------------------------------------------------------------------//

METHOD cGenPRG() CLASS TButton

   local cPrg := ""

   ::CoorsUpdate()

   cPrg += CRLF + ;
           "   @ " + Str( ::nTop, 3 ) + ", " + Str( ::nLeft, 3 ) + ;
           ' BUTTON "' + ::cCaption + '" SIZE ' + ;
           Str( ::nRight - ::nLeft + 1, 3 ) + ", " + ;
           Str( ::nBottom - ::nTop + 1, 3 ) + ;
           " PIXEL OF oWnd ;" + CRLF + ;
           '      ACTION MsgInfo( "Not defined yet!" )' + CRLF

return cPrg

//----------------------------------------------------------------------------//
