#include "FiveWin.ch"

static lRegistered := .f.

#define BAR_HEIGHT  28
#define GRAY_BRUSH   2

#define BAR_TOP      1
#define BAR_LEFT     2
#define BAR_RIGHT    3
#define BAR_ADJUST   4

//----------------------------------------------------------------------------//

CLASS TBar FROM TControl

   DATA   aButtons, nGroups, nMode
   DATA   nBtnWidth, nBtnHeight
   DATA   l3D

   METHOD New( oWnd, nBtnWidth, nBtnHeight, l3D, cMode, oCursor ) CONSTRUCTOR

   METHOD Add( oBtnBmp ) INLINE  AAdd( ::aButtons, oBtnBmp )

   METHOD Adjust() INLINE  BarAdjust( ::hWnd, ::nMode, ::oWnd:oMsgBar != nil )

   METHOD AdjMode() INLINE ::nMode := BAR_ADJUST,;
                            ::SetCoors( TRect():New( -1, -1,;
                            ::oWnd:nBottom + 1, ::oWnd:nRight + 1 ) )

   METHOD Click( hCtrl )

   METHOD cGenPRG()
   METHOD GetBtnTop( lNewGroup )
   METHOD GetBtnLeft( lNewGroup )
   METHOD HandleEvent( nMsg, nWParam, nLParam )

   METHOD LeftMode() INLINE ::nMode := BAR_LEFT,;
                            ::SetCoors( TRect():New( -1, -1,;
                            ::oWnd:nBottom + 1, ::nBtnWidth - 1 ) )

   METHOD MouseMove( nRow, nCol, nKeyFlags ) INLINE ;
                     Super:MouseMove( nRow, nCol, nKeyFlags ),;
                     ::SetMsg( "" ), ResetMsg( 0 ), 0

   METHOD Paint()

   METHOD RightMode() INLINE ::nMode := BAR_RIGHT,;
                             ::SetCoors( TRect():New( -1,;
                             ::oWnd:nRight - ::nBtnWidth - 1,;
                             ::oWnd:nBottom + 1, ::oWnd:nRight ) )

   METHOD SetMsg( cText )

   METHOD TopMode() INLINE ::nMode := BAR_TOP,;
                           ::SetCoors( TRect():New( -1, -1,;
                           ::nBtnHeight + 1, ::oWnd:nRight + 1 ) )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( oWnd, nBtnWidth, nBtnHeight, l3D, cMode, oCursor ) CLASS TBar

   local oRect := oWnd:GetCliRect()

   DEFAULT nBtnWidth := BAR_HEIGHT, nBtnHeight := BAR_HEIGHT,;
           l3D := .f., cMode := "TOP"

   ::nStyle     = nOR( WS_BORDER, WS_CHILD, WS_VISIBLE )
   ::aButtons   = {}
   ::nGroups    = 0
   ::oWnd       = oWnd
   ::nTop       = -1
   ::nLeft      = If( cMode == "RIGHT", oRect:nRight - nBtnWidth, -1 )
   ::nBottom    = If( cMode == "TOP", nBtnHeight, oRect:nBottom + 1 )
   ::nRight     = If( cMode == "TOP" .or. cMode == "ADJUST",;
                      oRect:nRight,;
                  If( cMode == "LEFT", nBtnWidth - 1, oRect:nRight + 1 ) )
   ::nBtnWidth  = nBtnWidth
   ::nBtnHeight = nBtnHeight
   ::nId       = ::GetNewId()
   ::lDrag     = .f.
   ::lCaptured = .f.
   ::nClrPane  = If( l3D, CLR_LIGHTGRAY, CLR_GRAY )
   ::lVisible  = .t.
   ::l3D       = l3D
   ::nMode     = AScan( { "TOP", "LEFT", "RIGHT", "ADJUST" }, cMode )

   ::oBrush    = TBrush():New( ,::nClrPane, )
   ::oCursor   = oCursor

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW, CS_GLOBALCLASS ) )
      lRegistered = .t.
   endif

   ::Create()

   if oWnd != nil
      oWnd:oBar = Self
   endif

return Self

//----------------------------------------------------------------------------//

METHOD Click( hCtrl ) CLASS TBar

   AEval( ::aButtons, { | oBtn | If( oBtn:hWnd == hCtrl, oBtn:Click(),) } )

return nil

//----------------------------------------------------------------------------//

METHOD cGenPRG() CLASS TBar

   local cPrg := ""
   local n

   cPrg += CRLF + CRLF + "   DEFINE BUTTONBAR oBar OF oWnd"

   for n = 1 to Len( ::aButtons )
      cPrg += ::aButtons[ n ]:cGenPRG()
   next

return cPrg

//----------------------------------------------------------------------------//

METHOD GetBtnLeft( lNewGroup ) CLASS TBar

   local nPos := 0

   do case
      case ::nMode == BAR_TOP
           nPos = ( Len( ::aButtons ) * ::nBtnWidth ) - 1 + ;
                  If( lNewGroup, ++::nGroups, ::nGroups ) * 15 + ;
                  If( ::l3D, 2, 0 )

      case ::nMode == BAR_LEFT
           nPos = -1 + If( ::l3D, 2, 0 )

      case ::nMode == BAR_RIGHT
           nPos = ::nLeft - If( ::l3D, 2, 0 )

      case ::nMode == BAR_ADJUST
           nPos = If( Len( ::aButtons ) > 0,;
                  If( ATail( ::aButtons ):nRight + ::nBtnWidth > ::nRight,;
                      -1, ( Len( ::aButtons ) * ::nBtnWidth ) - 1 ), -1 )
   endcase

return nPos

//----------------------------------------------------------------------------//

METHOD GetBtnTop( lNewGroup ) CLASS TBar

   local nPos := 0

   do case
      case ::nMode == BAR_TOP
           nPos = If( ::l3D, 2, -1 )

      case ::nMode == BAR_LEFT .or. ::nMode == BAR_RIGHT
           nPos = ( Len( ::aButtons ) * ( ::nBtnHeight + 1 ) ) - 1 + ;
                  If( lNewGroup, ++::nGroups, ::nGroups ) * 15 + ;
                  If( ::l3D, 3, 0 )
   endcase

return nPos

//----------------------------------------------------------------------------//

METHOD HandleEvent( nMsg, nWParam, nLParam ) CLASS TBar

     do case
        case nMsg == WM_LBUTTONDOWN
             return ::Click( nWParam )

        case nMsg == WM_PAINT
             ::BeginPaint()
             ::Paint()
             ::EndPaint()
             return 0

        otherwise
             return Super:HandleEvent( nMsg, nWParam, nLParam )
     endcase

return nil

//----------------------------------------------------------------------------//

METHOD SetMsg( cText ) CLASS TBar

   if ::oWnd != nil
      if ::oWnd:oWnd != nil
         ::oWnd:oWnd:SetMsg( cText )
      else
         ::oWnd:SetMsg( cText )
      endif
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Paint() CLASS TBar

   if ! ::l3D
      Super:Paint()
   else
      WndRaised( ::hWnd, ::GetDC() )
      ::ReleaseDC()
   endif

return nil

//----------------------------------------------------------------------------//
