/*
** Program fdb - family tree database generation and manipulation
**
** Copyright (C) 1994 Andy Burrows 
**
**            email: cadellin@corum.me.man.ac.uk (130.88.29.14)
**
** This program is free software; you can redistribute it and/or modify it
** under the terms of the GNU General Public Licence as published by the Free
** Software Foundation; either version 1, or any later version.
** 
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
** or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
** more details. It should be included in this distribution in a file 
** called COPYING
**
*/


/*
   this file contains the callback functions for the choice selections 
*/

/*#define DEBUG */

/* standard headers */

#include <stdio.h>
#include <sys/times.h>
#ifndef SYSV
#include <sys/timeb.h>
#endif

/* XView headers */

#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/font.h>

/* fdb database definitions header */

#include "definitions.h"

/* title choice callback */

void title_chosen(item, value, event)
Panel_item    item;
int           value;
Event        *event;
{

/*
    copy the entered text to the title field of the current person
*/

strcpy(entry[current_index]->title, titles[value]);

/* set the default file menu selection to save since something has changed */

xv_set(file_menu, MENU_DEFAULT, 3, NULL);

#ifdef DEBUG
printf("item %d selected; title set to **%s**\n",value,entry[current_index]->title);
#endif
}

/* add spaces choice callback */

void add_spaces_chosen(item, value, event)
Panel_item    item;
int           value;
Event        *event;
{

/*
   set the flag appropriately
*/

leave_spaces_in_output = value;

}

/* gender choice callback */

void gender_chosen(item, value, event)
Panel_item    item;
int           value;
Event        *event;
{
static int            initialise = 1;
static double         last_time = 0.0;
double                this_time;
double                elapsed_secs;
#ifdef SYSV
struct tms            tms_buf;
#else
static struct timeb   timeb_old_buf;
struct timeb          timeb_buf;
#endif

/* 
   this code added after a report of apparent mouse click bounces
   causing selection and the immediate deselection!
   so if the last selection was too recent, just return 
*/

#ifdef SYSV  /* if system V then use gethrtime function... */

/* find the time with the gethrtime function (returns value in nanoseconds) */
this_time = (double) gethrtime();
elapsed_secs = ((this_time - last_time))/1000000000.0;
last_time = this_time;

#else /* ...otherwise assumes BSD and uses ftime */

/* find the time with the ftime function (returns a timeb struct) */
if(ftime(&timeb_buf) == -1)
    printf("ftime error!\n"); 
if(!initialise)
    {
    elapsed_secs = ((double) (timeb_buf.time - timeb_old_buf.time)) + 
                   (((double) timeb_buf.millitm) - 
                    ((double) timeb_old_buf.millitm))/1000.;
    }
else
    {
    elapsed_secs = 1.0;
    initialise = 0;
    }
timeb_old_buf = timeb_buf;
#endif

#ifdef DEBUG
printf("elapsed value: %f\n",elapsed_secs);
#endif

/* if the last selection was too recent, return */

if(elapsed_secs < MULTICLICK_TOLERANCE)
    {
#ifdef DEBUG
    printf("apparent double click ignored\n");
#endif
    return;
    }

/* set the gender variable */

entry[current_index]->gender = value;

/* set the default file menu selection to save since something has changed */

xv_set(file_menu, MENU_DEFAULT, 3, NULL);

/* 
   if gender is male, deselect the maiden name choice option
   otherwise select it if the marriage date field is not empty
 */

if(entry[current_index]->gender == 0)
    {
    xv_set(maiden_name_text, PANEL_INACTIVE, TRUE, NULL);
    }
else
    {
    if(entry[current_index]->marriage_date[0] != '\0')
        {
        xv_set(maiden_name_text, PANEL_INACTIVE, FALSE, NULL);
        }
    }


#ifdef DEBUG
printf("gender set to %d\n",entry[current_index]->gender);
#endif
}

/* status choice callback */

void status_chosen(item, value, event)
Panel_item    item;
int           value;
Event        *event;
{
static int            initialise = 1;
static double         last_time = 0.0;
double                this_time;
double                elapsed_secs;
#ifdef SYSV
struct tms            tms_buf;
#else
static struct timeb   timeb_old_buf;
struct timeb          timeb_buf;
#endif

/* 
   this code added after a report of apparent mouse click bounces
   causing selection and the immediate deselection!
   so if the last selection was too recent, just return 
*/

#ifdef SYSV  /* if system V then use gethrtime function... */

/* find the time with the gethrtime function (returns value in nanoseconds) */
this_time = (double) gethrtime();
elapsed_secs = ((this_time - last_time))/1000000000.0;
last_time = this_time;

#else /* ...otherwise assumes BSD and uses ftime */

/* find the time with the ftime function (returns a timeb struct) */
if(ftime(&timeb_buf) == -1)
    printf("ftime error!\n"); 
if(!initialise)
    {
    elapsed_secs = ((double) (timeb_buf.time - timeb_old_buf.time)) + 
                   (((double) timeb_buf.millitm) - 
                    ((double) timeb_old_buf.millitm))/1000.;
    }
else
    {
    elapsed_secs = 1.0;
    initialise = 0;
    }
timeb_old_buf = timeb_buf;
#endif

#ifdef DEBUG
printf("elapsed value: %f\n",elapsed_secs);
#endif

/* if the last selection was too recent, return */

if(elapsed_secs < MULTICLICK_TOLERANCE)
    {
#ifdef DEBUG
    printf("apparent double click ignored\n");
#endif
    return;
    }

/* set the status variable */

entry[current_index]->status = value;

/* set the default file menu selection to save since something has changed */

xv_set(file_menu, MENU_DEFAULT, 3, NULL);

/* 
   if status is living, deactivate the death date and place,
   the resting place and the death source fields otherwise activate them
 */

if(entry[current_index]->status == LIVING)
    {
    xv_set(death_date_text, PANEL_INACTIVE, TRUE, NULL);
    xv_set(death_place_text, PANEL_INACTIVE, TRUE, NULL);
    xv_set(resting_place_text, PANEL_INACTIVE, TRUE, NULL);
    xv_set(death_source_text, PANEL_INACTIVE, TRUE, NULL);
    }
else
    {
    xv_set(death_date_text, PANEL_INACTIVE, FALSE, NULL);
    xv_set(death_place_text, PANEL_INACTIVE, FALSE, NULL);
    xv_set(resting_place_text, PANEL_INACTIVE, FALSE, NULL);
    xv_set(death_source_text, PANEL_INACTIVE, FALSE, NULL);
    }


#ifdef DEBUG
printf("status set to %d\n",entry[current_index]->status);
#endif
}

/* selection of output format callback */

void output_type_chosen(item, value, event)
Panel_item    item;
int           value;
Event        *event;
{

/*
    set the value of output_type_flag appropriately
    and activate or deactivate the descent line and 
    descendants tree plot menu selection items as 
    appropriate
*/

if(value == 0)
    {
    output_type_flag = POSTSCRIPT;
    xv_set(plot_des_line_item, MENU_INACTIVE, FALSE, NULL);
    xv_set(plot_gen_tree_item, MENU_INACTIVE, FALSE, NULL);
    }
else
    {
    output_type_flag = LATEX;
    xv_set(plot_des_line_item, MENU_INACTIVE, TRUE, NULL);
    xv_set(plot_gen_tree_item, MENU_INACTIVE, TRUE, NULL);
    }
}

/* "use all available generations in descent line plot" check box callback */

void use_all_gen(item, value, event)
Panel_item    item;
int           value;
Event        *event;
{
/*
   set the flag appropriately
*/

if(value == 1)
    {
    /* save the old value for when "all available" is deselected */
    old_max_gen_generations = max_gen_generations;
    max_gen_generations = MAX_INDICES;
    /* deactivate the slider */
    xv_set(descent_depth_slider, PANEL_INACTIVE, TRUE, NULL);
    }
else
    {
    /* reset the depth to the value before "all available" was selected */
    max_gen_generations = old_max_gen_generations;
    /* reactivate the slider */
    xv_set(descent_depth_slider, PANEL_INACTIVE, FALSE, NULL);
    }
}

/* "use all available generations in descendants tree plot" check box callback */

void use_all_des(item, value, event)
Panel_item    item;
int           value;
Event        *event;
{
/*
   set the flag appropriately
*/

if(value == 1)
    {
    /* save the old value for when "all available" is deselected */
    old_max_des_generations = max_des_generations;
    max_des_generations = MAX_INDICES;
    /* deactivate the slider */
    xv_set(descendants_depth_slider, PANEL_INACTIVE, TRUE, NULL);
    }
else
    {
    /* reset the depth to the value before "all available" was selected */
    max_des_generations = old_max_des_generations;
    /* reactivate the slider */
    xv_set(descendants_depth_slider, PANEL_INACTIVE, FALSE, NULL);
    }
}

