/*
** Program fdb - family tree database generation and manipulation
**
** Copyright (C) 1994 Andy Burrows 
**
**            email: cadellin@corum.me.man.ac.uk (130.88.29.14)
**
** This program is free software; you can redistribute it and/or modify it
** under the terms of the GNU General Public Licence as published by the Free
** Software Foundation; either version 1, or any later version.
** 
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
** or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
** more details. It should be included in this distribution in a file 
** called COPYING
**
*/


/*
   this file contains the callback functions for the buttons
*/

/*#define DEBUG */

/* standard headers */

#include <stdio.h>

/* XView headers */

#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/font.h>

/* fdb database definitions */

#include "definitions.h"

/*
   "cancel the load operation" button
*/

void  cancel_load_from(item, event)
Panel_item   item;
Event       *event;
{
Xv_object   return_code;

/* unshow the "Load From" window */

if((return_code = xv_set(load_frame, XV_SHOW, FALSE, NULL)) != XV_OK)
    {
    printf("unable to unshow the 'Load From' window\n");
    }
}

/*
   "cancel the save operation" button
*/

void  cancel_save_as(item, event)
Panel_item   item;
Event       *event;
{
Xv_object   return_code;

/* unshow the "Save as" window */

if((return_code = xv_set(save_frame, XV_SHOW, FALSE, NULL)) != XV_OK)
    {
    printf("unable to unshow the 'Save as' window\n");
    }
}

/*
   "cancel selection operation" button
*/

void  cancel_selection(item, event)
Panel_item   item;
Event       *event;
{
Xv_object   return_code;

/* unshow the "Select Entry" window */

if((return_code = xv_set(entries_frame, XV_SHOW, FALSE, NULL)) != XV_OK)
    {
    printf("unable to unshow the 'Select Entry' window\n");
    }
}

/*
   "dismiss error message display" button
*/

void  dismiss_error_frame(item, event)
Panel_item   item;
Event       *event;
{
Xv_object   return_code;

/* unshow the "Error Message Display" window */

#ifdef DEBUG
printf("in Dismiss Error Message callback\n");
#endif

if((return_code = xv_set(error_frame, XV_SHOW, FALSE, NULL)) != XV_OK)
    {
    printf("unable to unshow the 'Error Message Display' window\n");
    }
}

/*
   "dismiss settings menu display" button
*/

void  dismiss_settings_frame(item, event)
Panel_item   item;
Event       *event;
{
Xv_object   return_code;

/* unshow the "Settings Menu Display" window */

#ifdef DEBUG
printf("in Settings Menu Dismiss callback\n");
#endif

if((return_code = xv_set(settings_frame, XV_SHOW, FALSE, NULL)) != XV_OK)
    {
    printf("unable to unshow the 'Settings Menu Display' window\n");
    }
}

/*
   "dismiss descent display" button
*/

void  dismiss_gen_frame(item, event)
Panel_item   item;
Event       *event;
{
Xv_object   return_code;

/* unshow the "Descent Display" window */

#ifdef DEBUG
printf("in Dismiss Descent Display callback\n");
#endif

if((return_code = xv_set(gen_frame, XV_SHOW, FALSE, NULL)) != XV_OK)
    {
    printf("unable to unshow the 'Descent Display' window\n");
    }
}

/*
   "dismiss descendants display" button
*/

void  dismiss_des_frame(item, event)
Panel_item   item;
Event       *event;
{
Xv_object   return_code;

/* unshow the "Descendants Display" window */

#ifdef DEBUG
printf("in Dismiss Descendants Display callback\n");
#endif

if((return_code = xv_set(des_frame, XV_SHOW, FALSE, NULL)) != XV_OK)
    {
    printf("unable to unshow the 'Descendants Display' window\n");
    }
}

/*
   "display the current person's mother" button
*/

void  display_mother(item, event)
Panel_item   item;
Event       *event;
{
/* update the text entries before a change of current person */

update_text();

/* set the mother to be the new current person */

current_index = entry[current_index]->mother;

/* set the default file menu selection to save since something has changed */

xv_set(file_menu, MENU_DEFAULT, 3, NULL);

/* load the new current persons info into all the display entries */

update_panel_items();

}

/*
   "display the current person's father" button
*/

void  display_father(item, event)
Panel_item   item;
Event       *event;
{

/* update the text entries before a change of current person */

update_text();

/* set the father to be the new current person */

current_index = entry[current_index]->father;

/* set the default file menu selection to save since something has changed */

xv_set(file_menu, MENU_DEFAULT, 3, NULL);

/* load the new current persons info into all the display entries */

update_panel_items();

}

