
PROGRAM NAME2NUM;

uses Dos;

var
  ThisFile         : File;
  NewName          : string;
  BigPath, NewPath : PathStr;
  Dir, NewDir      : DirStr;
  Name             : NameStr;
  Ext              : ExtStr;
  LengthNewPath    : Integer;
  NewDirEnd        : String[1];
  Suffix, i        : Integer;
  FileRec          : SearchRec;
  Ex               : string[3];
  Err              : word;

Const
        note : String[55] =
               ' Compiled by David Adamson for the BatPower conference';

{$I IOERROR.psl}

Procedure Help;
begin
  if ParamCount = 0 then
    begin
    writeln;
    writeln(' NAME2NUM renames any file to a new extension name of 001 to 999.');
    writeln(' Usage is "NAME2NUM [drive][path]filename.exe [drive][new_path]" ');
    writeln(' where filename.exe is the name of the file to be renamed. ');
    writeln(' [drive][new_path] is optional, and moves the file to a new directory. ');
    writeln(' Drive letters must match - wild cards are not supported. ');
    Halt(255);
    end;
end;

Begin
 If ParamCount = 0 then Help;
 { else begin }

   BigPath:=ParamStr(1);
   NewPath:=ParamStr(2);
   Assign(ThisFile,BigPath);
   FSplit(BigPath,Dir,Name,Ext);

   if (ParamCount = 2)  and (ParamStr(2) <> '') then
      begin
       Dir := ParamStr(2);
       LengthNewPath := Length(ParamStr(2));
       NewDirEnd := copy(ParamStr(2), LengthNewPath,1);
       if (NewDirEnd <> '\') then
       Dir := ParamStr(2) + '\';
      end;
   Suffix := 0;
   repeat
     Suffix := Succ(Suffix);
     Str(Suffix, ex);
     if length(ex) = 1 then ex := '0'+ '0' + ex;
     if length(ex) = 2 then ex := '0' + ex;
     NewName:= Dir + Name + '.'+ ex;
     FindFirst(NewName,AnyFile,FileRec);
   until (DosError <> 0) or (Suffix = 999);
   {$I-}
      Rename(ThisFile,NewName);
   {$I+}
   Err := IOerror;
   if Err = 0 then writeln(#13,#10,'New Name: ',FExpand(NewName));
   Halt(Err);
   note := note;
End.


