/*
	Program:   ICBM - Installation script
	Copyright: KnowWare Computer Products (c) 1993 all rights reserved
	Author:    Grant Cause

	Purpose:   Installs ICBM OS/2 boot-up as part of config.sys

	Creation Date:  10/1/94
	Last Updated:   10/1/94
*/
trace 'O'								/* Initialization */
address CMD
Call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
Call sysloadfuncs

ProgName = "ICBM"						/* Package to install */
BootDrive = Substr(Translate(Value('PATH',,'OS2ENVIRONMENT')),Pos('\OS2\SYSTEM',Translate(Value('PATH',,'OS2ENVIRONMENT')))-2,2)
ConfPath=BootDrive||'\'||"Config.Sys"	/* Full Path to Config.sys file */
ConfBack=BootDrive||'\'||"Config.Bak"	/* Full Path to Config.Bak */
InstPath=BootDrive||'\'||"OS2\APPS"		/* Full install Path */
IniPath=BootDrive||'\'					/* Full Path to install INI file */
CmdPath=BootDrive||"\OS2\CMD.EXE"		/* Full Path to OS/2 CMD.EXE */

Main:
  Call DisplayAdvert
  MenuChoice = ''
  do until MenuChoice == "4"
    MenuOption="Installation Menu"
    Call DisplayMenu
    parse Upper Pull MenuChoice
    if MenuChoice == '1' then do
      MenuOption="Display Documentation"
      Call ReadMe
    end
    if MenuChoice == '2' then do
      MenuOption="Installation"
      Call Install
    end
    if MenuChoice == '3' then do
      MenuOption="Registration"
      Call Register
    end
  end
  Call QuitInstall			    		/* Display final message */
  exit 0

DisplayMenu:
  Call DisplayTitle
  say ""
  say "                        1.  Read" ProgName "Documentation"
  say ""
  say "                        2.  Install" Progname
  say ""
  say "                        3.  Register" Progname
  say ""
  say "                        4.  Quit"
  say ""
  say ""
  say "Please enter your choice:"
  return

ReadMe:										/* Read Documentation */
  'attrib icbm.doc +r'
  'e.exe icbm.doc'
  return

Install:									/* Installation procedure */
  do until response == 'Y'
    Call DisplayInfo						/* Verify default paths */
    if response == 'Y' then do
      if ConfPath == '' then do
        say "Path to Config.Sys file must be defined!"
        response="N"
        '@pause'
      end
      if InstPath == '' then do
        say "Installation path must be defined!"
        response="N"
        '@pause'
      end
    end
    if response == 'N' then do
      Call DisplayTitle
      Call GetBootDrive						/* Obtain installation drive */
      Call GetCmdPath						/* Obtain OS/2 Command Interpreter*/
      IniPath=BootDrive||'\'				/* Full Path to install INI file */
      ConfPath=BootDrive||'\'||"Config.Sys"	/* Full Path to Config.Sys */
      ConfBack=BootDrive||'\'||"Config.Bak"	/* Full Path to Config.Bak */
      Call GetInstallPath					/* Obtain installation path */
      response="N"
    end
  end
  Call DisplayTitle
  say "About to install" ProgName "to" InstPath
  say ""
  say "Do you wish to continue ? (Y/N)"
  parse Upper Pull response
  if response == 'Y' then do
    Call InstallIt
  end
  return

GetInstallPath:							/* Obtain installation path */
  Call DisplayTitle
  say "Enter the fully qualified path where" ProgName "should be placed,"
  say "ie" BootDrive"\OS2\APPS or leave blank to place in root directory of" BootDrive
  say ""
  say "Place" ProgName "in: "
  parse Upper Pull intpath
  InstPath=intpath
  if intpath == '' then do
    InstPath=BootDrive||'\'
  end
  if intpath <> '' then do
    if Substr(intpath,1,1) <> '\' then do
       if Substr(intpath, 3, 1) <> '\' then do
         InstPath='\'||intpath
       end
    end
    if Substr(InstPath, 2, 1) <> ':' then do
      InstPath=BootDrive||InstPath
    end
  end
  return

DisplayInfo:
  Call DisplayTitle
  say "Full path to Config.Sys is:" ConfPath
  say "Your original Config.Sys will be saved as:" ConfBack
  say ProgName "will be installed in: " InstPath
  say ProgName "default INI file will be installed in:" IniPath
  say "Your OS/2 Command Interpreter is:" CmdPath
  say ""
  say "Is this correct? (Y/N)"
  parse Upper Pull response
  return

InstallIt:					/* Install programs */
  Call DisplayTitle
  say "Installing files please wait..."
  'md ' InstPath ' 1>nul 2>nul'
  'copy icbm.exe ' InstPath ' 1>nul'
  if rc <> 0 then do
    say "Problem copying" ProgName "files to" InstPath
    Call Abort
    return
  end
  say "Installing" ProgName "default INI file will be installed in" IniPath
  say "This may be edited using any ASCII text editor."
  'copy icbm.ini ' IniPath ' 1>nul'
  if rc <> 0 then do
    say "Problem copying" ProgName "default INI file to" IniPath
    Call Abort
    return
  end
  Call UpdateConf
  say "Installation sucessfull."
  '@pause'
  return

QuitInstall:										/* Installation complete */
  Call DisplayTitle
  say "  Please edit " IniPath " to suit your system before using " ProgName"."
  say ""
  say "  If you enjoy using this shareware product, then please do not forget"
  say "  to register.  Select the "Register" option menu, or print and fill"
  say "  out the" ProgName".REG file. And send it to:-"
  Call DisplayAddress
  return

Abort:												/* Abort installation */
  say "Installation aborted.  Nothing installed."
  '@pause'
  return

UpdateConf:											/* Update Config.Sys file */
  say "Creating" ConfBack "please wait..."
  'copy ' ConfPath ConfBack ' 1>nul'
  say "Updating" ConfPath "please wait..."
  ConfNew=BootDrive||"\Config.ICB"			/* Full Path to temp Config.Sys */
  ProgPath=InstPath||'\'||ProgName||".EXE"	/* Full Path to ICBM.EXE */
  'echo REM > ICBM.SYS'
  'echo REM' ProgName 'Install >> ICBM.SYS'
  'echo REM >> ICBM.SYS'
  'echo CALL='CmdPath '/C "'ProgPath'" >> ICBM.SYS'
  'copy ' ConfPath'+ICBM.SYS' ConfNew ' 1>nul'
  'copy ' ConfNew ConfPath ' 1>nul'
  return

GetBootDrive:									/* Obtain installation drive */
  say ""
  say "Installation program has determined that OS/2 boots from drive:" BootDrive
  say ProgName "will be added to the" ConfPath "file."
  say ""
  say "Is this correct? (Y/N)"
  parse Upper Pull response
  if response <> 'Y' then do
	say "Please enter the drive OS/2 boots from: (ie. C:)"
	parse Upper Pull BootDrive
	if BootDrive == '' then do
		say "Boot drive must be entered!"
		Call Abort
	end
	if right(BootDrive, 1)<>':' then do
  		BootDrive=BootDrive||':'
    end 
  end
  return 

GetCmdPath:							/* Obtain OS/2 Command Interpreter path */
  Call DisplayTitle
  say "Installation program has determined that" CmdPath
  say "Is the OS/2 Command Interpreter."
  say ""
  say "Is this correct? (Y/N)"
  parse Upper Pull response
  if response <> 'Y' then do
    say "Enter the fully qualified path to your OS/2 Command Interpreter"
    say "ie" BootDrive"\4OS2\COMMAND.COM"
    say ""
    say "Path to OS/2 Command Interpreter: "
    parse Upper Pull NewCmdPath
    CmdPath=NewCmdPath
    if NewCmdPath <> '' then do
      if Substr(NewCmdPath,1,1) <> '\' then do
        if Substr(NewCmdPath, 3, 1) <> '\' then do
          CmdPath='\'||NewCmdPath
        end
     end
     if Substr(CmdPath, 2, 1) <> ':' then do
       CmdPath=BootDrive||CmdPath
     end
  end
  return

Register:		/* Print registration form */
  Call DisplayTitle
  say "  About to print the registration form, if this should prove unsuccessful"
  say "  then please print and fill in the file" ProgName".REG and send it to:-"
  Call DisplayAddress
  say "Do you wish to continue ? (Y/N)"
  parse Upper Pull response
  if response <> 'N' then do
    'print ICBM.REG'
  end
  return

DisplayCompany:
  '@ECHO OFF'
  'cls'
  say ""
  say ""
  say ""
  say "                              "
  say "                            "
  say "                                              "
  say "                              "
  say ""
  return

DisplayTitle:
  Call DisplayCompany
  say "                            " MenuOption
  say ""
  return

DisplayAdvert:
  MenuOption="Computer Products"
  Call DisplayTitle
  say " Proudly developing quality shareware for"
  say ""
  say "                                 "
  say "                                        "
  say "                                "
  say "                                    "
  say "                                tm"
  say "   The operating system and software development environment of choice."
  say " OS/2 is a registered trademark of International Business Machines Corp."
  say ""
  '@pause'
  return

DisplayAddress:
  say ""
  say "                        Ŀ"
  say "                                                "                       
  say "                              Att: SysOp        "                      
  say "                              KNOWWARE BBS         "                     
  say "                              26 Ralph St,         "                       
  say "                              Clontarf Qld 4019    "                       
  say "                                                   "                       
  say "                        "
  say ""
  return
