/***** Encode.c (25.12.93) by Flavio Stanchina *****/

#include <exec/types.h>
#include <dos/dos.h>
#include <dos/stdio.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>

#if defined(__SASC)
#define _USEOLDEXEC_
#include <proto/exec.h>
#include <proto/dos.h>
#endif

#include "FSCode.h"

ULONG Encode(BPTR in, BPTR out, LONG size)
{
	LONG c1, c2;
	ULONG tmp;
	TEXT buf[6];
	LONG c;

	ULONG crc = 0xFFFFFFFF; /* preload shift register, per CRC-32 spec */

	buf[5] = '\0';
	c1 = c2 = 0;

	while((c1 + c2) < size)
	{
		if((c = FGetC(in)) == ENDSTREAMCH) break; /* Shouldn't happen */
		c2++;
		crc = crc32_stream(c, crc);
		tmp = c;

		if((c = FGetC(in)) == ENDSTREAMCH) goto encode;
		c2++;
		crc = crc32_stream(c, crc);
		tmp = tmp << 8 | c;

		if((c = FGetC(in)) == ENDSTREAMCH) goto encode;
		c2++;
		crc = crc32_stream(c, crc);
		tmp = tmp << 8 | c;

		if((c = FGetC(in)) == ENDSTREAMCH) goto encode;
		c2++;
		crc = crc32_stream(c, crc);
		tmp = tmp << 8 | c;

encode:
		buf[4] = (tmp % 85) + 42; tmp /= 85;
		buf[3] = (tmp % 85) + 42; tmp /= 85;
		buf[2] = (tmp % 85) + 42; tmp /= 85;
		buf[1] = (tmp % 85) + 42; tmp /= 85;
		buf[0] = (tmp     ) + 42;

		if(c1 + c2 == size)
			switch(size & 3) /* Equivalent to size % 4 for our purpose */
			{
				case 1: buf[2] = '#';
				case 2: buf[1] = '#';
				case 3: buf[0] = '#';
			}

		FPuts(out, buf);

		if(c2 == 60)
		{
			FPutC(out, '\n');
			c1 += c2; /* Update counters */
			c2  =  0;
		}
	}

	/* Need a newline? */
	if(c2) FPutC(out, '\n');

	return crc;
}
