
(* Here is a simple little program written in Turbo Pascal that will
insert the current DOS time and date to the screen, or to a file with
">" redirection.
*)

Program DT_Now;
  uses Dos;
  {$I parsing}
Const
  DayNames : Array [0..6] Of String[3] =
             ('Sun', 'Mon', 'Tue', 'Wed', 'Thr', 'Fri', 'Sat');
  Note     : String[55] =
             ' Compiled by David Adamson for the BatPower Conference';
  var
    h, m, s, hund : Word;
    Year, Month, Day, DayOfWeek : Word;
  function LeadingZero(w : Word) : String;
    var
    m : String;
  begin
    Str(w:0,m);
    if Length(m) = 1 then
    m := '0' + m;
    LeadingZero := m;
  end;
  Procedure Help;
   begin
    writeln(' Use no parameter line switches for both time and date. ');
    writeln(' Use -T switch for time only, -D switch for date only,  ');
    writeln(' or the -W switch for day-of-week only.');
    Halt;
   end;
  Procedure WriteTime;
   begin
    WriteLn(LeadingZero(h),':',LeadingZero(m),':',LeadingZero(s));
   end;
  Procedure WriteDate;
   begin
    Writeln(LeadingZero(Month),'-',LeadingZero(Day),'-',Year);
   end;

begin
  GetTime(h,m,s,hund);
  GetDate(Year, Month, Day, DayOfWeek);
  If SwitchThere('?') or SwitchThere('H') Then
   Help;
  if switchThere('T') then
   begin
    write('Time ');
    WriteTime;
   end;
  If SwitchThere('W') then
   writeln(DayNames[DayOfWeek]);
  If SwitchThere('D') then
   begin
    write('Date ');
    WriteDate;
   end;
  If not SwitchThere('T') and not SwitchThere('D') and not SwitchThere('W') then
   begin
    write('Current time is ');
    WriteTime;
    write('Current date is ',DayNames[DayOfWeek],' ');
    WriteDate;
   end;

End.

