#ifndef DOS_DATE
#define DOS_DATE
typedef union {
        unsigned        u;
        struct {
                unsigned        Day:5;
                unsigned        Month:4;
                unsigned        Year:7;
                }               b;
        }               DOS_FILE_DATE;
#endif

#ifndef DOS_TIME
#define DOS_TIME
typedef union {
        unsigned        u;
        struct {
                unsigned        Second:5;
                unsigned        Minute:6;
                unsigned        Hour:5;
                }               b;
        }               DOS_FILE_TIME;
#endif

/* DpbStruct -- Layout of parameter block returned by Int 21H, Fn 32H    */
/* This function is an undocumented MS-DOS service but has  */
/* been verified to work correctly on PC/MS-DOS 2.0 through */
/* PC/MS-DOS 3.3                                            */

struct DOS_2 {
        unsigned char FatSize;
        unsigned          DirStart;
        unsigned long ddh;
        unsigned char MediaType;
        unsigned char Rebuild;
        unsigned long NextTable;
        unsigned          CurDir1st;
        char              CurDirPath[64];
        };

struct DOS_3 {
        unsigned char FatSize;
        unsigned          DirStart;
        unsigned long ddh;
        unsigned char MediaType;
        unsigned char Rebuild;
        unsigned long NextTable;
        unsigned          FreeSearchClus;
        unsigned          FreeCluster;
        };

struct DOS_4 {
        unsigned        FatSize;
        unsigned                DirStart;
        unsigned long   ddh;
        unsigned char   MediaType;
        unsigned char   Rebuild;
        unsigned long   NextTable;
        unsigned                FreeSearchClus;
        unsigned                FreeCluster;
        };

struct DpbStruct {
        unsigned char   Designator;                     /* Drive # (0=A, 1=B, ...)       */
        unsigned char   AltDesignator;          /* As above; 0 if RAMdisk        */
        unsigned        SectorSize;                     /* Bytes per Sector              */
        unsigned char   ClusterSize;            /* Sectors per Cluster - 1       */
        unsigned char   ClusterShift;           /* Log2 (Sectors per Clus)       */
        unsigned        FatStart;                       /* Sectors in Boot Record        */
        unsigned char   FatCopies;                      /* Copies of FAT                 */
        unsigned        MaxEntries;                     /* Max entries in Root Directory */
        unsigned        DataStart;                      /* 1st sector of data area       */
        unsigned        LastCluster;            /* Last cluster number           */
        union {
                struct DOS_2 V2;
                struct DOS_3 V3;
                struct DOS_4 V4;
                } V;
        };


/*
 * ExtendedHeader -- header used in constructing an extended file control
 * block.
 */

struct ExtendedHeader {
        char            Header;
        char            Zeros[5];
        char            Attrib;
};
/* ExtFcb -- extended file control block */

struct ExtFcb {
        struct ExtendedHeader FcbHdr;
        char            DriveId;
        char            FileName[8];
        char            FileExtension[3];
        unsigned        CurBlock;
        unsigned        RecSize;
        long            FileSize;
        DOS_FILE_DATE   Date;
        DOS_FILE_TIME   Time;
        char            Reserved[8];
        char            RecInBlock;
        long            RelRecord;
};
/*
 * DirDta -- dta directory entry structure
 */

struct DirDta {
        char            DriveNum;
        char            FileName[11];
        char            Attributes;
        char            Unused[10];
        DOS_FILE_TIME   CreateTime;
        DOS_FILE_DATE   CreateDate;
        unsigned        FirstCluster;
        long            FileSize;
};
/*
 * DirEntry -- format of an entry in the directory
 */

struct DirEntry {
        unsigned char   Name[8];
        char            Ext[3];
        char            Attribute;
        char            Reserved[10];
        unsigned        ModifyTime;
        unsigned        ModifyDate;
        unsigned        FirstCluster;
        long            FileSize;
};
/*
 * ExtendedEntry -- directory structure for use with extended file search
 */

struct ExtendedEntry {
        struct ExtendedHeader DirHdr;
        struct DirDta   Body;
};

struct ClusterEntry {
        struct ClusterEntry *Next;
        unsigned        Cluster;
};

struct ClusterQueue {
        struct ClusterEntry *Head, *Current;
        int             Count;
};


struct absr32m
 {
  long sector;
  int  nsect;
  unsigned char far  *xferad;
 };

#define FAT_BLK 57344U
#define INT_FAT_BLK (FAT_BLK / 2)

#if defined(MAIN)
        #define EXTERN
#else
        #define EXTERN extern
#endif

