  Program cmos2dos;

  USES
    CRT,
    Clocks,
    DOS;    {SearchRec,DOSError}

  {$I Parsing}

  VAR
    Clk2,Clk3:  Clock;       {clock objects -- real time clocks}
    er        : integer;
    Todaydate : string[10];
    time      : string[8];
    yr,mo,dy  : word;
    hr,mi,se  : word;
    f         : text;

 CONST
    note : string[55] =
                  ' compiled by David Adamson for the BatchPower conference';

  Procedure Help;
   begin
    ClrScr;
    TextColor(6); {orange}
    writeln(' Most IBM computers have two clocks. A hardware CMOS clock ');
    writeln(' and a DOS software clock.  The purpose of this utility is ');
    writeln(' to synchronize the DOS clock with the CMOS clock.         ');
    NormVideo;
    Halt(1);
   end;

BEGIN
    If SwitchThere('?') or SwitchThere('H') then
     Help;
    clrscr;
    assign(f, '');
    rewrite(f);
    Clk2.Start (CMOSClock);
    Clk3.Start (DOSClock);
    if SwitchThere('S') then
    WRITELN (f,'CMOS Clock: ',Clk2.date('u'),' ',Clk2.time('N') );
    close(f);
    TextColor(Yellow);
    If not SwitchThere('S') then
    WRITELN (' CMOS Clock time:  ',Clk2.date('u'),' ',Clk2.time('N') );
    Textcolor(lightred);
    If not SwitchThere('S') then
  WRITELN (' CMOS/DOS Clock differential was: ',
             hhmmss(TimeDiff(Clk2.StartValue,Clk3.StartValue)));
  todaydate :=  clk2.date('S');
  val(copy(todaydate,1,4),yr,er);
  val(copy(todaydate,5,2),mo,er);
  val(copy(todaydate,7,2),dy,er);
  SetDate(yr, mo, dy);
  time := (Clk2.Time('N'));
  val(copy(time,1,2),hr,er);
  val(copy(time,4,2),mi,er);
  val(copy(time,7,2),se,er);
  setTime(hr, mi, se, 50);
  Clk3.Start (DOSClock);
  TextColor(lightgreen);
    If not SwitchThere('S') then
  WRITELN (' DOS Clock set to: ',Clk3.date('u'),' ',Clk3.time('N') );
  note :=note;
  NormVideo;
end.
