/* BTNtape include file, version 3.0 */

/* Operations supported by TapeIO */
#define TSENSE  0    /* request sense */
#define TREADY  1    /* test unit ready */
#define TREAD   2    /* read blocks */
#define TWRITE  3    /* write blocks */
#define TREWIND 4    /* rewind tape */
#define WFMARK  5    /* write file mark */
#define TSKIPF  6    /* skip over files */
#define TSKIPE  7    /* skip to end of data */
#define TRETEN  8    /* retension tape */
#define TEJECT  9    /* eject tape */
#define INQUIRY 10   /* read device info */
#define MDSET   11   /* mode-set */
#define MDSNS   12   /* mode-sense */
#define USRMODE 13   /* user mode-set */
#define RDCAP   14   /* read capacity */
#define RAWCMD  15   /* send user scsi command to tape */
#define TFINISH 16   /* wait for last operation to finish */

/* these control how fast TapeIO returns to the caller */
#define CTLWAIT 0    /* return when operation is done */
#define CTLIMM  1    /* return immediately */

#define FAKEOM 99    /* special return code for DAC EOM */

/* Supported device types (from INQUIRY) */
#define SEQ    (inq[0]==0x01) /* sequential */
#define DAC    (inq[0]==0x10) /* direct-access */
#define BADLUN (inq[0]==0x7f) /* oops */

#define PKTADR(Z)   (struct DosPacket *)Z->mn_Node.ln_Name

/* function prototypes */
void _main(char*);
long  TapeIO(int,long,int);
int   DoSense(long);
int   postape(int,int,long);
long  wrteot(int,int,long);
void  freestuff(void);
int   getstart(long *);
void  Mprintf(char *, ...);
void  toUPPER(char *);
void  swapbytes(char *);
long  NewTape(void);
long  ask(char *, char *, char *);
void  returnpkt(ULONG, ULONG);

