#include <io.h>
#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include <cxlvid.h>
#include <cxlwin.h>
#include <cxldef.h>

void makebox(int COLOR);
void ASMCALL(int A, int B, int C, int D, int E, int F, int G);
extern ENDSCREEN(void);

void main(int argc, char *argv[])
{
union REGS r;
int comline;	    /* What choice comes from command line */
int x;		    /* X and Y are our counter integers */
int y;
int i;
int temp;	    /* Another counter variable */
int USR_COLOR=YELLOW|_BLUE, a, b, c, d;
char stuff[100];

disable();	    /* Must disable the interrupts so that the Timer will not */
                /* interfere with our graphics and sounds */
videoinit();


if(strstr(argv[1],"?")||argc==1){
  printf("\n\n   ͸");
  printf("\n           PRESS ANY KEY (part 3)  from Dave Smith          ");
  printf("\n               Usage: AK  [option] [box color]              ");
  printf("\n                                                            ");
  printf("\n          1. Textured Frame       16. Frame Open            ");
  printf("\n          2. Shove Down           17. Off and On            ");
  printf("\n          3. Squish               18. Four Windows          ");
  printf("\n          4. Close Frame          19. Explode Window        ");
  printf("\n          5. Fade Out             20. Shuffle               ");
  printf("\n          6. Shake                21. Falling Lines         ");
  printf("\n          7. Whappo               22. Scrolling Box         ");
  printf("\n          8. Zapped               23. ScreenFull            ");
  printf("\n          9. Color Dump           24. Big Message           ");
  printf("\n         10. Flash                25. Side Lines            ");
  printf("\n         11. Bounce               26. Moving Shades         ");
  printf("\n         12. Thick Lines          27. Random Lines          ");
  printf("\n         13. Thin Lines           28. Flasher               ");
  printf("\n         14. Colored Dots         29. Question              ");
  printf("\n         15. Stars                30. Sudden Noise          ");
  printf("\n   ;\n\n");
  exit(0);
  }
			   /* Get what we need from the command line, and
			   ** set our defaults.
			   */

comline=atoi(argv[1]);
if(argv[2]) USR_COLOR=atoi(argv[2]);

switch(comline){

	  /**  "Textured Frame" just clears the screen nicely,
	   **  then puts our frame on the screen.
	   **/

case 1: gotoxy(1,1);
	asm mov ah, 09H
	asm mov al, 0B0H
	asm mov bl, 1FH
	asm mov cx, 2000
	asm INT 10H

    makebox(USR_COLOR);
	break;

	  /**  "ShoveDown" uses service 7 to scroll screen down
	   **  26 times for the appearance of being shoved.
	   **/

case 2: for(y=1;y<26;y++)
	   {
	    ASMCALL(0,0,24,79,15,1,7);
	    delay(70);
	   }
    makebox(USR_COLOR);
	break;

	  /**  "Squish" splits the screen in half, then scrolls both
	   **  sides together.
	   **/

case 3: for(y=1;y<14;y++)
	   {
	ASMCALL(0,0,12,79,15,1,7);
	ASMCALL(12,0,24,79,15,1,6);
	delay(70);
	   }
    makebox(USR_COLOR);
	break;

	  /**  "Close Frame" scrolls each side of the screen toward
	   **  each other, thus appearing to 'close'.
	   **/

case 4:
     for(y=0;y<40;y++){
	ASMCALL(0,y,24,y,15,25,7);
	ASMCALL(0,79-y,24,79-y,15,25,7);
	delay(17);
		       }
      makebox(USR_COLOR);
      break;

	  /**  "Fade" just puts dots on the screen, then clears it.
	   **/

case 5:
      textbackground(0);
      randomize();
    for(temp=1;temp<3000;temp++)
      {
      y=random(24)+1;
      x=random(80)+1;
      gotoxy(x,y);
      cprintf(" ");
      }
      clrscr();
      makebox(USR_COLOR);
      break;

	  /**  "Shake" scrolls the screen up, then down 14 times, then
	   **  restores the screen and puts our box on.
	   **/

case 6: for(y=1;y<15;y++){
	   ASMCALL(0,0,24,79,15,1,6);
	   delay(90);
	   ASMCALL(0,0,24,79,15,1,7);
	   delay(90);
			}
       makebox(USR_COLOR);
	   break;

	  /**  "Whappo" just does some quick scrolling.
	   **/

case 7: for(y=1;y<30;y++){
	   ASMCALL(0,0,12,79,15,3,6);
	   delay(20);
	   ASMCALL(12,0,24,79,15,3,7);
	   delay(20);
			}

       makebox(USR_COLOR);
	   break;

	  /**  "Zapped" squishes the screen from a vertical and
	   **  horizontal place.
	   **/

case 8: for(y=0;y<40;y++){
	   ASMCALL(0,y,24,y,15,25,7);
	   ASMCALL(0,79-y,24,79-y,15,25,7);
	   delay(17);
	   gotoxy(1,y+1);
	   clreol();
	   gotoxy(1,24-y);
	   clreol();
			  }

     makebox(USR_COLOR);
	 break;

	  /**  "ColorDrop" just clears the screen, then drops our message
	   **  and erases the extras from top and bottom.
	   **/

case 9: textbackground(0);
	clrscr();

	for(y=1;y<25;y++)
	  {
	   delay(70);
	   textcolor(y);
	   gotoxy(26,y);
	   cprintf("Press Any Key To Continue ...");
	  }

	for(y=1;y<12;y++)
	  {
	   delay(80);
	   gotoxy(1,y);
	   clreol();
	   delay(80);
	   gotoxy(1,25-y);
	   clreol();
	   gotoxy(1,12);
	   clreol();
	  }

       break;

	  /**  "Flash" places a lot of different textures and colors on the
	   **  screen, then prints our box and message.
	   **/

case 10: gotoxy(1,1);
	 asm mov ah, 09H
	 asm mov al, 040H
	 asm mov bl, 0AH
	 asm mov cx, 2000
	 asm INT 10H

     makebox(USR_COLOR);

       delay(80);

       gotoxy(1,1);
       asm mov ah, 09H
       asm mov al, 0C0H
       asm mov bl, 0CH
       asm mov cx, 2000
       asm INT 10H

     makebox(USR_COLOR);

       delay(90);


    for(x=70;x<101;x+=10){
       gotoxy(1,1);
       asm mov ah, 09H
       asm mov al, 040H
       asm mov bl, 0AH
       asm mov cx, 2000
       asm INT 10H
       delay(x+20);

       gotoxy(1,1);
       asm mov ah, 09H
       asm mov al, 0C0H
       asm mov bl, 0CH
       asm mov cx, 2000
       asm INT 10H
       delay(x);
			 }

     makebox(USR_COLOR);
	 break;



      /* We use CXL library to bounce the box up and down */

case 11: wopen(1,28,8,48,0,LCYAN|_BLUE,LGREEN|_BLUE);
     wcenters(2,LCYAN|_BLUE,"Press Any Key");
     wcenters(3,LCYAN|_BLUE,"To Continue");

     for(i=1;i<23;i++){ wdrag(D_DOWN); delay(100); }
     for(i=1;i<25;i++) wdrag(D_UP);
     break;


      /**  "Thick Lines" throws our ASM screen on, then the box
       **/

case 12:
     fill_(0,0,24,80,'',GREEN|_LGREY);
     makebox(USR_COLOR);
	 break;

	  /**  "Thin Lines" is similar to the above
	   **/

case 13:
     fill_(0,0,24,80,'-',BLINK|YELLOW|_CYAN);
     makebox(USR_COLOR);
	 break;



     /**    Random colored boxes on screen   **/

case 14:
         textbackground(0);
         randomize();
         for(temp=1;temp<3000;temp++)
           {
           y=random(24)+1;
           x=random(80)+1;
           i=random(16);
           gotoxy(x,y);
           textcolor(i);
           cprintf("");
           delay(1);
           }
         makebox(USR_COLOR);
         break;

 /**  "Stars" puts a Star Trek effect on the screen around
  **  our message.

case 15: clrscr();
     makebox(USR_COLOR);
	 x=10;
	 y=60;
	 textcolor(4);

	 while(!kbhit())
	   {
	    gotoxy(x,9);   cprintf("*");
	    gotoxy(x,15);  cprintf("*");
	    gotoxy(y,9);   cprintf("*");
	    gotoxy(y,15);  cprintf("*");
	    delay(40);
	    gotoxy(x,9);   cprintf(" ");
	    gotoxy(x,15);  cprintf(" ");
	    gotoxy(y,9);   cprintf(" ");
	    gotoxy(y,15);  cprintf(" ");

	    x++;
	    y--;

	     if(x>36){ x=10; y=60; }
	   }
	 break;


	  /**  "Frame Open" is "Frame Close" in reverse.
	   **/

case 16:    x=41;

	 for(y=40;y>0;y--){
	    ASMCALL(0,y,24,y,15,25,7);
	    ASMCALL(0,x,24,x,15,25,7);
	    delay(17);
	    x++;
			  }
      makebox(USR_COLOR);
	  break;

	  /**  "Off and On" just flashes the box on and off.
	   **/

case 17: for(temp=1;temp<8;temp++){

	   textbackground(0);
	   clrscr();
       makebox(USR_COLOR);
       delay(170);
       wclose();
       delay(170);
	   }

     makebox(USR_COLOR);
	 break;

	  /**  "Four Windows"... here goes our screen split/scroll effects
	   **  again !	This time, we do four windows.
	   **/

case 18: for(y=1;y<15;y++){
	 ASMCALL(0,0,11,39,15,1,6);
	 ASMCALL(0,40,11,79,15,1,7);
	 ASMCALL(12,0,24,39,15,1,6);
	 ASMCALL(12,40,24,79,15,1,7);
	 delay(60);
	 }

     makebox(USR_COLOR);
	 break;



      /***      EXPLODING BOXES      ***/

case 19:
    a=10;  b=35;  c=12;  d=37;
    for(i=1;i<100;i++){
        wopen(a ,b ,c ,d ,3,YELLOW|_BLUE,WHITE|_BLUE);
        a-=1;
        b-=6;
        c+=1;
        d+=6;
        delay(30);
        if(a<1){
                 a=10;  b=35;   c=12;   d=37;
                 clrscr();
        wcloseall();
               }
                      }
    wcloseall();
     makebox(USR_COLOR);
    break;




      /*     We replicate a blue box, then make a colorful
	  **   one in the middle to attract attention.
	  */

case 20: wopen(1,28,8,48,0,LCYAN|_BLUE,LGREEN|_BLUE);
	 wcenters(2,LCYAN|_BLUE,"Press Any Key");
	 wcenters(3,LCYAN|_BLUE,"To Continue");

	 randomize();
	 for(i=1;i<150;i++) wcopy(random(19), random(74));

	 wopen(8,28,16,48,3,YELLOW|_GREEN,WHITE|_MAGENTA);
	 wcenters(2,YELLOW|_MAGENTA,"Press Any Key");
	 wcenters(3,YELLOW|_MAGENTA,"To Continue");
	 break;

case 21:
     for(i=0; i<25; i++){
         prints(i, 0, i, "");
         delay(200);
                        }
     makebox(USR_COLOR);
     break;

case 22:
     makebox(USR_COLOR);
     while(!kbhit()){
         for(i=0; i<79; i++){ wmove(11, i);  delay(50); if(kbhit()) exit(0);  }
         for(i=79; i>0; i--){ wmove(11, i);  delay(50); if(kbhit()) exit(0);  }
                    }
     break;

case 23:
    wopen(0,0,23,79,5,0,LGREEN|_GREEN);
    for(i=1;i<120;i++) wprintf("\033F%cPress Any Key to Continue   ",i);
    makebox(USR_COLOR);
    break;

case 24:
    for(;;)
    for(i=0;i<16;i++){
    delay(100);
    prints( 6, 2, i, "                                                                ");
    prints( 7, 2, i, "                                                                    ");
    prints( 8, 2, i, "                               ");
    prints( 9, 2, i, "                                            ");
    prints(10, 2, i, "                                   ");
    prints(11, 2, i, "                                                             ");
    prints(13, 2, i, "                                                                       ");
    prints(14, 2, i, "                                    ");
    prints(15, 2, i, "                                                      ");
    prints(16, 2, i, "                                          ");
    if(kbhit()) exit(0);
                      }

case 25:
    temp=0;
    for(y=0; y<81; y++){
        for(x=0; x<26; x++) printc(x,y,temp,'');
        temp++;
        if(temp>19) temp=0;
        delay(50);
                       }

    for(y=0; y<81; y++){
        delay(50);
        for(x=1; x<26; x++) printc(x,y,BLACK|_BLACK,'');
                       }
    makebox(USR_COLOR);
    break;

case 26:
      fill_(0,0,24,80,'',BLACK|_BLACK);
    makebox(USR_COLOR);
    while(!kbhit()){
      fill_(0,0,10,80,'|',YELLOW|_BLACK);
      fill_(0,0,10,80,'/',YELLOW|_BLACK);
      fill_(0,0,10,80,196,YELLOW|_BLACK);
      fill_(0,0,10,80,92 ,YELLOW|_BLACK);

      fill_(17,0,24,80,'|',YELLOW|_BLACK);
      fill_(17,0,24,80,'/',YELLOW|_BLACK);
      fill_(17,0,24,80,196,YELLOW|_BLACK);
      fill_(17,0,24,80,92 ,YELLOW|_BLACK);
                   }
      exit(0);

case 27:
    i=1;
    randomize();
    makebox(USR_COLOR);
    while(!kbhit()){
        delay(15);
        y=random(80);
        for(x=0; x<25; x++){
            delay(1);
            printc(x,y,i,'');
            printc(x+1,y,i,'');
            printc(x-1,y,i,'');
                           }
        i++;
        if(i>16) i=1;
                   }
    exit(0);


case 28:
    for(i=0; i<20; i++){
    fill_(0,0,24,80,'',BLACK|_BLACK);
        delay(20);
        fill_(0,0,24,80,'',YELLOW|_BLACK);
        delay(20);
    fill_(0,0,24,80,'',BLACK|_BLACK);
        delay(20);
        fill_(0,0,24,80,'',WHITE|_BLACK);
        delay(20);
    fill_(0,0,24,80,'',BLACK|_BLACK);
        delay(20);
        fill_(0,0,24,80,'',GREEN|_BLACK);
        delay(20);
    fill_(0,0,24,80,'',BLACK|_BLACK);
        delay(20);
        fill_(0,0,24,80,'',LGREEN|_BLACK);
        delay(20);
    fill_(0,0,24,80,'',BLACK|_BLACK);
                   }
    makebox(USR_COLOR);
    break;


case 29:
    fill_(0,0,24,80,178,BLUE|_BLACK);
    wopen(4,14,6,62,5,BLUE,YELLOW|_BLUE);
    wprintf("\n  $$$   The Seven MILLION Dollar Question   $$$");
    wopen(12,25,18,53,3,GREEN|_LGREY,BLACK|_LGREY);
    wprintf("\nWhat is the Square Root of");
    wprintf("\n       4,865,202,001");
    wprintf("\n?  ");
    wgets(stuff);
    if(strstr(stuff,"69751")){   makebox(USR_COLOR);      break;   }
    else {  textbackground(0);
            clrscr();
            prints(10,13,BLINK|YELLOW|_BLACK,"                              ");
            prints(11,13,BLINK|YELLOW|_BLACK,"                                           ");
            prints(12,13,BLINK|YELLOW|_BLACK,"                                     ");
            prints(13,13,BLINK|YELLOW|_BLACK,"                                     ");
            prints(14,13,BLINK|YELLOW|_BLACK,"                               ");
         }
    exit(0);



case 30: ENDSCREEN();
         break;


			    }
getch();

exit(0);  /* We're Out of here ! */
}


void makebox(int COLOR)
{
wopen(11,15,16,63,3,WHITE|_BLUE,COLOR);
wshadow(LGREY|_BLACK);
wprintf("\n          Press Any Key to Continue");
}


void ASMCALL(int A, int B, int C, int D, int E, int F, int G)
{
union REGS r;	    /* Set up our own low level calls */
r.h.ch=A;
r.h.cl=B;
r.h.dh=C;
r.h.dl=D;
r.h.bh=E;
r.h.al=F;
r.h.ah=G;
int86(0x10,&r,&r);
}
