/*
 TBINTERN.PRG  by Hannes Ziegler CS 100142,302


 Contains:
 Func HeadColSep(oTBrowse)
 Func FootColSep(oTBrowse)

 These funcs draw Colsep in the Heading/Footing region of a TBrowse.
 Both funcs deal with Tbrowse-internals that can be accessed
 using Clipper code only (No worry about incompatibilities!)

 Try:

 oTBrowse : HeadSep := ""
 oTBrowse : FootSep := ""
 oTBrowse : ColSep  := "  "
 
 After oTBrowse:AddColumn() and prior to oTBrowse:stabilize()
 pass oTbrowse to one or both funcs

 After stabilize() the TBrowse may look like

  Heading   Heading   Heading   Heading  
  -SubHead  -SubHead  -SubHead  -SubHead 
 
  Data12    Data12    Data12    Data12   
  Data13    Data13    Data13    Data13   
  Data14    Data14    Data14    Data14   
  Data15    Data15    Data15    Data15   
 
  Footing   Footing   Footing   Footing  
  -SubFoot  -SubFoot  -SubFoot  -SubFoot 

 Be aware of the fact that this code accesses TBrowse internals
 ie TBrowse doesn't know anything about it. What the funcs are
 doing is simply stuff() ColSep into the Heading and Footing area
 of the virtual screen-string that is being maintained by TBrowse.
 If you issue a TBrowse:configure() the whole beauty is gone because
 TBrowse rebuildts the virtual screen itself. As a result, ColSep in
 Heading/Footing will be overwritten with blanks (standard behaviour
 of TBrowse)

 Disclaimer:
 If you use these funcs, you know that you are doing non-OOPy stuff.
 You know that you are accessing TBrowse-internals which are not supposed
 to be accessed. You know that you can use these funcs with Clipper
 version 5.01 and 5.2 without any penalty (except TBrowse:configure())
 Well, I don't know what this disclaimer is good for since you know it all.
 You gotta know what you're doing (it may be 'illegal', but it works <g>).

*/

*************************
Func HeadColSep(oTBrowse)
local cColSep    :=oTBrowse:ColSep
local nColSepLen :=len(cColSep)
local nVScreenLen:=bin2i(substr(atail(oTbrowse),13))
local nVRowLen   :=bin2i(substr(atail(oTbrowse),23))
local nHeadLines :=bin2i(substr(atail(oTbrowse),29))
local cHeadLines :=substr(atail(oTbrowse),85,nVRowLen*nHeadLines)
local cColInfo   :=substr(atail(oTbrowse),85+nVScreenLen+1,12*oTBrowse:ColCount)
local nColSepPos , i, j

for j:=1 to nHeadLines
  for i:=1 to oTbrowse:ColCount-1
    nColSepPos:=bin2i(substr(cColInfo,12*i+2))-nColSepLen+1
    cHeadLines:=;
    stuff(cHeadLines,(nVRowLen*(j-1))+nColSepPos,nColSepLen,cColSep)
  next
next

cHeadLines := substr(atail(oTbrowse),1,84)+cHeadLines+;
              substr(atail(oTbrowse),85+len(cHeadLines))

oTbrowse[len(oTbrowse)]:=cHeadLines

*************************
Func FootColSep(oTBrowse)
local cColSep    :=oTBrowse:ColSep
local nColSepLen :=len(cColSep)
local nVScreenLen:=bin2i(substr(atail(oTbrowse),13))
local nVRowLen   :=bin2i(substr(atail(oTbrowse),23))
local nStart     :=bin2i(substr(atail(oTbrowse),37))
local nFootLines :=nStart-bin2i(substr(atail(oTbrowse),31))
local cFootLines :=substr(atail(oTbrowse),85+(nStart-nFootLines+1)*nVRowLen)
local cColInfo   :=substr(atail(oTbrowse),85+nVScreenLen+1,12*oTBrowse:ColCount)
local nColSepPos , i, j

for j:=1 to nFootLines
  for i:=1 to oTbrowse:ColCount-1
    nColSepPos:=bin2i(substr(cColInfo,12*i+2))-nColSepLen+1
    cFootLines:=;
    stuff(cFootLines,(nVRowLen*(j-1))+nColSepPos,nColSepLen,cColSep)
  next
next

cFootLines := substr(atail(oTbrowse),1,84+(nStart-nFootLines+1)*nVRowLen)+cFootLines

oTbrowse[len(oTbrowse)]:=cFootLines
