// tori203.pov   gjp   5/4/94

#include "tori.ani"  // defines Cr, T1x, T1y, T2x, T2y, etc

#declare r = .3  // minor radii of tori

#declare BrightGold = color red .85 green .85 blue .1

#declare Metal = 
finish { metallic ambient .2 diffuse .7 brilliance 6
   reflection .25 phong .75 phong_size 80 }

#declare Gold_Texture = 
texture { 
  pigment { color BrightGold } 
  finish { Metal } 
}

#declare Scene =
union {
  // torus { Cr, r  texture { pigment { red 1 } } }  // center torus

  // inside tori
  torus { T1x, r  translate<0, T1y, 0> }
  torus { T2x, r  translate<0, T2y, 0> }
  torus { T3x, r  translate<0, T3y, 0> }

  // middle tori
  torus { T4x, r  translate<0, T4y, 0> }
  torus { T5x, r  translate<0, T5y, 0> }
  torus { T6x, r  translate<0, T6y, 0> }

  // outside tori
  torus { T7x, r  translate<0, T7y, 0> }
  torus { T8x, r  translate<0, T8y, 0> }
  torus { T9x, r  translate<0, T9y, 0> }

  texture { Gold_Texture }
}

object { Scene rotate< -15, 0, 0 > }

light_source { <-100, 100, -100> color red 1 blue 1 green 1 }
camera { 
  right<1.6, 0, 0>     // aspect ratio for 320 x 200 FLI
  up<0 1 0>  
  direction<0 0 1>    
  location<0, 0, -27>
  look_at<0 0 0> }

