/****************************************************************************
*
* VERSION
*	$VER: prefsnotify.c 1.70 (12.12.93)
*
* DESCRIPTION
*	Screen mode prefs notify code...
*
* AUTHOR
*	Rune Johnsrud
*
* COPYRIGHT
*	(c) 1993 Amiga Freelancers
*
*****************************************************************************/

#include <exec/types.h>
#include <exec/memory.h>
#include <dos/dos.h>
#include <dos/notify.h>
#include <intuition/intuition.h>
#include <graphics/gfx.h>
#include <utility/date.h>

#include <proto/exec.h>
#include <proto/dos.h>

#include "global.h"

/****************************************************************************/

extern struct GlobalData *gd;

/****************************************************************************/

UBYTE PrefsFileName[] = "ENV:sys/screenmode.prefs";

/****************************************************************************/


WORD CreatePrefsNotify(VOID)
{
	gd->NReq = AllocVec(sizeof(struct NotifyRequest), MEMF_CLEAR);
	if (!gd->NReq) return GEN_ERR_ALLOCMEM;

	gd->PNSigNum = AllocSignal(-1L);
	if (gd->PNSigNum == -1) return GEN_ERR_ALLOCSIGNAL;

	gd->NReq->nr_Name                         = PrefsFileName;
	gd->NReq->nr_Flags                        = NRF_SEND_SIGNAL;
	gd->NReq->nr_stuff.nr_Signal.nr_Task      = (struct Task *) FindTask(NULL);
	gd->NReq->nr_stuff.nr_Signal.nr_SignalNum = gd->PNSigNum;

	if (StartNotify(gd->NReq) == DOSTRUE)
	{
		return NOERROR;
	}
	else
	{
		return PN_ERR_PREFSNOTIFY;
	}
}


WORD DeletePrefsNotify(VOID)
{
	if (gd->NReq)
	{
		EndNotify(gd->NReq);
		FreeVec(gd->NReq);
	}

	if (gd->PNSigNum != -1) FreeSignal(gd->PNSigNum);

	return NOERROR;
}


/* End Of File */
