        .model  small

Code    Segment Byte
        Assume  CS: Code, DS: Code

        ORG     100H

Start:
        jmp     LoadProg

; Data

Banner  DB      255 DUP(0)              ; make buffer large
Attr    DB      79                      ; yellow on red

Tick    DB      9                       ; display every 9 ticks
Old_1C  DW      ?,?                     ; location of old 1C interrupt
Old_2F  DW      ?,?                     ; location of old 2F interrupt

Int2F   Proc                            ;
        cmp     AX, 0DB00h              ; installation check?
        jne     Check1C                 ; no, check for 1C request
        dec     AL                      ; successful
        push    CS                      ; put code segment
        pop     ES                      ;  in ES
        mov     DI, OFFSET Banner       ; put offset to banner text in DI
        iret                            ;
Check1C:
        cmp     AX, 0DB1Ch              ; do they want the old 1C location?
        jne     Check2F                 ; no, check for 2F request
        mov     AL, 0FFh                ; successful
        mov     BX, CS: [Old_1C]        ; put offset in BX
        mov     ES, CS: [Old_1C+2]      ; put segment in ES
        iret                            ;
Check2F:
        cmp     AX, 0DB2Fh              ; do they want the old 2F location?
        jne     CallOld2F               ; no, call the old 2F interrupt
        mov     AL, 0FFh                ; successful
        mov     BX, CS: [Old_2F]        ; put offset in BX
        mov     ES, CS: [Old_2F+2]      ; put segment in ES
        iret                            ;
CallOld2F:
        jmp     DWord Ptr CS: Old_2F    ;
Int2F   EndP

Int1C   Proc
        pushf                           ;
        call    DWord Ptr CS: Old_1C    ; call old 1C interrupt
        dec     Byte Ptr CS: Tick       ; one less tick
        jnz     Done_1C                 ; if not zero, quit
        mov     Byte Ptr CS: Tick, 9    ; make it 9 more ticks
        call    DisplayString           ;  and display the string
Done_1C:
        iret                            ;
Int1C   EndP

DisplayString Proc
        push    AX                      ;
        push    BX                      ;
        push    CX                      ;
        push    DX                      ;
        push    DS                      ;
        push    ES                      ;
        push    DI                      ;
        push    SI                      ;
        push    BP                      ;

        xor     AX, AX                  ;
        mov     ES, AX                  ;
        mov     AX, 0B800h              ; use color video memory
        cmp     Byte Ptr ES: [0449h], 3 ; are we in text video mode?
        je      Display_Text            ; no, skip displaying text
        mov     AX, 0B000h              ; use mono video memory
        cmp     Byte Ptr ES: [0449h], 7 ; are we in text video mode?
        jne     Display_Done            ; no, exit

Display_Text:
        mov     ES, AX                  ; put video segment in ES
        xor     DI, DI                  ; point to top left corner
        xor     BX, BX                  ; clear pointer
        mov     AH, Byte Ptr CS: Attr   ; get color attribute
PutWord:
        mov     AL, Byte Ptr CS: Banner[BX] ; get a charactor
        cmp     AL, 13                  ; is it a carriage return?
        je      Display_Done            ; yes, exit
        stosw                           ; write it to the screen
        inc     BX                      ; point to next charactor
        jmp     PutWord                 ; do it all again
Display_Done:
        pop     BP                      ;
        pop     SI                      ;
        pop     DI                      ;
        pop     ES                      ;
        pop     DS                      ;
        pop     DX                      ;
        pop     CX                      ;
        pop     BX                      ;
        pop     AX                      ;
        ret                             ;
DisplayString EndP

;===========================[  Transient Code  ]===============================

Copyright DB    'Screen Banner 1.02  TSR to display a banner',13,10
        DB      '(c) Copyright 1993,94 Product Identification'
        DB      ' and Processing Systems, Inc.',13,10
        DB      'Written by Dave Navarro, Jr.',13,10,10,'$'
Success DB      'Screen Banner successfully installed.',13,10,'$'
ErrMsg1 DB      'Screen Banner already installed.',13,10
        DB      'Banner changed to new text',13,10,'$'
ErrMsg2 DB      'Usage:  SBANNER Text_To_Display',13,10,13,10
        DB      'Screen Banner not installed.',13,10,'$'

LoadProg Proc
        mov     DX, OFFSET Copyright    ; point to copyright message
        mov     AH, 9                   ;
        int     21h                     ; display it
        mov     AL, DS: [0080h]         ; get length of command line
        or      AL, AL                  ; anything there?
        jnz     CheckInstall            ; yes, check for previous install
        mov     DX, OFFSET ErrMsg2      ; give them the syntax
        mov     AH, 9                   ;
        int     21h                     ; display it
        jmp     Exit                    ; and exit
CheckInstall:
        mov     AX, 0DB00h              ; see if we're already installed
        int     2Fh                     ;
        cmp     AL, 0FFh                ; are we?
        jne     DoInstall               ; no, do the instalation.
        cli                             ;
        mov     SI, 0082h               ; point to start of command line
GetByte:
        lodsb                           ; get a byte
        stosb                           ; write it to buffer
        cmp     AL, 13                  ; are we at the end?
        jne     GetByte                 ; no, keep moving text

        sti                             ;
        mov     DX, OFFSET ErrMsg1      ; let them know about the new text
        mov     AH, 9                   ;
        int     21h                     ; display it
        jmp     Exit                    ; and exit
DoInstall:
        mov     SI, 0082h               ; point to start of command line
        mov     DI, OFFSET Banner       ; and text buffer area
        push    DS                      ;
        pop     ES                      ;
CopyByte:
        lodsb                           ; get a byte
        stosb                           ; write it to buffer
        cmp     AL, 13                  ; are we at the end?
        jne     CopyByte                ; no, keep moving text

        mov     ES, DS: [002Ch]         ; point to environment segment
        mov     AH, 49h                 ;
        int     21h                     ; release it

        mov     AX, 352Fh               ; get interrupt 2F location
        int     21h                     ;
        mov     CS: [Old_2F], BX        ; save offset
        mov     CS: [Old_2F+2], ES      ; save segment
        mov     DX, OFFSET Int2F        ; point to our interrupt handler
        mov     AX, 252Fh               ;
        int     21h                     ; install it

        mov     AX, 351Ch               ; get interrupt 1C location
        int     21h                     ;
        mov     CS: [Old_1C], BX        ; save offset
        mov     CS: [Old_1C+2], ES      ; save segment
        mov     DX, OFFSET Int1C        ; point to our interrupt handler
        mov     AX, 251Ch               ;
        int     21h                     ; install it

        mov     DX, OFFSET Success      ; let 'em know we're done
        mov     AH, 9                   ;
        int     21h                     ; display it

        mov     DX, OFFSET Copyright    ; point to transient code
        int     27h                     ; release it

Exit:
        mov     AX, 4C00h               ; exit with an error level of zero
        int     21h                     ;
LoadProg EndP
Code    EndS
        End     Start
