/*
** AREXX $VER: MakeTeXFont 1.01
**
** Send new features and bug reports to 
**
** Martin Bokaemper
** Reuthstr. 12
** 91099 Poxdorf
** Germany
**
** Email: mnbokaem@cip.e-technik.uni-erlangen.de (Internet)
**        mab@ame.zer (Zerberus)
**
** Ulrich Wisser
** Heerstr. 125
** 53111 Bonn
**
** HISTORY:
**
** 0.80: My 'works-fine-for-me' version modified by Georg Hessmann 13.04.91
**       + Variables for all directories and filenames
**       + ^C and ^D detection 
**       + support for a 'modefile' containing site-specific information
**       + searches for standard magsteps 
**       + support for different format-files
**
** 0.81: + take new Parameters 'drivertype' and 'pkfilename' 
**       Georg Hessmann 17.04.91
**
** 0.82: + History 
**       + a lot of small improvements and bugfixes
**       + looking for PK-directory for each device 
**       + checking if the font already exists
**       Martin Bokaemper 21.04.91
**
** 0.84: + add new parameter 'pkdir' (new since driver version V1.10)
**       Georg Hessmann 09.06.91
**
** 0.85: + fixed a pkdir/pkfilename mixing bug
**       + slight modifications, now works with old driver versions
**       + changed exit codes
**       + always calls uses plain.base (absolutely no gain in using cmbase)
**       J\"org H\"ohle 24.6.91, 01.08.91
**
** 0.86: + fixed makedir(pkname) bug
**       J\"org H\"ohle 06.08.91
**
** 0.90: + add makedir(pkdir)
**       + delete localfont entry in 'modes' file
**       Georg Hessmann 28.08.91
**
** 1.00: + only one logfile entry per call
**       + ERROR: now reports interpreted sourceline
**       + fonts can be copied to mf:<mode> for font-caching
**       + magstep calculation improved.  now same as in ShowDVI/DVIPrint
**       + MISSING: \scrollmode correctly inserted
**       Ulrich Wisser 25.08.92
**
** 1.01: + bumped revision number because of partial integration of
**       + versions 0.91 and 1.0 and some personal modifications.
**       Andreas Scherer 31.10.93
*/

Signal On ERROR
Signal On BREAK_C
Signal On BREAK_D

/*
** Files / Directories
*/
LOGDIR       = "MF:log"                 /* directory of the logfiles    */
                                        /* without trailing slash!      */
LOGNAME      = LOGDIR"/MakeTeXFont.log" /* logfile                      */
PKDIR        = "TeX:pk/"                /* Where pk fonts are copied to */
MODEFILENAME = "MF:config/modes"        /* description of the modes     */
TEXTFM       = "TeX:fonts/"             /* TeX tfm-files directory      */
VIRMF        = "MF:bin/VirMF"
GFTOPK       = "MF:bin/GFtoPK"
FONTFILENAME = "TeX:config/fontvols"

/*
** Bases. Put in others, if you like.
*/
NORMALBASE = "plain"

/*
** Arguments
*/
Parse Arg FNTNAME DPI HBASEDPI VBASEDPI DRIVERTYPE PKFILENAME PKDIR .

Say "Making font "FNTNAME" at "DPI" dpi and base ("HBASEDPI","VBASEDPI")"

If ~Show('Libraries','rexxsupport.library') Then Do
  If ~AddLib('rexxsupport.library',0,-30) Then Do
     Say "No RexxSupport.library ... No Metafont!"
     Exit 5
  End
End

DUMMY = Time("Reset")

If ~Exists(LOGDIR) Then Do
  Address COMMAND 'MakeDir 'LOGDIR
  If ~Exists(LOGDIR) Then Do
    Call Log("Could not create logdir="LOGDIR)
    Exit 5
  End
  Say "logfile-directory ("LOGDIR"/) did not exist. It was created."
End

If ~Exists(LOGNAME) Then Do
  Address COMMAND 'echo >'||LOGNAME
  If ~Exists(LOGNAME) Then Do
    Call Log("Could not create logfile="LOGDIR"/"LOGNAME)
    Exit 5
  End
  Say "logfile did not exist. It was created."
End

FNTNAME    = Translate(FNTNAME,XRange('a','z'),XRange('A','Z')) /* lower */
DPI        = Strip(DPI)
HBASEDPI   = Strip(HBASEDPI)
VBASEDPI   = Strip(VBASEDPI)
DRIVERTYPE = Translate(DRIVERTYPE,XRange('a','z'),XRange('A','Z')) /* lower */
PKFILENAME = Translate(PKFILENAME,XRange('a','z'),XRange('A','Z')) /* lower */
PKDIR      = Translate(PKDIR,XRange('a','z'),XRange('A','Z')) /* lower */

/*
** Changed 19.07.92 by Ulrich Wisser
** Needed to calculate correct DPI sizes
*/
Numeric DIGITS 12

/*
** What magstep should the font have?
*/
MAG = DPI/HBASEDPI

/*
** MAGMULT.NUM.I set to correct values!
** 21.07.92 by Ulrich Wisser
** Needed to calculate correct DPI values.
*/
MAGMULT.0      = 13            /* number of saved MagSteps */

MAGMULT.NUM.1  = 1.0           /* MagStep(0)   */
MAGMULT.STR.1  = "0"
MAGMULT.NUM.2  = 1.09544511501 /* MagStep(0.5) */
MAGMULT.STR.2  = "0.5"
MAGMULT.NUM.3  = 1.2           /* MagStep(1)   */
MAGMULT.STR.3  = "1"
MAGMULT.NUM.4  = 1.31453413801 /* MagStep(1.5) */
MAGMULT.STR.4  = "1.5"
MAGMULT.NUM.5  = 1.44          /* MagStep(2)   */
MAGMULT.STR.5  = "2"
MAGMULT.NUM.6  = 1.57744096561 /* MagStep(2.5) */
MAGMULT.STR.6  = "2.5"
MAGMULT.NUM.7  = 1.728         /* MagStep(3)   */
MAGMULT.STR.7  = "3"
MAGMULT.NUM.8  = 2.0736        /* MagStep(4)   */
MAGMULT.STR.8  = "4"
MAGMULT.NUM.9  = 2.48832       /* MagStep(5)   */
MAGMULT.STR.9  = "5"
MAGMULT.NUM.10 = 2.985984      /* MagStep(6)   */
MAGMULT.STR.10 = "6"
MAGMULT.NUM.11 = 3.5831808     /* MagStep(7)   */
MAGMULT.STR.11 = "7"
MAGMULT.NUM.12 = 4.29981696    /* MagStep(8)   */
MAGMULT.STR.12 = "8"
MAGMULT.NUM.13 = 5.159780352   /* MagStep(9)   */
MAGMULT.STR.13 = "9"

MAGMULT.STR.DEFAULT = "???"
MAGSTR              = MAGMULT.STR.DEFAULT

/*
** Changed 21.07.92 by Ulrich Wisser
** DPI rounding caused troubles sometimes, e.g., for
** magstep2 with ShowDVI 44x44
*/
Do I = 1 To MAGMULT.0
  MAGDPI = (MAGMULT.NUM.I * HBASEDPI) + 0.5
  If Pos('.',MAGDPI) > 0 Then
    MAGDPI = Left(MAGDPI,Pos('.',MAGDPI)-1)
  If MAGDPI = DPI Then Do
    MAG    = MAGMULT.NUM.I
    MAGSTR = MAGMULT.STR.I
    Leave I
  End
End

If MAGSTR ~= MAGMULT.STR.DEFAULT Then MAG = 'magstep('magstr')'

/*
** Modes ... search the correct mode in the file MODEFILENAME (see above).
*/
If ~Open('MODEFILE',MODEFILENAME,'READ') Then Do
  Call Log("Can't find file "MODEFILENAME"!")
  Exit 5
End

/*
** 29.10.1993 Andreas Scherer: I keep this from version 0.91, because my
** configuration depends on argument PKDIR.
** In case this doesn't work, put in the following by Ulrich Wisser:
**
**   Do Until(XRES==HBASEDPI & YRES == VBASEDPI) | EOF('MODEFILE')
**     LINE = ReadLn('MODEFILE')
**     LINE = Readln('MODEFILE')
**     LINE = Strip(Translate(LINE, ' ', '   '))
**     MODE = Word(LINE,1)
**     XRES = Word(LINE,2)
**     YRES = Word(LINE,3)
**   End
**
** Maybe this could work with an additional entry
**     PKDIR = Word(LINE,4)
*/
Do Until (XRES == HBASEDPI & YRES == VBASEDPI) | EOF('MODEFILE')
  Parse Value Translate(Readln('MODEFILE'),'','2009'X) With MODE XRES YRES PKDIR .
End

If ~Close('MODEFILE') Then
  Call Log("Can't close mode-file!")

If XRES ~= HBASEDPI | YRES ~= VBASEDPI Then Do
  MODE = '' /* for pretty log-entry */
  Call Log("Can't find matching mode!  Make an update in your "MODEFILENAME" file.")
  Exit 5
End

/*
** Produce the complete name of the file.
*/
If PKFILENAME="" Then
  PKNAME = PKDIR||DPI'/'FNTNAME'.'DPI'pk'
Else
  PKNAME = PKDIR||PKFILENAME

/*
** Look if the font already is there.
*/
If Exists(PKNAME) Then Do
  Say "The font "PKNAME" already exists!"
  Say "Check your driver's configuration!"
  Call Log(PKNAME" already exists; check your driver's configuration!")
  Exit 5
End

/*
** Install the options MetaFont is called with.
*/
FORMAT = NORMALBASE

If MAGSTR ~= MAGMULT.STR.DEFAULT Then
  OPTIONS = "\mode:="MODE"; mag:=magstep("MAGSTR"); scrollmode; input "FNTNAME
Else
  OPTIONS = "\mode:="mode"; mag:="MAG"; scrollmode; input "FNTNAME

DUMMY = Pragma("directory","MF:")
Address COMMAND

/*
** First: Create the GF-file and the TFM-file and the LOG-file
** by calling the METAFONT progam.  If anything below fails, you
** can proceed by hand; all necessary files will be present.
*/
Say "Calling MetaFont with format: &"FORMAT" and startup commands: "
Say "'"OPTIONS"'"

VIRMF '&'FORMAT' "'OPTIONS'"'

/*
** My version of METAFONT returns codes 0, 5, 10 or 20.
** Take appropriate actions.
*/
ERRORCODE = RC

If 5 >= ERRORCODE Then Do
  If 0 < ERRORCODE Then
    Say "Translation problem, MetaFont returned "ERRORCODE"."
  Else
    Say FNTNAME" translated without errors."
End; Else Do
  Say "Translation error, MetaFont returned "ERRORCODE"."
  EDITSCRIPT = Word(MyGetEnv("MFREXXEDIT"),1)
  If "" = EDITSCRIPT Then
    EDITSCRIPT = 'MFEdit.rexx'
  Say "Start editor for "FNTNAME" with "EDITSCRIPT"."
  EDITSCRIPT FNTNAME 0
  Exit 5
End

/*
** Second: Create the PK-file by calling the GFtoPK program.
** This is done in the "MF:" directory, not in the final path.
*/
GFTOPK FNTNAME'.'DPI'gf'

/*
** Don't delete the GF-file on failure.
*/
If Exists(FNTNAME'.'DPI'pk') Then Do
  Delete FNTNAME'.'DPI'gf'
  FileNote FNTNAME'.'DPI'pk' ' "mode='MODE', magstep='MAGSTR'"'
End

/*
** Third: Create all needed directories and try to move the
** files appropriately.
*/

/*
** Don't include last '/' in PKDIR, makedir doesn't like it.
*/
PKDIR2 = Left(PKDIR,LastPos("/",PKDIR)-1)

If ~Exists(PKDIR2) Then
  If ~MakeDir(PKDIR2) Then Do
    Call Log("MakeDir "PKDIR2" failed")
    Exit 5
  End

/*
** A '/' is required to exist in PKNAME
*/

/*
** Don't include last '/' in FULLDIR, makedir doesn't like it.
*/
FULLDIR = Left(PKNAME,LastPos("/",PKNAME)-1)

If ~Exists(FULLDIR) Then
  If ~MakeDir(FULLDIR) Then Do
    Call Log("MakeDir "FULLDIR" failed")
    Exit 5
  End

/*
** Check the TFM-file; if it doesn't exist, move it there
** and delete it here.
*/
If Exists(TEXTFM) & ~Exists(TEXTFM||FNTNAME'.tfm') Then Do
  Copy FNTNAME'.tfm' TEXTFM clone
  Protect TEXTFM||FNTNAME'.tfm' r
End

Delete FNTNAME'.tfm'

/*
** The following section makes a copy of the pk-file to MF:<mode>/PKFILENAME
** This is useful if you like to copy all new font-files to disks for
** future font-caching.  See the documentation for further details.
*/
/*
If ~Exists(MODE) Then Do
  If ~MakeDir(MODE) Then Do
    Call Log("Makedir "MODE" failed!")
  End
End
If ~Exists(MODE'/'DPI) Then Do
  If ~MakeDir(MODE'/'DPI) Then Do
    Call Log("Makedir "MODE"/"DPI" failed!")
  End
End
If Exists(MODE) Then
  Copy FNTNAME'.'DPI'pk' MODE'/'PKFILENAME
*/

Copy FNTNAME'.'DPI'pk' PKNAME clone
Delete FNTNAME'.'DPI'pk'
Protect PKNAME r

/*
** Copy/Delete instead Rename to overwrite existing logfile (e.g., from
** a failed call of MakeTeXfont). Replace by 'move' if you have ARP:
** i.e., add a line here ``copy = "move" or "mv"''.  This seems to be
** the case for Ulrich Wisser in Version 1.0, as he uses "move" here.
** I still assume that most people want to use this script with the
** original WorkBench, so double moving would cause this to crash.
** Also, copy/delete unlike move works between devices, too.
*/
Copy FNTNAME'.log' LOGDIR'/'FNTNAME'.'DPI'log'
Delete FNTNAME'.log'

ELAPSED = Time("ELAPSED")
Call Log("created in "ELAPSED%3600":"Right(ELAPSED%60//60,2,'0')":"Right(ELAPSED%1//60,2,'0'))

Exit 0

/*
** Log-function
*/
LOG: Procedure Expose LOGNAME FNTNAME MODE HBASEDPI VBASEDPI DPI MAGSTR
Parse Arg MSG

MESSAGE = Date()" "Time()": "FNTNAME" for "MODE" ("HBASEDPI","VBASEDPI") with "DPI" dpi (mag="MAGSTR") "'0A'X || MSG
Say MESSAGE

If ~Open(LOGFILE,LOGNAME,'Append') Then Do
  Say "Can't open logfile!"
  Return
End

DUMMY = Writeln(LOGFILE,MESSAGE)
If ~Close(LOGFILE) Then
  Say "Can't close logfile!"

Return

/*
** Signal-functions.
*/
ERROR:
  DOLINE = 'call log("errorlevel 'rc' in line 'sigl': "'sourceline(sigl)')'
  Interpret(DOLINE)
  If Exists(FNNAME'.log') Then Do
    Copy FNTNAME'.log' FNTNAME'.'DPI'log'
    Delete FNTNAME'.log'
  End
  Exit 1

BREAK_C:
BREAK_D:
  Call Log "execution aborted!"
  If Exists(FNTNAME'.'DPI'gf') Then
    DUMMY = Delete FNTNAME'.'DPI'gf'
  If Exists(FNTNAME'.log') Then
    DUMMY = Delete FNTNAME'.log'

  Exit 1
