/*** 
Demo program to demonstrate the use of the Ferns' Graphics Library V 1.2.
Programmer : F.D. Paanakker, 1994.

This DEMO program gives some examples of what you can do with the
Ferns' Graphics Library.
Although this demo is not particularly gripping, it works in 3 different
graphic modes : 16 color, 256 color and 32768 Hicolor ! 
The library has 16 color VGA support, but that is just so you can run
it on almost every computer. The 16 color mode functions for saving and
restoring backgrounds are not fast...maybe they will be fast in the
next version of the library. For now they are just to support the few
computer-owners who still have to cope with a standard VGA. 
The 256 color and 32768 Hicolor functions are highly optimized.
They are particularly fast !
There are about 16 different SuperVGA cards that are supported. There's
also VESA support ! 
Hope you enjoy this demo and that it may give you many ideas...

Compile with :
        CLIPPER FGL_DEMO /N
***/

PROCEDURE FGL_DEMO()         // main module.
 SET SCOREBOARD OFF

  if (FGL_VGA_640x480() = .F.)              // Initialize video mode 640x480
   QOUT("Hicolor Video not found...aborting")
   QUIT
  end if

  FGL_load_font("normal.fnt")               // load normal font 
  ini_colors()                  // This functions initializes colors like
                                // WHITE,RED,BLACK etc...

  FGL_fill_rectangle(0,0,639,479,BLUE)      // blue background
  IntroWindow(0,140)                        // window about features FGL
  SpecialWindow(400,60)                     // Different kinds of windows
  GraphWindow(50,100)                       // Show graphic primitives
  FontWindow(0,0)                           // Show different fonts
  SayGetWindow(135,230)                     // Window to demonstrate SAY and GET support
  FGL_fill_rectangle(0,0,639,479,BLUE)      // clear background for last window
  LastWindow(150,90)                        // Window about FGL
 FGL_free_font()                             // release font-memory
 FGL_TEXTMODE()                              // back to textmode.
 QUIT                                        // THE END
RETURN

PROCEDURE IntroWindow(X,Y)
/* Introduction window */
local text := {"With the Ferns' Graphics Library you can easily incorporate neat",;
                "graphics into your Clipper application.",;
                "There are functions for lines, text, circles, ellipses, rectangles, points,",; 
                "different fonts, etc. etc.",;
                "Then there are also functions to get en put backgrounds, display check-",;
                "boxes, radiobuttons, windows and normal buttons."}

  // N.B. : We don't save the background !
                                                // make window
  FGL_OS2window(X,Y,639,200,"Ferns' Graphics Library Demo") 
                                                // print text
  for i := 1 TO 6 ; FGL_text(X+10,Y+40+i*16,BLACK,WHITE,text[i]) ; next   

                                                // make button
  FGL_textbutton(X+220,Y+160,X+440,Y+180,"Continue")
  selected(X+220,Y+160,X+440,Y+180,BLACK)       // special function to select button
  INKEY(0)                                      // wait for key pressed
  selected(X+220,Y+160,X+440,Y+180,WHITE)       // unselect button
RETURN // IntroWindow

PROCEDURE SpecialWindow(X,Y)
/* Shows different types of windows */
local i
local back                                         // variable for background
local text1 := {"You can make your","program look like",;
                "an OS/2 program with","this window..."}
local text2 := {"or like an Windows pro-","gram with this window."}
  FGL_text(10,463,BRIGHT_WHITE,BLUE,'Please wait while saving background ...')
  back := FGL_get_background(X,Y,X+200,Y+200)      // save background
  FGL_text(10,463,BRIGHT_WHITE,BLUE,'                                       ')
  FGL_OS2window(X,Y,200,200,"OS/2-like window")    // draw OS/2-like window
  FOR i := 1 TO 4 
   FGL_text(X+10,Y+20+(i*20),BLACK,WHITE,text1[i]) // text in window 
  NEXT i 
  FGL_textbutton(X+50,Y+160,X+150,Y+180,"Next")    // button
  selected(X+50,Y+160,X+150,Y+180,BLACK)           // make button selected
  inkey(0)                                         // wait for key pressed
  FGL_WINwindow(X,Y,200,200,"Windows-like window") // new window
  FOR i := 1 TO 2 
   FGL_text(X+10,Y+40+(i*20),BLACK,BRIGHT_WHITE,text2[i])    // text in window 
  NEXT i 
   FGL_textbutton(X+50,Y+160,X+150,Y+180,"Continue")// button
  selected(X+50,Y+160,X+150,Y+180,BLACK)            // make button selected
  inkey(0)                                          // wait for key pressed
  FGL_put_background(X,Y,X+200,Y+200,back)          // restore background
RETURN // SpecialWindows

PROCEDURE GraphWindow(X,Y)
/* Shows graphic primitives */
local back                                        // variable for background
  FGL_text(10,463,BRIGHT_WHITE,BLUE,'Please wait while saving background ...')
  back := FGL_get_background(X,Y,X+500,Y+300)     // save background
  FGL_text(10,463,BRIGHT_WHITE,BLUE,'                                       ')
  FGL_OS2window(X,Y,500,300,"Window to demonstrate different graphic primitives")
  FGL_text(X+10,Y+25,RED,WHITE,"The diffent graphic primitives are :")
  FGL_rectangle(X+9,Y+49,X+491,Y+241,GRAY)        // make neat window
  FGL_line(X+9,Y+49,X+9,Y+241,BRIGHT_WHITE)
  FGL_line(X+9,Y+49,X+491,Y+49,BRIGHT_WHITE)
  RandomPrimitives(X,Y)                           // Show different primitives
  ButtonWindow(10,10)                             // call function (so you can
                                                  // see that multiple windows
                                                  // are saved correctly).
  FGL_put_background(X,Y,X+500,Y+300,back)        // restore background
RETURN // GraphWindow

PROCEDURE RandomPrimitives(X,Y)
/* procedure will draw rectangles of random size at random locations */
local key,xpos,ypos,width,hight,color
local prim                                        // PRIMitive counter
local text := {"lines            ",;              // names of primitives
               "open rectangles  ",;
               "filled rectangles",;
               "open ellipses    ",;
               "filled ellipses  ",;
               "open circles     ",; 
               "filled circles   "}
  
  FGL_textbutton(X+200,Y+260,X+300,Y+280,"Next")  // button

  FOR prim := 1 TO 7
    FGL_set_viewport(0,0,0,0)                     // viewport now total screen
    FGL_text(X+310,Y+25,BLUE,WHITE,text[prim])
    selected(X+200,Y+260,X+300,Y+280,BLACK)       // make button selected
    FGL_set_viewport(X+10,Y+50,X+490,Y+240)       // viewport : all output outside
                                                  // this window won't be drawn.
    FGL_fill_rectangle(X+10,Y+50,X+490,Y+240,prim)// background
    key := INKEY()                           // get last key and make current
    srandom(prim)                            // SeedRandom : starting point   
                                             // random generator. This function   
                                             // is supplied in Random.obj
     DO WHILE (key = INKEY())                // loop while no key is pressed   
       xpos := random() % 500                // select random values.
       ypos := random() % 250                // the function random is also
       width := (random() % 50)+40           // supplied in Random.obj
       hight := (random() % 50)+40           // minimum value 40
       color := random() % FGL_getnumcolors()// select one out of all the
                                             // colors available.
       DO CASE                               // which primitives is to be drawn ?
         CASE prim = 1 ; FGL_line(X+xpos,Y+ypos,X+(random()%500),Y+(random()%250),color)
         CASE prim = 2 ; FGL_rectangle(X+xpos,Y+ypos,X+xpos+width,Y+ypos+hight,color)
         CASE prim = 3 ; FGL_fill_rectangle(X+xpos,Y+ypos,X+xpos+width,Y+ypos+hight,color)
         CASE prim = 4 ; FGL_ellipse(X+xpos,Y+ypos,X+xpos+width,Y+ypos+hight,color)
         CASE prim = 5 ; FGL_fill_ellipse(X+xpos,Y+ypos,X+xpos+width,Y+ypos+hight,color)
         CASE prim = 6 ; FGL_circle(X+xpos,Y+ypos,width,color)
         CASE prim = 7 ; FGL_fill_circle(X+xpos,Y+ypos,width,color)
       ENDCASE
     ENDDO
    selected(X+200,Y+260,X+300,Y+280,WHITE)  // make button unselected
  NEXT
  
  FGL_fill_rectangle(X+10,Y+50,X+490,Y+240,WHITE)    // background
  FGL_set_viewport(0,0,0,0)                          // viewport now total screen
  FGL_textbutton(X+200,Y+260,X+300,Y+280,"Continue") // button
  selected(X+200,Y+260,X+300,Y+280,BLACK)            // make button selected
  FGL_fill_rectangle(X+10,Y+25,X+490,Y+45,WHITE)     // remove text
  FGL_text(X+50,Y+130,BLUE,WHITE,"As you have just seen, all the functions work with") 
  FGL_text(X+50,Y+150,BLUE,WHITE,"    viewports. And at considerable speed too !")
  inkey(0)                                           // wait for key pressed
  selected(X+200,Y+260,X+300,Y+280,WHITE)            // unselect button.
RETURN // Randomprimitives


PROCEDURE ButtonWindow(X,Y)
/* Shows neat window with radiobuttons and checkboxes */
local back                                        // variable for background
  FGL_text(10,463,BRIGHT_WHITE,BLUE,'Please wait while saving background ...')
  back := FGL_get_background(X,Y,X+400,Y+270)     // save background
  FGL_text(10,463,BRIGHT_WHITE,BLUE,'                                       ')
  // now make nice box...
  FGL_fill_rectangle(X,Y,X+400,Y+270,WHITE)
  FGL_rectangle(X,Y,X+400,Y+270,BLACK)
  little_shade(X+5,Y+5,X+400-5,Y+270-5)           // function for kind of 
                                                  // a shadowbox.
  little_shade(X+10,Y+15,X+400-10,Y+105)
  little_shade(X+10,Y+115,X+400-10,Y+225)
  little_shade(X+10,Y+235,X+400-10,Y+255)
  
  FGL_text(X+40,Y+20,BLUE,WHITE,"Want do you want ?")
  FGL_text(X+40,Y+40,BLACK,WHITE,"Windows, with all it's overhead.")
  FGL_text(X+40,Y+60,BLACK,WHITE,"Expensive DOS graphics lib.")
  FGL_text(X+40,Y+80,BLACK,WHITE,"The Ferns' Graphics Library !")
  FGL_RADIOBUTTON(X+20,Y+40,.F.)                  // display radiobutton
  FGL_RADIOBUTTON(X+20,Y+60,.F.)
  FGL_RADIOBUTTON(X+20,Y+80,.T.)
  
  FGL_text(X+40,Y+120,RED,WHITE,"The FG Library has :")
  FGL_text(X+40,Y+140,BLACK,WHITE,"VGA, SuperVGA and Hicolor support !")
  FGL_text(X+40,Y+160,BLACK,WHITE,"support of many graphic modes !")
  FGL_text(X+40,Y+180,BLACK,WHITE,"Very fast and neat graphics !")
  FGL_text(X+40,Y+200,BLACK,WHITE,"All kinds of useful functions !")
  FGL_CHECKBOX(X+20,Y+140,.T.)                    // display checkbox
  FGL_CHECKBOX(X+20,Y+160,.T.)
  FGL_CHECKBOX(X+20,Y+180,.T.)
  FGL_CHECKBOX(X+20,Y+200,.T.)

  FGL_text(X+12,Y+238,BLACK,WHITE,"The FG Library makes graphics programming easy!")
  inkey(0)                                        // wait for keypress
  FGL_put_background(X,Y,X+400,Y+270,back)        // restore background
RETURN // ButtonWindow

PROCEDURE FontWindow(X,Y)
local back                                        // variable for background
  FGL_text(10,463,BRIGHT_WHITE,BLUE,'Please wait while saving background ...')
  back := FGL_get_background(X,Y,X+450,Y+150)     // save background
  FGL_text(10,463,BRIGHT_WHITE,BLUE,'                                       ')
  FGL_fill_rectangle(X,Y,X+450,Y+150,WHITE)       // make neat box
  FGL_rectangle(X,Y,X+450,Y+150,BLACK)
  little_shade(X+5,Y+5,X+450-5,Y+150-5)
  
  FGL_text(X+10,Y+10,BLACK,WHITE,"You can put text on the screen using the normal font.")
  FGL_load_font("helvetic.fnt")                   // load helvetic font 
  FGL_text(X+10,Y+50,RED,WHITE,"or surprise everyone with the HELVETIC font !")
  FGL_load_font("script.fnt")                     // load script font 
  FGL_text(X+10,Y+70,RED,WHITE,"or surprise everyone with the SCRIPT font !")
  FGL_load_font("broadway.fnt")                   // load broadway font 
  FGL_text(X+10,Y+90,RED,WHITE,"or surprise everyone with the BROADWAY font !")
  FGL_load_font("normal.fnt")                     // now load normal font 
  FGL_textbutton(X+175,Y+150-30,X+275,Y+150-10,'Continue')
  selected(X+175,Y+150-30,X+275,Y+150-10,BLACK)   // make button selected
  inkey(0)                                        // wait for keypress
  selected(X+175,Y+150-30,X+275,Y+150-10,WHITE)   // unselect button
  FGL_put_background(X,Y,X+450,Y+150,back)        // restore background
RETURN // FontWindow

PROCEDURE SayGetWindow(X,Y)
local text := "Test input"
  // N.B. : We don't save the background !
  FGL_OS2window(X,Y,500,200,"The FG Library also has SAY and GET support")
  FGL_text(X+8,Y+30,BLACK,WHITE,"Using the old coordinate system, you can still use the normal")
  FGL_text(X+8,Y+50,BLACK,WHITE,"@ SAY and @ GET (with graphical cursor) !!!!")
  FGL_textbutton(X+200,Y+200-30,X+300,Y+200-10,'Continue')
  FGL_rectangle(23*8-1,20*16-1,33*8,21*16,BLACK) // black rect around input
  FGL_textcolor(BLACK,BRIGHT_WHITE)              // set color for SAY and GET's
  @ 20,23 GET text                               // display get
  READ                                           // get input
  selected(X+200,Y+200-30,X+300,Y+200-10,BLACK)   // make button selected
  inkey(0)                                        // wait for keypress
  selected(X+200,Y+200-30,X+300,Y+200-10,WHITE)   // unselect button
RETURN  // SayGetWindow

PROCEDURE LastWindow(X,Y)
local back,i,text := {"As you have just seen, the Ferns'",; 
                    "Graphics Library contains many powerful",;
                    "graphic functions. As development conti-",;
                    "nues, there soon will be mouse, 24 bits",; 
                    "Truecolor and wallpaper support. If you",; 
                    "register now, you will receive the la-",;
                    "test version and notification of major",; 
                    "new versions.",; 
                    "With the Ferns' Graphics Library, you",; 
                    "will be ready for whatever comes next !"}
  FGL_text(10,463,BRIGHT_WHITE,BLUE,'Please wait while saving background ...')
  back := FGL_get_background(X,Y,X+340,Y+300)     // save background
  FGL_text(10,463,BRIGHT_WHITE,BLUE,'                                       ')
  FGL_fill_rectangle(X,Y,X+340,Y+300,WHITE)       // make another neat box
  FGL_rectangle(X,Y,X+340,Y+300,BLACK)
  little_shade(X+5,Y+5,X+340-5,Y+300-5)
  FOR i := 1 TO 10
   FGL_text(X+10,Y+30+((i-1)*20),BLACK,WHITE,text[i])  // text in window
  NEXT i
  FGL_textbutton(X+120,Y+300-50,X+220,Y+300-30,'End Demo')
  selected(X+120,Y+300-50,X+220,Y+300-30,BLACK)   // make button selected
  inkey(0)                                        // wait for keypress
  selected(X+120,Y+300-50,X+220,Y+300-30,WHITE)   // make button unselected
  FGL_put_background(X,Y,X+340,Y+300,back)        // restore background
RETURN // LastWindow

PROCEDURE little_shade(X1,Y1,X2,Y2)
/* procedure to make open rectangle with shade .. */
  FGL_rectangle(X1,Y1,X2-1,Y2-1,GRAY)
  FGL_rectangle(X1+1,Y1+1,X2,Y2,BRIGHT_WHITE)
RETURN // little_shade

PROCEDURE selected(X1,Y1,X2,Y2,color)
/* Functions draws outline around button in 'color' */
 FGL_line(X1-1,Y1+3,X1-1,Y2-3,color)
 FGL_line(X2+1,Y1+3,X2+1,Y2-3,color)
 FGL_line(X1+3,Y1-1,X2-3,Y1-1,color)
 FGL_line(X1+3,Y2+1,X2-3,Y2+1,color)
RETURN // selected

PROCEDURE ini_colors()
/***
Procedure initializes colors. Best method if you want to program in
3 different graphic modes...
***/
public BLACK,BLUE,RED,WHITE,GRAY,BRIGHT_WHITE //Variable visible in whole program

IF (FGL_getnumcolors() = 16 .OR. FGL_getnumcolors() = 256)  // which mode ?
 BLACK := 0                             // 16 and 256 color mode
 BLUE  := 1
 RED   := 4
 WHITE := 7
 GRAY  := 8
 BRIGHT_WHITE := 15
ELSE
 BLACK := 0                             // 32768 Hicolor mode.
 BLUE  := 21
 RED   := 21504
 WHITE := 22197
 GRAY  := 10570
 BRIGHT_WHITE := 32767
ENDIF                                   // done..

RETURN // ini_colors()

/*** END DEMO PROGRAM ***/
