#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "orbit.inc"

#declare Planet_Texture = texture {
	color red .7 green .3 blue 0 ambient .5 diffuse .9
}

camera {
	location <0 48 -5>
	direction <0 0 1.5>
	up <0 1 0>
	right <1.33 0 0>
	look_at <0 0 0>
	translate <6 0 0>
}

//  Here is the sun positioned at (0,0)
object {
   union {
      sphere { <0 0 0> 1
         texture {
            color red 1.0 green 0.6 alpha 0.35
            ambient 1.0
            diffuse 0.0
        }
      }
      light_source { <0  0  0>  color White }
   }
}

//  Planet 1
object {
	sphere { <x1 0 z1> .5}
	texture {Planet_Texture}
}

//  Planet 2
object {
	sphere { <x2 0 z2> .7}
	texture {color red .8 green .1 blue .1 ambient .5 diffuse .9}
}

//  Planet 3
object {
	sphere { <x3 0 z3> .55}
	texture {color red .4 green .2 blue .5 ambient .5 diffuse .9}
}

//  Moon around planet 3
object {
	sphere { <xm 0 zm> .25}
	texture {color red .8 green .2 blue 0 ambient .5 diffuse .9}
}
