DEFINT A-Z

    CONST BPORT = &H220  'Base Port address
    CONST XPORT = &H226  'Reset port address
    CONST WPORT = &H22C  'Write port address
    CONST RPORT = &H22A  'Read port address
    CONST APORT = &H22E  'Data Available port address

    DIM lenarray(30)    'pos/neg sustinance
    lens = 0
    last = 0

    DEF SEG = &HA000
    SCREEN 13
    
    DO
        OUT WPORT, &H20           'Tell SoundBlaster you wanna read a byte.
        gotit = INP(RPORT)
        gg = (gotit - 128)
        IF gg > 4 THEN current = 1 ELSE IF gg < -4 THEN current = -1 ELSE current = last
        IF current <> last THEN
            IF lens > 309 THEN lens = 309
            lens = lens \ 10
            lenarray(lens) = lenarray(lens) + (lens \ 3)
            lens = 0
        ELSE
            lens = lens + 1
        END IF
        
        at = at + 1

        last = current
        
        IF at = 2500 THEN
            at = 0
            FOR r = 0 TO 30
                xx = lenarray(30 - r)
                lenarray(30 - r) = 0
                IF xx > 94 THEN xx = 94

                    IF xx < 94 THEN
                        FOR rr = xx + 1 TO 94
                            POKE (((94 - rr) * 320) + r) * 2 + 1, &H0
                        NEXT
                    END IF

                    FOR rr = 0 TO xx
                        POKE (((94 - rr) * 320) + r) * 2 + 1, &HF
                    NEXT
            NEXT
        END IF
    LOOP UNTIL INP(&H60) = 1    'esc pressed

    SCREEN 0
    PRINT "Realtime Frequency Analysis"
    PRINT
    PRINT " -based sustinance above/below neutral sample point"
    PRINT " -ie: high frequency / complex frequency --> high crossrate"
    PRINT "      low frequency / simple frequency ----> low crossrate"
    END

