DECLARE FUNCTION bitswap% (i%, nu%)
DECLARE SUB fft (real.data%(), imag.data%(), n.pts%, nu%, inv%)

'*  real.data%() ... real part of data to be transformed
'*  imag.data%() ... imag  "   "   "   "  "      "
'*  inv% ..... Switch to flag normal or inverse transform
'*  n.pts% ... Number of real data points
'*  nu% ...... logarithm in base 2 of n.pts% e.g. nu% = 5 if n.pts% = 32.

'for some reason, does not work...


CONST PI = 3.1419527#

FUNCTION bitswap% (i%, nu%)
    'Bit swaping routine in which the bit pattern of the integer i%
    'is reordered.

    'int i%, nu%
    'int ib%, i1%, i2%

    ib% = 0

    FOR i1% = 0 TO nu%
        i2% = i% / 2
        ib% = ib% * 2 + i% - 2 * i2%
        i% = i2%
    NEXT i1%
    bitswap% = ib%
END FUNCTION

SUB fft (real.data%(), imag.data%(), n.pts%, nu%, inv%)
    'int n.pts%, nu%, inv%                 
    'int n2%, j%, j1%, l%, i%, ib%, k%, k1%, k2%
    'int sign%                 
    'double tr#, ti#, arg#, nu1#    'intermediate values in calcs.
    'double c#, s#                  'cosine & sine components of Fourier
                                    'trans.

    n2% = n.pts% / 2
    nu1# = nu% - 1
    k% = 0

    'sign change for inverse transform
    IF inv% THEN sign% = -1 ELSE sign% = 1

    'Calculate the componets of the Fourier series of the function
    FOR l% = 0 TO nu%
        DO
            FOR i% = 0 TO n2%
                j% = k% / (nu1# ^ 2)
                ib% = bitswap%(j%, nu%)
                arg# = 2 * PI * ib% / n.pts%
                c# = COS(arg#)
                s# = sign% * SIN(arg#)
                k1% = k%
                k2% = k1% + n2%
                tr# = real.data%(k2%) * c# + imag.data%(k2%) * s#
                ti# = imag.data%(k2%) * c# - real.data%(k2%) * s#
                real.data%(k2%) = real.data%(k1%) - tr#
                imag.data%(k2%) = imag.data%(k1%) - ti#
                real.data%(k1%) = real.data%(k1%) + tr#
                imag.data%(k1%) = imag.data%(k1%) + ti#
                k% = k% + 1
            NEXT i%
            k% = k% + n2%
        LOOP WHILE (k% < n.pts% - 1)
        k% = 0
        nu1# = nu1# - 1
        n2% = n2% / 2
    NEXT l%

    FOR k% = 0 TO n.pts%
        ib% = bitswap%(k%, nu%)
        IF ib% > k% THEN
            SWAP real.data%(k%), real.data%(ib%)
            SWAP imag.data%(k%), imag.data%(ib%)
        END IF
    NEXT k%

    'If calculating the inverse transform, must divide the data
    'by the number of data points.
    IF inv% THEN
        FOR k% = 0 TO n.pts%
            real.data%(k%) = real.data%(k%) / n.pts%
            imag.data%(k%) = imag.data%(k%) / n.pts%
        NEXT k%
    END IF
END SUB

