' MIDI API Functions for Windows 3.1
Declare Function midiOutOpen Lib "mmsystem.dll" (hMidiOut As Integer, ByVal DeviceId As Integer, ByVal C As Long, ByVal I As Long, ByVal F As Long) As Integer
Declare Function midiOutShortMsg Lib "mmsystem.dll" (ByVal hMidiOut As Integer, ByVal midiMessage As Long) As Integer
Declare Function MidiOutClose Lib "mmsystem.dll" (ByVal hMidiOut As Integer) As Integer

Global midiMessageOut As Long
Global midiData1 As Long
Global midiData2 As Long

Global hMidiOut As Integer

' The Patch number array used for current patch for each midi channel
Global midiPatch(16) As Integer

' The Volume array (velocity) used for each MIDI channel
Global midiVolume(16) As Integer

' The Pan array (Left - Center - Right) used for each MIDI channel
Global midiPan(16) As Integer

' The Octave array (piano keys octave shift) used for each MIDI channel
Global octave(16) As Integer

' The current Midi Channel out set on Piano form
Global midiChannelOut As Integer

' NoteRepeat used to stop the same key from repeating.
Global noteRepeat As Integer

' MIDI status messages
Global Const NOTE_OFF = &H80
Global Const NOTE_ON = &H90
Global Const POLY_KEY_PRESS = &HA0
Global Const CONTROLLER_CHANGE = &HB0
Global Const PROGRAM_CHANGE = &HC0
Global Const CHANNEL_PRESSURE = &HD0
Global Const PITCH_BEND = &HE0

' MIDI Controller Numbers Constants
Global Const MOD_WHEEL = 1
Global Const BREATH_CONTROLLER = 2
Global Const FOOT_CONTROLLER = 4
Global Const PORTAMENTO_TIME = 5
Global Const MAIN_VOLUME = 7
Global Const BALANCE = 8
Global Const PAN = 10
Global Const EXPRESS_CONTROLLER = 11
Global Const DAMPER_PEDAL = 64
Global Const PORTAMENTO = 65
Global Const SOSTENUTO = 66
Global Const SOFT_PEDAL = 67
Global Const HOLD_2 = 69
Global Const EXTERNAL_FX_DEPTH = 91
Global Const TREMELO_DEPTH = 92
Global Const CHORUS_DEPTH = 93
Global Const DETUNE_DEPTH = 94
Global Const PHASER_DEPTH = 95
Global Const DATA_INCREMENT = 96
Global Const DATA_DECREMENT = 97

'MIDI Mapper
Global Const MIDI_MAPPER = -1

' MousePointer
Global Const DEFAULT = 0
Global Const HOURGLASS = 11

' Show parameters
Global Const MODAL = 1
Global Const MODELESS = 0

Sub MidiOutOpenPort ()
    Dim midiOpenError As Integer

    Dim msg, response  ' Declare variables.

    'Open MIDIOut using MIDI Mapper
    midiOpenError = midiOutOpen(hMidiOut, MIDI_MAPPER, 0, 0, 0)

    If midiOpenError <> 0 Then
	' Put together a error message box
	msg = "The MIDI Mapper would not open.  It is either already"
	msg = msg & " in use or not installed correctly."
	msg = msg & "  VB MIDI Piano will not make any sound until the"
	msg = msg & " MIDI Mapper can be opened."

	response = MsgBox(msg, 48, "VB MIDI Piano MIDI Open Error")
    End If

End Sub

Sub SendMidiOut ()
    Dim midiMessage As Long
    Dim lowint As Long
    Dim highint As Long
    Dim x As Integer
    
    'Pack MIDI message data into 4 byte long integer
    lowint = (midiData1 * 256) + midiMessageOut
    highint = (midiData2 * 256) * 256

    midiMessage = lowint + highint

    'Windows MIDI API function
    x = midiOutShortMsg(hMidiOut, midiMessage)
End Sub

