(*(***********************************************************************

:Program.    FuelGaugeIClass.mod
:Contents.   boopsi class for fuel gauge image using OberonBOOPSI
:Author.     hartmut Goebel [hG]
:Address.    Aufseplatz 5, D-90459 Nrnberg
:Address.    UseNet: hartmut@oberon.nbg.sub.org
:Address.    Z-Netz: hartmut@asn.zer   Fido: 2:246/81.1
:Copyright.  Copyright  1993 by hartmut Goebel
:Language.   Oberon-2
:Translator. Amiga Oberon 3.0
:Version.    $VER: FuelGaugeIClass.mod 1.3 (5.9.93) Copyright  1993 by hartmut Goebel

(* $StackChk- $NilChk- $RangeChk- $CaseChk- $OvflChk- $ReturnChk- $ClearVars- *)
(****i* FuelGaugeIClass/--history-- ***************************************
*
*********************************************************************)*)*)

MODULE FuelGaugeIClass;

IMPORT
  RootClass,
  I := Intuition,
  IC:= ImageClass,
  g := Graphics,
  u := Utility,
  e := Exec,
  y := SYSTEM;

CONST
  versionString = "$VER: FuelGaugeIClass 1.3 (5.9.93) Copyright  1993 by hartmut Goebel";

TYPE
  FuelGaugeI = UNTRACED POINTER TO FuelGaugeIClass;
  FuelGaugeIClass * = RECORD (IC.ImageClass)
    current  -: LONGINT;
    old       : LONGINT;
    max      -: LONGINT;
    kind     -: SET;
    drawInfo -: I.DrawInfoPtr;
  END;

VAR
  fuelGaugeIClass * : I.IClassPtr;

CONST
  tagDummy = u.user;
  current         * = tagDummy + 1;
  max             * = tagDummy + 2;
  vertical        * = tagDummy + 3;
  fromRightToLeft * = tagDummy + 4;
  fromTopToButtom * = fromRightToLeft;

  (* FuelGaugeIClass.kind: for use by subclasses only *)
  horizontal * = 0;
  reverse    * = 1;

(*
** redifinition of some methods
*)

PROCEDURE Set (VAR fg: FuelGaugeIClass; VAR msg: I.OpSet);
VAR
  tag: u.TagItemPtr;
BEGIN
  fg.old := fg.current;
  fg.drawInfo := u.GetTagDataP(I.sysiaDrawInfo, fg.drawInfo,msg.attrList);
  fg.current  := u.GetTagData(current, fg.current, msg.attrList);
  fg.max      := u.GetTagData(max,     fg.max,     msg.attrList);
  IF fg.max <= 0 THEN fg.max := 1; END;
  tag := u.FindTagItem(vertical, msg.attrList);
  IF tag # NIL THEN
    IF tag.data # I.LFALSE THEN EXCL(fg.kind, horizontal);
                           ELSE INCL(fg.kind, horizontal); END;
  END;
  tag := u.FindTagItem(fromRightToLeft, msg.attrList);
  IF tag # NIL THEN
    IF tag.data = I.LFALSE THEN EXCL(fg.kind, reverse);
                           ELSE INCL(fg.kind, reverse); END;
  END;
END Set;


PROCEDURE (VAR fg: FuelGaugeIClass) New * (VAR msg: I.OpSet): e.APTR;
VAR
  setMsg: I.OpSet;
  tags: u.Tags3;
CONST
  tag3 = u.Tags3(I.iaRecessed,I.LTRUE,
                 I.iaEdgesOnly,I.LTRUE,
                 u.more, NIL);
BEGIN
  setMsg := msg; tags := tag3;
  tags[2].data := msg.attrList; msg.attrList := y.ADR(tags);
  IF fg.New^(msg) # NIL THEN
    fg.kind := {horizontal}; fg.current := 0; fg.max := 100; fg.drawInfo := NIL;
    fg.old := 0;
    Set(fg,msg);
    IF fg.drawInfo = NIL THEN RETURN NIL; END;
    setMsg.attrList := y.ADR(tags);
    IF fg.Set(setMsg) # NIL THEN END;
  END;
  msg.attrList := tags[2].data;
  RETURN fg.image;
END New;


PROCEDURE (VAR fg: FuelGaugeIClass) Draw * (VAR msg: I.Draw): e.APTR;
TYPE
  Pens = STRUCT
    fill, backGround: INTEGER;
  END;
VAR
  left, top, width, height, i: INTEGER;
  fTop, fRight, fButtom: INTEGER;
  eLeft, eRight, eButtom: INTEGER;
  current: LONGINT;
  pens: Pens;
CONST
  normalPens  = Pens(I.fillPen,I.backGroundPen);
  reversePens = Pens(I.backGroundPen,I.fillPen);
BEGIN
  IF fg.Draw^(msg) = NIL THEN END;

  left := msg.offset.x+1; top  := msg.offset.y+1;
  width := fg.image.width-2; height := fg.image.height-2;

  current := fg.current;
  eLeft  := left; fTop := top; eRight := left+width-1; fButtom := top+height-1;
  IF horizontal IN fg.kind THEN
    IF reverse IN fg.kind THEN
      current := fg.max-fg.current; END;
    i := SHORT((width * current) DIV fg.max);
    eButtom := fButtom; fRight  := left+i-1; INC(eLeft,i);
  ELSE
    IF ~ (reverse IN fg.kind) THEN
      current := fg.max-fg.current; END;
    i := SHORT((height * current) DIV fg.max);
    eButtom := top+i-1; fRight := eRight; INC(fTop,i);
  END;

  pens := normalPens;
  IF reverse IN fg.kind THEN
    pens := reversePens;
  END;
  IF g.base.libNode.version >= 39 THEN
    g.SetABPenDrMd(msg.rPort,fg.drawInfo.pens[pens.fill],
                             fg.drawInfo.pens[pens.backGround],g.jam2);
  ELSE
    g.SetAPen(msg.rPort,fg.drawInfo.pens[pens.fill]);
    g.SetBPen(msg.rPort,fg.drawInfo.pens[pens.backGround]);
    g.SetDrMd(msg.rPort,g.jam2);
  END;
  (* IF old < current THEN ELSE END; further optimisation *)
  g.RectFill(msg.rPort, left, fTop, fRight, fButtom);
  g.SetDrMd(msg.rPort,g.jam2+SHORTSET{g.inversvid});
  g.RectFill(msg.rPort, eLeft, top, eRight, eButtom);
  RETURN 1;
END Draw;


PROCEDURE (VAR fg: FuelGaugeIClass) Set * (VAR msg: I.OpSet): e.APTR;
BEGIN
  IF fg.Set^(msg) # NIL THEN END; (* always returns 1 for image classes *)
  Set(fg,msg);
  IF fg.current > fg.max THEN fg.current := fg.max; END;
  RETURN 1;
END Set;


PROCEDURE (VAR fg: FuelGaugeIClass) Get * (VAR msg: I.OpGet): e.APTR;
VAR
  dum : UNTRACED POINTER TO ARRAY 1 OF LONGINT;
BEGIN
  dum := y.VAL(e.ADDRESS,msg.storage);
  CASE msg.attrID OF
  |current: dum[0] := fg.current;
  |max:     dum[0] := fg.max;
  |vertical:
    dum[0] := I.LFALSE;
    IF ~ (horizontal IN fg.kind) THEN dum[0] := I.LTRUE; END;
  |fromRightToLeft:
    dum[0] := I.LFALSE;
    IF reverse IN fg.kind THEN dum[0] := I.LTRUE; END;
  ELSE
    RETURN fg.Get^(msg);
  END;
  RETURN I.LTRUE;
END Get;

(*
** init fuelgaugiclass as private subclass of imageclass
*)

PROCEDURE InitClass * (): BOOLEAN;
BEGIN
  IF fuelGaugeIClass = NIL THEN
    fuelGaugeIClass := RootClass.InitPrivFromName(
                        I.frameIClass,
                        IC.Dispatch,
                        SIZE(FuelGaugeIClass),
                        y.TYPEDESC(FuelGaugeIClass));
  END;
  RETURN fuelGaugeIClass # NIL;
END InitClass;

CLOSE
  IF fuelGaugeIClass # NIL THEN
    IF I.FreeClass (fuelGaugeIClass) THEN END;
  END;
END FuelGaugeIClass.

