 DEFINT A-Z
 '============================= MLIBSAM6.BAS ================================
 '             Copyright (C) 1994 Terry Venn. All rights reserved.
 '
 '                  THIS SAMPLE PROGRAM IS PROVIDED AS IS.
 '
 ' You may modify/use this code in any way you wish, provided that you agree
 ' that Terry Venn has no warranties, obligations or liabilities for any code
 ' contained in this sample program.
 '
 ' QB refers to: QuickBasic 4.5
 ' VBDOS refers to: Visual Basic for DOS
 '
 ' MLIBSAM6.BAS is a mouse event-driven sample program that you can use to
 ' test, and see exactly how the mouse event routines are used. The code is
 ' written in a straight forward, simple to understand manner. You will see
 ' that using the handler's routines gives you more mouse-power, and
 ' simplifies writing code as well.
 '
 ' You may notice that inside the QB environment, the mouse may not respond
 ' when a program is running and is stopped before normal termination due to
 ' an error, or breakpoints, etc.. The reason for this is that our mouse
 ' handler is still active, and must be disabled, giving mouse control back
 ' to QB. To give control back to QB, type: END in the Immediate window and
 ' press Enter, or if possible, restart your program and let it run to normal
 ' termination. The MLIB mouse event handler is automatically disabled when
 ' your program terminates. Once compiled, and outside the QB environment,
 ' our handler is on its own, and this will no longer pose a problem.
 '
 ' To run this sample program from inside the QB environment, start the QB
 ' editor by typing: QB/L MLIBN
 '
 ' To run this sample program from inside the VBDOS environment, start the
 ' editor by typing: VBDOS/L MLIBF
 '
 ' To run this sample program, the following files must be loaded along with
 ' MLIBSAM6.BAS:
 '
 ' MLIB.BI      - MLIB mouse library include file.
 ' MLIBSAM4.BAS - Menu support routines.
 ' MLIBTOOL.BAS - Event handler BASIC support routines.
 '
 ' Mouse event routines:
 '
 ' InMouseHandler(Command)
 '                           Mouse event handler (simular to a TSR program).
 '                           Once installed it immediately becomes active,
 '                           responding to mouse events. You can specify
 '                           which events will be trapped by using the
 '                           optional BASIC routines contained in the file:
 '                           MLIBTOOL.BAS. These events are then stored in
 '                           the event buffer for later use (simular to the
 '                           way keyboard data is stored in the type-ahead
 '                           buffer). The InMouse() function is used to
 '                           retrieve these events when needed. The event
 '                           buffer can hold a maximum of eight events.
 '
 '                           Controlling the event handler:
 '
 '                           Commands-CONST:  Value:  Description:
 '                               
 '                           EventInstall     1       Installs handler.
 '                           EventEnable      2       Enables handler.
 '                           EventDisable     4       Disables handler.
 '                           ClearBuffer      8       Clears event buffer.
 '                           
 '
 '                           NOTE: You need to install the handler only once
 '                                 in your code. Once installed it cannot be
 '                                 deinstalled from within your code, the
 '                                 handler will remove itself upon (normal or
 '                                 abnormal) program termination.
 '
 ' Event% = InMouse(MouseX%, MouseY%)
 '
 '                           Returns mouse events. You would poll this
 '                           function for mouse events the same way you would
 '                           poll INKEY$ for keyboard events.
 '
 '                           Argument:  Description:
 '                             
 '                           Event%     Bit-field returning mouse and shift-
 '                                      state information (see: Event bit-
 '                                      field below).
 '                           MouseX%    Returns horizontal pointer position,
 '                                      WHEN, the event occurred.
 '                           MouseY%    Returns vertical pointer position,
 '                                      WHEN, the event occurred.
 '
 '                                      NOTE: When the event buffer is empty,
 '                                      MouseX, and MouseY%, return the cur-
 '                                      rent pointer position.
 '                           
 '
 '                           Event bit-field:     Represents (when set):
 '                            
 '                           00000000 00000000 Mouse pointer moved.
 '                           ٳ  Left button pressed.
 '                               Left button released.
 '                               Right button pressed.
 '                               Right button released.
 '                               Center button pressed.
 '                               Center button released.
 '                               Left button double-click.
 '                              Right button double-click.
 '                              Center button double-click.
 '                              Shift key down.
 '                              Ctrl key down.
 '                              Alt key down.
 '                             Unused.
 '                           
 '
 ' Segment% = InMouseAddress(Offset%)
 '
 '                           Returns address to the handler's data block.
 '                           This routine is used to change or read the
 '                           handler's default settings. For further
 '                           information, look through the mouse toolkit
 '                           file: MLIBTOOL.BAS.
 '
 '                           Argument:  Description:
 '                             
 '                           Segment%   Returns the segment part of address.
 '                           Offset%    Returns the offset part of address.
 '                           
 '
 ' The following are extra routines included with MLIB. They offer greater
 ' speed and/or do things BASIC cannot do.
 '
 ' Value% = GetWord (Segment%, Offset%)
 '
 '                           Returns two bytes from specified memory location
 '                           (simular to BASIC's PEEK function).
 '
 ' PutWord (Segment%, Offset%, Value%)
 '
 '                           Writes two bytes to specified memory location
 '                           (simular to BASIC's POKE statement).
 '
 ' Value% = CvsBin% (BinaryString$)
 '
 '                           Returns the decimal value of the binary string
 '                           representation.
 '     
 '                           BinaryString$ - Must be 16 bytes in length.
 '                                           "0000000000000001" would return
 '                                           the decimal value 1.
 '
 ' BinaryString$ = CviBin$ (Value%)
 '
 '                           Returns a 16 byte string that represents the
 '                           binary value of the passed argument.
 '
 '                           Value% - A value of 1 would return
 '                                    "0000000000000001"
 '
 ' QuickBasic and Visual Basic are trademarks of Microsoft Corporation.
 '===========================================================================
 ' $INCLUDE: 'MLIB.BI'

 DECLARE SUB DetectMouse ()
 DECLARE SUB DoodlePad ()
 DECLARE SUB ScreenDisable ()
 DECLARE SUB SaveScreen ()
 DECLARE SUB SaveMenuItems ()
 DECLARE SUB Help ()
 DECLARE SUB ShowBoxes ()
 DECLARE SUB DrawShiftKeys (R%, C%, Action%)
 DECLARE SUB DrawMouse (R%, C%, Action%)
 DECLARE SUB DecodeMouseEvent (MouseEvent%, MouseRow%, MouseCol%, UserDelay%)
 DECLARE SUB TheMainLoop ()
 DECLARE SUB Calculator ()
 DECLARE SUB DrawButtonUp (R%, C%, Wide%, High%, Title$)
 DECLARE SUB DrawButtonDown (R%, C%, Wide%, High%)
 DECLARE FUNCTION MouseOnButton% (X%, MouseRow%, MouseCol%)

 ' Text button.
 TYPE ButtonType
      R AS INTEGER
      C AS INTEGER
      W AS INTEGER
      H AS INTEGER
      T AS STRING * 4
 END TYPE

 ' Menu.
 TYPE BoxType
      C AS INTEGER ' Column.
      R AS INTEGER ' Row.
      W AS INTEGER ' Width.
      H AS INTEGER ' Height.
 END TYPE

 DECLARE SUB DrawBox (R%, C%, Wide%, High%, Title$)
 DECLARE SUB MouseCheck (NewItem%, MouseRow%, MouseCol%)
 DECLARE SUB KeyBoardCheck (Kbd$, ChosenItem%)
 DECLARE SUB ShowMenu (Row%, Col%, Title$)
 DECLARE SUB MouseStatus (MousePress%, MouseCol%, MouseRow%)
 TYPE MenuType
      mnuCol    AS INTEGER
      mnuRow    AS INTEGER
 END TYPE
 CONST TRUE = -1, FALSE = 0
 COMMON SHARED /Menu/ Menu()           AS MenuType ' Menu control array.
 COMMON SHARED /Menu/ MenuItem()       AS STRING   ' Menu item array.
 COMMON SHARED /Menu/ MinItem          AS INTEGER  ' First menu item.
 COMMON SHARED /Menu/ MaxItem          AS INTEGER  ' Last menu item.
 COMMON SHARED /Menu/ LongestMenuItem  AS INTEGER  ' Longest menu item.
 COMMON SHARED /Menu/ LastItem         AS INTEGER  ' Last item hilighted.
 COMMON SHARED /Menu/ NewItem          AS INTEGER  ' Currently hilighted item.
 COMMON SHARED /Menu/ MenuForeColor    AS INTEGER  ' Menu foreground color.
 COMMON SHARED /Menu/ MenuBackColor    AS INTEGER  ' Menu background color.
 COMMON SHARED /Menu/ FrameForeColor   AS INTEGER  ' Box
 COMMON SHARED /Menu/ FrameBackColor   AS INTEGER  ' colors.
 COMMON SHARED /Menu/ BoxForeColor     AS INTEGER  ' "
 COMMON SHARED /Menu/ BoxBackColor     AS INTEGER  ' "
 COMMON SHARED /Menu/ TitleForeColor   AS INTEGER  ' "
 COMMON SHARED /Menu/ TitleBackColor   AS INTEGER  ' "

 DIM SHARED Box(1 TO 5) AS BoxType              ' Dialog box.
 DIM SHARED ScreenBuf AS STRING * 4000          ' Display buffer.
 DIM SHARED CurMouseRow AS STRING * 2           ' Current pointer
 DIM SHARED CurMouseCol AS STRING * 2           ' position.
 DIM SHARED MouseButtons AS INTEGER             ' Number of mouse buttons.
 
 DIM SHARED TButton(1 TO 21) AS ButtonType      ' Calculator
 DIM SHARED DecResult AS STRING * 26            ' data.
 DIM SHARED HexResult AS STRING * 26
 DIM SHARED BinResult AS STRING * 26

 WIDTH 80, 25

 CLS
 
 CALL ShowBoxes

 CALL TheMainLoop

 COLOR 7, 0
 SCREEN 0, 0, 0
 CLS
 END

 ' Calculator button data.
 DATA 2,36,5,3,"7", 2,41,5,3,"8", 2,46,5,3,"9", 2,52,10,3,"C", 5,36,5,3,"4"
 DATA 5,41,5,3,"5", 5,46,5,3,"6", 5,52,10,3,"CE", 8,36,5,3,"1", 8,41,5,3,"2"
 DATA 8,46,5,3,"3", 8,52,5,3,"+", 8,57,5,3,"-", 11,7,7,3,"Not", 11,14,7,3,"And"
 DATA 11,21,7,3,"Or", 11,28,7,3,"Xor", 11,36,5,3,"0", 11,41,10,3,"="
 DATA 11,52,5,3,"*", 11,57,5,3,"\"

'
' Display a simple calculator that can handle integers only (-32768 to 32767).
'
' Supports mouse and keyboard.
'
SUB Calculator

 CALL HidePointer

 ' Save our display.
 CALL SaveScreen

 ' Background color.
 COLOR 7, 0

 ' Draw a background screen.
 FOR R% = 2 TO 24
    LOCATE R%, 1: PRINT STRING$(80, "");
 NEXT

 ' Show help bar.
 COLOR 0, 3: LOCATE 25, 1: PRINT SPACE$(33) + "<Esc=Close Box>" + SPACE$(32);

 ' Save colors.
 OldBoxForeColor = BoxForeColor
 OldBoxBackColor = BoxBackColor

 BoxForeColor = 0
 BoxBackColor = 7

 '===========================================================================
 ' Draw calculator read-outs.
 '===========================================================================
 X% = 5 ' Box index.

 Box(X%).W = 64
 Box(X%).H = 15

 ' Center box on screen.
 Box(X%).R = (25 - Box(X%).H) \ 2 + 1
 Box(X%).C = (80 - Box(X%).W) \ 2 + 1

 Title$ = "Integer Calculator"
 CALL DrawBox(Box(X%).R, Box(X%).C, Box(X%).W, Box(X%).H, Title$)

 COLOR BoxForeColor, BoxBackColor
 
  LOCATE Box(X%).R + 2, Box(X%).C + 2: PRINT "     Ŀ"
  LOCATE Box(X%).R + 3, Box(X%).C + 2: PRINT "Dec:                           "
  LOCATE Box(X%).R + 4, Box(X%).C + 2: PRINT "     "
  LOCATE Box(X%).R + 5, Box(X%).C + 2: PRINT "     Ŀ"
  LOCATE Box(X%).R + 6, Box(X%).C + 2: PRINT "Hex:                           "
  LOCATE Box(X%).R + 7, Box(X%).C + 2: PRINT "     "
  LOCATE Box(X%).R + 8, Box(X%).C + 2: PRINT "     Ŀ"
  LOCATE Box(X%).R + 9, Box(X%).C + 2: PRINT "Bin:                           "
 LOCATE Box(X%).R + 10, Box(X%).C + 2: PRINT "     "

 '===========================================================================

 '===========================================================================
 ' Draw the calculator buttons.
 '===========================================================================
 Min% = LBOUND(TButton, 1)
 Max% = UBOUND(TButton, 1)

 FOR I% = Min% TO Max%

    READ R%
    READ C%

    TButton(I%).R = Box(X%).R + R%
    TButton(I%).C = Box(X%).C + C%
    READ TButton(I%).W
    READ TButton(I%).H
    READ TButton(I%).T

    CALL DrawButtonUp(TButton(I%).R, TButton(I%).C, TButton(I%).W, TButton(I%).H, TButton(I%).T)

 NEXT
 RESTORE
 '===========================================================================

 GOSUB HiLiteAccessKey

 Result$ = "0"
 NumOps% = 0
 LastInput$ = ""
 OpFlag$ = ""
 Temp$ = "0"

 ' Save mask.
 CALL GetEventMask(OldMask%)

 ' Trap left button, and mouse movement events.
 NewMask% = NewMask% OR LButtonDown OR LButtonUp OR MouseMoved

 ' Use new mask.
 CALL SetEventMask(NewMask%)

 ' Print zeros in readouts.
 GOSUB PrintResult

 CALL ShowPointer

 DO
    DO ' Wait for a mouse or key event.
       MouseEvent% = InMouse(MouseX%, MouseY%)
       MouseCol% = MouseX% \ 8 + 1 ' Convert to BASIC's
       MouseRow% = MouseY% \ 8 + 1 ' row/column format.
   
       KeyPress$ = INKEY$
       KeyPress% = LEN(KeyPress$)

    LOOP UNTIL MouseEvent% OR KeyPress%
 
    ' Add key support.
    IF KeyPress% THEN
       ChosenButton$ = UCASE$(KeyPress$)
       IF ChosenButton$ = "N" THEN
          ChosenButton$ = "Not"
       ELSEIF ChosenButton$ = "A" THEN
          ChosenButton$ = "And"
       ELSEIF ChosenButton$ = "O" THEN
          ChosenButton$ = "Or"
       ELSEIF ChosenButton$ = "X" THEN
          ChosenButton$ = "Xor"
       ELSEIF ChosenButton$ = "E" THEN
          ChosenButton$ = "CE"
       END IF
    END IF

    IF MouseEvent% AND LButtonDown THEN
      
       ' See if we need to exit.
       IF MouseRow% = 25 THEN                       ' If we're on help bar.
          IF MouseCol% > 33 AND MouseCol% < 49 THEN ' <Esc=Close Box>
           
             ' Requires a double-click to close box.
             IF MouseEvent% AND LButtonDblClk THEN EXIT DO
          END IF
       END IF
      
       ' Show calc button down.
       IF MouseOnButton(Index%, MouseRow%, MouseCol%) THEN
          I% = Index%
          TButtonDown% = -1
          CALL DrawButtonDown(TButton(I%).R, TButton(I%).C, TButton(I%).W, TButton(I%).H)
          GOSUB HiLiteAccessKey
       END IF
 
    ' Show calc button up.
    ELSEIF MouseEvent% AND LButtonUp AND TButtonDown% THEN
    
       ' Button was chosen.
       IF MouseOnButton(Index%, MouseRow%, MouseCol%) THEN
          ChosenButton$ = RTRIM$(TButton(I%).T)
       ELSE
          ChosenButton$ = ""
       END IF
    
       Index% = 0
       TButtonDown% = 0
       CALL DrawButtonUp(TButton(I%).R, TButton(I%).C, TButton(I%).W, TButton(I%).H, TButton(I%).T)
       GOSUB HiLiteAccessKey
    
    ' Check if we need to show calc button down, or up.
    ELSEIF MouseEvent% AND MouseMoved AND TButtonDown% THEN
       IF NOT MouseOnButton(Index%, MouseRow%, MouseCol%) THEN
          CALL DrawButtonUp(TButton(I%).R, TButton(I%).C, TButton(I%).W, TButton(I%).H, TButton(I%).T)
          GOSUB HiLiteAccessKey
       ELSEIF MouseOnButton(Index%, MouseRow%, MouseCol%) THEN
          I% = Index%
          CALL DrawButtonDown(TButton(I%).R, TButton(I%).C, TButton(I%).W, TButton(I%).H)
          GOSUB HiLiteAccessKey
       END IF
 
    END IF

    ' If a calc button was chosen.
    IF LEN(ChosenButton$) THEN

       ' Calculator code.
       SELECT CASE ChosenButton$
          CASE "C"
             Temp$ = "0"
             Result$ = "0"
             NumOps% = 0
             LastInput$ = ""
             OpFlag$ = ""
             GOSUB PrintResult

          CASE IS = "CE"
             Result$ = Temp$
             LastInput$ = ""
             GOSUB PrintResult

          CASE "0" TO "9"
             IF LastInput$ <> "NUMS" THEN
                Result$ = ""
                GOSUB PrintResult
             END IF
          
             IF VAL(Result$) = 0 THEN Result$ = ""
             Result$ = Result$ + ChosenButton$
             LastInput$ = "NUMS"
          
             GOSUB PrintResult

          CASE IS = "Not"
             Result$ = STR$(NOT VAL(Result$))
             GOSUB PrintResult
             LastInput$ = "NUMS"

          CASE IS = "\", "*", "-", "+", "=", "And", "Or", "Xor"
             IF LastInput$ = "NUMS" THEN
                NumOps% = NumOps% + 1
             END IF
           
             Temp$ = Result$
             IF NumOps% = 1 THEN
                Val1& = VAL(Temp$)
             ELSEIF NumOps% = 2 THEN
                Val2& = VAL(Temp$)
                SELECT CASE OpFlag$
                   CASE IS = "*": Val1& = Val1& * Val2&
                   CASE IS = "-": Val1& = Val1& - Val2&
                   CASE IS = "+": Val1& = Val1& + Val2&
                   CASE IS = "\"
                      IF Val2& = 0 THEN
                         ErrorMsg$ = "     Division by zero"
                         GOSUB ShowCalcError
                      ELSE
                         Val1& = Val1& \ Val2&
                      END IF
                
                   CASE IS = "=": Val1& = Val2&
                   CASE IS = "And": Val1& = Val1& AND Val2&
                   CASE IS = "Or": Val1& = Val1& OR Val2&
                   CASE IS = "Xor": Val1& = Val1& XOR Val2&

                END SELECT

                Result$ = LTRIM$(STR$(Val1&))
                NumOps% = 1
                GOSUB PrintResult

             END IF

          LastInput$ = ""
          OpFlag$ = ChosenButton$

       END SELECT

       ChosenButton$ = ""
    END IF
 
 LOOP UNTIL KeyPress$ = CHR$(27)

 ' Restore colors.
 BoxForeColor = OldBoxForeColor
 BoxBackColor = OldBoxBackColor
 COLOR BoxForeColor, BoxBackColor

 ' Restore mask.
 CALL SetEventMask(OldMask%)

 ' Restore our display.
 CALL SaveScreen

 EXIT SUB

' Show result.
PrintResult:

 DecResult = Result$
 HexResult = Result$
 BinResult = Result$

 ' Test for overflow.
 Test& = VAL(Result$)
 IF Test& > 32767 OR Test& < -32768 THEN
    ErrorMsg$ = "         Overflow"
    GOSUB ShowCalcError
 END IF

 IF ErrFlag% THEN
    ErrFlag% = 0
    Temp$ = "0"
    Result$ = "0"
    NumOps% = 0
    LastInput$ = ""
    OpFlag$ = ""
 END IF

 RSET DecResult = Result$
 RSET HexResult = HEX$(VAL(Result$))
 RSET BinResult = CviBin$(VAL(Result$))

 CALL HidePointer
 LOCATE Box(X%).R + 3, Box(X%).C + 8: PRINT DecResult
 LOCATE Box(X%).R + 6, Box(X%).C + 8: PRINT HexResult
 LOCATE Box(X%).R + 9, Box(X%).C + 8: PRINT BinResult
 CALL ShowPointer

 RETURN

HiLiteAccessKey:

 CALL HidePointer
 COLOR 15, 7
 LOCATE Box(X%).R + 3, Box(X%).C + 57: PRINT "C"
 LOCATE Box(X%).R + 6, Box(X%).C + 57: PRINT "E"
 LOCATE Box(X%).R + 12, Box(X%).C + 9: PRINT "N"
 LOCATE Box(X%).R + 12, Box(X%).C + 16: PRINT "A"
 LOCATE Box(X%).R + 12, Box(X%).C + 23: PRINT "O"
 LOCATE Box(X%).R + 12, Box(X%).C + 30: PRINT "X"
 COLOR BoxForeColor, BoxBackColor
 CALL ShowPointer
 RETURN

ShowCalcError:

 ' Draw the Help box on the screen.
 '===========================================================================
 ErrFlag% = -1

 R% = Box(X%).R
 C% = Box(X%).C
 H% = Box(X%).H
 W% = Box(X%).W

 CALL HidePointer

 ' Save screen.
 PCOPY 0, 1

 CALL ScreenDisable

 Box(X%).H = 5
 Box(X%).W = 30

 ' Center box on screen.
 Box(X%).R = (25 - Box(X%).H) \ 2 + 1
 Box(X%).C = (80 - Box(X%).W) \ 2 + 1

 Title$ = "Calculator Error"
 CALL DrawBox(Box(X%).R, Box(X%).C, Box(X%).W, Box(X%).H, Title$)

 COLOR BoxForeColor, BoxBackColor

 ' Print message.
 LOCATE Box(X%).R + 2, Box(X%).C + 2: PRINT ErrorMsg$

 CALL ShowPointer

 DO ' Wait for a mouse or key event.
    MouseEvent% = InMouse(MouseX%, MouseY%)
    MouseCol% = MouseX% \ 8 + 1 ' Convert to BASIC's
    MouseRow% = MouseY% \ 8 + 1 ' row/column format.
  
    KeyPress$ = INKEY$
      
    IF MouseEvent% AND LButtonDown THEN
       ' See if we need to exit.
       IF MouseRow% = 25 THEN                       ' If we're on help bar.
          IF MouseCol% > 33 AND MouseCol% < 49 THEN ' <Esc=Close Box>
          
             ' Requires a double-click to close box.
             IF MouseEvent% AND LButtonDblClk THEN EXIT DO
          END IF
       END IF
    END IF

 LOOP UNTIL KeyPress$ = CHR$(27)

 KeyPress$ = ""

 CALL HidePointer

 ' Restore screen.
 PCOPY 1, 0

 CALL ShowPointer

 Box(X%).R = R%
 Box(X%).C = C%
 Box(X%).H = H%
 Box(X%).W = W%

 RETURN

END SUB

'
' Show mouse events on the screen.
'
SUB DecodeMouseEvent (MouseEvent%, MouseRow%, MouseCol%, UserDelay%)

 CALL HidePointer

 ' Update the Miscellaneous box.
 CALL GetDblClkSettings(ClickS%, ClickW%, ClickH%)
 LOCATE Box(4).R + 2, Box(4).C + 12: PRINT CviBin$(MouseEvent%)
 LOCATE Box(4).R + 3, Box(4).C + 17: PRINT GetEventsPending
 LOCATE Box(4).R + 4, Box(4).C + 17: PRINT GetHeadPtr
 LOCATE Box(4).R + 5, Box(4).C + 17: PRINT GetTailPtr
 LOCATE Box(4).R + 6, Box(4).C + 17: PRINT ClickS%; "   "
 LOCATE Box(4).R + 7, Box(4).C + 17: PRINT ClickW%; "   "
 LOCATE Box(4).R + 8, Box(4).C + 17: PRINT ClickH%; "   "

 DoDelay% = 0

 ' Print the position of the mouse pointer WHEN the event occurred.
 LOCATE Box(2).R + 2, Box(2).C + 2
 PRINT "Row:"; MouseRow%; "   Col:"; MouseCol%; " "
   
 ' Test for a mouse button press or release.
 ' Test for each separately, as more than one
 ' event can occur at the same time.
 ' Position of mouse image.
 R% = Box(2).R + 3: C% = Box(2).C + 2
 IF MouseEvent% AND LButtonDown THEN ' Draw left button down.
    CALL DrawMouse(R%, C%, -LButtonDown)
 END IF
 IF MouseEvent% AND LButtonUp THEN   ' Draw left button up.
    CALL DrawMouse(R%, C%, LButtonUp)
 END IF
 IF MouseEvent% AND RButtonDown THEN ' Draw right button down.
    CALL DrawMouse(R%, C%, -RButtonDown)
 END IF
 IF MouseEvent% AND RButtonUp THEN   ' Draw right button up.
    CALL DrawMouse(R%, C%, RButtonUp)
 END IF
 IF MouseEvent% AND CButtonDown THEN ' Draw center button down.
    CALL DrawMouse(R%, C%, -CButtonDown)
 END IF
 IF MouseEvent% AND CButtonUp THEN   ' Draw center button up.
    CALL DrawMouse(R%, C%, CButtonUp)
 END IF

 ' Test for double-click events.
 IF MouseEvent% AND LButtonDblClk THEN
    CALL DrawMouse(R%, C%, -LButtonDblClk): DoDelay% = -1
 END IF
 IF MouseEvent% AND RButtonDblClk THEN
    CALL DrawMouse(R%, C%, -RButtonDblClk): DoDelay% = -1
 END IF
 IF MouseEvent% AND CButtonDblClk THEN
    CALL DrawMouse(R%, C%, -CButtonDblClk): DoDelay% = -1
 END IF
 IF MouseEvent% AND MouseMoved THEN
    CALL DrawMouse(R%, C%, -MouseMoved): DoDelay% = -1
 END IF

 ' Test for shift-state key events.
 ' The key must be down during mouse event, for the shift event
 ' to be recognized.
 ' Position of shift-state key images.
 C% = Box(3).C + 3: R% = Box(3).R + 2
 IF MouseEvent% AND AltKey THEN
    CALL DrawShiftKeys(R%, C%, -AltKey): DoDelay% = -1
 END IF
 IF MouseEvent% AND ShiftKey THEN
    CALL DrawShiftKeys(R%, C%, -ShiftKey): DoDelay% = -1
 END IF
 IF MouseEvent% AND CtrlKey THEN
    CALL DrawShiftKeys(R%, C%, -CtrlKey): DoDelay% = -1
 END IF

 CALL ShowPointer

 ' Loop here for a while so we can
 ' see which event(s) took place.
 IF DoDelay% AND UserDelay% THEN
    T& = TIMER + .5
    WHILE TIMER < T&: WEND
 END IF
      
 ' Cleanup Mouse Events box.
 R% = Box(2).R + 3: C% = Box(2).C + 2
 CALL DrawMouse(R%, C%, MouseMoved)

 ' Clear all double-clicks.
 CALL DrawMouse(R%, C%, LButtonDblClk)

 ' Cleanup Key Events box.
 R% = Box(3).R + 2: C% = Box(3).C + 3
 CALL DrawShiftKeys(R%, C%, AltKey)
 CALL DrawShiftKeys(R%, C%, ShiftKey)
 CALL DrawShiftKeys(R%, C%, CtrlKey)

END SUB

'
' Check for the existence of a mouse, if a mouse is detected, it is
' initialized along with the MLIB library. If no mouse is found, program
' exits.
'
SUB DetectMouse

 ' Name of box.
 Title$ = "Initialize Mouse"

 ' Save our display.
 CALL SaveScreen
 CALL ScreenDisable

 ' Box index.
 X% = 5

 '===========================================================================
 ' Display message box.
 '===========================================================================
 Box(X%).W = 38
 Box(X%).H = 7

 ' Center box on screen.
 Box(X%).R = (25 - Box(X%).H) \ 2 + 1
 Box(X%).C = (80 - Box(X%).W) \ 2 + 1

 CALL DrawBox(Box(X%).R, Box(X%).C, Box(X%).W, Box(X%).H, Title$)
 COLOR BoxForeColor, BoxBackColor

 LOCATE Box(X%).R + 2, Box(X%).C + 7: PRINT "Initializing the mouse"
 LOCATE Box(X%).R + 4, Box(X%).C + 9: PRINT "Please wait..."
 '===========================================================================

 ' Initialize the mouse, and MLIB.
 CALL InitPointer(MouseButtons)

 ' If MouseButtons equals zero, there's no mouse installed.
 IF MouseButtons = 0 THEN
   
    LOCATE Box(X%).R + 2, Box(X%).C + 7: PRINT "Unable to detect a mouse!"
    LOCATE Box(X%).R + 4, Box(X%).C + 9: PRINT "Press any key to exit"

    BEEP

    ' Wait for a key press.
    WHILE LEN(INKEY$) = 0: WEND

    COLOR 7, 0
    SCREEN 0, 0, 0
    CLS
    END

 END IF
   
 ' Restore our display.
 CALL SaveScreen
 
END SUB

'
' Demonstrates: Mouse movement and button events.
'
' You will notice if the mouse is moved too quickly, characters will be
' missed when drawing. This is due to the fact that the operating system
' allows only a limited number of mouse checks per second.
'
' IMPORTANT: Trapping mouse movement can noticeably slow program execution
'            down. Therefore, in speed critical areas, you should turn this
'            feature off.
'
SUB DoodlePad

 ' Name of box.
 Title$ = "Doodle Pad"

 ' Save our display.
 CALL SaveScreen
 CALL ScreenDisable

 ' Box index.
 X% = 5

 ' Get status of handler.
 Status% = InMouseState
 
 ' If handler is not active.
 IF Status% = 0 OR Status% AND EventDisable THEN
    
    '===========================================================================
    ' Display message box.
    '===========================================================================
    Box(X%).W = 38
    Box(X%).H = 12

    ' Center box on screen.
    Box(X%).R = (25 - Box(X%).H) \ 2 + 1
    Box(X%).C = (80 - Box(X%).W) \ 2 + 1

    CALL DrawBox(Box(X%).R, Box(X%).C, Box(X%).W, Box(X%).H, Title$)
    COLOR BoxForeColor, BoxBackColor
   
    LOCATE Box(X%).R + 2, Box(X%).C + 2: PRINT "Mouse event handler is not active!"
    LOCATE Box(X%).R + 4, Box(X%).C + 2: PRINT "Choose from Menu: "
    LOCATE Box(X%).R + 6, Box(X%).C + 5: PRINT "1. Install Handler."
    LOCATE Box(X%).R + 7, Box(X%).C + 5: PRINT "2. Enable Handler."
    LOCATE Box(X%).R + 9, Box(X%).C + 5: PRINT "Press any key to continue..."
    '===========================================================================
   
    ' Wait for a key press.
    WHILE LEN(INKEY$) = 0: WEND

    ' Restore our display.
    CALL SaveScreen
    EXIT SUB
 END IF

 CALL HidePointer

 ' Show help bar.
 COLOR 0, 3: LOCATE 25, 1: PRINT "     <Left=Doodle>  <Shift+Left=Erase>  <Right DblClk=New>  <Esc=Close Box>     ";
 CALL ShowPointer

 ' Get the current event mask (events currently being trapped).
 CALL GetEventMask(OldMask%)

 ' DoodlePad, requires the following mouse events trapped.
 CALL SetEventMask(NewMask% OR RButtonDown OR LButtonUp OR LButtonDown OR MouseMoved)

 ' Get pointer rate of travel settings.
 CALL GetSpeedM(OldH%, OldV%, OldD%)

 ' Use our own settings here.
 CALL SetSpeedM(30, 30, 20)

 '===========================================================================
 ' Draw the Doodle Pad box on the screen.
 '===========================================================================
 Box(X%).W = 70
 Box(X%).H = 21

 ' Center box on screen.
 Box(X%).R = (25 - Box(X%).H) \ 2 + 1
 Box(X%).C = (80 - Box(X%).W) \ 2 + 1

 CALL DrawBox(Box(X%).R, Box(X%).C, Box(X%).W, Box(X%).H, Title$)

 COLOR BoxForeColor, BoxBackColor
 '===========================================================================

 DO
    DO ' Wait for a mouse or key event.
       MouseEvent% = InMouse(MouseX%, MouseY%)
       MouseCol% = MouseX% \ 8 + 1 ' Convert to BASIC's
       MouseRow% = MouseY% \ 8 + 1 ' row/column format.
       KeyPress$ = INKEY$
    LOOP UNTIL MouseEvent% OR LEN(KeyPress$)
   
    ' Show that the left button went down.
    IF MouseEvent% AND LButtonDown THEN
       LeftDown% = -1
      
       ' See if we need to exit.
       IF MouseRow% = 25 THEN                       ' If we're on help bar.
          IF MouseCol% > 60 AND MouseCol% < 76 THEN ' <Esc=Close Box>
            
             ' Requires a double-click to close box.
             IF MouseEvent% AND LButtonDblClk THEN EXIT DO
          END IF
       END IF
   
    ' Show that the left button went up,
    ELSEIF MouseEvent% AND LButtonUp THEN
       LeftDown% = 0
    
    ' Check if doodle pad needs to be cleared.
    ELSEIF MouseEvent% AND RButtonDblClk AND DidDoodle% THEN
       
       ' Clear did doodle flag.
       DidDoodle% = 0

       ' Requires a double-click to completely erase pad.
       CALL DrawBox(Box(X%).R, Box(X%).C, Box(X%).W, Box(X%).H, Title$)
    END IF

    ' Doodle code begins here.
    IF LeftDown% THEN
         
       ' If the pointer is inside the draw box.
       IF MouseRow% >= Box(X%).R + 1 AND MouseRow% <= (Box(X%).R + Box(X%).H) - 2 THEN
          IF MouseCol% >= Box(X%).C + 1 AND MouseCol% <= (Box(X%).C + Box(X%).W) - 2 THEN
            
             ' Draw if the pointer moved, or if the left
             ' button is down.
             IF MouseEvent% AND MouseMoved OR LeftDown% THEN
           
                ' If the shift key bit is set, reverse colors
                ' to erase, else use the normal colors.
                IF MouseEvent% AND ShiftKey THEN
                   COLOR BoxBackColor, BoxForeColor
                ELSE
                   COLOR BoxForeColor, BoxBackColor
                END IF
           
                ' Draw or erase a character.
                CALL HidePointer
                LOCATE MouseRow%, MouseCol%
                PRINT CHR$(219);
                CALL ShowPointer
               
                ' Set we did doodle flag.
                DidDoodle% = -1
             END IF
          END IF
       END IF
    END IF
   
 LOOP UNTIL KeyPress$ = CHR$(27)

 COLOR BoxForeColor, BoxBackColor

 ' Restore our display.
 CALL SaveScreen

 ' Restore original mask.
 CALL SetEventMask(OldMask%)

 ' Restore original pointer rate of travel settings.
 CALL SetSpeedM(OldH%, OldV%, OldD%)

END SUB

'
' Draw what represents a text button in the down position.
'
' R - Row
' C - Col
'
SUB DrawButtonDown (R%, C%, Wide%, High%)

 CALL HidePointer

 ' Draw frame.
 COLOR BoxForeColor, BoxBackColor

 LOCATE R%, C%: PRINT ""; STRING$(Wide% - 2, ""); "";

 FOR RR% = R% + 1 TO R% + High% - 2
    LOCATE RR%, C%: PRINT "";
    LOCATE RR%, C% + Wide% - 1: PRINT "";
 NEXT RR%

 LOCATE R% + High% - 1, C%: PRINT ""; STRING$(Wide% - 2, ""); "";

 CALL ShowPointer

END SUB

'
' Draw what represents a text button in the up position.
'
' R - Row
' C - Col
'
SUB DrawButtonUp (R%, C%, Wide%, High%, Title$)

 CALL HidePointer

 ' Draw frame.
 COLOR BoxForeColor, BoxBackColor
 
 LOCATE R%, C%: PRINT ""; STRING$(Wide% - 2, ""); "";

 FOR RR% = R% + 1 TO R% + High% - 2
    LOCATE RR%, C%: PRINT "";
    LOCATE RR%, C% + Wide% - 1: PRINT "";
 NEXT RR%
 
 LOCATE R% + High% - 1, C%:
 PRINT ""; STRING$(Wide% - 2, ""); "";

 ' Fill in frame.
 COLOR BoxForeColor, BoxBackColor ' Frame fill color.
 FOR RR% = R% + 1 TO R% + High% - 2
     LOCATE RR%, C% + 1: PRINT SPACE$(Wide% - 2);
 NEXT RR%

 ' Calculate title stuff.
 TitleBarWidth% = Wide% - 2
 TitleBarCenter% = (TitleBarWidth%) \ 2

 Text$ = RTRIM$(Title$)
 TitleLen% = LEN(Text$)

 ' Clip title if needed.
 IF TitleLen% > TitleBarWidth% THEN
    Text$ = LEFT$(Text$, TitleBarWidth%)
    TitleLen% = LEN(Text$)
 END IF

 ' Calculate title stuff.
 TitleBarHeight% = High%
 TitleBarCenter2% = (TitleBarHeight%) \ 2

 ' Center and print title.
 LOCATE R% + TitleBarCenter2%, C% + TitleBarCenter% - (TitleLen% \ 2) + 1
 PRINT Text$
 
 CALL ShowPointer

END SUB

'
' Draw something that resembles a mouse on the screen.
'
' R% - Row    \
'              - Upper left corner of image.
' C% - Column /
'
' Action:  0 - Draw complete mouse.
'            - A negative value shows event.
'            - A positive value clears event.
'
SUB DrawMouse (R%, C%, Action%)
 
 CALL HidePointer

 IF Action% = 0 THEN
  
    COLOR BoxForeColor, BoxBackColor

        LOCATE R%, C%: PRINT "Ŀ"
    LOCATE R% + 1, C%: PRINT "               "
    LOCATE R% + 2, C%: PRINT "  L    C    R  "
    LOCATE R% + 3, C%: PRINT "               "
    LOCATE R% + 4, C%: PRINT "Ĵ"
    LOCATE R% + 5, C%: PRINT "                 "
    LOCATE R% + 6, C%: PRINT "                 "
    LOCATE R% + 7, C%: PRINT "  Double-Click   "
    LOCATE R% + 8, C%: PRINT "                 "
    LOCATE R% + 9, C%: PRINT "                 "
   LOCATE R% + 10, C%: PRINT ""
   LOCATE R% + 11, C%: PRINT "Ŀ"
   LOCATE R% + 12, C%: PRINT "                 "
   LOCATE R% + 13, C%: PRINT "   Mouse Moved   "
   LOCATE R% + 14, C%: PRINT "                 "
   LOCATE R% + 15, C%: PRINT ""

 ' Show that an event occurred
 ELSEIF Action% < 0 THEN

    ' Reverse colors.
    COLOR BoxBackColor, BoxForeColor

    IF Action% = -MouseMoved THEN
      
       ' Show that the mouse moved.
       FOR RR% = R% + 12 TO R% + 14
          LOCATE RR%, C% + 1: PRINT SPACE$(17)
       NEXT RR%
       LOCATE R% + 13, C% + 4: PRINT "Mouse Moved"

    ELSEIF Action% = -LButtonDown THEN

       ' Draw left button down.
       FOR RR% = R% + 1 TO R% + 3
          LOCATE RR%, C% + 1: PRINT SPACE$(5)
       NEXT RR%
       LOCATE R% + 2, C% + 3: PRINT "L"
  
    ELSEIF Action% = -RButtonDown THEN

       ' Draw right button down.
       FOR RR% = R% + 1 TO R% + 3
          LOCATE RR%, C% + 13: PRINT SPACE$(5)
       NEXT RR%
       LOCATE R% + 2, C% + 15: PRINT "R"
  
    ELSEIF Action% = -CButtonDown THEN

       ' Draw center button down.
       FOR RR% = R% + 1 TO R% + 3
          LOCATE RR%, C% + 7: PRINT SPACE$(5)
       NEXT RR%
       LOCATE R% + 2, C% + 9: PRINT "C"

    ELSEIF Action% = -LButtonDblClk THEN

       ' Show that left button was double-clicked.
       FOR RR% = R% + 5 TO R% + 9
          LOCATE RR%, C% + 1: PRINT SPACE$(5)
       NEXT RR%
       LOCATE R% + 7, C% + 3: PRINT "Dou"
  
    ELSEIF Action% = -RButtonDblClk THEN

       ' Show that right button was double-clicked.
       FOR RR% = R% + 5 TO R% + 9
          LOCATE RR%, C% + 13: PRINT SPACE$(5)
       NEXT RR%
       LOCATE R% + 7, C% + 13: PRINT "ck"
  
    ELSEIF Action% = -CButtonDblClk THEN

       ' Show that center button was double-clicked.
       FOR RR% = R% + 5 TO R% + 9
          LOCATE RR%, C% + 7: PRINT SPACE$(5)
       NEXT RR%
       LOCATE R% + 7, C% + 7: PRINT "le-Cl"

    END IF
      
    ' Restore colors.
    COLOR BoxForeColor, BoxBackColor

 ' Clear shown events.
 ELSEIF Action% > 0 THEN

    COLOR BoxForeColor, BoxBackColor
  
    IF Action% = MouseMoved THEN
      
       ' Clear mouse moved box.
       FOR RR% = R% + 12 TO R% + 14
          LOCATE RR%, C% + 1: PRINT SPACE$(17)
       NEXT RR%
       LOCATE R% + 13, C% + 4: PRINT "Mouse Moved"
  
    ELSEIF Action% = LButtonUp THEN

       ' Clear left button box.
       FOR RR% = R% + 1 TO R% + 3
          LOCATE RR%, C% + 1: PRINT SPACE$(5)
       NEXT RR%
       LOCATE R% + 2, C% + 3: PRINT "L"
  
    ELSEIF Action% = RButtonUp THEN

       ' Clear right button box.
       FOR RR% = R% + 1 TO R% + 3
          LOCATE RR%, C% + 13: PRINT SPACE$(5)
       NEXT RR%
       LOCATE R% + 2, C% + 15: PRINT "R"
  
    ELSEIF Action% = CButtonUp THEN

       ' Clear center button box.
       FOR RR% = R% + 1 TO R% + 3
          LOCATE RR%, C% + 7: PRINT SPACE$(5)
       NEXT RR%
       LOCATE R% + 2, C% + 9: PRINT "C"
  
    ELSEIF Action% = LButtonDblClk OR RButtonDblClk OR CButtonDblClk THEN

       ' Clear double-click box.
       FOR RR% = R% + 5 TO R% + 9
          LOCATE RR%, C% + 1: PRINT SPACE$(17)
       NEXT RR%
       LOCATE R% + 7, C% + 3: PRINT "Double-Click"
  
    END IF
 END IF

 CALL ShowPointer

END SUB

'
' Draw boxes that represent the Shift, Ctrl and Alt keys.
'
' R% - Row    \
'              - Upper left corner of image.
' C% - Column /
'
' Action:  0 - Draw complete picture.
'            - A negative value shows event.
'            - A positive value removes event.
'
SUB DrawShiftKeys (R%, C%, Action%)

 CALL HidePointer

 IF Action% = 0 THEN

    COLOR BoxForeColor, BoxBackColor
    
        LOCATE R%, C%: PRINT "Ŀ"
    LOCATE R% + 1, C%: PRINT "                    "
    LOCATE R% + 2, C%: PRINT " Shift  Ctrl   Alt  "
    LOCATE R% + 3, C%: PRINT "                    "
    LOCATE R% + 4, C%: PRINT ""

 ' Show that an event occurred.
 ELSEIF Action% < 0 THEN

    ' Reverse colors.
    COLOR BoxBackColor, BoxForeColor

    IF Action% = -ShiftKey THEN

       ' Show that Shift key was down.
       FOR RR% = R% + 1 TO R% + 3
          LOCATE RR%, C% + 1: PRINT SPACE$(7)
       NEXT RR%
       LOCATE R% + 2, C% + 2: PRINT "Shift"

    ELSEIF Action% = -CtrlKey THEN

       ' Show that Ctrl key was down.
       FOR RR% = R% + 1 TO R% + 3
          LOCATE RR%, C% + 9: PRINT SPACE$(6)
       NEXT RR%
       LOCATE R% + 2, C% + 10: PRINT "Ctrl"
   
    ELSEIF Action% = -AltKey THEN

       ' Show that Alt key was down.
       FOR RR% = R% + 1 TO R% + 3
          LOCATE RR%, C% + 16: PRINT SPACE$(7)
       NEXT RR%
       LOCATE R% + 2, C% + 18: PRINT "Alt"

    END IF

    ' Restore colors.
    COLOR BoxForeColor, BoxBackColor

 ' Clear shown events.
 ELSEIF Action% > 0 THEN

    COLOR BoxForeColor, BoxBackColor
   
    IF Action% = ShiftKey THEN

       ' Clear Shift key box.
       FOR RR% = R% + 1 TO R% + 3
          LOCATE RR%, C% + 1: PRINT SPACE$(7)
       NEXT RR%
       LOCATE R% + 2, C% + 2: PRINT "Shift"

    ELSEIF Action% = CtrlKey THEN

       ' Clear Ctrl key box.
       FOR RR% = R% + 1 TO R% + 3
          LOCATE RR%, C% + 9: PRINT SPACE$(6)
       NEXT RR%
       LOCATE R% + 2, C% + 10: PRINT "Ctrl"

    ELSEIF Action% = AltKey THEN

       ' Clear Alt key box.
       FOR RR% = R% + 1 TO R% + 3
          LOCATE RR%, C% + 16: PRINT SPACE$(7)
       NEXT RR%
       LOCATE R% + 2, C% + 18: PRINT "Alt"

    END IF
 END IF

 CALL ShowPointer


END SUB

'
' Display a simple help screen.
'
SUB Help

 ' Save colors.
 OldFrameForeColor = FrameForeColor
 OldFrameBackColor = FrameBackColor
 OldBoxForeColor = BoxForeColor
 OldBoxBackColor = BoxBackColor
 OldTitleForeColor = TitleForeColor
 OldTitleBackColor = TitleBackColor
 OldMenuForeColor = MenuForeColor
 OldMenuBackColor = MenuBackColor

 CALL HidePointer

 ' Save our display.
 CALL SaveScreen

 CALL ScreenDisable

 ' Save menu items.
 CALL SaveMenuItems

 ' Show help bar.
 COLOR 0, 3: LOCATE 25, 1: PRINT "   <Arrow=Scroll Menu Items>  <Enter=Choose Menu Item>  <Esc=Close Help Menu>   ";

 ' Set our Help colors.
 FrameForeColor = 0
 FrameBackColor = 7
 BoxForeColor = 7
 BoxBackColor = 0
 TitleForeColor = 15
 TitleBackColor = 4

 '===========================================================================
 ' Display the Help box plus help topics.
 '===========================================================================
 X% = 5 ' Box index.
 Box(X%).C = 15
 Box(X%).R = 5
 Box(X%).W = 0
 Box(X%).H = 0
 
 Title$ = "Choose Help On:"

 ' Define the items to appear on menu.
 TotalItem% = 4   ' Total number of menu items.

 REDIM MenuItem(1 TO TotalItem%) AS STRING ' Menu item array.

 MenuItem(1) = "       Menu Items          "
 MenuItem(2) = "       Mouse Events        "
 MenuItem(3) = "       Key Events          "
 MenuItem(4) = "       Miscellaneous       "

 MenuForeColor = BoxForeColor: MenuBackColor = BoxBackColor
 COLOR MenuForeColor, MenuBackColor

 ' Upper left corner of menu.
 Row% = Box(X%).R: Col% = Box(X%).C
 CALL ShowMenu(Row%, Col%, Title$)

 '===========================================================================
 CALL ShowPointer
 
 DO
    DO ' Wait for a mouse or key event.
       MouseEvent% = InMouse(MouseX%, MouseY%)
       MouseCol% = MouseX% \ 8 + 1 ' Convert to BASIC's
       MouseRow% = MouseY% \ 8 + 1 ' row/column format.
       KeyPress$ = INKEY$
    LOOP UNTIL MouseEvent% OR LEN(KeyPress$)
    
    ' Check for a mouse event first.
    IF MouseEvent% AND LButtonDown THEN
       IF MouseRow% = 25 THEN                           ' If we're on help bar.
          IF MouseCol% > 3 AND MouseCol% < 29 THEN      ' <Arrow=Scroll Menu Items>
             KeyPress$ = CHR$(0) + "P"
          ELSEIF MouseCol% > 30 AND MouseCol% < 55 THEN ' <Enter=Choose Menu Item>
             KeyPress$ = CHR$(13)
          ELSEIF MouseCol% > 56 AND MouseCol% < 78 THEN ' <Esc=Close Help Menu>
            
             ' Requires a double-click to close help menu.
             IF MouseEvent% AND LButtonDblClk THEN EXIT DO
          END IF
       END IF
      
       ' Check on menu.
       CALL MouseCheck(ChosenItem%, MouseRow%, MouseCol%)

    END IF
  
    ' Check for a key press.
    IF KeyPress$ <> "" THEN
       CALL KeyBoardCheck(KeyPress$, ChosenItem%)
    END IF
  
    IF ChosenItem% THEN
       HelpTopic$ = LTRIM$(RTRIM$(MenuItem(ChosenItem%)))
       SELECT CASE HelpTopic$
          CASE "Menu Items": GOSUB MenuItemsHelp
          CASE "Mouse Events": GOSUB MouseEventsHelp
          CASE "Key Events": GOSUB KeyEventsHelp
          CASE "Miscellaneous": GOSUB MiscellaneousHelp
       END SELECT
       KeyPress$ = ""
       ChosenItem% = 0
    ELSE
       HelpTopic$ = ""
    END IF

 LOOP UNTIL KeyPress$ = CHR$(27)

 ' Restore colors.
 FrameForeColor = OldFrameForeColor
 FrameBackColor = OldFrameBackColor
 BoxForeColor = OldBoxForeColor
 BoxBackColor = OldBoxBackColor
 TitleForeColor = OldTitleForeColor
 TitleBackColor = OldTitleBackColor
 MenuForeColor = OldMenuForeColor
 MenuBackColor = OldMenuBackColor
 COLOR MenuForeColor, MenuBackColor

 ' Restore our display.
 CALL SaveScreen

 ' Restore menu items.
 CALL SaveMenuItems

 ' Redisplay caller's menu.
 Row% = Box(1).R: Col% = Box(1).C
 CALL ShowMenu(Row%, Col%, "Menu")

 ' Return to caller.
 EXIT SUB

MenuItemsHelp:
 '===========================================================================
 ' Initialize help array and show help box for: Menu Items.
 '===========================================================================

 REDIM H(1 TO 21) AS STRING

  H(1) = ""
  H(2) = "Choose:                 To:"
  H(3) = "  "
  H(4) = "Install Handler         Initialize the mouse event handler."
  H(5) = "Disable Handler         Disable the mouse event handler."
  H(6) = "Enable Handler          Enable the mouse event handler."
  H(7) = "Left Press Off/On       Stop/start trapping left button press events."
  H(8) = "Left Release Off/On     Stop/start trapping left button release events."
  H(9) = "Right Press Off/On      Stop/start trapping right button press events."
 H(10) = "Right Release Off/On    Stop/start trapping right button release events."
 H(11) = "Center Press Off/On     Stop/start trapping center button press events."
 H(12) = "Center Release Off/On   Stop/start trapping center button release events."
 H(13) = "Mouse Move On/Off       Start/stop trapping mouse pointer movement."
 H(14) = "Clear Buffer            Clear all data from the mouse event buffer."
 H(15) = "Delay Off/On            Toggle visual display timer off/on."
 H(16) = "Default Settings        Use demo/mouse event handler default settings."
 H(17) = "Doodle Pad              Draw, using mouse movement."
 H(18) = "Calculator              Display a calculator, handles integers only."
 H(19) = "DOS Shell               Temporarily drop to DOS."
 H(20) = "Quit Demo               Exit program."
 H(21) = ""
 
 Box(X%).W = 77
 Box(X%).H = 23
 Title$ = "Help: Menu Items"

 GOSUB ShowHelpBox
 '===========================================================================
 RETURN

MouseEventsHelp:
 '===========================================================================
 ' Initialize help array and show help box for: Mouse Events.
 '===========================================================================

 REDIM H(1 TO 21) AS STRING

  H(1) = ""
  H(2) = "Items:               Indicates the following:"
  H(3) = "  "
  H(4) = " Row:    Col:        Pointer position WHEN event occurred, mouse button"
  H(5) = "Ŀ  status, double-click events, and pointer movement."
  H(6) = "  L    C    R  "
  H(7) = "Ĵ  MouseEvent% = InMouse(MouseX%, MouseY%)"
  H(8) = "                 "
  H(9) = "  Double-Click     MouseEvent% bit-field:  Represents (when set):"
 H(10) = "                     "
 H(11) = "  00000000 00000000  Mouse pointer moved."
 H(12) = "Ŀ           Left button pressed."
 H(13) = "   Mouse Moved              Left button released."
 H(14) = "           Right button pressed."
 H(15) = "                              Right button released."
 H(16) = "                              Center button pressed."
 H(17) = "                              Center button released."
 H(18) = "                              Left button double-click."
 H(19) = "                             Right button double-click."
 H(20) = "                             Center button double-click."
 H(21) = ""

 Box(X%).W = 76
 Box(X%).H = 23
 Title$ = "Help: Mouse Events"

 GOSUB ShowHelpBox
 '===========================================================================
 RETURN

KeyEventsHelp:
 '===========================================================================
 ' Initialize help array and show help box for: Key Events.
 '===========================================================================

 REDIM H(1 TO 17) AS STRING

  H(1) = ""
  H(2) = "Item:                 Indicates:"
  H(3) = "  "
  H(4) = "Ŀ  Shift-state key events."
  H(5) = " Shift Ctrl Alt   Shift events occur when one or more of these keys are"
  H(6) = "  down during a mouse event."
  H(7) = ""
  H(8) = "                      Shift events are returned in the following bit order:"
 H(9) = ""
 H(10) = "                      MouseEvent% = InMouse(MouseX%, MouseY%)"
 H(11) = ""
 H(12) = "                      MouseEvent% = 00011100 00000000"
 H(13) = "                                       "
 H(14) = "                                        Shift - Value: 1024"
 H(15) = "                                        Ctrl  - Value: 2048"
 H(16) = "                                        Alt   - Value: 4096"
 H(17) = ""

 Box(X%).W = 79
 Box(X%).H = 19
 Title$ = "Help: Key Events"

 GOSUB ShowHelpBox
 '===========================================================================
 RETURN

MiscellaneousHelp:
 '===========================================================================
 ' Initialize help array and show help box for: Miscellaneous.
 '===========================================================================

 REDIM H(1 TO 16) AS STRING

  H(1) = ""
  H(2) = "Item:             Description:"
  H(3) = "  "
  H(4) = "Status            Indicates status of the mouse event handler."
  H(5) = "Bit Field         Binary representation of returned shift/mouse events."
  H(6) = "Events Pending    Number of events currently in the mouse event buffer."
  H(7) = "Tail Pointer      Position of tail pointer in the mouse event buffer."
  H(8) = "Head Pointer      Position of head pointer in the mouse event buffer."
  H(9) = "Click Speed       Time frame in which a double-click will be registered."
 H(10) = "Click Width       Amount of horizontal movement (in pixels, on either"
 H(11) = "                  side of pointer) that the mouse pointer can move"
 H(12) = "                  between clicks when double-clicking."
 H(13) = "Click Height      The amount of vertical movement (in pixels, above or"
 H(14) = "                  below pointer) that the mouse pointer can move between"
 H(15) = "                  clicks when double-clicking."
 H(16) = ""

 Box(X%).W = 76
 Box(X%).H = 18
 Title$ = "Help: Miscellaneous"

 GOSUB ShowHelpBox
 '===========================================================================
 RETURN

ShowHelpBox:

 '===========================================================================
 ' For demonstration purposes, we will use a new instance of the mouse
 ' handler. This will eliminate unwanted events waiting in the buffer. First
 ' save the handler's state in Buffer$, next, clear the buffer. Now we have a
 ' new instance to use. After the help screen is cleared, we will restore the
 ' handler's state back to original.
 '===========================================================================
 ' Save handler's state.
 CALL InMouseSave(Buffer$)

 ' Clear buffer and zero internal data.
 CALL InMouseHandler(ClearBuffer)
 '===========================================================================

 '===========================================================================
 ' Draw the Help box on the screen.
 '===========================================================================
 CALL HidePointer

 ' Save help screen.
 PCOPY 0, 1

 ' Center box on screen.
 Box(X%).R = (25 - Box(X%).H) \ 2 + 1
 Box(X%).C = (80 - Box(X%).W) \ 2 + 1

 CALL DrawBox(Box(X%).R, Box(X%).C, Box(X%).W, Box(X%).H, Title$)

 ' Show help bar.
 COLOR 0, 3: LOCATE 25, 1: PRINT SPACE$(30); "<Esc=Close Help Box>"; SPACE$(30);
 COLOR BoxForeColor, BoxBackColor

 ' Print help lines.
 FOR L% = LBOUND(H, 1) TO UBOUND(H, 1)
    LOCATE Box(X%).R + L%, Box(X%).C + 2: PRINT H(L%)
 NEXT L%

 CALL ShowPointer

 DO ' Wait for a mouse or key event.
    MouseEvent% = InMouse(MouseX%, MouseY%)
    MouseCol% = MouseX% \ 8 + 1 ' Convert to BASIC's
    MouseRow% = MouseY% \ 8 + 1 ' row/column format.
    
    IF MouseEvent% AND LButtonDown THEN ' On help bar?
       IF MouseRow% = 25 THEN
          IF MouseCol% > 30 AND MouseCol% < 51 THEN      '<Esc=Close Help Box>
            
             ' Requires a double-click to close help box.
             IF MouseEvent% AND LButtonDblClk THEN EXIT DO
          END IF
       END IF
    END IF
   
    KeyPress$ = INKEY$

 LOOP UNTIL KeyPress$ = CHR$(27)

 ERASE H

 CALL HidePointer

 ' Restore help screen.
 PCOPY 1, 0

 CALL ShowPointer

 ' Restore handler's state.
 CALL InMouseRestore(Buffer$)
 '===========================================================================

 RETURN

END SUB

'
' Checks if mouse pointer is on a button.
'
' X% - Returns index to button.
'
FUNCTION MouseOnButton (X%, MouseRow%, MouseCol%)

 IF X% = 0 THEN
    FOR X% = LBOUND(TButton, 1) TO UBOUND(TButton, 1)

        SELECT CASE MouseRow%
           CASE TButton(X%).R TO TButton(X%).R + TButton(X%).H - 1
        
              SELECT CASE MouseCol%
                 CASE TButton(X%).C TO TButton(X%).C + TButton(X%).W - 1
                    MouseOnButton = -1
                    EXIT FUNCTION
              END SELECT
        END SELECT

    NEXT X%

    ' No match found.
    X% = 0

    MouseOnButton = 0

 ' If X% holds a value upon entry, then check if pointer is on the
 ' button that X% (index) refers to.
 ELSE
  
    SELECT CASE MouseRow%
       CASE TButton(X%).R TO TButton(X%).R + TButton(X%).H - 1
       
          SELECT CASE MouseCol%
             CASE TButton(X%).C TO TButton(X%).C + TButton(X%).W - 1
                MouseOnButton = -1
                EXIT FUNCTION
          END SELECT
    END SELECT

    ' Pointer moved off button.
    MouseOnButton = 0

 END IF

END FUNCTION

'
' Save the contents of MenuItem array in OldMenuArray.
'
' First call saves, second restores.
'
SUB SaveMenuItems STATIC

 'Save the calling procedure's dialog box properties.
 IF NOT BeenHere% THEN

    ' Save the menu item array.
   
    'Get current boundries.
    MenuMin% = LBOUND(MenuItem, 1)
    MenuMax% = UBOUND(MenuItem, 1)
  
    REDIM OldMenuArray(MenuMin% TO MenuMax%)   AS STRING

    FOR Xn% = MenuMin% TO MenuMax%

        SWAP OldMenuArray(Xn%), MenuItem(Xn%)

    NEXT Xn%

    'Save old boundaries.
    OldMenuMin% = MenuMin%
    OldMenuMax% = MenuMax%

    BeenHere% = -1
    '==========================================================

 'Restore the calling procedure's button properties.
 ELSE

    ' Restore the menu item array.
    REDIM MenuItem(OldMenuMin% TO OldMenuMax%) AS STRING

    'Restore the old boundaries.
    FOR Xn% = OldMenuMin% TO OldMenuMax%

        SWAP MenuItem(Xn%), OldMenuArray(Xn%)

    NEXT Xn%
  
    ERASE OldMenuArray
    BeenHere% = 0
    '==========================================================

 END IF

END SUB

'
' Store the contents of display memory in ScreenBuf.
'
' First call saves, second restores.
'
SUB SaveScreen

 STATIC BeenHere%

 BufSeg% = VARSEG(ScreenBuf)
 BufOff% = VARPTR(ScreenBuf)

 IF PEEK(&H463) = &HB4 THEN    ' Monochrome.
    DisplaySeg% = &HB000
 ELSE                          ' Color.
    DisplaySeg% = &HB800
 END IF

 CALL HidePointer

 IF NOT BeenHere% THEN

    FOR X% = 0 TO 3998 STEP 2
        Value% = GetWord(DisplaySeg%, X%)
        CALL PutWord(BufSeg%, BufOff% + X%, Value%)
    NEXT X%

    BeenHere% = -1

 ELSE

    FOR X% = 0 TO 3998 STEP 2
        Value% = GetWord(BufSeg%, BufOff% + X%)
        CALL PutWord(DisplaySeg%, X%, Value%)
    NEXT X%

    BeenHere% = 0

 END IF

 CALL ShowPointer

END SUB

'
' Causes the objects on the screen to appear disabled, making new objects
' drawn easier to see.
'
SUB ScreenDisable

 IF PEEK(&H463) <> &HB4 THEN            ' If not monochrome.

    Titles% = TitleBackColor * 16 + TitleForeColor
    Boxes% = BoxBackColor * 16 + BoxForeColor
    Item% = MenuForeColor * 16 + MenuBackColor ' These colors are reversed.
    Shade% = 0 * 16 + 8
   
    DEF SEG = &HB800

    CALL HidePointer

    FOR X% = 161 TO 3999 STEP 2         ' Skip main title.

       C% = PEEK(X%)
       IF C% = Titles% THEN             ' Disable titles.
          POKE X%, &H70                 ' 7*16+0
       ELSEIF C% = Boxes% THEN          ' Disable boxes.
          POKE X%, &H70                 ' 7*16+0
       ELSEIF C% = Item% THEN           ' Disable menu hilighted item.
          POKE X%, &H70                 ' 7*16+0
      
       ' Works only one level deep.
       ELSEIF C% = Shade% THEN          ' Remove shading.
          POKE X%, &H7                  ' 7
       END IF

    NEXT X%
   
    CALL ShowPointer

    DEF SEG
 END IF

END SUB

'
' Initialize some data and draw boxes on screen.
'
SUB ShowBoxes

 '===========================================================================
 ' Initialize box colors, and draw a background.
 '===========================================================================
 FrameForeColor = 0
 FrameBackColor = 7
 BoxForeColor = 7
 BoxBackColor = 1
 TitleForeColor = 15
 TitleBackColor = 5

 ' Use all the screen.
 VIEW PRINT

 ' Background color.
 COLOR 7, 0

 ' Draw a background screen.
 FOR R% = 2 TO 24
    LOCATE R%, 1: PRINT STRING$(80, "");
 NEXT

 COLOR TitleForeColor, TitleBackColor
 LOCATE 1, 1: PRINT SPACE$(32); "Mouse Event Test"; SPACE$(32)
 
 COLOR 0, 3 ' Draw help bar.
 LOCATE 25, 1: PRINT "  <F1=Help>  <Arrow=Scroll Menu>  <Enter=Choose Menu Item>  <Esc=Quit>   0 :0  ";
 '===========================================================================

 '===========================================================================
 ' Draw the Menu box on the screen, and show items.
 '===========================================================================
 X% = 1
 Box(X%).C = 2
 Box(X%).R = 3
 Box(X%).W = 19
 Box(X%).H = 11
 
 Title$ = "Menu"
 ' The menu procedure will automatically draw a box.
 'CALL DrawBox(Box(X%).R, Box(X%).C, Box(X%).W, Box(X%).H, Title$)

 ' Define the items that will appear on the menu.
 TotalItem% = 17   ' Total number of menu items.

 REDIM MenuItem(1 TO TotalItem%) AS STRING ' Array to hold menu items.

 MenuItem(1) = " Install Handler    "
 MenuItem(2) = " Disable Handler    "
 MenuItem(3) = " Enable Handler     "
 MenuItem(4) = " Left Press Off     "
 MenuItem(5) = " Left Release Off   "
 MenuItem(6) = " Right Press Off    "
 MenuItem(7) = " Right Release Off  "
 MenuItem(8) = " Center Press Off   "
 MenuItem(9) = " Center Release Off "
 MenuItem(10) = " Mouse Move On      "
 MenuItem(11) = " Clear Buffer       "
 MenuItem(12) = " Delay Off          "
 MenuItem(13) = " Default Settings   "
 MenuItem(14) = " Doodle Pad         "
 MenuItem(15) = " Calculator         "
 MenuItem(16) = " DOS Shell          "
 MenuItem(17) = " Quit Demo          "

 MenuForeColor = BoxForeColor: MenuBackColor = BoxBackColor
 COLOR MenuForeColor, MenuBackColor

 ' Upper left corner of menu.
 Row% = Box(X%).R: Col% = Box(X%).C
 CALL ShowMenu(Row%, Col%, Title$)
 '===========================================================================

 '===========================================================================
 ' Draw the Mouse Events box on the screen.
 '===========================================================================
 X% = 2
 Box(X%).C = 25
 Box(X%).R = 3
 Box(X%).W = 23
 Box(X%).H = 20
  
 Title$ = "Mouse Events"
 CALL DrawBox(Box(X%).R, Box(X%).C, Box(X%).W, Box(X%).H, Title$)
 CALL DrawMouse(Box(X%).R + 3, Box(X%).C + 2, 0)
 LOCATE Box(2).R + 2, Box(2).C + 2: PRINT "Row:      Col:"

 '===========================================================================

 '===========================================================================
 ' Draw the Key Events box on the screen.
 '===========================================================================
 X% = 3
 Box(X%).C = 50
 Box(X%).R = 3
 Box(X%).W = 30
 Box(X%).H = 9
 
 Title$ = "Key Events"
 CALL DrawBox(Box(X%).R, Box(X%).C, Box(X%).W, Box(X%).H, Title$)
 CALL DrawShiftKeys(Box(X%).R + 2, Box(X%).C + 3, 0)
 '===========================================================================

 '===========================================================================
 ' Draw the Miscellaneous box on the screen.
 '===========================================================================
 X% = 4
 Box(X%).C = 50
 Box(X%).R = 13
 Box(X%).W = 30
 Box(X%).H = 10

 Title$ = "Miscellaneous"
 CALL DrawBox(Box(X%).R, Box(X%).C, Box(X%).W, Box(X%).H, Title$)

 COLOR BoxForeColor, BoxBackColor
 LOCATE Box(X%).R + 1, Box(X%).C + 2: PRINT "   Status: Not installed"
 LOCATE Box(X%).R + 2, Box(X%).C + 2: PRINT "Bit Field:"
 LOCATE Box(X%).R + 3, Box(X%).C + 2: PRINT "Events Pending:"
 LOCATE Box(X%).R + 4, Box(X%).C + 2: PRINT "  Tail Pointer:"
 LOCATE Box(X%).R + 5, Box(X%).C + 2: PRINT "  Head Pointer:"
 LOCATE Box(X%).R + 6, Box(X%).C + 2: PRINT "   Click Speed:"
 LOCATE Box(X%).R + 7, Box(X%).C + 2: PRINT "   Click Width:"
 LOCATE Box(X%).R + 8, Box(X%).C + 2: PRINT "  Click Height:"
 '===========================================================================
 
END SUB

'
'  This procedure is the main control for the demo.
'
SUB TheMainLoop

 ' If you want to change the default double-click
 ' settings, just unREM the following few lines of
 ' code and replace the values with your own.
 '
 ' ClickS% = 6  ' Double-click speed  - 18 = 1 second (approx).
 ' ClickW% = 2  ' Double-click width  - 2 pixels of movement on either side,
 ' ClickH% = 2  ' Double-click height - plus, above and below pointer.
 ' CALL SetDblClkSettings(ClickS%, ClickW%, ClickH%)

 Title$ = "Menu"
 UserDelay% = -1        ' Turn delay on.
 
 DO
    DO ' Wait for a mouse or key event.
       MouseEvent% = InMouse(MouseX%, MouseY%)
       MouseCol% = MouseX% \ 8 + 1 ' Convert to BASIC's
       MouseRow% = MouseY% \ 8 + 1 ' row/column format.
      
       ' InMouse(), returns the current pointer position only
       ' if the mouse event buffer is empty. Display position
       ' in lower right hand corner of screen.
       IF MouseEvent% = 0 THEN
          IF MouseX% <> OldMouseX% OR MouseY% <> OldMouseY% THEN
             CurMouseRow = LTRIM$(STR$(MouseRow%))
             CurMouseCol = LTRIM$(STR$(MouseCol%))
             COLOR 0, 3: CALL HidePointer
             LOCATE 25, 75: PRINT CurMouseRow; ":"; CurMouseCol;
             CALL ShowPointer: COLOR BoxForeColor, BoxBackColor
             OldMouseX% = MouseX%
             OldMouseY% = MouseY%
          END IF
       END IF
      
       KeyPress$ = INKEY$

    LOOP UNTIL MouseEvent% OR LEN(KeyPress$)
   
    IF KeyPress$ = CHR$(0) + CHR$(59) THEN CALL Help ' F1 key.
   
    ' Pass event through DecodeMouseEvent() first so we can visually
    ' see what is happening (if delay is turned on).
    IF MouseEvent% THEN
       CALL DecodeMouseEvent(MouseEvent%, MouseRow%, MouseCol%, UserDelay%)
    END IF
   
    ' Check for a mouse event.
    IF MouseEvent% AND LButtonDown THEN
       IF MouseRow% = 25 THEN                           ' Pointer on help bar?
          IF MouseCol% > 2 AND MouseCol% < 12 THEN      ' <F1=Help>
             CALL Help
          ELSEIF MouseCol% > 13 AND MouseCol% < 33 THEN ' <Arrow=Scroll Menu>
             KeyPress$ = CHR$(0) + "P"
          ELSEIF MouseCol% > 34 AND MouseCol% < 59 THEN ' <Enter=Choose Menu Item>
             KeyPress$ = CHR$(13)
          ELSEIF MouseCol% > 60 AND MouseCol% < 71 THEN ' <Esc=Quit>
             ' Requires a double-click to quit program.
             IF MouseEvent% AND LButtonDblClk THEN EXIT DO
          END IF
       END IF
      
       CALL MouseCheck(ChosenItem%, MouseRow%, MouseCol%) ' Menu procedure.

    END IF
   
    ' Check for a key press.
    IF KeyPress$ <> "" THEN
       CALL KeyBoardCheck(KeyPress$, ChosenItem%)       ' Menu procedure.
    END IF
   
    IF ChosenItem% THEN
       ItemText$ = LTRIM$(RTRIM$(MenuItem(ChosenItem%)))
       SELECT CASE ItemText$
          CASE "Install Handler"

             ' Only if handler is not installed.
             IF InMouseState = 0 THEN
                CALL DetectMouse
               
                CALL SetPointer(0, 0)

                ' NOTE, installing also shows mouse pointer.
                CALL InMouseHandler(EventInstall)
             END IF

          CASE "Disable Handler"

             ' NOTE, disabling also hides mouse pointer.
             CALL InMouseHandler(EventDisable)
            
          CASE "Enable Handler"
            
             ' NOTE, enabling also shows mouse pointer.
             CALL InMouseHandler(EventEnable)
            
          ' Trap left button presses.
          CASE "Left Press On"
             MenuItem(4) = " Left Press Off     "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)
             CALL GetEventMask(OldMask%)
            
             '===============================================================
             ' CvsBin%- lets you visually see what bit is being added to
             ' the new mask (by ORing it with the old mask).
             NewMask% = OldMask% OR CvsBin%("0000000000000010") ' 2
             '===============================================================
             
             ' Inform handler.
             CALL SetEventMask(NewMask%)

          ' Stop trapping left button presses.
          CASE "Left Press Off"
             MenuItem(4) = " Left Press On      "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)
             CALL GetEventMask(OldMask%)
            
             '===============================================================
             ' CvsBin%- lets you visually see what bit is being removed
             ' (masked out) from the old mask (by ANDing with the old mask).
             NewMask% = OldMask% AND CvsBin%("1111111111111101")' -3
             '===============================================================
            
             CALL SetEventMask(NewMask%)
         
          ' Trap left button releases.
          CASE "Left Release On"
             MenuItem(5) = " Left Release Off   "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)
             CALL GetEventMask(OldMask%)
            
             '===============================================================
             ' OR the constant LButtonUp with (start trapping left button
             ' release events) the old mask.
             NewMask% = OldMask% OR LButtonUp
             'NewMask% = OldMask% OR CvsBin%("0000000000000100") ' 4
             '===============================================================

             CALL SetEventMask(NewMask%)

          ' Stop trapping left button releases.
          CASE "Left Release Off"
             MenuItem(5) = " Left Release On    "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)
             CALL GetEventMask(OldMask%)
            
             '===============================================================
             ' Use the NOT operator to mask out (stop trapping) left button
             ' releases.
             NewMask% = OldMask% AND NOT LButtonUp
             'NewMask% = OldMask% AND CvsBin%("1111111111111011") ' -5
             '===============================================================
            
             CALL SetEventMask(NewMask%)
         
          CASE "Right Press On"
             MenuItem(6) = " Right Press Off    "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)
             CALL GetEventMask(OldMask%)
             NewMask% = OldMask% OR CvsBin%("0000000000001000") ' 8
             CALL SetEventMask(NewMask%)

          CASE "Right Press Off"
             MenuItem(6) = " Right Press On     "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)
             CALL GetEventMask(OldMask%)
             NewMask% = OldMask% AND CvsBin%("1111111111110111") ' -9
             CALL SetEventMask(NewMask%)
         
          CASE "Right Release On"
             MenuItem(7) = " Right Release Off  "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)
             CALL GetEventMask(OldMask%)
             NewMask% = OldMask% OR CvsBin%("0000000000010000") ' 16
             CALL SetEventMask(NewMask%)

          CASE "Right Release Off"
             MenuItem(7) = " Right Release On   "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)
             CALL GetEventMask(OldMask%)
             NewMask% = OldMask% AND CvsBin%("1111111111101111") ' -17
             CALL SetEventMask(NewMask%)

          CASE "Center Press On"
             MenuItem(8) = " Center Press Off   "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)
             CALL GetEventMask(OldMask%)
             NewMask% = OldMask% OR CvsBin%("0000000000100000") ' 32
             CALL SetEventMask(NewMask%)

          CASE "Center Press Off"
             MenuItem(8) = " Center Press On    "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)
             CALL GetEventMask(OldMask%)
             NewMask% = OldMask% AND CvsBin%("1111111111011111") ' -33
             CALL SetEventMask(NewMask%)
         
          CASE "Center Release On"
             MenuItem(9) = " Center Release Off "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)
             CALL GetEventMask(OldMask%)
             NewMask% = OldMask% OR CvsBin%("0000000001000000") ' 64
             CALL SetEventMask(NewMask%)

          CASE "Center Release Off"
             MenuItem(9) = " Center Release On  "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)
             CALL GetEventMask(OldMask%)
             NewMask% = OldMask% AND CvsBin%("1111111110111111") ' -65
             CALL SetEventMask(NewMask%)
         
          CASE "Mouse Move On"
             MenuItem(10) = " Mouse Move Off     "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)
             CALL GetEventMask(OldMask%)
             NewMask% = OldMask% OR CvsBin%("0000000000000001") ' 1
             CALL SetEventMask(NewMask%)

          CASE "Mouse Move Off"
             MenuItem(10) = " Mouse Move On      "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)
             CALL GetEventMask(OldMask%)
             'NewMask% = OldMask% AND CvsBin%("1111111111111110") ' -2
             NewMask% = OldMask% AND NOT MouseMoved
             CALL SetEventMask(NewMask%)
         
          CASE "Clear Buffer": CALL InMouseHandler(ClearBuffer)
         
          CASE "Delay On"
             UserDelay% = -1
             MenuItem(12) = " Delay Off          "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)
          
          CASE "Delay Off"
             UserDelay% = 0
             MenuItem(12) = " Delay On           "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)

          CASE "Default Settings"
             CALL SetDblClkSettings(6, 2, 2)
             DefaultMask% = CvsBin%("0000000001111110") '126
             CALL SetEventMask(DefaultMask%)
             MenuItem(4) = " Left Press Off     "
             MenuItem(5) = " Left Release Off   "
             MenuItem(6) = " Right Press Off    "
             MenuItem(7) = " Right Release Off  "
             MenuItem(8) = " Center Press Off   "
             MenuItem(9) = " Center Release Off "
             MenuItem(10) = " Mouse Move On      "
             MenuItem(12) = " Delay Off          "
             CALL ShowMenu(Box(1).R, Box(1).C, Title$)
             UserDelay% = -1

             ' Only if disabled.
             IF InMouseState AND EventDisable THEN
                ' NOTE, enabling also shows mouse pointer.
                CALL InMouseHandler(EventEnable)
             END IF

          CASE "Doodle Pad": CALL DoodlePad
          CASE "Calculator": CALL Calculator

          '==================================================================
          ' We must save our mouse driver's state before shelling in case
          ' some other program alters it after we have dropped to DOS.
          '==================================================================
          CASE "DOS Shell"
               CALL InMouseHandler(EventDisable) ' Disable event handler.
               CALL HidePointer
               MouseSize% = GetSizeM%            ' Get the size of mouse
               Buf$ = SPACE$(MouseSize%)         ' state and store it in
               CALL SaveStateM(Buf$, ErrNum%)    ' Buf$.
               CALL SaveScreen                   ' Save our display.
               COLOR 7, 0: CLS
               PRINT "Type EXIT to return. "
               SHELL
               CALL SaveScreen                   ' Restore everything back
               COLOR BoxForeColor, BoxBackColor  ' to normal.
               CALL RestoreStateM(Buf$, ErrNum%)
               Buf$ = ""
               CALL InMouseHandler(EventEnable)
               CALL ShowPointer
         
          CASE "Quit Demo": EXIT DO
       END SELECT
       KeyPress$ = ""
       ChosenItem% = 0
    ELSE
       ItemText$ = ""
    END IF
   
    ' Show state of handler.
    Status% = InMouseState

    IF Status% = 0 THEN
       Stat$ = "Not Installed"
    ELSEIF Status% AND EventEnable THEN
       Stat$ = "Enabled      "
    ELSEIF Status% AND EventDisable THEN
       Stat$ = "Disabled     "
    END IF
   
    CALL HidePointer
    LOCATE Box(4).R + 1, Box(4).C + 2: PRINT "   Status: "; Stat$
    CALL ShowPointer
    
 LOOP UNTIL KeyPress$ = CHR$(27)

END SUB

