DEFINT A-Z
'=========================== MLIB Include File ==============================
' This file should be included in your program for proper operation. To
' increase the amount of memory available to your program, you may edit this
' file to include only the procedure declarations and/or constants needed.
' You could also use a numeric value in place of the symbolic names in your
' code, and remove the constant definitions from this file altogether.
'============================================================================

' Standard mouse routines.
DECLARE SUB InitPointer (Buttons%)
DECLARE SUB ShowPointer
DECLARE SUB HidePointer

DECLARE SUB SetPointer (X%, Y%)
DECLARE SUB SetHLimitM (X%, Y%)
DECLARE SUB SetVLimitM (X%, Y%)
DECLARE SUB SetBoundM (x1%, y1%, x2%, y2%)
DECLARE SUB ChangePointer (Shape$, HotX%, HotY%)

DECLARE SUB GetMotionM (X%, Y%)
DECLARE SUB GetSpeedM (H%, V%, D%)
DECLARE SUB SetSpeedM (H%, V%, D%)
DECLARE SUB GetButtonM (Button%, X%, Y%)
DECLARE SUB GetPressM (Button%, Status%, Count%, X%, Y%)
DECLARE SUB GetReleaseM (Button%, Status%, Count%, X%, Y%)

DECLARE SUB SaveStateM (Buffer$, SaveErr%)
DECLARE SUB RestoreStateM (Buffer$, RestoreErr%)

DECLARE FUNCTION GetSizeM%
DECLARE FUNCTION ShowPtrM% (Buffer$)
DECLARE FUNCTION InWinM% (BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%)

' Sample pointer shapes.
DECLARE SUB PEN0
DECLARE SUB ARROW0
DECLARE SUB ARROW1
DECLARE SUB HANDV0
DECLARE SUB MOUSE0
DECLARE SUB WATCH0
DECLARE SUB PAINTCUP0
DECLARE SUB HOURGLASS0
DECLARE SUB MAGNIFYGLASS0

' Pointer shape file (.SHP) record format.
TYPE MOUSEtype              ': Each record is 80 bytes.
      DLT    AS INTEGER     ': 2  bytes for editor use.
      HTX    AS INTEGER     ': 2  bytes for hotspot  X.
      HTY    AS INTEGER     ': 2  bytes for hotspot  Y.
      FRM    AS STRING * 10 ' bytes for solid or transparent format.
      DAT    AS STRING * 64 ' bytes for shape data.
END TYPE

' Extra routines.
DECLARE FUNCTION CvsBin% (BinaryString$)
DECLARE FUNCTION CviBin$ (BYVAL BinaryValue%)
DECLARE FUNCTION GetWord% (BYVAL SegVal%, BYVAL OffVal%)
DECLARE SUB PutWord (BYVAL SegVal%, BYVAL OffVal%, BYVAL Value%)

'============================================================================
' Mouse event handling procedure declarations and constant definitions.
'============================================================================
' Mouse event procedures.
DECLARE SUB InMouseHandler (BYVAL Action%)
DECLARE FUNCTION InMouseAddress% (OffVal%)
DECLARE FUNCTION InMouse% (MouseX%, MouseY%)

' Event handler control constants.
CONST EventInstall = 1          ' Install InMouse().
CONST EventEnable = 2           ' Enable InMouse().
CONST EventDisable = 4          ' Disable InMouse().
CONST ClearBuffer = 8           ' Clear event buffer.

' Mouse move mask.
CONST MouseMoved = 1

' Mouse down masks.
CONST LButtonDown = 2           ' Left button down.
CONST RButtonDown = 8           ' Right button down.
CONST CButtonDown = 32          ' Center button down.

' Mouse up masks.
CONST LButtonUp = 4             ' Left button up.
CONST RButtonUp = 16            ' Right button up.
CONST CButtonUp = 64            ' Center button up.

' Mouse double-click masks.
CONST LButtonDblClk = 128       ' Left button double-click.
CONST RButtonDblClk = 256       ' Right button double-click.
CONST CButtonDblClk = 512       ' Center button double-click.

' Shift-state key masking constants.
CONST ShiftKey = 1024           ' Shift key mask.
CONST CtrlKey = 2048            ' Ctrl key mask.
CONST AltKey = 4096             ' Alt key mask.

' Optional mouse toolkit (MLIBTOOL.BAS) BASIC procedure
' declarations and constant definitions.
DECLARE SUB ClearEventBuffer ()
DECLARE SUB InMouseSave (Buffer$)
DECLARE SUB InMouseRestore (Buffer$)
DECLARE SUB GetEventMask (OldMask%)
DECLARE SUB SetEventMask (NewMask%)
DECLARE SUB SetDblClkSettings (ClickS%, ClickW%, ClickH%)
DECLARE SUB GetDblClkSettings (ClickS%, ClickW%, ClickH%)

DECLARE FUNCTION GetTailPtr% ()
DECLARE FUNCTION GetHeadPtr% ()
DECLARE FUNCTION InMouseState% ()
DECLARE FUNCTION GetEventsPending% ()

' Handler data block offset constants.
CONST InMouseStateOff = 28      ' Handler status flag.
CONST EventMaskOff = 30         ' Mouse event mask.
CONST ClickSOff = 32            ' Double-click speed offset.
CONST ClickWOff = 34            ' Double-click width offset.
CONST ClickHOff = 36            ' Double-click height offset.
CONST HeadPtrOff = 38           ' Buffer head pointer offset.
CONST TailPtrOff = 40           ' Buffer tail pointer offset.
CONST BufferOff = 42            ' Buffer offset.

