// G_TEST.HPP
//
// Genesis Graphical Interface Application Library version 2
// Copyright (c) '93 by Kevin C.W. Hise - All rights reserved.
//
// sample and test program.

// GXL include files

#include <g_kernl.hpp>     // the GL2 event manager
#include <g_timer.hpp>     // programmable event timer
#include <g_elodv.hpp>     // the ELODEV elographics driver input device
#include <g_keybd.hpp>     // the BIOS keyboard input device
#include <g_3dbor.hpp>     // a 3D window border
#include <g_title.hpp>     // window title bar
#include <g_helpb.hpp>     // window help bar
#include <g_cbutn.hpp>     // a 'combo' button type (can display icon and text)
#include <g_stopb.hpp>     // 3D stop sign button
#include <g_arowb.hpp>
#include <g_rndb.hpp>
#include <g_trib.hpp>
#include <g_label.hpp>      // text object
#include <g_clock.hpp>     // clock object (analog / digital )
#include <g_scrol.hpp>     // scroll bar
#include <g_vlist.hpp>     // a vertical list box
#include <g_field.hpp>     // string input fields
#include <g_pfile.hpp>
#include <g_flag.hpp>

#include <g_ssave.hpp>
#include <g_stars.hpp>

//#include <bgipcx.hpp>       // 'size_PCX()' and 'draw_PCX()' using BGI routines

#if defined ( USE_BGI )
#include <g_bgi.hpp>       // Borland's BGI display device
//#include <svga256.h>        // extended graphics
#include <g_mmous.hpp>     // microsoft mouse input device

#elif defined ( USE_META )
#include <g_meta.hpp>      // MetaGraphics display device
#include <g_metam.hpp>
//#include <pcxlab.h>

#else
#error dont know what graphics to include!
#endif

#if defined(USING_BGI_GRAPHICS) && defined(USE_METAWINDOW)
#error Opps!
#endif

// 'C' library include files

#include <string.h>         // standard string functions
#include <constrea.h>       // 'cout' declaration
#include <stdio.h>          // for 'sprintf'
#include <dos.h>            // misc defines

#include <moredos.hpp>      // kev's dos functions






pixel_array ico_ok[] = {        // a green check mark
#include "ico\ok.hpp"
};

pixel_array ico_cancel[] = {    // a red 'X'
#include "ico\cancel.hpp"
};

pixel_array ico_exit[] = {      // exit door
#include "ico\exit.hpp"
};

pixel_array ico_windows[] = {   // overlaped windows
#include "ico\windows.hpp"
};

pixel_array ico_buttons[] = {   // four buttons
#include "ico\buttons.hpp"
};

pixel_array ico_paint[] = {     // two paint cans
#include "ico\paint.hpp"
};

pixel_array ico_text[] = {      // small paragraph of text
#include "ico\text.hpp"
};

pixel_array ico_clock[] = {     // a analog clock
#include "ico\clock.hpp"
};

pixel_array ico_plus[] = {      // large red plus symbol
#include "ico\plus_sym.hpp"
};

pixel_array ico_minus[] = {     // large blue minus symbol
#include "ico\less_sym.hpp"
};

pixel_array ico_no[] = {        // international NO symbol
#include "ico\no_sym.hpp"
};

pixel_array ico_trash[] = {     // wanna-be-mac trash can
#include "ico\tras_sym.hpp"
};

pixel_array ico_stop[] = {      // octagonal stop sign
#include "ico\stopsign.hpp"
};

pixel_array ico_lrg_cup[] = {
#include "ico\lrg_cup.hpp"
};

pixel_array ico_med_cup[] = {
#include "ico\med_cup.hpp"
};

pixel_array ico_sml_cup[] = {
#include "ico\sml_cup.hpp"
};



const SCHEME_ID

    SID_MAIN_WINDOW    = 1,
    SID_BORDER         = 2,
    SID_TITLE_BAR      = 3,
    SID_BUTTON         = 4,
    SID_BLACK_TEXT     = 5,
    SID_TEXT           = 6,
    SID_TEXT_FIELD     = 7,

    SID_VLIST          = 8,
    SID_ITEM           = 9,
    SID_SCROLL         = 10,

    SID_CANVAS         = 11,

    SID_POS_MAIN_WIN   = 12,
    SID_POS_TICKET_WIN = 13,

    SID_POS_MAIN_MENU  = 14,
    SID_POS_SIDES_MENU = 15,
    SID_POS_CASH_MENU  = 16,

    SID_W_BLUE         = 17,
    SID_W_GREEN        = 18,
    SID_W_CYAN         = 19,
    SID_W_RED          = 20,
    SID_W_BROWN        = 21,
    SID_W_MAGENTA      = 22,


    SID_CLOCK          = 23

    ;


// define some sample 3D color schemes


COLOR_SCHEME colorTable[] =
{
#if defined ( USE_BGI )

//----SCHEME_ID---------BRIGHT------SHADOW------FILL--------BG FILL------TEXT-----PATTERN--------

    { SID_MAIN_WINDOW,  lightcyan,  darkgray,   cyan,       cyan,        black,      SOLID_FILL      },
    { SID_BORDER,       lightcyan,  darkgray,   cyan,       cyan,        black,      SOLID_FILL      },
    { SID_TITLE_BAR,    lightblue,  darkgray,   blue,       blue,        yellow,     SOLID_FILL      },
    { SID_BUTTON,       white,      darkgray,   lightgray,  lightgray,   black,      SOLID_FILL      },
    { SID_BLACK_TEXT,   black,      black,      black,      black,       black,      SOLID_FILL      },
    { SID_TEXT,         black,      black,      cyan,       cyan,        yellow,     SOLID_FILL      },
    { SID_TEXT_FIELD,   white,      darkgray,   lightgray,  black,       black,      SOLID_FILL      },

    { SID_VLIST,        white,      darkgray,   lightgray,  black,       black,      SOLID_FILL      },
    { SID_ITEM,         black,      black,      white,      black,       black,      SOLID_FILL      },
    { SID_SCROLL,       white,      darkgray,   lightgray,  black,       lightgray,  INTERLEAVE_FILL },

    { SID_CANVAS,       white,      darkgray,   cyan,       black,       black,      XHATCH_FILL     },

// the POS demo

    { SID_POS_MAIN_WIN,    white,         darkgray,   blue,       blue,        black,      INTERLEAVE_FILL },
    { SID_POS_TICKET_WIN,  white,         darkgray,   cyan,       cyan,        black,      INTERLEAVE_FILL },

    { SID_POS_MAIN_MENU,   white,         darkgray,   magenta,    black,       black,      INTERLEAVE_FILL },
    { SID_POS_SIDES_MENU,  white,         darkgray,   green,      black,       black,      INTERLEAVE_FILL },
    { SID_POS_CASH_MENU,   white,         darkgray,   lightgray,  black,       black,      INTERLEAVE_FILL },

    { SID_W_BLUE,       lightblue,     darkgray,   blue,       black,       white,      SOLID_FILL  },
    { SID_W_GREEN,      lightgreen,    darkgray,   green,      black,       white,      SOLID_FILL  },
    { SID_W_CYAN,       lightcyan,     darkgray,   cyan,       black,       white,      SOLID_FILL  },
    { SID_W_RED,        lightred,      darkgray,   red,        black,       white,      SOLID_FILL  },
    { SID_W_BROWN,      lightred,      darkgray,   brown,      black,       yellow,     SOLID_FILL  },
    { SID_W_MAGENTA,    lightmagenta,  darkgray,   magenta,    black,       yellow,     SOLID_FILL  },


//----SCHEME_ID---------HR HAND----MIN HAND-----FACE--------OUTLINE------TICS--------N/A------------

    { SID_CLOCK,        red,        blue,       white,      black,       black,      0               },

//----terminate the list

    { SID_DEFAULT,      white,      darkgray,   lightgray,  lightgray,  black,       SOLID_FILL      }

#elif defined ( USE_META )

    { SID_MAIN_WINDOW,  lightcyan,  darkgray,   cyan,       cyan,        black,      1      },
    { SID_BORDER,       lightcyan,  darkgray,   cyan,       cyan,        black,      1      },
    { SID_TITLE_BAR,    lightblue,  darkgray,   blue,       blue,        yellow,     1      },
    { SID_BUTTON,       white,      darkgray,   lightgray,  lightgray,   black,      1      },
    { SID_BLACK_TEXT,   black,      black,      black,      black,       black,      1      },
    { SID_TEXT,         black,      black,      cyan,       cyan,        yellow,     1      },
    { SID_TEXT_FIELD,   white,      darkgray,   yellow,     white,       black,      4      },

    { SID_VLIST,        white,      darkgray,   yellow,     white,       black,      4      },
    { SID_ITEM,         black,      black,      white,      black,       black,      1      },
    { SID_SCROLL,       white,      darkgray,   lightgray,  black,       lightgray,  3      },

    { SID_CANVAS,       white,      darkgray,   cyan,       black,       black,      24     },

// the POS demo

    { SID_POS_MAIN_WIN,    white,         darkgray,   blue,       black,       black,   3   },
    { SID_POS_TICKET_WIN,  white,         darkgray,   cyan,       black,       black,   3   },

    { SID_POS_MAIN_MENU,   white,         darkgray,   magenta,    black,       black,   3   },
    { SID_POS_SIDES_MENU,  white,         darkgray,   green,      black,       black,   3   },
    { SID_POS_CASH_MENU,   white,         darkgray,   lightgray,  black,       black,   3   },

    { SID_W_BLUE,       lightblue,     darkgray,   blue,       black,       white,      1   },
    { SID_W_GREEN,      lightgreen,    darkgray,   green,      black,       white,      1   },
    { SID_W_CYAN,       lightcyan,     darkgray,   cyan,       black,       white,      1   },
    { SID_W_RED,        lightred,      darkgray,   red,        black,       white,      1   },
    { SID_W_BROWN,      lightred,      darkgray,   brown,      black,       yellow,     1   },
    { SID_W_MAGENTA,    lightmagenta,  darkgray,   magenta,    black,       yellow,     1   },

//----SCHEME_ID---------HR HAND----MIN HAND-----FACE--------OUTLINE------TICS--------N/A------------

    { SID_CLOCK,        red,        blue,       white,      black,       black,      0      },

//----terminate the list

    { SID_DEFAULT,      white,      darkgray,   lightgray,  lightgray,  black,       1      }

#endif
};


// global access to the wallpaper and help bar

WINDOW      * desktop;          // workspace background

HELP_BAR    * help_bar;         // main window help bar

TIMER       * event_timer;      // programmable event timer



// text font handles

int
    tri_font,
    san_font,
    scr_font

    ;




// some user-defined event IDs

const OBJECT_ID

// Point-Of-Sale demo event IDs

    OI_MENU_MANAGER   = 1,
    OI_TICKET_MANAGER = 2

    ;




// some user-defined events

const EVENT_TYPE

// general event types

    EV_OPTION       = 1,     // returned from Ok, Cancel and menu buttons
    EV_COLOR        = 2,     // returned when a color is selected from the canvas window
    EV_TIMEOUT      = 3,

// Point-Of-Sale demo event types

    EV_POS_EXIT     = 10,
    EV_SELECT_ITEM  = 11,
    EV_SELECT_MENU  = 12,
    EV_EDIT_ITEM    = 13,
    EV_CLEAR_TICKET = 14,

    EV_SALE_TYPE_KEY     = 15,
    EV_NUMBER_KEY        = 16,
    EV_PRESET_DOLLAR_KEY = 17,
    EV_PAY_TYPE_KEY      = 18,

    EV_SUB_TOTAL         = 19,
    EV_GET_SUB_TOTAL     = 20
    ;



// some event codes used with the 'EV_OPTION' event

const EVENT_CODE

    C_EXIT           = 1,   // exit the demo
    C_CANCEL         = 2,   // restore changes, end edit/operation
    C_OK             = 3,   // keep changes, end edit/operation
    C_CLOSE          = 4,

    C_WINDOW         = 5,   // display a popup window
    C_SET_DESKTOP    = 6,   // change the wallpaper style or color
    C_TEXT_OBJECTS   = 7,   // sample text objects
    C_BUTTON_OBJECTS = 8,   // sample button objects
    C_CLOCK          = 9,   // clocks
    C_LIST           = 10,  // a list box
    C_INPUT          = 11,  // string and numeric input
    C_PICK_FILE      = 12,  // file selection dialog

    C_POS            = 13,  // point-of-sale demo

// POS demo commands

    C_MORE           = 1,   // 'More' button was selected
    C_LESS           = 2,   // 'Less' button
    C_NO             = 3,   // 'NO' button
    C_TRASH          = 4    // 'Cancel' trash can

    ;



// help context strings (order matches event code values)

const char * help_context[] = {

    "(c) '93 Hise Programming.",
    "Exit from this demo.",
    "Cancel",
    "Keep changes",
    "Close window",

    "Sample dialog box",
    "Modify the background",
    "Text objects",
    "Buttons, Icons, Scrollbars",
    "Analog & digital clocks",
    "A Selection List",
    "Data entry fields",
    "Directory Dialog",

    "Point-Of-Sale Application"

};




// ===============
// the main window

class MAIN_WINDOW : public WINDOW
{
public:

    MAIN_WINDOW( void );

    EVENT_STATUS Event( EVENT & event );

};





// ====================
// a menu button option

class OPTION : public COMBO_BUTTON
{
protected:

    EVENT_CODE option;

public:

    OPTION  // text-only constructor
    (
        gRECT &              r,
        SCHEME_ID           s,
        const char *        t,
        int                 fh,
        EVENT_CODE          opt,
        bit_flag_t          bf  = WOF_L_BUTTON | WOF_SEND_QUEUE
    );

    OPTION  // icon-only constructor
    (
        gRECT &              r,
        SCHEME_ID           s,
        const pixel_array * pa,
        EVENT_CODE          opt,
        bit_flag_t          bf  = WOF_L_BUTTON | WOF_SEND_QUEUE
    );

    OPTION  // icon and text constructor
    (
        gRECT &              r,
        SCHEME_ID           s,
        const char *        t,
        int                 fh,
        const pixel_array * pa,
        EVENT_CODE          opt,
        bit_flag_t          bf = WOF_L_BUTTON | WOF_SEND_QUEUE
    );

    EVENT_STATUS Event( EVENT & event );

};




// ==================================
// the wallpaper configuration window

class SET_DESKTOP : public WINDOW
{
protected:

    int old_color,
        old_pattern;

public:

    SET_DESKTOP( void );

    EVENT_STATUS Event( EVENT & event );

};


// ====================================
// a color and pattern selection button

class COLOR_OPTION : public BUTTON
{
protected:

    int col,    // color of the button
        pat;    // pattern

    gRECT swatch_area;   // color/pattern swatch rectangle

    EVENT_CODE option;  //

public:

    COLOR_OPTION
    (
        gRECT &     r,   // area of button
        int        c,   // color of swatch
        int        p,   // pattern of swatch
        EVENT_CODE opt  // option to return
    );

    EVENT_STATUS Event( EVENT & event );

    void Draw( void );

    void Selected( boolean status );

};



// ===================
// blank sample window

class SAMPLE_WINDOW : public WINDOW
{
protected:

    TIMER_BLOCK_HANDLE thandle1, thandle2;

public:

    SAMPLE_WINDOW();

    EVENT_STATUS Event( EVENT & event );

};




// ==================================================
// window with different fonts and some blinking text

class TEXT_WINDOW : public WINDOW
{
public:

    TEXT_WINDOW( void );

    EVENT_STATUS Event( EVENT & event );

};




// =====================================
// window with analog and digital clocks

class CLOCK_WINDOW : public WINDOW
{
public:

    CLOCK_WINDOW( void );

    EVENT_STATUS Event( EVENT & event );

};



// ==========================================
// window with buttons, icons and scroll bars

class BUTTON_WINDOW : public WINDOW
{
public:

    int x_scroll,       // hold position of scroll bar
        y_scroll;

    LABEL * x_text,      // text objects to display position of scroll bar
         * y_text;

    char x_buf[ 20 ],   // buffers to hold scroll bar position text
         y_buf[ 20 ];

    BUTTON_WINDOW( void );

    EVENT_STATUS Event( EVENT & event );

};





class LIST_WINDOW : public WINDOW
{
public:

    bit_flag_t data;


    LIST_WINDOW( void );

    EVENT_STATUS Event( EVENT & event );

};




class INPUT_WINDOW : public WINDOW
{
protected:

    char string_field_1[ 31 ],
         string_field_2[ 31 ];

    int int_data;

    long long_data;

    double double_data;


public:

    INPUT_WINDOW( void );

    EVENT_STATUS Event( EVENT & event );

};





class PICK_WINDOW : public WINDOW
{
public:

    PICK_WINDOW( void );

    EVENT_STATUS Event( EVENT & event );

};





// ===========================
// Point-Of-Sale Demonstration
// ===========================


const int MAX_SIZES = 3;


const EVENT_CODE

// menu screens

    PM_NONE     = 0,
    PM_MAIN     = 1,
    PM_SIDES    = 2,
    PM_CASH_OUT = 3

    ;



enum ITEM_TYPE
{
    IT_UNKNOWN,     // unknown type

    IT_MENU,        // a menu

    IT_FOOD,        // food item
    IT_BASE,        // base modifier
    IT_MODIFIER,    // modifier
    IT_SIZE,        // size

    IT_SALE_KEY,    // sale type
    IT_PAY_KEY,     // payment type
    IT_NUMBER_KEY,  // number key
    IT_DOLLAR_KEY   // preset dollar amounts

};


enum MENU_ITEMS
{

    MI_NONE = -1,

    MI_BURGER,
    MI_CLUCK_BURGER,
    MI_BLT,
    MI_HOT_DOG,
    MI_POLISH_DOG,
    MI_ROAST_BEEF,

    MI_DOUBLE,
    MI_LARGE,

    MI_CHEESE,
    MI_LETTUCE,
    MI_TOMATO,
    MI_ONION,
    MI_PICKLE,
    MI_MAYO,
    MI_KETCHUP,
    MI_MUSTARD,
    MI_RELISH,

    MI_FRIES,
    MI_ONION_RINGS,
    MI_ZUCCINI_STICKS,
    MI_BROCCOLI,
    MI_MUSHROOMS,
    MI_MOZZARELLA_STICKS,

    MI_RANCH_DRESSING,
    MI_BBQ_SAUCE,
    MI_SWEET_N_SOUR,
    MI_TARTAR_SAUCE,
    MI_1000_ISLAND,

    MI_RC_COLA,
    MI_7_UP,
    MI_ROOT_BEER,
    MI_ICE_TEA,

    MI_LEMON_WEDGE,
    MI_DIET,

    MI_SMALL_CUP,
    MI_MEDIUM_CUP,
    MI_LARGE_CUP,

    MI_MAIN_MENU,
    MI_SIDES_MENU,
    MI_CASH_MENU,

    MI_TAKE_OUT,
    MI_DELIVERY,
    MI_DINING,

    MI_CASH,
    MI_CHECK,
    MI_VISA,
    MI_MASTER_CARD,

    MI_BACK_SPACE,
    MI_0,
    MI_1,
    MI_2,
    MI_3,
    MI_4,
    MI_5,
    MI_6,
    MI_7,
    MI_8,
    MI_9,

    MI_CLEAR_ENTRY,
    MI_1_DOLLAR,
    MI_5_DOLLAR,
    MI_10_DOLLAR,
    MI_20_DOLLAR

};




enum ICON_TYPE
{
    NO_ICON,
    PIXEL_TYPE,
    PCX_TYPE
};



struct MENU_DATA
{
    SCHEME_ID scheme_id;            // color scheme

    char      menu[ 16 ];           // menu button text

    int       font;                 // font handle

    char      name[ 16 ];           // ticket list description

    pixel_array * icon;

    ICON_TYPE icon_type;            // icon type

    ITEM_TYPE type;                 // type

    int       size[ MAX_SIZES ],    // size index
              cost[ MAX_SIZES ];    // cost X 100

} menu_list[] = {

// food items

    { SID_BUTTON,   "Burger",         0, "Burger",        NULL,            NO_ICON,     IT_FOOD,        0, 1, 0,    225, 295,   0 },
    { SID_BUTTON,   "Cluck\rBurger",  0, "Cluck Burger",  NULL,            NO_ICON,     IT_FOOD,        0, 0, 0,    225,   0,   0 },
    { SID_BUTTON,   "BLT",            1, "BLT",           NULL,            NO_ICON,     IT_FOOD,        0, 0, 0,    275,   0,   0 },
    { SID_BUTTON,   "Hot Dog",        0, "Hot Dog",       NULL,            NO_ICON,     IT_FOOD,        0, 2, 0,    125, 175,   0 },
    { SID_BUTTON,   "Polish\rDog",    0, "Polish Dog",    NULL,            NO_ICON,     IT_FOOD,        0, 0, 0,    275,   0,   0 },
    { SID_BUTTON,   "Roast\rBeef",    0, "Roast Beef",    NULL,            NO_ICON,     IT_FOOD,        0, 0, 0,    395,   0,   0 },

    { SID_W_GREEN,  "Double",         0, "Dbl",           NULL,            NO_ICON,     IT_SIZE,        1 },
    { SID_W_GREEN,  "Large",          0, "Lrg",           NULL,            NO_ICON,     IT_SIZE,        2 },

// toppings and condiments

    { SID_W_CYAN,   "Cheese",         0, "Cheese",        NULL,            NO_ICON,     IT_MODIFIER  },
    { SID_W_CYAN,   "Lettuce",        0, "Lettuce",       NULL,            NO_ICON,     IT_MODIFIER  },
    { SID_W_CYAN,   "Tomato",         0, "Tomato",        NULL,            NO_ICON,     IT_MODIFIER  },
    { SID_W_CYAN,   "Onion",          0, "Onion",         NULL,            NO_ICON,     IT_MODIFIER  },
    { SID_W_CYAN,   "Pickle",         0, "Pickle",        NULL,            NO_ICON,     IT_MODIFIER  },
    { SID_W_CYAN,   "Mayo",           0, "Mayo",          NULL,            NO_ICON,     IT_MODIFIER  },
    { SID_W_CYAN,   "Ketchup",        0, "Ketchup",       NULL,            NO_ICON,     IT_MODIFIER  },
    { SID_W_CYAN,   "Mustard",        0, "Mustard",       NULL,            NO_ICON,     IT_MODIFIER  },
    { SID_W_CYAN,   "Relish",         0, "Relish",        NULL,            NO_ICON,     IT_MODIFIER  },

// sides

    { SID_BUTTON,   "Fries",            0, "Fries",        NULL,           NO_ICON,     IT_FOOD,        0, 1, 0,    125,  75,   0 },
    { SID_BUTTON,   "Onion\rRings",     0, "Onion Rings",  NULL,           NO_ICON,     IT_FOOD,        0, 0, 0,    195,   0,   0 },
    { SID_BUTTON,   "Zuccini\rSticks",  0, "Zuccini",      NULL,           NO_ICON,     IT_FOOD,        0, 0, 0,    195,   0,   0 },
    { SID_BUTTON,   "Brocoli",          0, "Broccoli",     NULL,           NO_ICON,     IT_FOOD,        0, 0, 0,    195,   0,   0 },
    { SID_BUTTON,   "Mush\rrooms",      0, "Mushrooms",    NULL,           NO_ICON,     IT_FOOD,        0, 0, 0,    195,   0,   0 },
    { SID_BUTTON,   "Mozz.\rSticks",    0, "Mozz. Sticks", NULL,           NO_ICON,     IT_FOOD,        0, 0, 0,    195,   0,   0 },

// dips

    { SID_W_CYAN,   "Ranch\rDressing",  0, "Ranch Dres",   NULL,           NO_ICON,     IT_MODIFIER,    0, 1, 3,    150, 100, 200 },
    { SID_W_CYAN,   "BBQ\rSauce",       0, "BBQ Sauce",    NULL,           NO_ICON,     IT_MODIFIER,    0, 1, 3,    150, 100, 200 },
    { SID_W_CYAN,   "Sweet\rN-Sour",    0, "Sweet/Sour",   NULL,           NO_ICON,     IT_MODIFIER,    0, 1, 3,    150, 100, 200 },
    { SID_W_CYAN,   "Tartar\rSauce",    0, "Tartar Sauce", NULL,           NO_ICON,     IT_MODIFIER,    0, 1, 3,    150, 100, 200 },
    { SID_W_CYAN,   "1000\rIsland",     0, "1000 Island",  NULL,           NO_ICON,     IT_MODIFIER,    0, 1, 3,    150, 100, 200 },


// drinks

    { SID_BUTTON,   "RC Cola",        0, "RC Cola",       NULL,            NO_ICON,     IT_FOOD,        1, 2, 3,     50,  70, 125 },
    { SID_BUTTON,   "7-UP",           0, "7-UP",          NULL,            NO_ICON,     IT_FOOD,        1, 2, 3,     50,  70, 125 },
    { SID_BUTTON,   "Root\rBeer",     0, "Root Beer",     NULL,            NO_ICON,     IT_FOOD,        1, 2, 3,     50,  70, 125 },
    { SID_BUTTON,   "Ice\rTea",       0, "Ice Tea",       NULL,            NO_ICON,     IT_FOOD,        1, 2, 3,     50,  70, 125 },

    { SID_W_CYAN,   "Lemon\rWedge",   0, "Lemon Wedge",   NULL,            NO_ICON,     IT_MODIFIER },
    { SID_W_BROWN,  "Diet",           1, "Diet",          NULL,            NO_ICON,     IT_MODIFIER },

// drinks sizes

    { SID_W_MAGENTA,"Small",          0, "Sml",           ico_sml_cup,     PIXEL_TYPE,  IT_SIZE,        1 },
    { SID_W_MAGENTA,"Medium",         0, "Med",           ico_med_cup,     PIXEL_TYPE,  IT_SIZE,        2 },
    { SID_W_MAGENTA,"Large",          0, "Lrg",           ico_lrg_cup,     PIXEL_TYPE,  IT_SIZE,        3 },

// menu buttons

    { SID_W_MAGENTA,"Sand-\rwiches",    0, "",             NULL,           NO_ICON,     IT_MENU },
    { SID_W_GREEN,  "Sides\r&\rDrinks", 0, "",             NULL,           NO_ICON,     IT_MENU },
    { SID_BUTTON,   "Cash\rOut",        0, "",             NULL,           NO_ICON,     IT_MENU },

// cash-out functions

    { SID_W_GREEN,  "Take\rOut",        0, "Take-Out:",    NULL,           NO_ICON,     IT_SALE_KEY,    0, 0, 0,     100 },
    { SID_W_GREEN,  "Deliver",          0, "Delivery:",    NULL,           NO_ICON,     IT_SALE_KEY,    0, 0, 0,     250 },
    { SID_W_GREEN,  "Dining\rRoom",     0, "Dining Room:", NULL,           NO_ICON,     IT_SALE_KEY,    0, 0, 0,     0   },

    { SID_BUTTON,   "Cash",             0, "",             NULL,           NO_ICON,     IT_PAY_KEY  },
    { SID_BUTTON,   "Check",            0, "",             NULL,           NO_ICON,     IT_PAY_KEY  },
    { SID_BUTTON,   "Visa",             0, "",             NULL,           NO_ICON,     IT_PAY_KEY  },
    { SID_BUTTON,   "Master\rCharge",   0, "",             NULL,           NO_ICON,     IT_PAY_KEY  },

    { SID_W_MAGENTA,  "Back\rSpace",      0, "",           NULL,           NO_ICON,     IT_NUMBER_KEY,  8   },
    { SID_W_CYAN,     "0",                1, "",           NULL,           NO_ICON,     IT_NUMBER_KEY,  48  },
    { SID_W_CYAN,     "1",                1, "",           NULL,           NO_ICON,     IT_NUMBER_KEY,  49  },
    { SID_W_CYAN,     "2",                1, "",           NULL,           NO_ICON,     IT_NUMBER_KEY,  50  },
    { SID_W_CYAN,     "3",                1, "",           NULL,           NO_ICON,     IT_NUMBER_KEY,  51  },
    { SID_W_CYAN,     "4",                1, "",           NULL,           NO_ICON,     IT_NUMBER_KEY,  52  },
    { SID_W_CYAN,     "5",                1, "",           NULL,           NO_ICON,     IT_NUMBER_KEY,  53  },
    { SID_W_CYAN,     "6",                1, "",           NULL,           NO_ICON,     IT_NUMBER_KEY,  54  },
    { SID_W_CYAN,     "7",                1, "",           NULL,           NO_ICON,     IT_NUMBER_KEY,  55  },
    { SID_W_CYAN,     "8",                1, "",           NULL,           NO_ICON,     IT_NUMBER_KEY,  56  },
    { SID_W_CYAN,     "9",                1, "",           NULL,           NO_ICON,     IT_NUMBER_KEY,  57  },

// preset dollar keys

    { SID_W_MAGENTA,  "Clear\rEntry",     0, "",           NULL,           NO_ICON,     IT_DOLLAR_KEY,  0      },
    { SID_W_BROWN,    "$ 1.00",           0, "",           NULL,           NO_ICON,     IT_DOLLAR_KEY,  100    },
    { SID_W_BROWN,    "$ 5.00",           0, "",           NULL,           NO_ICON,     IT_DOLLAR_KEY,  500    },
    { SID_W_BROWN,    "$ 10.00",          0, "",           NULL,           NO_ICON,     IT_DOLLAR_KEY,  1000   },
    { SID_W_BROWN,    "$ 20.00",          0, "",           NULL,           NO_ICON,     IT_DOLLAR_KEY,  2000   },

};








// --------------------
// the ticket item list

// sample format:

// 99 Size Item      5.00
//        Modifier
//   99 X Modifier
//        Modifier
//



class TICKET_ITEM : public WINDOW_OBJECT
{
protected:

    char   t_quan[ 5 ], // quantity text buffer '99'
         * t_size,      // pointer to size string
         * t_name,      // pointer to name
           t_cost[ 9 ]; // cost text buffer '99.99'


    int  x_quan,        // quantity text X offset
         y_quan,        // Y offset

         x_size,        // size text Y offset

         x_item,        // item text Y offset

         x_cost;        // cost text X offset

    boolean selected;   // change color scheme

public:

    MENU_ITEMS item_index,  // index into menu list array
               size_index;

    int quantity,           // item quantity
        size,               //
        cost;               // item cost * 100

    ITEM_TYPE type;


    TICKET_ITEM
    (
        MENU_ITEMS index
    );

    EVENT_STATUS Event( EVENT & event );

    void Draw( void );

    void Item( MENU_ITEMS index );

    void Quantity( int q );

    void Size( MENU_ITEMS index );

};



// ---------------------------
// a menu manager event device

class MENU_MANAGER : public EVENT_DEVICE
{
protected:

    int      current_menu_n;

    WINDOW * current_menu_p;

public:

    MENU_MANAGER( void );

    virtual ~MENU_MANAGER( );

    EVENT_STATUS Event( EVENT & event );

    EVENT_STATUS Poll( void );

};



// -----------------
// a ticket list box

class TICKET_LIST : public VLIST
{
public:

    TICKET_LIST
    (
        gRECT      r,
        SCHEME_ID s
    );

    ~TICKET_LIST();

    void Add( WINDOW_OBJECT * element );

    void Insert( WINDOW_OBJECT * element );

};



// ---------------------
// a ticket item manager

class TICKET_MANAGER : public EVENT_DEVICE
{
public:

    static TICKET_LIST * ticket_list;

    K_DLLIST < TICKET_ITEM * > itemList;

    long sub_total;

    MENU_ITEMS current_sale_type;


    TICKET_MANAGER( void );

    virtual ~TICKET_MANAGER();

    EVENT_STATUS Event( EVENT & event );

    EVENT_STATUS Poll( void );

};



// ---------------------------------------------------
// main window with ticket list, exit button and clock


class POS_MENU : public WINDOW
{
public:

    LABEL * sub_total_text,      // the sub total
         * order_type_text,     // the order type
         * order_cost_text,     // the order type cost
         * tax_text,            // tax total
         * grand_total_text;

    char sub_total_buf[ 8 ],    // the sub total
         order_cost_buf[ 8 ],   // the order type cost
         tax_buf[ 8 ],          // the tax
         grand_total_buf[ 8 ];

    FIELD * tendered_field;

    double tendered;


    POS_MENU( void );

    EVENT_STATUS Event( EVENT & event );

};


class POS_MENU_WINDOW : public WINDOW
{
protected:

    int SBH, SBW;

public:

    POS_MENU_WINDOW( void );

    EVENT_STATUS Event( EVENT & event );

};


class POS_TICKET_WINDOW : public WINDOW
{
protected:

    TICKET_LIST * ticket_list;

public:

    LABEL * sub_total_text;

    char sub_total_buf[ 8 ];


    POS_TICKET_WINDOW( void );

    EVENT_STATUS Event( EVENT & event );

};



// -------------
// a menu button

class MENU_BUTTON : public COMBO_BUTTON
{
protected:

    MENU_ITEMS item_index;

public:

    MENU_BUTTON
    (
        gRECT & r,
        MENU_ITEMS index
    );

    void GetIconSize( int * x, int * y );

    void DrawIcon( void );

    void Draw( void );

    void Selected( boolean state );

};



