         dosseg
         ideal
         model large
         p286
         jumps
         include "guslib.inc"
         stack 2048

         dataseg
data                 db    4864 dup (00h)
file                 db    'bummer.snd',0
file_size_high       dw    0000h
file_size_low        dw    0000h
gfh                  dw    0000h
psp_seg              dw    0000h
msg1_command_line    db    'Sound Player - By Paul Kimbrel - 5/31/1994',13,10
                     db    'Plays back .VOC files to Gravis UltraSound sound cards',13,10,10
                     db    'Usage:  GUS <sound file>',13,10,10
                     db    '        <sound file>   Any .VOC file (include directory'
                     db    ' if necessary)',13,10,10,'$'
msg2_fnf             db    13,10,7,'Warning!  File not found!',13,10,10,'$'
msg3_no_env          db    7,'UltraSound environmental variable not found or not correct!',13,10
                     db    'Make sure you have your SET ULTRASND= line in your autoexec.bat file.',13,10
                     db    'For information on setting the variable, please refer to your GUS manual.$'
msg4_bad_gus         db    7,'UltraSound failed to respond!$'
msg5_keybreak        db    7,'DownLoad_Sound - DMA canceled by keybreak!$'
buffer_seg           dw    0000h
lc                   db       '0'


         codeseg
proc     main     far
         mov      ax,dgroup
         mov      ds,ax
         mov      [psp_seg],es
         mov      bx,stack
         sub      bx,playvoc_text
         add      bx,1024
         mov      ah,4ah
         int      21h
         jc       doneman
         call     get_fn

         mov      ax,[file_size_low]
         mov      dx,[file_size_high]
         mov      bx,16
         idiv     bx
         inc      ax
         mov      bx,ax
         mov      ah,48h
         int      21h
         jc       doneman
         mov      [buffer_seg],ax
         call     load_fn

         call     start_GUS

         mov      ax,0
         mov      bx,Play_Voice
         call     guslib

key_lp1: mov      ah,6
         mov      dl,0ffh
         int      21h
         jnz      key_hit
         mov      bx,Voice_Status
         mov      al,0
         call     guslib
         cmp      ax,0
         jz       key_lp1
         jmp      no_key
key_hit: mov      bx,Stop_Voice
         mov      al,0
         call     guslib

no_key:  mov      al,00h
         jmp      doneman
endp     main

proc     start_gus   far
         mov      bx,Init_GUS
         call     guslib

         cmp      ax,0
         jz       init_ok
         cmp      ax,4
         jnc      nbe
         mov      ah,9
         mov      dx,offset msg3_no_env
         int      21h
         mov      al,3
         jmp      doneman
nbe:     mov      ah,9
         mov      dx,offset msg4_bad_gus
         int      21h
         mov      al,4
         jmp      doneman
init_ok: mov      al,14
         mov      bx,Set_Active
         call     guslib

         mov      ax,[buffer_seg]
         mov      es,ax
         mov      cl,1
         mov      di,0
         mov      si,0
         mov      dx,[file_size_high]
         mov      ax,[file_size_low]
         dec      ax
         mov      bx,Download_Sound
         call     guslib

         cmp      ax,0
         jz       kok
         mov      ah,9
         mov      dx,offset msg5_keybreak
         int      21h
         mov      al,5
         call     doneman
kok:     mov      bx,Set_Volume
         mov      cl,0
         mov      ax,4095
         call     guslib

         mov      ax,[buffer_seg]
         mov      es,ax
         xor      ax,ax
         mov      al,[byte es:1eh]
         mov      bx,256
         sub      bx,ax
         mov      ax,4240h
         mov      dx,0fh
         idiv     bx
         mov      cl,0
         mov      bx,Set_Freq
         call     guslib

         mov      al,3
         mov      cl,0
         mov      bx,Set_Loop
         call     guslib
         mov      dx,0
         mov      ax,0
         mov      cl,0
         mov      bx,Set_Start
         call     guslib

         mov      dx,[file_size_high]
         mov      ax,[file_size_low]
         mov      cl,0
         mov      bx,Set_End
         call     guslib

         ret
endp     start_gus

proc     load_fn  far
         push     es
         mov      cx,[file_size_high]
         mov      bx,[file_size_low]
         mov      dx,[buffer_seg]
         cmp      cx,0
         jz       last_part
rd_lp1:  mov      es,dx
         push     bx cx dx
;
         mov      bx,[gfh]
         mov      cx,65535
         mov      dx,0
         push     ds
         mov      ax,[buffer_seg]
         mov      ds,ax
         mov      ah,3fh
         int      21h
         pop      ds
;
         mov      bx,[gfh]
         mov      cx,1
         mov      dx,65535
         push     ds
         mov      ax,es
         mov      ds,ax
         mov      ah,3fh
         int      21h
         pop      ds
;
         pop      dx cx bx
         add      dx,1000h
         dec      cx
         jnz      rd_lp1
last_part:
         mov      es,dx
         mov      cx,bx
         mov      bx,[gfh]
         mov      dx,0
         push     ds
         mov      ax,es
         mov      ds,ax
         mov      ah,3fh
         int      21h
         pop      ds
         pop      es
         ret
endp     load_fn

proc     doneman  far
         push     ax
         cmp      [gfh],0
         jz       nfo
         mov      ah,3eh
         mov      bx,[gfh]
         int      21h
nfo:     cmp      [buffer_seg],0
         jz       nda
         mov      ax,4900h
         push     es
         mov      bx,[buffer_seg]
         mov      es,bx
         int      21h
         pop      es
nda:     mov      bx,Deinit_GUS
         call     guslib
         pop      ax
         mov      ah,4ch
         int      21h
endp     doneman

proc     get_fn   far
         mov      ax,[psp_seg]
         mov      es,ax
         mov      di,80h
         mov      cl,[es:di]
         xor      ch,ch
         cmp      cx,0
         jnz      cmdlnok
         mov      ax,0003h
         int      10h
         mov      ah,9
         mov      dx,offset msg1_command_line
         int      21h
         mov      al,1
         jmp      doneman
cmdlnok: inc      di
gcmdlp1: inc      di
         mov      al,[es:di]
         cmp      al,20
         jz       gcmddn1
         loop     gcmdlp1
gcmddn1: mov      al,0
         mov      [es:di],al
         push     ds
         mov      dx,82h
         mov      ax,es
         mov      ds,ax
         mov      ax,3dc2h
         int      21h
         pop      ds
         jnc      fok
fnok:    mov      ah,9
         mov      dx,offset msg2_fnf
         int      21h
         mov      al,2
         jmp      doneman
fok:     mov      [gfh],ax
         mov      ax,4202h
         mov      cx,0
         mov      dx,0
         mov      bx,[gfh]
         int      21h
         mov      [file_size_high],dx
         mov      [file_size_low],ax
         mov      ax,4200h
         mov      cx,0
         mov      dx,0
         mov      bx,[gfh]
         int      21h
         ret
endp     get_fn
end      main
