/* Copyright (C) 1993 Aladdin Enterprises.  All rights reserved.
  
  This file is part of Aladdin Ghostscript.
  
  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.
  
  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* gxfarith.h */
/* Floating point arithmetic macros for Ghostscript library */
#include "gxarith.h"

/*
 * These macros replace the ones in gxarith.h on machines
 * that are likely to have very slow floating point.
 * Note that any module that includes this file should be compiled
 * with USE_FPU defined; otherwise, the default definitions will prevail.
 */
#ifdef USE_FPU
# if USE_FPU <= 0 && arch_floats_are_IEEE && (arch_sizeof_float == arch_sizeof_int || arch_sizeof_float == arch_sizeof_long)
#  if arch_sizeof_float == arch_sizeof_int
#    define _f_as_int(f) *(int *)(&(f))
#  else		/* arch_sizeof_float == arch_sizeof_long */
#    define _f_as_int(f) *(long *)(&(f))
#  endif
#  if arch_sizeof_double == arch_sizeof_int
#    define _d_as_int(f) *(int *)(&(d))
#  else
#   if arch_sizeof_double == arch_sizeof_long
#    define _d_as_int(f) *(long *)(&(d))
#   endif
#  endif
#  ifdef _d_as_int
#    define _fdtest(v,f,d,n)\
	(sizeof(v)==sizeof(float)?(f):sizeof(v)==sizeof(double)?(d):(n))
#  else
#    define _fdtest(v,f,d,n)\
	(sizeof(v)==sizeof(float)?(f):(n))
#  endif
#  undef is_fzero
#  define is_fzero(f)	/* must handle both +0 and -0 */\
     _fdtest(f, (_f_as_int(f) << 1) == 0, (_d_as_int(f) << 1) == 0,\
       (f) == 0.0)
#  undef is_fzero2
#  define is_fzero2(f1,f2)\
     (sizeof(f1) == sizeof(float) && sizeof(f2) == sizeof(float) ?\
      ((_f_as_int(f1) | _f_as_int(f2)) << 1) == 0 :\
      (f1) == 0.0 && (f2) == 0.0)
#  undef is_fneg
#  if arch_is_big_endian
#    define _is_fnegb(f) (*(byte *)&(f) >= 0x80)
#  else
#    define _is_fnegb(f) (((byte *)&(f))[sizeof(f) - 1] >= 0x80)
#  endif
#  if arch_sizeof_float == arch_sizeof_int
#    define is_fneg(f)\
       (sizeof(f) == sizeof(float) ? _f_as_int(f) < 0 :\
	_is_fnegb(f))
#  else
#    define is_fneg(f) _is_fnegb(f)
#  endif
#  undef is_fge1
#  if arch_sizeof_float == arch_sizeof_int
#    define is_fge1(f)\
       (sizeof(f) == sizeof(float) ?\
	(_f_as_int(f)) >= 0x3f800000 /* IEEE 1.0 */ :\
	(f) >= 1.0)
#  else			/* arch_sizeof_float == arch_sizeof_long */
#    define is_fge1(f)\
       (sizeof(f) == sizeof(float) ?\
	(int)(_f_as_int(f) >> 16) >= 0x3f80 :\
	(f) >= 1.0)
#  endif
# endif
#endif
