/*This is the second example program in EASYX.DOC.  The program is written
for Microsoft C.  The program should be linked with EASYX.LIB.  Borland C
users must change the second line below to:  #include <easyxb.h>, and should
link with EASYXB.LIB.*/

#include<stdio.h>
#include <string.h>
#include <easyx.h>

void main (void)
{
  int i;
  long errcode, nobytes, xaddress, xsize, handle, arrayaddress;
  int array[100];
  struct xfile fb;                 /*Declare file control block*/

  errcode = INITXLIB();            /*Initialize XLIB*/
  if(errcode != 0)
  {
    printf("Library initialization error:  %lX\n",errcode);
    return;
  }

  nobytes = 0x10000;               /*Allocate 64k of extended memory*/
  errcode = XMALLOC(nobytes,&xaddress,&xsize,&handle);
  if(errcode != 0)
  {
    printf("Extended memory allocation error:  %lX\n",errcode);
    return;
  }

  for(i = 0; i < 100; i++)         /*Put something in array[]*/
    array[i] = i;

  arrayaddress = LINADR(array);    /*Compute linear address of array[]*/

  fb.condcode = 0;                 /*Set control block to create file*/
  strcpy(fb.fname,"junk.dat");     /*Specify file name*/
  fb.blkadr = arrayaddress;        /*Will transfer array[] to the file*/
  fb.blksize = 200;                /*There are 200 bytes in array[]*/
  fb.bufsize = 0;                  /*Force XLIB to use its internal buffer*/
  XFSAVE(&fb);                     /*Create file and save array[] to it*/
  if(fb.condcode != 0)
  {
    printf("File save error:  %lX\n",fb.condcode);
    return;
  }

  XFOPEN(&fb);                     /*Reopen the file*/
  if(fb.condcode != 0)
  {
    printf("File open error:  %lX\n",fb.condcode);
    return;
  }

  fb.blkadr = xaddress;         /*Prepare to transfer the file to extended*/
  fb.blksize = 100;             /*Will transfer only 100 bytes*/
  fb.fptrmode = 0;              /*File pointer is relative to start of file*/
  fb.fptr = 100;                /*Set file pointer to 50th element*/
  XFREAD(&fb);                  /*Read last 50 elements to extended*/
  if(fb.condcode != 0)
  {
    printf("File read error:  %lX\n",fb.condcode);
    return;
  }

  MOVMEM(arrayaddress,xaddress,100); /*Transfer file contents back to array[]


  XFCLOSE(&fb);                      /*Close the file*/
  if(fb.condcode != 0)
  {
    printf("File close error:  %lX\n",fb.condcode);
    return;
  }

  errcode = XFREE(handle);           /*Release extended memory*/
  if(errcode != 0)
  {
    printf("Memory release error:  %lX\n",errcode);
    return;
  }
}
