/*
  NAME   The_Prn.C  Copyright 1992-94, Rob W. Smetana All Rights Reserved.
  ====
          C INCLUDE file for The Printer (a printer code database).

  PURPOSE
  =======

  An INCLUDE file providing the "field structure" of both Printer.Dat (large
  database) and Printer.Cfg (small configuration file saved by Printer.Exe).


  RECORD LAYOUT
  =============

  "Records" (for each printer) are 1024 bytes in length.  In the main
  database, there's 1 record for each printer (but see next paragraph).
  The "Printer.Cfg" file saved by Printer.Exe or Edit.Exe contains TWO
  1024 byte records.  The first contains labels, the 2nd contains
  printer codes.

  In The Printer's database, a printer may have 2 or more records if it
  can emulate 2 or more other printers.  In other words, each emulation
  is treated as a separate printer. The field "EmMode" tells you which
  printer is being emulated.

  ALL fields are STRINGS and all are 14 bytes long EXCEPT the first two:
     1, Reserved, is 1 byte   (reserved for our development)
     2, Printer Manufacturer, is 15 bytes


  PLACEHOLDERS:  ASCII character 251 ()
  ============

  Some printer codes require "variables."  For example, to specify, say
  3/48 inch line spacing (instead of the normal 6 lines per inch), you
  send a code like Chr$(27);"L03" (for a Toshiba printer).  In this case
  both "0" and "3" are variables.
   - The database would store this code as:  L
   - Escape is stored as ASCII character 27.
   - ASCII 251 () is simply a "placeholder" which YOU must replace
     with appropriate characters.

  You MUST replace the placeholder -- the printer code is meaningless
  otherwise.


  TWO TYPES
  =========

  Below are 2 TYPES you may use to read printer records.

   * These TYPES can be used to read either the large database itself
     (Printer.Dat) or the small config. file (Printer.Cfg) saved by
     Printer.Exe when you select a printer.

   * The first TYPE (PrnHeader) reads the 1st 44 bytes of records.
     Here you'll find the printer's Manufacturer, Model and Emulation mode.

   * The 2nd TYPE (ThePrn) will read/hold actual printer codes.


  NOTE:  By separating these, if you don't care about the header, you're
         not forced to keep it around.  Read it (with any 44-byte variable),
         throw it away, then read just the printer codes.
*/


typedef struct {

/* '=========== Start with a header (Printer manufacturer, model and emulation). */

  char reserved [1];                /* Reserved (for development) */

  char manufacturer [8];            /* eg., Epson, Panasonic, Star, etc. */


/* =========== All remaining fields are 14 bytes. */

   char model [14];                 /* Specific printer model (eg., LQ-510) */

   char emmode [14];                /* If not blank, this describes the */
                                    /* printer being emulated. */

                                    /* 44 bytes through here !!! */
}   PrnHeader;


typedef struct {

/*========== 70, 14-byte printer codes follow.

            The last few are blank, "expansion" fields for our
            use (if we add codes), or by you or your user.

            NOTE:  We may expand into these -- starting with the
            first.  If you're concerned that later we might collide
            with you, start your codes at the end, then move forward.
*/

char Initialize [14];             /* Reset to power-on mode (many printers */
                                  /* have no reset -- a shame). */

/* ...pitch/character sets/master attributes */

char pitch10ON [14];              /* Turn ON 10 characters-per-inch (CPI; Pica) */
char pitch12ON [14];              /* Turn ON 12 CPI (eg., Elite) */
char condensedON [14];            /* Turn ON Condensed mode (15-17 CPI) */
char condensedOFF [14];           /* Turn Condensed mode OFF */
char proportionalSpacing [14];    /* Turn ON Proportional Spacing */
char fixedspacing [14];           /* Turn ON Fixed Spacing */

char selectcharset [14];          /* Select Character Set (USA, French, etc.) */
char selectmasterfont [14];       /* Select Master Font (Roman, Prestige, etc.) */
char selectprintstyle [14];       /* Select Elite, Condensed, etc.    */
char draftmode [14];              /* Turn Draft Mode on (high speed)  */
char nearletterquality [14];      /* Turn on Near-Letter Quality mode */

/* ... Line spacing */

char linesperinch6 [14];          /* Turn on 6 lines-per-inch (LPI) */
char linesperinch8 [14];          /*   "  "  8    "   "   " */
char linesPerinch12 [14];         /*   "  "  12   "   "   " */

char variablelinespace [14];      /* Change line spacing (LPI) -- fine increments */
char altvariableline [14];        /* Alternate way to change line spacing */

/* ... Attributes/Emphasis/SuperScript/Etc */

char doublestrikeON [14];         /* Turn ON Double-Strike mode */
char doublestrikeOFF [14];        /*   "  OFF  "       "     "  */

char doublewideON [14];           /* Turn Double-Wide ON  */
char doublewideOFF [14];          /*   "    "     "   OFF */

char doubleheightON [14];         /* Turn Double-High ON  */
char doubleheightOFF [14];        /*   "    "     "   OFF */

char emphasizedON [14];           /* Turn Emphasized mode ON  */
char emphasizedOFF [14];          /*   "       "      "   OFF */

char boldON [14];                 /* Turn Bold mode ON  */
char boldOFF [14];                /*   "   "     "  OFF */

char underlineON [14];            /* Turn Underline mode ON  */
char underlineOFF [14];           /*   "       "     "   OFF */

char italicON [14];               /* Turn Italic mode ON  */
char italicOFF [14];              /*   "     "     "   OFF */

char superscriptON [14];          /* Superscript ON  */
char superscriptOFF [14];         /*     "       OFF */

char subscriptON [14];            /* Subscript ON  */
char subscriptOFF [14];           /*     "     OFF */

/* ... Other */

char skipperforationON [14];      /* Skip perforation zone */
char skipperforationOFF [14];     /* Turn OFF Skip perf.   */

char unidirectional [14];         /* Unidirectional print (for accuracy) */
char bidirectional [14];          /* Bidirectional print (for speed)     */

char pushcursor [14];             /* (LaserJet) Push (save) cursor position */
char popcursor [14];              /*      "     Pop  (restore) "       "    */

char pagelengthinches [14];       /* Set page length in INCHES */
char pagelengthlines [14];        /* Set page length in LINES  */

char settabstops [14];            /* Set Tab Stops */

char settopmargin [14];           /* Set Top Margin */
char setbottommargin [14];        /*  "  Bottom "   */
char setleftmargin [14];          /*  "  Left   "   */
char setrightmargin [14];         /*  "  Right  "   */


/* ... The next 4 codes let you move to vertical or horizontal locations,   */
/*     either in absolute terms (ie., a specific row/column) or relative to */
/*     where you are (ie., move 5 dots down). */

char absvertical [14];            /* Move vertically to a specific Row (or dot) */
char relvertical [14];            /* Move "y" rows/dots from where we are now */

char abshoriz [14];              /* Move horizontally to a column (or dot) */
char relhoriz [14];              /* Move "x" columns/dots from where we are */

char intercharspace [14];         /* Expand/shrink the spacing between */
                                  /* letters (some newer printers only) */


/* ... Expansion fields to give us, you or your users options to add codes. */

    char user1 [14];
    char user2 [14];
    char user3 [14];
    char user4 [14];
    char user5 [14];
    char user6 [14];
    char user7 [14];
    char user8 [14];
    char user9 [14];
   char user10 [14];
   char user11 [14];
   char user12 [14];
   char user13 [14];
   char user14 [14];
   char user15 [14];
   char user16 [14];
   char user17 [14];
                                       /* structure to 1024 bytes.*/
} ThePrn;

