{******************************************************************}
{   Source File: ZPASDEMO.PAS                                      }
{   Description: Pascal Source file to demonstrate Zip Studio      }
{   Date:        Wed Jul 13 17:06:53 1994                          }
{   Author:      Brad Stowers, CIS: 72733,3374                     }
{                              Internet: brad.stowers@delta.com    }
{******************************************************************}

program Zpasdemo;

{$R ZPASDEMO.RES}

uses
   WinProcs, WinTypes, Objects, OWindows, OMemory, ODialogs, Strings, BWCC,
   OStdDlgs, CommDlg, Zip, Unzip;

{$I ZPASDEMO.INC}
const
   AppName: PChar = 'ZPasDemo';

type

{--------------- Main Window Object ---------------}
  PZPasDemo = ^TZPasDemo;
  TZPasDemo = object(TApplication)
     procedure   InitMainWindow;                            virtual;
  end;

{--------------- Main Window of the application -------------------}
  PMainWindow = ^TMainWindow;
  TMainWindow = object(TDlgWindow)
    ZFStat,
    OpStat,
    MsgText,
    StatusBar: pStatic;
    ProcessingZip: boolean;
    ZipFile:   array [0..127] of char;
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    destructor Done; virtual;
    procedure GetWindowClass(var AWndClass: TWndClass);     virtual;
    function  GetClassName: PChar;                          virtual;

    procedure WMInitMenu(var Msg: tMessage);                virtual wm_First + wm_InitMenu;
    procedure WMClose(var Msg: tMessage);                   virtual wm_First + wm_Close;

    procedure SelectZipFile(var Msg: TMessage);             virtual cm_First + cm_Select;
    procedure Zip(var Msg: TMessage);                       virtual cm_First + cm_Zip;
    procedure Unzip(var Msg: TMessage);                     virtual cm_First + cm_Unzip;
    procedure ExitDemo(var Msg: TMessage);                  virtual cm_First + cm_Exit;
    procedure AboutZDemo(var Msg: TMessage);                virtual cm_First + cm_About;

    { Notification messages from unzip process }
		procedure ZNOpenFile(var Msg: TMessage);                virtual wm_First + ZN_OPENFILE;
		procedure ZNExpanding(var Msg: TMessage);               virtual wm_First + ZN_EXPANDING;
		procedure ZNCloseFile(var Msg: TMessage);               virtual wm_First + ZN_CLOSEFILE;

    { Notification messages from zip process }
    procedure ZNZipping(var Msg: TMessage);                 virtual wm_First + ZN_ZIPPING;
    procedure ZNFileZipped(var Msg: TMessage);              virtual wm_First + ZN_FILEZIPPED;
    procedure ZNWriting(var Msg: TMessage);                 virtual wm_First + ZN_WRITING;
    procedure ZNCompute(var Msg: TMessage);                 virtual wm_First + ZN_COMPUTE;
  end;



constructor TMainWindow.Init(AParent: PWindowsObject; ATitle: PChar);
var
  p: pWindowsObject;
begin
  inherited Init(AParent, ATitle);
  ZFStat   := New(pStatic, InitResource(@Self, id_ZipFile, 127));
  OpStat   := New(pStatic, InitResource(@Self, id_Operation, 127));
  MsgText  := New(pStatic, InitResource(@Self, id_MsgText, 511));
  StatusBar:= New(pStatic, InitResource(@Self, id_StatusBar, 127));
  ZipFile[0] := #0;
  UnzipInit('TEST', '');
  ZipInit('TEST', '');
  ProcessingZip := False;
end;


destructor TMainWindow.Done;
begin
  inherited Done;
end;


function TMainWindow.GetClassName : PChar;
begin
  GetClassName := 'BORDLGZPASDEMO';
end;


procedure TMainWindow.GetWindowClass(var AWndClass: TWndClass);
begin
  inherited GetWindowClass(AWndClass);
  AWndClass.hIcon := LoadIcon(hInstance, pChar(icoMain));
end;


procedure TMainWIndow.WMInitMenu(var Msg: tMessage);
begin
  if ProcessingZip then begin
    EnableMenuItem(hMenu(Msg.wParam), cm_Select, MF_BYCOMMAND or MF_GRAYED);
    EnableMenuItem(hMenu(Msg.wParam), cm_Zip, MF_BYCOMMAND or MF_GRAYED);
    EnableMenuItem(hMenu(Msg.wParam), cm_Unzip, MF_BYCOMMAND or MF_GRAYED);
    EnableMenuItem(hMenu(Msg.wParam), cm_Exit, MF_BYCOMMAND or MF_GRAYED);
  end else begin
    EnableMenuItem(hMenu(Msg.wParam), cm_Select, MF_BYCOMMAND or MF_ENABLED);
    EnableMenuItem(hMenu(Msg.wParam), cm_Zip, MF_BYCOMMAND or MF_ENABLED);
    EnableMenuItem(hMenu(Msg.wParam), cm_Unzip, MF_BYCOMMAND or MF_ENABLED);
    EnableMenuItem(hMenu(Msg.wParam), cm_Exit, MF_BYCOMMAND or MF_ENABLED);
  end;
end;


procedure TMainWindow.WMClose(var Msg: tMessage);
begin
  { We disabled the exit menu item if processing, but we still have to stop Alt-F4 }
  if ProcessingZip then begin
    MessageBox(hWindow, 'Currently processing a ZIP file, can''t shut down!', 'Zip Studio', MB_OK);
    Msg.Result := 0;
  end else
    inherited CloseWindow;
end;


procedure TMainWindow.SelectZipFile(var Msg: TMessage);
  function StrReplace(Dest: pChar; Orig, Rep: char): pChar;
  var
    Found: pChar;
  begin
    Found := StrScan(Dest, Orig);
    while assigned(Found) do begin
      Found[0] := Rep;
      inc(Found);
      Found := StrScan(Found, Orig);
    end;
    StrReplace := Dest;
  end;
const
  Filter: pChar = 'ZIP Files|*.ZIP|All Files|*.*||';
var
  OpenInfo: pOpenFileName;
  Path:     array [0..100] of char;
  Buff:     array [0..127] of char;
  Slash:    pChar;
begin
  new(OpenInfo);
  Buff[0] := #0;
  StrReplace(Filter, '|', #0);
  StrLCopy(Path, ZipFile, SizeOf(Path)-1);
  Slash := StrRScan(Path, '\');
  if assigned(Slash) then
    Slash[0] := #0;
  with OpenInfo^ do begin
    lStructSize := SizeOf(tOpenFileName);
    hWndOwner := hWindow;
    hInstance := 0;
    lpstrFilter := Filter;
    lpstrCustomFilter := nil;
    nMaxCustFilter := 0;
    nFilterIndex := 1;
    lpstrFile := @Buff;
    nMaxFile := SizeOf(Buff)-1;
    lpstrFileTitle := nil;
    nMaxFileTitle := 0;
    lpstrInitialDir := @Path;
    lpstrTitle := 'Select ZIP File';
    Flags := OFN_HIDEREADONLY;
    lpstrDefExt := 'ZIP';
    lCustData := 0;
    lpfnHook := nil;
    lpTemplateName := nil;
  end;

  if GetOpenFileName(OpenInfo^) then begin
    StrCopy(ZIPFile, Buff);
    ZFStat^.SetText(ZIPFile);
  end;

  dispose(OpenInfo);
end;


procedure TMainWindow.Zip(var Msg: TMessage);
var
  Input: pInputDialog;
  FileSpec: array[0..255] of char;
  Result: integer;
begin
  StrCopy(FileSpec, '*.*');
  if Application^.ExecDialog(New(pInputDialog, Init(@Self, 'Zip Studio',
                            'Enter file to add to the zip file (wildcards OK):',
                            FileSpec, SizeOf(FileSpec)-1))) <> idOK then exit;
  ProcessingZip := TRUE;
  Result := AddFileToZip(ZIPFile, FileSpec, OVERWRITE_PROMPT, STOREPATH_NO, RECURSE_NO, hWindow);
  ProcessingZip := FALSE;
  case Result of
    ZERROR_WARNING:
      begin
        OpStat^.SetText('Done ( but warnings )');
        MsgText^.SetText('Ok, but warnings');
      end;
    ZERROR_DESTFILE:
      begin
        OpStat^.SetText('File error');
        MsgText^.SetText('Source file or ZIP file maybe dammaged!');
      end;
    ZERROR_INTERNAL:
      begin
        OpStat^.SetText('Internal error');
        MsgText^.SetText('Internal error.  Maybe Zip file not generated!');
      end;
    ZERROR_FORMAT:
      begin
        OpStat^.SetText('Not a zip file');
        MsgText^.SetText('Not a zip file.\nMaybe zip file corrupted!');
      end;
    ZERROR_NOMEM:
      begin
        OpStat^.SetText('Not enough memory');
        MsgText^.SetText('Not enough memory to zip!  Serious error!  Please use a smaller ZIP file!');
      end;
    ZERROR_NOFILE:
      begin
        OpStat^.SetText('No file or nothing to do!');
        MsgText^.SetText('No file or nothing to do!');
      end;
    ZERROR_NODLL:
      begin
        OpStat^.SetText('Can''t find ZDLL12B.DLL');
        MsgText^.SetText('Please put ZDLL12B.DLL in your current directory.  Maybe this DLL is corrupted.');
      end;
  else
    OpStat^.SetText('Done');
    MsgText^.SetText('Ok');
  end;
  StatusBar^.SetText('Ready');
end;


procedure TMainWindow.Unzip(var Msg: TMessage);
var
  Result: word;
begin
  UnzipSetReceivingWindow(hWindow);               { to receive all notification messages during unzipping }
  UnzipSetBackgroundMode(TRUE);                   { to activate the multitask mode }
  ProcessingZip := TRUE;
  Result := ExtractZipFiles(ZipFile, '*.*', '',   { DestDir is always WINDOWS\TEST }
                            OVERWRITE_QUERY, CREATEDIR_FALSE);
  ProcessingZip := FALSE;
  { Depending on the result, we set the text in the main window }
  case Result of
    ZEXTRACT_INTERNALERROR:
      begin
        OpStat^.SetText('Internal Error');
        MsgText^.SetText('Internal error.  All files may not have been extraced!');
      end;
    ZEXTRACT_FILENOTFOUND:
      begin
        OpStat^.SetText('File not found');
        MsgText^.SetText('Source file missing.  Please choose existing file to unzip!');
      end;
    ZEXTRACT_CORRUPTED:
       begin
        OpStat^.SetText('Zip file format error');
        MsgText^.SetText('Zip file format error.  Zip file may be damaged!');
      end;
   ZEXTRACT_EMPTY:
      begin
        OpStat^.SetText('Nothing to do');
        MsgText^.SetText('Nothing to do: No files!');
      end;
    ZEXTRACT_ERRORINZIPFILE:
      begin
        OpStat^.SetText('Fatal error');
        MsgText^.SetText('Fatal error!  Zip file may be corrupted!');
      end;
  else
    OpStat^.SetText('Unzipping is done');
    MsgText^.SetText('Ok');
  end;
  StatusBar^.SetText('Ready');
end;


procedure TMainWindow.ExitDemo(var Msg: TMessage);
begin
  CloseWindow;
end;


procedure TMainWindow.AboutZDemo(var Msg: TMessage);
begin
  Application^.ExecDialog(New(pDialog, Init(@Self, pChar(dlgAbout))));
end;



{ Notification messages from Unzip }

procedure TMainWindow.ZNOpenFile(var Msg: TMessage);
var
  MsgBuf: array[0..255] of char;
  Args: record
    Str1,
    Str2: pChar;
  end;
begin
  with Msg do
    if wParam <> 0 then begin
      Args.Str1 := pChar(lParam);
      Args.Str2 := ZIPFile;
      WVSPrintF(MsgBuf, '%s from %s is opened.', Args);
      MsgText^.SetText(MsgBuf);

      WVSPrintF(MsgBuf, '%s successfully opened.', pChar(lParam));
      OpStat^.SetText(MsgBuf);

      StatusBar^.SetText(MsgBuf);
    end else begin
      WVSPrintF(MsgBuf, 'Can''t open %s', pChar(lParam));
      MessageBox(hWindow, MsgBuf, 'Zip Studio', MB_OK or MB_ICONSTOP);
      OpStat^.SetText('Fatal error!');
      MsgText^.SetText('Fatal error!');
      StatusBar^.SetText('Fatal error!');
    end;
end;

procedure TMainWindow.ZNExpanding(var Msg: TMessage);
var
  MsgBuf: array[0..255] of char;
  Args: record
    Str:  pChar;
    Wrd: Word;
  end;
  Args2: record
    Str1,
    Str2: pChar;
  end;
begin
  with Msg do begin
    Args.Str := pChar(lParam);
    Args.Wrd := wParam;
		WVSPrintF(MsgBuf, '%s is in process.- %i %% filled.', Args);
    OpStat^.SetText(MsgBuf);
    if wParam < 4 then begin { at the beginning }
      Args2.Str1 := pChar(lParam);
      Args2.Str2 := ZIPFile;
      WVSPrintF(MsgBuf, '%s from %s is unzipping...', Args2);
      MsgText^.SetText(MsgBuf);
      StatusBar^.SetText('Unzipping...');
    end;
  end;
end;

procedure TMainWindow.ZNCloseFile(var Msg: TMessage);
var
  MsgBuf: array[0..255] of char;
  Args: record
    Str1,
    Str2: pChar;
  end;
begin
  with Msg do
    if wParam <> 0 then begin
      Args.Str1 := pChar(lParam);
      Args.Str2 := ZIPFile;
      WVSPrintF(MsgBuf, '%s from %s successfully unzipped.', Args);
      MsgText^.SetText(MsgBuf);

      WVSPrintF(MsgBuf, '%s successfully unzipped.', pChar(lParam));
      OpStat^.SetText(MsgBuf);

      StatusBar^.SetText(MsgBuf);
    end else begin
      WVSPrintF(MsgBuf, 'Can''t unzip %s!', pChar(lParam));
      MessageBox(hWindow, MsgBuf, 'Zip Studio', MB_OK or MB_ICONSTOP);
      OpStat^.SetText('Fatal error!');
      MsgText^.SetText('Fatal error!');
      StatusBar^.SetText('Fatal error!');
    end;
end;


procedure TMainWindow.ZNZipping(var Msg: TMessage);
var
  CheckBuf,
  MsgBuf: array[0..255] of char;
begin
  with Msg do begin
    { We get a lot of these messages and it causes 'flicker'.  We'll get the existing }
    { string and see if it is the same first.  We'll take a performance hit for it,   }
    { but it sure does look better.  If you want to see the difference it makes, put  }
    { the conditional define 'WITHFLICKER' in you compiler options.                   }
    WVSPrintF(MsgBuf, 'Compressed size: %i k.', wParam);
    {$IFNDEF WITHFLICKER}
    OpStat^.GetText(CheckBuf, SizeOf(CheckBuf)-1);
    if StrComp(MsgBuf, CheckBuf) = 0 then exit;  { Doesn't need changing, we're done  }
    {$ENDIF}
    OpStat^.SetText(MsgBuf);
    if wParam < 4 then begin
      WVSPrintF(MsgBuf, '%s in process!', pChar(lParam));
      {$IFNDEF WITHFLICKER}
      MsgText^.GetText(CheckBuf, SizeOf(CheckBuf)-1);
      if StrComp(MsgBuf, CheckBuf) = 0 then exit;  { Doesn't need changing, we're done  }
      {$ENDIF}
      StatusBar^.SetText(MsgBuf);
    end;
  end;
end;


procedure TMainWindow.ZNFileZipped(var Msg: TMessage);
var
  MsgBuf: array[0..255] of char;
  Args: record
    Str:  pChar;
    Wrd: Word;
  end;
  Arg2: record
    Str1,
    Str2:  pChar;
    Wrd: Word;
  end;
begin
  with Msg do begin
    WVSPrintF(MsgBuf, 'The file %s is zipped!', pChar(lParam));
    StatusBar^.SetText(MsgBuf);
    WVSPrintF(MsgBuf, '%s zipped', pChar(lParam));
    OpStat^.SetText(MsgBuf);
    Arg2.Str1 := pChar(lParam);
    Arg2.Str2 := ZIPFile;
    Arg2.Wrd  := wParam;
    WVSPrintF(MsgBuf, '%s is successfully added to %s.  Compression rate is %i %%.', Arg2);
    MsgText^.SetText(MsgBuf);
  end;
end;


procedure TMainWindow.ZNWriting(var Msg: TMessage);
var
  MsgBuf: array[0..255] of char;
begin
  with Msg do begin
    WVSPrintF(MsgBuf, '%s successfully zipped!  Please wait...', pChar(lParam));
    StatusBar^.SetText(MsgBuf);
    WVSPrintF(MsgBuf, '%s zipped', pChar(lParam));
    OpStat^.SetText(MsgBuf);
    MsgText^.SetText(MsgBuf);
  end;
end;


procedure TMainWindow.ZNCompute(var Msg: TMessage);
var
  MsgBuf: array[0..255] of char;
  Args: record
    Str:  pChar;
    Wrd: Word;
  end;
begin
  with Msg do begin
    Args.Str := ZIPFile;
    Args.Wrd := wParam;
    WVSPrintF(MsgBuf, '%s contains %i files.', Args);
    OpStat^.SetText(MsgBuf);
    MsgText^.SetText(MsgBuf);
    StatusBar^.SetText(MsgBuf);
    if wParam > 500 then
      if wParam > 1000 then
        MessageBox(hWindow, 'There are many files in this ZIP file.  Computing this file will require a few minutes.',
                   'Zip Studio', MB_ICONEXCLAMATION or MB_OK)
      else
        MessageBox(hWindow, 'There are many files in this ZIP file.  Computing this file will require a few seconds.',
                   'Zip Studio', MB_ICONEXCLAMATION or MB_OK);
  end;
end;


{ Create the application's main window }
procedure TZPasDemo.InitMainWindow;
begin
  MainWindow := New(PMainWindow, Init(nil, pChar(dlgMain)));
end;

var
  MainApp: TZPasDemo;

begin
   MainApp.Init('ZPasDemo');
   MainApp.Run;
   MainApp.Done;
end.
