{
Accelerator keys for the XView-PC interface
By Antonio Carlos Moreirao de Queiroz - acmq@coe.ufrj.br
Version 1.0 - 10/04/94

This procedure implements a system of "accelerator keys" using the
"interposer". The mouse will move to the center of the first object
in the screen that has in its "xv_label" the letter pressed along
with the "Alt" key, in upper case. The selected window becomes the
active window. Buttons are pressed, textfields put in edition mode,
and menus are opened.
To install:
Include this file, and insert after "xv_init": interposer:=HotKeys;
The program must use the units Mickey and XView.
}

{$I extkeys.inc}

{$F+}

PROCEDURE HotKeys;
VAR
  ptw,pto:Xv_opaque;
  found:BOOLEAN;
  pt:INTEGER;
CONST
  table:ARRAY[0..35] OF INTEGER=(
    kAltA,kAltB,kAltC,kAltD,KAltE,
    kAltF,kAltG,kAltH,kAltI,kAltJ,
    kAltK,kAltL,kAltM,kAltN,kAltO,
    kAltP,kAltQ,kAltR,kAltS,kAltT,
    kAltU,kAltV,kAltW,kAltX,kAltY,kAltZ,
    kAlt0,kAlt1,kAlt2,kAlt3,kAlt4,
    kAlt5,kAlt6,kAlt7,kAlt8,kAlt9
  );

BEGIN
  IF (ie_code>2000) THEN BEGIN
    pt:=0; found:=FALSE;
    REPEAT
      IF table[pt]=ie_code THEN found:=TRUE
      ELSE inc(pt)
    UNTIL found or (pt>35);
    IF not found THEN Exit;
    IF pt>25 THEN inc(pt,Ord('0')-26) ELSE inc(pt,Ord('A'));
    found:=FALSE;
    ptw:=active_w;
    REPEAT
      pto:=ptw;
      REPEAT
        IF pos(Chr(pt),pto^.xv_label)<>0 THEN found:=TRUE
        ELSE pto:=pto^.next
      UNTIL found or (pto=nil);
      IF not found THEN ptw:=ptw^.under;
    UNTIL found or (ptw=active_w);
    IF found THEN BEGIN
      cursor_off;
      open_window(ptw);
      IF pto^.o_type=frame THEN BEGIN
        mousex:=ptw^.x+ptw^.dx div 2;
        mousey:=ptw^.y+mrgy div 2;
      END
      ELSE BEGIN
        mousex:=ptw^.x+mrgx+pto^.x+pto^.dx div 2;
        mousey:=ptw^.y+mrgy+pto^.y+pto^.dy div 2;
      END;
      mouse_move(mousex,mousey);
      IF pto^.menu_name<>nil THEN menu_show(pto^.menu_name);
      IF (pto^.o_type=button) or (pto^.o_type=textfield) THEN ie_code:=MS_LEFT;
    END
  END
END;

{$F-}
