{ͻ
                                                                           
                    XLIB v2.0 for BORLAND/TURBO PASCAL 7.0                 
                 Tristan Tarrant ( tristant@cogs.susx.ac.uk )              
                                                                           
 ͹
  Credits :                                                                
    Michael Abrash - Concept and Algorithms                                
    Themie Gouthas - Original code                                         
    Michael McKenzie - Lots of code                                        
    Tore Bastiansen - Virtual VSync code                                   
 ͼ}

{$A+,B-,E-,G+,N-,O-,P-,Q-,S-,T-,X+}

{$IFDEF DPMI}
{$C FIXED PRELOAD PERMANENT}
{$ENDIF}

Unit XLib2;

Interface

Type
	Vertex = record
		x, y : word;
	end;
	VBMInfoStruc = record
		Size, ImageWidth, ImageHeight : word;
	end;
	VBMAlignmentStruc = record
		ImagePtr, MaskPtr : word;
	end;
	AlignmentHeader = record
		size, ImageWidth, ImageHeight : word;
		alignments : array[0..3] of
		record
			 ImagePtr, MaskPtr : word;
		end;
	end;
	LBMHeader = record
		width, height : byte;
	end;
	PAlignmentHeader = ^AlignmentHeader;

Const
	XMode320x200  = 0;
	XMode320x240  = 1;
	XMode360x200  = 2;
	XMode360x240  = 3;
	XMode376x282  = 4;
	XMode320x400  = 5;
	XMode320x480  = 6;
	XMode360x400  = 7;
	XMode360x480  = 8;
	XMode360x360  = 9;
	XMode376x308  = 10;
	XMode376x564  = 11;
	XMode256x200  = 12;
	XMode256x240  = 13;
	XMode256x224  = 14;
	XMode256x256  = 15;
	XMode360x270  = 16;
	XMode400x300  = 17;

	LastMode      = 17;

	RBackward     = 0;
	RForward      = 1;
	InvalidXMode  = -1;
	Error         = 1;
	AlignData     = 6;
	LeftPressed   = 1;
	RightPressed  = 2;

	X320Y200 : array[0..4] of word =
		( $0200, $0014, $E317, 320, 200 );
	X320Y240 : array[0..12] of word =
		( $0AE3, $0D06, $3E07, $4109, $EA10, $AC11, $DF12, $0014, $E715, $0616,
				$E317, 320, 240 );
	X360Y200 : array[0..10] of word =
		( $08E7, $6B00, $5901, $5A02, $8E03, $5E04, $8A05, $0014, $E317, 360,
				200 );
	X360Y240 : array[0..19] of word =
		( $11E7, $6b00, $5901, $5A02, $8E03, $5E04, $8A05, $0D06, $3E07, $4109,
				$EA10, $AC11, $DF12, $2D13, $0014, $E715, $0616, $E317, 360, 240 );
	X376Y282 : array[0..20] of word =
		( $12E7, $6e00, $5d01, $5e02, $9103, $6204, $8f05, $6206, $f007, $6109,
				$310f, $3710, $8911, $3312, $2f13, $0014, $3C15, $5C16, $e317, 376,
				282 );
	X256Y400 : array[0..11] of word  =
		( $08E3, $5f00, $3f01, $4202, $9f03, $4c04, $0005, $4009, $0014, $E317,
				256, 400 );
	X256Y480 : array[0..18] of word =
		( $10e3, $5f00, $3f01, $4202, $9f03, $4c04, $0005, $0d06, $3e07, $4009,
				$ea10, $ac11, $df12, $0014, $e715, $0616, $e317, 256, 480 );
	X320Y400 : array[0..5] of word =
		( $03e3, $4009, $0014, $e317, 320, 400 );
	X320Y480 : array[0..12] of word =
		( $0AE3, $0D06, $3E07, $4009, $EA10, $AC11, $DF12, $0014, $E715, $0616,
				$E317, 320, 480 );
	X360Y400 : array[0..11] of word =
		( $09E7, $6B00, $5901, $5A02, $8E03, $5E04, $8A05, $4009, $0014, $E317,
				360, 400 );
	X360Y480 : array[0..19] of word =
		( $11E7, $6B00, $5901, $5A02, $8E03, $5E04, $8A05, $0D06, $3E07, $4009,
				$EA10, $AC11, $DF12, $2D13, $0014, $E715, $0616, $E317, 360, 480 );
	X360Y360 : array[0..17] of word =
		( $0FE7, $6b00, $5901, $5A02, $8E03, $5E04, $8A05, $4009, $8810, $8511,
				$6712, $2D13, $0014, $6D15, $BA16, $E317, 360, 360 );
	X376Y308 : array[0..20] of word =
		( $12E7, $6E00, $5D01, $5E02, $9103, $6204, $8F05, $6206, $0F07, $4009,
				$310F, $3710, $8911, $3312, $2F13, $0014, $3C15, $5C16, $E317, 376,
				308 );
	X376Y564 : array[0..20] of word =
		( $12E7, $6E00, $5D01, $5E02, $9103, $06204, $8F05, $6206, $F007, $6109,
				$310F, $3710, $8911, $3312, $2F13, $0014, $3C15, $5C16, $E317, 376,
				564 );
	X256Y200 : array[0..10] of word =
		( $08e3, $5f00, $3f01, $4202, $9f03, $4c04, $0005, $0014, $e317, 256,
				200 );
	X256Y240 : array[0..18] of word =
		( $10e3, $5f00, $3f01, $4202, $9f03, $4c04, $0005, $0d06, $3e07, $4109,
				$ea10, $ac11, $df12, $0014, $e715, $0616, $e317, 256, 240 );
	X256Y224 : array[0..20] of word =
		( $12e3, $5f00, $3f01, $4202, $8203, $4a04, $9a05, $0b06, $3e07, $0008,
				$4109, $da10, $9c11, $bf12, $2013, $0014, $c715, $0416, $e317, 256,
				224 );
	X256Y256 : array[0..20] of word =
		( $12e3, $5f00, $3f01, $4002, $8203, $4a04, $9a05, $2306, $b207, $0008,
			$6109, $0a10, $ac11, $ff12, $2013, $0014, $0715, $1a16, $e317, 256,
			256 );
	X360Y270 : array[0..20] of word =
		( $12e7, $6b00, $5901, $5a02, $8e03, $5e04, $8a05, $3006, $f007, $0008,
			$6109, $2010, $a911, $1b12, $2d13, $0014, $1f15, $2f16, $e317, 360,
			270 );
	X400Y300 : array[0..20] of word =
		( $12a7, $7100, $6301, $6402, $9203, $6504, $8205, $4606, $1f07, $0008,
			$4009, $3110, $8011, $2b12, $3213, $0014, $2f15, $4416, $e317, 400,
			300 );

	ModeTable : array[0..17] of word =
		( Ofs(X320Y200[0]), Ofs(X320Y240[0]), Ofs(X360Y200[0]), Ofs(X360Y240[0]),
			Ofs(X376Y282[0]), Ofs(X320Y400[0]), Ofs(X320Y480[0]), Ofs(X360Y400[0]),
			Ofs(X360Y480[0]), Ofs(X360Y360[0]), Ofs(X376Y308[0]), Ofs(X376Y564[0]),
			Ofs(X256Y200[0]), Ofs(X256Y240[0]), Ofs(X256Y224[0]), Ofs(X256Y256[0]),
			Ofs(X360Y270[0]), Ofs(X400Y300[0]) );

	MirrorTable : array[0..255] of byte =
		( 0,128, 64,192, 32,160, 96,224, 16,144, 80,208, 48,176,112,240,
			8,136, 72,200, 40,168,104,232, 24,152, 88,216, 56,184,120,248,
			4,132, 68,196, 36,164,100,228, 20,148, 84,212, 52,180,116,244,
		 12,140, 76,204, 44,172,108,236, 28,156, 92,220, 60,188,124,252,
			2,130, 66,194, 34,162, 98,226, 18,146, 82,210, 50,178,114,242,
		 10,138, 74,202, 42,170,106,234, 26,154, 90,218, 58,186,122,250,
			6,134, 70,198, 38,166,102,230, 22,150, 86,214, 54,182,118,246,
		 14,142, 78,206, 46,174,110,238, 30,158, 94,222, 62,190,126,254,
			1,129, 65,193, 33,161, 97,225, 17,145, 81,209, 49,177,113,241,
			9,137, 73,201, 41,169,105,233, 25,153, 89,217, 57,185,121,249,
			5,133, 69,197, 37,165,101,229, 21,149, 85,213, 53,181,117,245,
		 13,141, 77,205, 45,173,109,237, 29,157, 93,221, 61,189,125,253,
			3,131, 67,195, 35,163, 99,227, 19,147, 83,211, 51,179,115,243,
		 11,139, 75,203, 43,171,107,235, 27,155, 91,219, 59,187,123,251,
			7,135, 71,199, 39,167,103,231, 23,151, 87,215, 55,183,119,247,
		 15,143, 79,207, 47,175,111,239, 31,159, 95,223, 63,191,127,255 );

	PelPanMask : array[0..3] of byte =
		( 0, 2, 4, 6 );
	LeftClipPlaneMask  : array[0..3] of byte =
		( $0F, $0E, $0C, $08 );
	RightClipPlaneMask : array[0..3] of byte =
		( $0F, $01, $03, $07 );
	ColumnMask : array[0..3] of byte =
		( $11, $22, $44, $88 );
	LeftMaskTable : array[0..8] of byte =
		( 0, $ff, $ee, 0, $cc, 0, 0, 0, $88 );
	RightMaskTable: array[0..8] of byte =
		( 0, $11, $33, 0, $77, 0, 0, 0, $ff );
	InitMouseDef : array[0..13] of byte =
		(1,3,7,15,31,63,127,255,31,27,48,48,96,96);
	LeftDelay : array[0..3] of byte =
		( 0, 1, 2, 4 );
	RightDelay : array[0..3] of byte =
		( 0, 4, 2, 1 );
	PS2Cards : array[0..12] of byte = ( 0,1,2,2,4,3,2,5,6,2,8,7,8 );

	WhenToDraw : array[0..31] of byte = ( 0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3,
			2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5 );

Var
	InGraphics,
	ErrorValue,
	FontDriverActive,
	CharHeight,
	CharWidth,
	FirstChar,
	UserChHeight,
	UserChWidth,
	UserFirstCh,
	DoubleScanFlag : Byte;
	CurrXMode,
	ScrnPhysicalByteWidth,
	ScrnPhysicalPixelWidth,
	ScrnPhysicalHeight,
	SplitScrnOffs,
	SplitScrnScanLine,
	SplitScrnVisibleHeight,
	SplitScrnActive,
	Page0Offs,
	Page1Offs,
	Page2Offs,
	ScrnLogicalByteWidth,
	ScrnLogicalPixelWidth,
	ScrnLogicalHeight,
	MaxScrollX,
	MaxScrollY,
	DoubleBufferActive,
	TripleBufferActive,
	VisiblePageIdx,
	HiddenPageOffs,
	VisiblePageOffs,
	WaitingPageOffs,
	NonVisualOffs,
	TopClip,
	BottomClip,
	LeftClip,
	RightClip,
	PhysicalStartPixelX,
	PhysicalStartByteX,
	PhysicalStartY,
	VsyncHandlerActive,
	MouseRefreshFlag,
	StartAddressFlag,
	WaitingStartLow,
	WaitingStartHigh,
	WaitingPelPan,
	VsyncPaletteStart,
	VsyncPaletteCount,
	MirrorTableOffs,
	MouseInstalled,
	MouseHidden,
	MouseButtonStatus,
	MouseButtonCount,
	MouseX,
	MouseY,
	BGSaveOffs,
	TopBound,
	BottomBound,
	LeftBound,
	RightBound,
	MouseVersion,
	ScreenSeg, 
	Seg0000,
	SelectorInc: word;
	MouseFrozen,
	MouseColor,
	MouseType,
	MouseIRQ,
	inhandler : byte;
	FontPtr,
	UserFontPtr,
	F8x8Ptr,
	F8x14Ptr, 
	OldTimerIntVar : pointer;
	MouseMask : array[0..167] of byte;
	VSyncPaletteBuffer : array[0..767] of byte;

Function  XSetMode( Mode, WidthInPixels : Word ) : Word;
Procedure XSelectDefaultPlane( Plane : Byte );
Procedure XSetSplitscreen( Line : Word );
Procedure XSetStartAddr( X, Y : Word );
Procedure XHideSplitscreen;
Procedure XShowSplitscreen;
Procedure XAdjustSplitscreen( Line : Word );
Procedure XSetDoubleBuffer( PageHeight : Word );
Procedure XSetTripleBuffer( PageHeight : word );
Procedure XPageFlip( X, Y : Word );
Procedure XSetClipRect( Left, Top, Right, Bottom : Word );
Procedure XTextMode;
Procedure XWaitVsync;
Procedure XLine( x1, y1, x2, y2, Color, PgOffs : word );
Procedure XPutPix( X,Y,PgOfs,Color:word );
Function  XGetPix( x,y,PageBase:word ) : word;
Procedure XRectFill( StartX,StartY,EndX,EndY,PageBase,Color:word );
Procedure XRectPattern( StartX,StartY,EndX,EndY,PageBase:word; var Pattern);
Procedure XCpVidPage( SourceOffs, DestOffs : word );
Procedure XCpVidRect( SrcStartX,SrcStartY,SrcEndX,SrcEndY,DestStartX,
											DestStartY,SrcPageBase,DestPageBase,SrcBitmapW,
											DestBitmapW:word );
Procedure XShiftRect( SrcLeft,SrcTop,SrcRight,SrcBottom,DestLeft,DestTop,
											ScreenOffs:word );
Procedure XCircle( Left, Top, Diameter, Color, ScreenOffs:word );
Procedure XFilledCircle( Left, Top, Diameter, Color, ScreenOffs:word );
Procedure XGetPalStruc( var PalBuff; NumColors,StartColor:word );
Procedure XGetPalRaw( Var PalBuff; NumColors,StartColor:word );
Procedure XPutPalStruc( Var CompPalBuff );
Procedure XTransposePalStruc( Var CompPalBuff; StartColor:word );
Procedure XPutPalRaw( Var PalBuff; NumColors,StartColor:word );
Procedure XSetRGB( ColorIndex,R,G,B:byte );
Procedure XRotPalStruc( Var PalBuff; Direction:word );
Procedure XRotPalRaw( Var PalBuff; Direction, NumColors:word );
Function  XCpContrastPalStruc( Var PalSrcBuff,PalDestBuff; Intensity:byte ) : word;
Procedure XPutContrastPalStruc( Var CompPalBuff; Intensity:byte );
Function  XCharPut( Chr:char; X, Y, ScrnOffs, Color:word ) : byte;
Procedure XSetFont( FontID : word );
Procedure XTextInit;
Procedure XRegisterUserFont( var FontToRegister );
Function  XGetCharWidth( ch : char ) : byte;
Function  XPrintf( x, y, ScrnOffs, Color : word; s : string ) : integer;
Function  XBgPrintf( x, y, ScrnOffs, fgcolor, bgcolor : word; s : string ) : integer;
Function  XCentre( x, y, ScrnOffs, color : word; s : string ) : integer;
Function  XBgCentre( x, y, ScrnOffs, fgcolor, bgcolor : word; s : string ) : integer;
function  XStrWidth( s : string ) : integer;
Procedure XTriangle( X0, Y0, X1, Y1, X2, Y2, Color, PageOffset:word );
Procedure XPolygon( var vertices; numvertices, Color, PageOffset:word );
Procedure XPutCursor( X, Y, TopClip, BottomClip, ScrnOffs : word );
Procedure XDefineMouseCursor( var MouseDef; MouseColor:byte );
procedure XMouseInit;
Procedure XMouseWindow( x0, y0, x1, y1:word );
procedure XShowMouse;
Procedure XHideMouse;
Procedure XMouseRemove;
Procedure XPositionMouse( X, Y : word );
Procedure XUpdateMouse;
Function  XFloodFill( X, Y, PgOfs, Color:word ) : word;
Function  XBoundaryFill( X, Y, PgOfs, BoundaryColor, Color : word ) : word;
Procedure XInstallVSyncHandler( VrtsToSkip : word );
Procedure XRemoveVSyncHandler;
Procedure XSetUserVSyncHandler;

Implementation

{$IFDEF DPMI}
{$L XLIB2.OBP}
procedure __a000h; far; external 'KERNEL' index $00AE;
procedure __c000h; far; external 'KERNEL' index $00C3;
procedure __AHIncr; far;        external 'KERNEL' index $0072;
procedure __0000h; far; external 'KERNEL' index $00B7;
{$ELSE}
{$L XLIB2.OBJ}
{$ENDIF}

Function  XSetMode( Mode, WidthInPixels : Word ) : Word; external;
Procedure XSelectDefaultPlane( Plane : Byte ); external;
Procedure XSetSplitscreen( Line : Word ); external;
Procedure XSetStartAddr( X, Y : Word ); external;
Procedure XHideSplitscreen; external;
Procedure XShowSplitscreen; external;
Procedure XAdjustSplitscreen( Line : Word ); external;
Procedure XSetDoubleBuffer( PageHeight : Word ); external;
Procedure XSetTripleBuffer( PageHeight : word ); external;
Procedure XPageFlip( X, Y : Word ); external;
Procedure XSetClipRect( Left, Top, Right, Bottom : Word ); external;
Procedure XTextMode; external;
Procedure XWaitVsync; external;
Procedure XLine( x1, y1, x2, y2, Color, PgOffs : word ); external;
Procedure XPutPix( X,Y,PgOfs,Color:word ); external;
Function  XGetPix( x,y,PageBase:word ) : word; external;
Procedure XRectFill( StartX,StartY,EndX,EndY,PageBase,Color:word ); external;
Procedure XRectPattern( StartX,StartY,EndX,EndY,PageBase:word; var Pattern); external;
Procedure XCpVidPage( SourceOffs, DestOffs : word ); external;
Procedure XCpVidRect( SrcStartX,SrcStartY,SrcEndX,SrcEndY,DestStartX,
											DestStartY,SrcPageBase,DestPageBase,SrcBitmapW,
											DestBitmapW:word ); external;
Procedure XShiftRect( SrcLeft,SrcTop,SrcRight,SrcBottom,DestLeft,DestTop,
											ScreenOffs:word ); external;
Procedure XCircle( Left, Top, Diameter, Color, ScreenOffs:word ); external;
Procedure XFilledCircle( Left, Top, Diameter, Color, ScreenOffs:word ); external;
Procedure XGetPalStruc( var PalBuff; NumColors,StartColor:word ); external;
Procedure XGetPalRaw( Var PalBuff; NumColors,StartColor:word ); external;
Procedure XPutPalStruc( Var CompPalBuff ); external;
Procedure XTransposePalStruc( Var CompPalBuff; StartColor:word ); external;
Procedure XPutPalRaw( Var PalBuff; NumColors,StartColor:word ); external;
Procedure XSetRGB( ColorIndex,R,G,B:byte ); external;
Procedure XRotPalStruc( Var PalBuff; Direction:word ); external;
Procedure XRotPalRaw( Var PalBuff; Direction, NumColors:word ); external;
Function  XCpContrastPalStruc( Var PalSrcBuff,PalDestBuff; Intensity:byte ) : word; external;
Procedure XPutContrastPalStruc( Var CompPalBuff; Intensity:byte ); external;
Function  XCharPut( Chr:char; X, Y, ScrnOffs, Color:word ) : byte; external;
Procedure XSetFont( FontID : word ); external;
Procedure XTextInit; external;
Procedure XRegisterUserFont( var FontToRegister ); external;
Function  XGetCharWidth( ch : char ) : byte; external;
Procedure XTriangle( X0, Y0, X1, Y1, X2, Y2, Color, PageOffset:word ); external;
Procedure XPolygon( var vertices; numvertices, Color, PageOffset:word ); external;
Procedure XPutCursor( X, Y, TopClip, BottomClip, ScrnOffs : word ); external;
Procedure XDefineMouseCursor( var MouseDef; MouseColor:byte ); external;
procedure XMouseInit; external;
Procedure XMouseWindow( x0, y0, x1, y1:word ); external;
procedure XShowMouse; external;
Procedure XHideMouse; external;
Procedure XMouseRemove; external;
Procedure XPositionMouse( X, Y : word ); external;
Procedure XUpdateMouse; external;
Function  XFloodFill( X, Y, PgOfs, Color:word ) : word; external;
Function  XBoundaryFill( X, Y, PgOfs, BoundaryColor, Color : word ) : word; external;
Procedure XInstallVSyncHandler( VrtsToSkip:word ); external;
Procedure XRemoveVSyncHandler; external;
Procedure XSetUserVSyncHandler; external;

function XPrintf( x, y, ScrnOffs, Color : word; s : string ) : integer;
var
	w, i : integer;
begin
	w := x;
	for i := 1 to length(s) do
		x:=x+XCharPut( s[i], x, y, ScrnOffs, color );
	XPrintf := x-w+1;
end;

function XStrWidth( s : string ) : integer;
var
	w, i : integer;
begin
	w := 0;
	for i := 1 to length(s) do
		w:=w+XGetCharWidth( s[i] );
	XStrWidth := w;
end;

function XBgPrintf( x, y, ScrnOffs, fgcolor, bgcolor : word; s : string ) : integer;
var
	i : integer;
begin
	for i := 1 to length(s) do
	begin
		XRectFill( x, y, x+XGetCharWidth(s[i]),y+CharHeight,ScrnOffs,bgcolor);
		x := x + XCharPut( s[i], x, y, ScrnOffs, fgcolor);
	end;
	XBgPrintf := x;
end;

Function XCentre( x, y, ScrnOffs, color : word; s : string ) : integer;
var
	w, i : integer;
begin
	w := 0;
	for i := 1 to length(s) do
		w:=w+XGetCharWidth( s[i] );
	x := x-w div 2;
	xprintf( x, y, ScrnOffs, color, s );
	xcentre := x;
end;

Function XBgCentre( x, y, ScrnOffs, fgcolor, bgcolor : word; s : string ) : integer;
var
	w, i : integer;
begin
	w := 0;
	for i := 1 to length(s) do
		w:=w+XGetCharWidth( s[i] );
	x := x-w div 2;
	xbgprintf( x, y, ScrnOffs, fgcolor, bgcolor, s );
	xbgcentre := x;
end;

End.

