unit Vesa;

{ VESA support for GR, Copr. 1994 Matthias Kppe

  Simply link this unit to your program, and all VESA modes will
  be available with the graphic modules using GR. Don't care about
  the things in the inteface.
}

interface

{ Vesa-specific map address function
}
const
  qVesaMapAddr = 40;

{ Vesa-specific init graphics function
}
const
  qInitVesaGraph = 40;

function InitVesaGraph: Boolean;

{ Vesa-driver detection
}
function DetectVesa: Boolean;

implementation

uses Gr, VesaInt;

function DetectVesa: Boolean;
var
  VesaInfo: TVesaInfo;
Begin
  DetectVesa := GetVesaInfo(VesaInfo)
End;

function ld(x: Word): ShortInt; assembler;
asm
	mov	dx, x
	mov	al, -1
	or	dx, dx
	jz	@@0
@@1:	inc	al
	shr	dx, 1
	jnc	@@1
@@0:
end;

function InitVesaGraph: Boolean;
var
  Info: TVesaModeInfo;
  VesaMode: Word;
Begin
  case GrMode of
    gr640x480x256:
      VesaMode := $101;
    grSvgaStd:
      VesaMode := $102;
    gr800x600x256:
      VesaMode := $103;
    gr1024x768x16:
      VesaMode := $104;
    gr1024x768x256:
      VesaMode := $105;
    else Begin
      InitVesaGraph := InitBiosGraph;
      Exit
    End;
  End;
  SaveTextMode;
  InitVesaGraph := false;
  If not GetVesaModeInfo(VesaMode, Info) then Exit;
  with Info do Begin
    If vmModeAttrib and vmaSupported = 0 then Exit;
    If vmAWindowAttrib and (vwaExists + vwaReadable + vwaWritable) <>
       (vwaExists + vwaReadable + vwaWritable) then Exit;
    MapGranRight 	:= ld(vmGranularity) + 10;
    MapGranLeft		:= 16 - MapGranRight;
    WindowSize 		:= vmWindowSize * 1024;
    OffsetMask 		:= WindowSize - 1;
    GransPerWindow 	:= vmWindowSize div vmGranularity;
    WindowAddr 		:= SelOfsZero(Ptr(vmAWindowSegment, 0));
    @MapAddrProc	:= vmPositionProc;
    RealBytesPerLine	:= vmBytesPerLine;
    BytesPerLine	:= vmBytesPerLine;
    InitVesaGraph := SetVesaMode(VesaMode)
  End
End;

begin
  If DetectVesa then
    If qInitVesaGraph > qInitGraphProc then Begin
      qInitGraphProc := qInitVesaGraph;
       InitGraphProc :=  InitVesaGraph
    End
end.
