program Demo_SuperVGA_VESA_Mouse;

{ MyMouse Video Mode Demonstration, Copyright 1994 Matthias Kppe
}

{$G+,X+}

uses Crt, Gr, Objects, Vesa, MyMouse;

{ This section provides our super user interface 
}

const
{ Screen constants
}
  ScreenAttr = $30;
  LineAttr = $F0;

{ Dialog constants
}
  DlgX1 = 15;
  DlgX2 = 64;
  DlgY1 = 6;
  DlgY2 = 20;
  DlgAttr = $F0;
  ShadeAttr = $80;
  InputAttr = $1E;
  ListSelAttr = $1F;
  ListAttr = $70;

const
  ExecY: Byte = 1;

var
  OldMode: Byte;

procedure MixedLine(OAttr, UAttr: Byte; x1, x2, y: Integer; Top: Boolean); assembler;
asm
	mov     ax, y
	dec     ax
	mov     cx, 80
	mul     cx
	add     ax, x1
	dec     ax
	shl     ax, 1
	mov     di, ax
	mov     es, segb800
	mov     ah, oattr
	mov     bh, uattr
	mov     al, ""
	cmp     top, 0
	jz      @@1
	mov     al, ""
	xchg    ah, bh
@@1:    shr     bh, 4
	and     ah, 0F0H
	or      ah, bh
	mov     cx, x2
	sub     cx, x1
	inc     cx
	cld
	rep     stosw
End;

procedure InitScreen;
Begin
  OldMode := LastMode;
  TextMode(CO80);
  asm
	mov     dx, 03c0h
	in      al, dx
	mov     ah, al
	mov     al, 10h
	out     dx, al
	inc     dx
	in      al, dx
	dec     dx
	and     al, not 8
	out     dx, al
	mov     al, ah
	out     dx, al
  end;
  TextAttr := ScreenAttr;
  Window(1, 4, 80, 24);
  ClrScr;
  Window(1, 1, 80, 25);
  MixedLine(ScreenAttr, 0, 1, 80, 25, false);
  MixedLine(0, LineAttr, 1, 80, 1, true);
  TextAttr := LineAttr;
  GotoXY(1, 2);
  Write(' SuperVGA VESA Mouse Demonstration Program            Copr. 1994 Matthias Kppe ');
  MixedLine(LineAttr, ScreenAttr, 1, 80, 3, false);
End;

procedure DoneScreen;
Begin
  TextMode(OldMode)
End;

procedure Error(const s: string);
Begin
  NormVideo; DoneScreen;
  WriteLn(s);
  Halt(1)
End;

procedure MovePages(Source, Dest: Word); assembler;
asm
	mov     es, segb800
	mov     si, Source
	shl     si, 12
	mov     di, Dest
	shl     di, 12
	cld
	mov     cx, 2000
	rep
	seges   movsw
end;

procedure Dialog;
Begin
  MovePages(0, 1);
  Window(DlgX1 + 2, DlgY1 + 1, DlgX2 + 2, DlgY2 + 1);
  TextAttr := ShadeAttr; ClrScr;
  Window(DlgX1, DlgY1, DlgX2, DlgY2);
  TextAttr := DlgAttr; ClrScr;
End;

procedure ChangeAttr(x1, y, x2: Integer; Attr: Byte); assembler;
asm
	mov     ax, y
	dec     ax
	add     al, windmin.1.byte
	adc     ah, 0
	mov     cx, 80
	mul     cx
	add     ax, x1
	dec     ax
	add     al, windmin.0.byte
	adc     ah, 0
	shl     ax, 1
	mov     di, ax
	mov     es, segb800
	mov     cx, x2
	sub     cx, x1
	add     cx, 2
	cld
	mov     al, attr
@@1:    inc     di
	stosb
	loop    @@1
end;

procedure ListBox(var y: Integer);
var
  h, w: Integer;
  x: Char;
Begin
  w := Lo(WindMax) - Lo(WindMin);
  h := Hi(WindMax) - Hi(WindMin);
  Repeat
    ChangeAttr(1, y, w, ListSelAttr);
    x := ReadKey;
    case x of
      #0:
      case ReadKey of
	#$48:
	If y > 1 then Begin
	  ChangeAttr(1, y, w, ListAttr);
	  Dec(y)
	End;
	#$50:
	If y < h + 1 then Begin
	  ChangeAttr(1, y, w, ListAttr);
	  Inc(y)
	End;
      End;
      #27:
	Begin
	  y := 0;
	  Exit
	End
    end;
  Until x = #13;
End;

function ModeDialog(var Mode: Integer): Boolean;
Begin
  Dialog;
  TextAttr := $1F;
  WriteLn;
  MixedLine(ScreenAttr, TextAttr, DlgX1, DlgX2, DlgY1, true);
  Write('         Choose a video mode to be shown          ');
  MixedLine(TextAttr, DlgAttr, DlgX1, DlgX2, DlgY1+2, false);
  Window(DlgX1 + 2, DlgY1 + 4, DlgX2 - 2, DlgY2 - 1);
  TextAttr := ListAttr;
  ClrScr;
  WriteLn(' Very low resolution......... 640 x 200 x 16 ');
  WriteLn(' EGA resolution.............. 640 x 350 x 16 ');
  WriteLn(' VGA resolution.............. 640 x 480 x 16 ');
  WriteLn(' EGA resolution widened...... 720 x 350 x 16 ');
  WriteLn(' VGA resolution widened...... 720 x 480 x 16 ');
  WriteLn(' SuperVGA resolution......... 800 x 600 x 16 ');
  WriteLn(' VGA hardly any resolution... 320 x 200 x 256');
  WriteLn(' SuperVGA low resolution..... 640 x 480 x 256');
  WriteLn(' SuperVGA resolution......... 800 x 600 x 256');
  Write  (' SuperVGA high resolution....1024 x 768 x 256');
  Listbox(Mode);
  MovePages(1, 0);
  ModeDialog := Mode <> 0
End;

procedure SetBorderColor(Color: Byte); assembler;
asm
	MOV     AX, 1001h
	MOV     BH, Color
	INT     10h
end;

{ This section provides mouse cursor control 
}

procedure DoChangeCursor; far;
const
  CursorCount = 6;
var
  ColorCount: Integer;
Begin
  If GrFlags and gf256 <> 0 then ColorCount := 256 else ColorCount := 16;
  SetMCursor(MouseWhere.y * CursorCount div SizeY);
  SetPointerColor(LongDiv(LongMul(MouseWhere.x , ColorCount-1), SizeX) + 1);
End;

var
  SaveGetCursor: TGetMCProc;

procedure DoGetCursor(n: Integer); far; assembler;
Asm
	MOV     AX, n
	CMP     AX, 4
	MOV     SI, OFFSET @D4
	JZ      @@3
	CMP     AX, 5
	MOV     SI, OFFSET @D5
	JNZ     @@1
@@3:    MOV     CursorNum, AX
	MOV     WORD PTR CursorPtr, SI
	MOV     WORD PTR CursorPtr+2, CS
	JMP     @@2
@D4:    DW      17, 2                   { "Text" vertical bar }
	DW      3, 8
	DW      0000000000000000B       { is xorred on (screen mask zero) }
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      1110111000000000B
	DW      0001000000000000B
	DW      0001000000000000B
	DW      0001000000000000B
	DW      0001000000000000B
	DW      0001000000000000B
	DW      0001000000000000B
	DW      0001000000000000B
	DW      0001000000000000B
	DW      0001000000000000B
	DW      0001000000000000B
	DW      0001000000000000B
	DW      0001000000000000B
	DW      0001000000000000B
	DW      0001000000000000B
	DW      0001000000000000B
	DW      1110111000000000B
@D5:    DW      64, 8                   { 64x64 demo cursor }
	DW      32, 31

	DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

	DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

	DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

	DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

	DW      1111111111111111B
	DW      1000000000000000B
	DW      1000111000000000B
	DW      1001000100000000B
	DW      1010000001000101B
	DW      1010000001000101B
	DW      1010000001000101B
	DW      1010000001000101B
	DW      1001000101001101B
	DW      1000111000110101B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1010000000000000B
	DW      1010000000000000B
	DW      1010110001110001B
	DW      1011001010001010B
	DW      1010001011111010B
	DW      1010001010000010B
	DW      1011001010001010B
	DW      1010110001110001B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1010001001110010B
	DW      1010001010001011B
	DW      1001010011111010B
	DW      1001010010000010B
	DW      1000100010001010B
	DW      1000100001110010B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1011111111111111B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1000000000000000B
	DW      1000000000000001B
	DW      1000000000000010B
	DW      1000000000000100B
	DW      1000000000001000B
	DW      1000000000010000B
	DW      1000000000100000B
	DW      1000000001000000B
	DW      1000000010000000B
	DW      1000000100000000B
	DW      1000001000000000B
	DW      1000010000000000B
	DW      1000100000000000B
	DW      1001000000000000B
	DW      1010000000000000B
	DW      1100000000000000B
	DW      1111111111111111B

	DW      1111111111111111B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0100111000111001B
	DW      1001000101000101B
	DW      0000110001000101B
	DW      0000001001000101B
	DW      0001000101000101B
	DW      0000111000111001B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      1100011100101001B
	DW      0010100010110110B
	DW      0000100010100100B
	DW      0000100010100100B
	DW      0010100010100100B
	DW      1100011100100100B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      1010001000000000B
	DW      0010001000000000B
	DW      0001010000000000B
	DW      0001010000000000B
	DW      0000100000000000B
	DW      0000100000011111B
	DW      0000100000001111B
	DW      0001000000000111B
	DW      1111111100001011B
	DW      0000000000010001B
	DW      0000000000100000B
	DW      0000000001000000B
	DW      0000000010000000B
	DW      0000000100000000B
	DW      0000001000000000B
	DW      0000010000000000B
	DW      0000100000000000B
	DW      0001000000000000B
	DW      0010000000000000B
	DW      0100000000000000B
	DW      1000000000000000B
	DW      0000000000000000B
	DW      0001100000000111B
	DW      0001100000000111B
	DW      0001100000001101B
	DW      0001100000001101B
	DW      0001100000001101B
	DW      0001100000011000B
	DW      0001100000011000B
	DW      0001100000011111B
	DW      0001100000110000B
	DW      0001111110110000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      1111111111111111B

	DW      1111111111111111B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0100111000000111B
	DW      1001000100001000B
	DW      0000110000001000B
	DW      0000001000001000B
	DW      0001000100001000B
	DW      0000111000000111B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0001110000000001B
	DW      1010001000000010B
	DW      1011111000000100B
	DW      1010000000001000B
	DW      1010001000010000B
	DW      1001110000100000B
	DW      0000000001000000B
	DW      0000000010000000B
	DW      0000000100000000B
	DW      0000001000000000B
	DW      0100010000000000B
	DW      0110100000000000B
	DW      0111000000000000B
	DW      0111100000000000B
	DW      0111110000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000111111000001B
	DW      0000110001100011B
	DW      1000110001100110B
	DW      1000110001100110B
	DW      1000110001100110B
	DW      1100111111000110B
	DW      1100110011000110B
	DW      1100110011100110B
	DW      0110110001100011B
	DW      0110110001110001B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
	DW      1111111111111111B

	DW      1111111111111111B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0001110010110001B
	DW      1010001011001001B
	DW      0001111010001001B
	DW      0010001010001001B
	DW      1010011010001001B
	DW      0001101010001001B
	DW      0000000000000001B
	DW      0000100000000001B
	DW      0001000000000001B
	DW      0010000000000001B
	DW      0100000000000001B
	DW      1000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      1111000111111001B
	DW      0001100110000001B
	DW      0000000110000001B
	DW      0000000110000001B
	DW      0000000111111001B
	DW      0111100110000001B
	DW      0001100110000001B
	DW      0001100110000001B
	DW      0001100110000001B
	DW      1111000111111001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      0000000000000001B
	DW      1111111111111111B
@@1:    PUSH    AX
	CALL    SaveGetCursor
@@2:
End;

{ This is the main program 
}

var
  Mode: Integer;

const
  GrModes: array[1..10] of Byte =
  (gr640x200x16, gr640x350x16, gr640x480x16, gr720x350x16, gr720x480x16,
   gr800x600x16, gr320x200x256, gr640x480x256, gr800x600x256, gr1024x768x256);

Begin
  Mode := 3;                            { standard mode be 640x480x16 }
  MaxWidth := 8;                        { prepare for huge cursor shapes }
  MaxLength := 64;
  InitMyMouse;                          { only for graphics }
  ChangeCursor := DoChangeCursor;       { set the automatic adaption proc }
  SaveGetCursor := GetMCursor;
  GetMCursor := DoGetCursor;            { set the cursor provision proc }
  Repeat
    InitScreen;
    If ModeDialog(Mode) then Begin
      DoneScreen;
      SetGrMode(GrModes[Mode]);         { set logical mode }
      If InitGraphics                   { initialize graphics... }
      then Begin                        { ... succeeded }
	SetBorderColor(3);
	Readkey;                        { wait }
	CloseGraphics
      End
      else ;                            { .. failed }
    End
    else Break
  Until false;
  DoneScreen;
  DoneMyMouse;                          { have thou noticed that MyMouse
					  installs its graphic output at
					  an InitGraphics call, and can
					  be initialized in text mode... }
End.
