(* This is a test program for the TSUNTK.TPU unit 23-Jan-93 *)

uses TSUNTK;

procedure LOGO;
begin
  writeln;
  writeln ('TSUNTK unit test by Prof. Timo Salmi, 23-Jan-93');
  writeln ('University of Vaasa, Finland, ts@uwasa.fi');
{$IFDEF VER40}
  writeln ('TP version 4.0');
{$ENDIF}
{$IFDEF VER50}
  writeln ('TP version 5.0');
{$ENDIF}
{$IFDEF VER55}
  writeln ('TP version 5.5');
{$ENDIF}
{$IFDEF VER60}
  writeln ('TP version 6.0');
{$ENDIF}
{$IFDEF VER70}
  writeln ('TP version 7.0');
{$ENDIF}
  writeln;
end;  (* logo *)

(* Display the boot drive *)
procedure TEST1;
begin
   writeln ('The boot drive was ', BOOTDRFN);
   Flush (output);
end;  (* test1 *)

(* Return the serial number of a disk *)
procedure TEST2;
var serial : string;
    drive  : char;
    path   : string;
begin
  drive := 'A';
  serial := GETSERFN (drive);
  writeln ('The serial number for ', UpCase(drive), ' is ', serial);
end;  (* test2 *)

(* Get the volume label of a MsDos 4.+ disk *)
procedure TEST3;
var volume : string;
    drive  : char;
begin
  drive := 'A';
  volume := GETVOLFN (drive);
  writeln ('The volume label for ', UpCase(drive), ' is ', volume);
end;  (* test3 *)

(* Set the serial number of a floppy *)
procedure TEST4;
var serial : string;
    drive  : char;
    path   : string;
    status : integer;
begin
  drive := 'A';
  SETSER (drive, '1FAC-2B4D', status);
  case status of
    -1 : writeln ('Procedure not supported for MsDos versions prior 4.0');
    -2 : writeln ('Unacceptable drive chosen');
    -3 : writeln ('Error in the serial string XXXX-XXXX');
    -4 : writeln ('An error was reported by the MsDos interrupt');
  end; {case}
end;  (* test4 *)

(* Main program *)
begin
  LOGO;
  TEST1;
  TEST2;
  {}
  write ('Press <-'' '); readln;
end.  (* tsuntz.tst *)
