{
MG>>   Can someone give me the trick to get a methode addr ??

I tried real hard to do this exact thing! After hours of stress and
heartache I came to the conclusion that you can't get the address of a
method directly. I also tried using the VMT as DJ suggested but this
also gave me problems.

What I assumed (and i think you are assuming also), is that for each
object instance declared, a corresponding method for that instance
exists. For example doing the following ,

Var
  a,b,c,d : Obj;
  p1,p2,p3,p4 : Pointer;

Begin
  p1 := @a.hello;
  p2 := @b.hello;
  p3 := @c.hello;
  p4 := @d.hello;
End.

should give me four different addresses. If this snippet of code were
compilable (and its not), it would only give me one address!! Only one
method exists in memory for each object type!

I proved this by getting the actual memory location of a method with
the VMT for three objects and yep, they were all the same. That's the
smart-linker at work i guess.

In case you're interested, I'll describe the prob I had. I wanted to
be able to call a method of any object in my library by storing
it's location in a Procedure variable. Thats when I discovered that the
compiler wouldn't let me.
A real pain, I know, but I solved my dilemna by defining a base class
(TBASEOBJ) and having a virual method (ProcessSignal). Now every new
object I define MUST be a descendent of this one. Instead of storing
the address of the method in a variable, i store the OBJECT'S ADDRESS.
Here's a slight mod to my previous example to show what i mean...
}

type
  {Your object here}
  PObj = ^TOBJ;
  TObj = Object
    procedure Hello; virtual;
  end;

  {Just an example descendant to demonstrate}
  PAnotherObject = ^TAnotherObject;
  TanotherObject = Object(TObj)
    Procedure GoodBye; {just made this up. Doesnt do anything}
  end;

Var
  a,b         : PObj;
  c,d         : PAnotherObject;
  p1,p2,p3,p4 : POBJ;

Begin
  p1 := a;
  p2 := b;
         {the following two assignments are perfectly valid because the
          PAnotherObject is a descendant of PObj}
  p3 := c;
  p4 := d;

  p1^.hello;
  p3^.hello;
End.

{
Ok ok, I realise it's really simple but Im sure you get the point.
Every object has the "Hello" method in it so all you have to do is
call that method directly and be assured of doing what you want!

In the above example only one "hello" method exists in memory. If you
redefine the method in one of your descendants then not only does a new
"hello" now exist but that hello is called instead. This is OOP at
it's finest! ;-)

Hope that helps.


Cya,

Gabriel Lagos

--- 
 * Origin:    Melb, Aus (3:632/552.11)
}
