{
JD>I need some source code that would allow me to stuff my keyboard buffer.
}

Unit KeyStuffer;

(**) Interface (**)

Uses DOS;
TYPE String15 = String[15];

  PROCEDURE ClearBuffer;
  PROCEDURE StuffBuffer(S : String15);


(**) Implementation (**)

CONST
  KbStart = $1E;

VAR
  ShiftState : Byte ABSOLUTE $40:$17;
  KbHead     : Word ABSOLUTE $40:$1A;
  KbTail     : Word ABSOLUTE $40:$1C;
  KbBuff     : ARRAY[0..15] OF Word ABSOLUTE $40:KbStart;


  PROCEDURE ClearBuffer;
  BEGIN
    ASM CLI END;
    KbHead := KbStart;
    KbTail := KbStart;
    ASM STI END;
  END;

  PROCEDURE StuffBuffer(S : String15);
  VAR N, max : Byte;
  BEGIN
    max := 15;
    IF length(S) < max THEN max := length(S);
    ASM CLI END;
    KbHead := KbStart;
    KbTail := KbStart + 2*max;
    FOR N := 1 to max DO
      KbBuff[pred(N)] := Word(S[N]);
    ASM STI END;
  END;

  FUNCTION IsEnhanced : Boolean;
  VAR StateFrom16 : Byte;
  BEGIN
    IsEnhanced := FALSE;
    ASM
      MOV AH, 12h
      INT 16h
      MOV StateFrom16, AL
    END;
    IF StateFrom16 <> ShiftState THEN Exit;
    ShiftState := ShiftState XOR $20;
    ASM
      MOV AH, 12h
      INT 16h
      MOV StateFrom16, AL
    END;
    IsEnhanced := StateFrom16 = ShiftState;
    ShiftState := ShiftState XOR $20;
  END;

  FUNCTION ReadKeyEnh : Word; Assembler;
  ASM
    MOV AH, 10h
    INT 16h
  END;

  FUNCTION KeyPressedEnh : Boolean; Assembler;
  ASM
    MOV AH, 11h
    INT 16h
    MOV AX, 0
    JZ @NoKey
    INC AX
    @NoKey:
  END;

BEGIN
   IF NOT IsEnhanced THEN
    BEGIN
      MEM[CSeg : Ofs(ReadKeyEnh)+1] := $00;
      MEM[CSeg : Ofs(KeyPressedEnh)+1] := $01;
    END;
END.

{
Hope this helps Jason!

**Jordan

--- 
 * Origin: The Power Supply - Tampa, Fl - (813)949-7153 (1:377/64)
}
