{
 GK> Does anybody know how to put text onto a graphics screen using the
 GK> tweaked mode 320x240x256?

Check out XLIB in the file XTEXT for 8x8 or 8x14 vga bios fonts.  Also
here is some pascal source that I sometimes use.  It displays an 8x8
font from the bios.  I'm not quite sure who originally wrote this
procedure...
}

PROCEDURE PrintChar(TheChar:Char;X,Y:Integer;Fg,Bk:Byte);
{This procedure prints one char on a 320x240x256 screen.  Fg is the  }
{foreground color, bk is the background color.  No range checking on }
{either x or y.                                                      }
TYPE
    fdef=ARRAY[0..255,0..7] OF Byte;
    tptr=^fdef;
VAR
   Regs:Registers;
   Ch:Char;
   I,K,BMask:Byte;
CONST
     Fptr:TPTR=Nil;
BEGIN
     IF Fptr=NIL THEN
     BEGIN
          Regs.AH:=$11;
          Regs.AL:=$30;
          Regs.BH:=3;
          Intr($10,Regs);
          FPtr:=Ptr(Regs.ES,Regs.BP);
     END;
     IF (BK=255) THEN
        FOR I:=0 TO 7 DO
        BEGIN
             BMask:=Fptr^[ord(TheChar),i];
             FOR K:=0 TO 7 DO
             BEGIN
                  IF (BMask AND 128<>0) THEN
                     setpix(x+k,y+i,fg)
                  ELSE
                      setpix(x+k,y+i,bk);
                  BMask:=BMask SHL 1;
             END;
        END;
END;

{
BTW the above procedure expects you to have written setpix(x,y,color)
somewhere in your program.

-Alex Falardeau
alex@leotech.mv.com

--- 
 * Origin: NETIS Public Access Internet (603)432-2517 (1:132/189)
}
