{
Turbo Vision CyberTools 2.0
(C) 1994 Steve Goldsmith
All Rights Reserved

CyberEdit application allows editing VGA 8X16 text mode fonts.  Uses tool bar,
help system and CyberFont graphic interface.

Borland Pascal 7.x or Turbo Pascal 7.x and Turbo Vision 2.x are required to
compile.

Set IDE directories to

\BP\UNITS;
\BP\EXAMPLES\DOS\TVDEMO;
\BP\EXAMPLES\DOS\TVFM;

These path names are BP 7.x defaults.  If you changed any of these then use
the correct paths in Options|Directories...  See APP.INC for global compiler
switches.
}

PROGRAM CYBEREDIT; {$I APP.INC} {$X+} USES DOS , MEMORY , DRIVERS , OBJECTS , VIEWS , MENUS , DIALOGS , APP , MSGBOX ,
STDDLG , COLORSEL , GADGETS , HELPFILE , VIEWTEXT , CEHELP , CECMDS , VGA , VGACGFIL , PCX , COMMDLGS , CEDLGS , TVSTR ;
CONST APPHELPNAME ='CEHELP.HLP';APPEXENAME ='CYEDIT.EXE';APPDOCNAME ='CYBER.DOC';APPCFGNAME ='CYEDIT.CFG';
APPCFGHEADERLEN =10 ;APPCFGHEADER :STRING [ APPCFGHEADERLEN ] ='CYBEREDIT'#26;APPVIEWDOCBUF =8192 ;APPCHRWIDTH8 =$01 ;
APPPAGEMODE =$02 ;APP8COLORS =$04 ;APPSCROPTS =$07 ;APPHELPINUSE =$8000 ;APPGRAPHWINX =32 ;APPGRAPHWINY =8 ;
APPFADEINC =8 ;CSYSCOLOR =#$00#$00#$00;CSYSPAL =#137#138#139;APPTOOLCMDS =[ CMQUIT , CMLOADFONT , CMSAVEFONT ,
CMDIRCHANGE , CMSHELLTODOS , CMSCREENOPTS , CMEXIT , CMBARHELP ] ;TYPE TCYBEREDIT =OBJECT (TAPPLICATION)FONTTABLE1 ,
FONTTABLE2 , FIRSTCHR , LASTCHR :BYTE ;APPOPTIONS , PAGEOFS , DEFCHRHEIGHT :WORD ;SCRDATA :SCROPTSDATA ;PAGE :POINTER ;
DEFFONT :VGACHRTABLEPTR ;DACPALETTE :VGAPALETTE ;CLOCK :PCLOCKVIEW ;HEAP :PHEAPVIEW ;CONSTRUCTOR INIT ;DESTRUCTOR DONE ;
VIRTUAL;PROCEDURE SETCUSTOMSCREEN ;PROCEDURE FLIPPAGE ;PROCEDURE CLEARDESKTOP ;PROCEDURE IDLE ;VIRTUAL;
PROCEDURE ABOUTBOX ;PROCEDURE CHARSELECTOR ;PROCEDURE TOOLBAR ;PROCEDURE LOADFONTTABLE (CHRDATA :POINTER ;
CHRTABLE ,CHRHEIGHT:BYTE ;STARTCHR ,NUMCHRS:WORD );FUNCTION SAVEFONTTABLE (CHRTABLE ,CHRHEIGHT:BYTE ;
STARTCHR ,NUMCHRS:WORD ):VGACHRTABLEPTR ;PROCEDURE RESTOREDESKTOP (F :PATHSTR );PROCEDURE SAVEDESKTOP (F :PATHSTR );
FUNCTION GETPALETTE :PPALETTE ;VIRTUAL;PROCEDURE GETEVENT (VAR EVENT :TEVENT );VIRTUAL;PROCEDURE HANDLEEVENT
(VAR EVENT :TEVENT );VIRTUAL;PROCEDURE INITDESKTOP ;VIRTUAL;PROCEDURE INITMENUBAR ;VIRTUAL;PROCEDURE INITSTATUSLINE ;
VIRTUAL;PROCEDURE OUTOFMEMORY ;VIRTUAL;PROCEDURE LOADDESKTOP (VAR S :TSTREAM );PROCEDURE STOREDESKTOP (VAR S :TSTREAM );
END ;

CONSTRUCTOR TCYBEREDIT . INIT ;VAR OO1I:TRECT;BEGIN LOWMEMSIZE := 4095 ;INHERITED INIT;REGISTEROBJECTS
;REGISTERVIEWS ;REGISTERMENUS ;REGISTERDIALOGS ;REGISTERAPP ;REGISTERHELPFILE ;OO1I.ASSIGN (71 , 0 , 79 , 1 );CLOCK :=
NEW (PCLOCKVIEW , INIT (OO1I ));INSERT (CLOCK );OO1I.ASSIGN (64 , 0 , 70 , 1 );HEAP := NEW (PHEAPVIEW , INIT (OO1I ));
INSERT (HEAP );RESTOREDESKTOP (APPCFGNAME );TOOLBAR ;ABOUTBOX ;END ;DESTRUCTOR TCYBEREDIT.DONE;BEGIN IF DEFFONT <> NIL
THEN FREEMEM (DEFFONT , VGAMAXCHRS * DEFCHRHEIGHT );FADEOUTDAC (APPFADEINC );SETVIDEOMODE (STARTUPMODE );INHERITED DONE;
END ;

{
Sets screen page if not not flipping, 8 or 16 color mode, 8 or 9 pixel width,
font map, DAC palette and mouse mask.
}

procedure TCyberEdit.SetCustomScreen;

begin
  HideMouse;
  if AppOptions and appPageMode = 0 then
    SetPage (vgaPageOfsLoc[0]); {screen page 0 for non page flipping displays}
  if AppOptions and app8Colors = app8Colors then
    SetAttrCont (vgaAttrCPEnable,$07)  {use 8 colors}
  else
    SetAttrCont (vgaAttrCPEnable,$0f); {use 16 colors}
  if AppOptions and appChrWidth8 = appChrWidth8 then
  begin
    if IsChrWidth9 then
      SetChrWidth8                     {640 x 400 screen}
  end
  else
  begin
    if not IsChrWidth9 then
      SetChrWidth9                     {720 x 400 screen}
  end;
  FontMapSelect (vgaChrTableMap1[FontTable1],
  vgaChrTableMap2[FontTable2]);        {select font tables}
  SetDACBlock (@DacPalette,0,256);     {set 256 color palette}
  MouseTextMask ($ffff,$f700);         {set mouse mask for both fonts}
  ShowMouse
end;

{
Copy screen page 0 to new non-visiable page and flip to new page.
}

procedure TCyberEdit.FlipPage;

begin
  CopyScrMem (ScreenBuffer,Page,vgaScrSize25);
  SetPage (PageOfs);
  if PageOfs = vgaPageOfsLoc[1] then
  begin
    PageOfs := vgaPageOfsLoc[2];
    Page := vgaPageLoc[2]
  end
  else
  begin
    PageOfs := vgaPageOfsLoc[1];
    Page := vgaPageLoc[1]
  end;
  WaitVertSync {wait for vga vert sync before drawing anything}
end;

{
Remove all closeable windows from desk top.
}

procedure TCyberEdit.ClearDeskTop;

procedure CloseDlg (P : PView); far;

begin
  Message (P,evCommand,cmClose,nil)
end;

begin
  Desktop^.ForEach (@CloseDlg)
end;

{
Handle app's idle time processing.
}

procedure TCyberEdit.Idle;

function IsTileable (P : PView) : Boolean; far;

begin
  IsTileable := (P^.Options and ofTileable <> 0) and
  (P^.State and sfVisible <> 0);
end;

function IsThere (P : PView) : Boolean; far;

begin
  IsThere := (P^.State and sfActive = sfActive)
end;

function IsModal (P : PView) : Boolean; far;

begin
  IsModal := (P^.State and sfModal = sfModal)
end;

begin
  inherited Idle;
  Clock^.Update; {update tvdemo gadgets}
  Heap^.Update;
  if Desktop^.FirstThat (@IsThere) <> nil then {see if anything is}
  begin                                        {on the desk top}
    EnableCommands ([cmCloseAll]);
    if Desktop^.FirstThat (@IsTileable) <> nil then {see if any tileable}
      EnableCommands ([cmTile,cmCascade])           {windows are on the}
    else                                            {desk top}
      DisableCommands ([cmTile,cmCascade]);
  end
  else
    DisableCommands ([cmCloseAll,cmTile,cmCascade]);
  if (Desktop^.FirstThat (@IsModal) <> nil)
  or (AppOptions and appHelpInUse = appHelpInUse) then {see if a modal dialog}
    DisableCommands (appToolCmds)   {is on the desk top}
  else
    EnableCommands (appToolCmds);
  if AppOptions and appPageMode = appPageMode then
    FlipPage; {if page mode is enabled then flip page each idle cycle}
end;

{
Display info about app.
}

procedure TCyberEdit.AboutBox;

begin
  HelpCtx := hcAbout;
  MessageBox(
    #3'Turbo Vision CyberTools 2.0'#13+
    #3'(C) 1994 Steve Goldsmith'#13+
{$IFDEF DPMI}
    #3'CyberEdit PROTECTED',
{$ELSE}
    #3'CyberEdit REAL',
{$ENDIF}
    nil, mfInformation or mfOKButton);
  HelpCtx := hcNoContext
end;

{
Char selector window selects which char to edit.
}

procedure TCyberEdit.CharSelector;

var

  D : PChrSetEditDlg;

function IsThere (P : PView) : Boolean; far;

begin {see if view is a chr set dialog}
  IsThere := (TypeOf (P^) = TypeOf (TChrSetEditDlg))
end;

begin
  PView (D) := Desktop^.FirstThat (@IsThere);
  if D <> nil then {if on desk top then update title and focus}
  begin
    if D^.Title <> nil then
      DisposeStr (D^.Title);
    D^.Title := NewStr ('Font Table '+IntToStr (FontTable2));
    D^.Frame^.DrawView;
    D^.MakeFirst
  end
  else  {if not on desk top the create new window}
  begin
    D := New(PChrSetEditDlg,Init ('Font Table '+IntToStr (FontTable2)));
    D^.HelpCtx := hcSelectorWindow;
    InsertWindow (D)
  end
end;

{
Tool bar with graphic icons.
}

procedure TCyberEdit.ToolBar;

var

  D : PToolBarDlg;

function IsThere (P : PView) : Boolean; far;

begin {see if view is a tool bar}
  IsThere := (TypeOf (P^) = TypeOf (TToolBarDlg))
end;

begin
  PView (D) := Desktop^.FirstThat (@IsThere);
  if D = nil then {if tool bar is not on desk top then create}
  begin
    D := New (PToolBarDlg,Init (128,3,7,cmLoadFont));
    D^.HelpCtx := hcToolBar;
    InsertWindow (D)
  end
  else {if tool bar is on desk top the focus}
    D^.MakeFirst
end;

{
Load font table from system RAM.
}

procedure TCyberEdit.LoadFontTable (ChrData : pointer;
                                    ChrTable, ChrHeight :byte;
                                    StartChr, NumChrs : word);

begin
  HideMouse;
  AccessFontMem;
  SetRamTable (StartChr,NumChrs,ChrHeight,ChrData,vgaChrTableLoc[ChrTable]);
  AccessScreenMem;
  ShowMouse
end;

{
Save font table from video RAM.
}

function TCyberEdit.SaveFontTable (ChrTable, ChrHeight :byte;
                                      StartChr, NumChrs : word) : vgaChrTablePtr;

begin
  HideMouse;
  AccessFontMem;
  SaveFontTable :=
  GetRamTable (StartChr,NumChrs,ChrHeight,vgaChrTableLoc [ChrTable]);
  AccessScreenMem;
  ShowMouse
end;

{
Restore desk top stream.
}

procedure TCyberEdit.RestoreDesktop (F : PathStr);

var

  I : byte;
  S : PStream;
  Signature : string[appCfgHeaderLen];

begin
  S := New (PBufStream,Init (F,stOpenRead,1024));
  if LowMemory then OutOfMemory
  else
    if S^.Status <> stOk then
    begin
      MessageBox (#3'Unable to open file.',nil,mfOkButton+mfError)
    end
    else
    begin
      Signature[0] := Char (appCfgHeaderLen);
      S^.Read (Signature[1],appCfgHeaderLen);
      if Signature = appCfgHeader then {see if signature is right}
      begin
        S^.Read (AppOptions,SizeOf (AppOptions)); {read data from stream}
        S^.Read (FontTable1,SizeOf (FontTable1));
        S^.Read (FontTable2,SizeOf (FontTable2));
        S^.Read (FirstChr,SizeOf (FirstChr));
        S^.Read (LastChr,SizeOf (LastChr));
        S^.Read (DacPalette,SizeOf (DacPalette));

        if DefFont = nil then
          DefFont := MemAlloc (DefChrHeight*vgaMaxChrs);
        HideMouse; {no screen writes during font mem access}
        AccessFontMem;
        for I := 0 to 7 do
        begin
          S^.Read (DefFont^,DefChrHeight*vgaMaxChrs);
          SetRamTable (0,vgaMaxChrs,DefChrHeight,DefFont,vgaChrTableLoc[I])
        end;
        AccessScreenMem;
        ShowMouse;

        LoadDesktop (S^);
        LoadIndexes (S^);
        ShadowAttr := GetColor (137);   {tv shadow color}
        SysColorAttr := (GetColor (138) shl 8) or
        GetColor (138);                 {tv system error color}
        ErrorAttr := GetColor (139);    {tv palette index error color}
        Application^.ReDraw;            {draw app with new config}
        if DefFont <> nil then
        begin
          FreeMem (DefFont,DefChrHeight*vgaMaxChrs);
          DefFont := SaveFontTable (FontTable1,DefChrHeight,0,vgaMaxChrs)
        end;
        SetCustomScreen;
        CharSelector;
        if S^.Status <> stOk then
          MessageBox (#3'Stream error.',nil,mfOkButton+mfError);
      end
      else
        MessageBox (#3'Invalid configuration format.',nil,mfOkButton+mfError)
    end;
  Dispose (S,Done)
end;

{
Save desk top stream.
}

procedure TCyberEdit.SaveDesktop (F : PathStr);

var

  I : byte;
  CfgFile : File;
  S : PStream;
  SFont : vgaChrTablePtr;

begin
  S := New(PBufStream,Init (F,stCreate,1024));
  if not LowMemory and (S^.Status = stOk) then
  begin
    S^.Write (appCfgHeader[1],appCfgHeaderLen); {write stream data}
    S^.Write (AppOptions,SizeOf (AppOptions));
    S^.Write (FontTable1,SizeOf (FontTable1));
    S^.Write (FontTable2,SizeOf (FontTable2));
    S^.Write (FirstChr,SizeOf (FirstChr));
    S^.Write (LastChr,SizeOf (LastChr));
    GetDACBlock (@DacPalette,0,256);
    S^.Write(DacPalette,SizeOf (DacPalette));

    HideMouse; {no screen write during font mem access}
    AccessFontMem;
    for I := 0 to 7 do {save all 8 vga font tables}
    begin
      SFont := GetRamTable (0,vgaMaxChrs,DefChrHeight,vgaChrTableLoc[I]);
      S^.Write (SFont^,DefChrHeight*vgaMaxChrs);
      if SFont <> nil then
        FreeMem (SFont,DefChrHeight*vgaMaxChrs)
    end;
    AccessScreenMem;
    ShowMouse;

    StoreDesktop (S^);
    StoreIndexes (S^);
    if S^.Status <> stOk then
    begin {if stream error then delete file}
      MessageBox (#3'Could not create stream.',nil,mfOkButton+mfError);
      Dispose (S,Done);
      Assign (CfgFile,F);
      {$I-} Erase (CfgFile) {$I+};
      Exit
    end
  end;
  Dispose (S,Done)
end;

{
Get custom app palette.
}

function TCyberEdit.GetPalette: PPalette;

const

  CNewColor = CAppColor+CHelpColor+CCharColor+CSysColor;
  CNewBlackWhite = CAppBlackWhite+CHelpBlackWhite+CCharColor+CSysColor;
  CNewMonochrome = CAppMonochrome+CHelpMonochrome+CCharColor+CSysColor;
  P: array[apColor..apMonochrome] of string[Length (CNewColor)] =
  (CNewColor, CNewBlackWhite, CNewMonochrome);

begin {add additional entries to the normal application palettes}
  GetPalette := @P[AppPalette]
end;

{
Intercept cmHelp and cmBarHelp to display help even when views are in modal
state.
}

procedure TCyberEdit.GetEvent (var Event : TEvent);

function CalcHelpName : PathStr;

var

  EXEName : PathStr;
  Dir : DirStr;
  Name : NameStr;
  Ext : ExtStr;

begin
  if Lo (DosVersion) >= 3 then
    EXEName := ParamStr (0)
  else
    EXEName := FSearch (appExeName, GetEnv ('PATH'));
  FSplit (EXEName, Dir, Name, Ext);
  if Dir[Length (Dir)] = '\' then
    Dec (Dir[0]);
  CalcHelpName := FSearch (appHelpName, Dir)
end;

var

  W : PWindow;
  HFile : PHelpFile;
  HelpStrm : PDosStream;

begin
  inherited GetEvent (Event);
  if (Event.What = evCommand) and
  ((Event.Command = cmHelp) or (Event.Command = cmBarHelp)) and
  (AppOptions and appHelpInUse = 0) then
  begin
    AppOptions := AppOptions or appHelpInUse; {help's in use}
    HelpStrm := New (PDosStream, Init (CalcHelpName, stOpenRead));
    HFile := New (PHelpFile, Init (HelpStrm));
    if HelpStrm^.Status <> stOk then
    begin
      MessageBox (#3'Could not open help file.', nil, mfError + mfOkButton);
      Dispose (HFile, Done);
    end
    else
    begin
      if Event.Command = cmHelp then
        W := New (PHelpWindow,Init (HFile,GetHelpCtx))
      else                                  {cmBarHelp displays help topics}
        W := New (PHelpWindow,Init (HFile,hcNoContext));
      if ValidView (W) <> nil then
      begin
        DisableCommands ([cmHelp]);
        ExecView (W);
        Dispose (W, Done);
        EnableCommands ([cmHelp])
      end
    end;
    ClearEvent (Event);
    AppOptions := AppOptions and not appHelpInUse
  end
end;

{
Process app events.
}

procedure TCyberEdit.HandleEvent (var Event: TEvent);

{
Restore default font loaded by config.
}

procedure RestoreDefFont;

begin
  if (DefFont <> nil) and
  (DefChrHeight = BiosGetChrHeight) then
    LoadFontTable (DefFont,FontTable1,DefChrHeight,0,vgaMaxChrs)
end;

{
Tree window.
}

procedure TreeWindow (T : string; FMask : PathStr; ACmd : word);

var

  W : PDirWindow;
  Drive : PathStr;

begin
  GetDir (0,Drive);
  W := New (PDirWindow,Init (T,Drive,FMask,ACmd));
  W^.HelpCtx := hcTreeWindow;
  InsertWindow (W)
end;

{
Return focused file name from dir tree window.  If the extension param is not
null then that extension is used.
}

function TreeFileName (TW : PDirWindow; EStr : PathStr; ReadFlag : boolean) : PathStr;

var

  F : file;
  FName : PathStr;

begin
  FName := UpCaseStr (TW^.FocDirName+TW^.NameLine^.Data^);
  if (EStr <> '') and (FName[byte (FName[0])] <> '\') then {force extension}
    FName := AddExtStr (FName,EStr);
  if ReadFlag then
    TreeFileName := FName
  else
  begin
    Assign (F,FName);
    {$I-} Reset (F); {$I+}
    if IoResult = 0 then {see if file exists before writes}
    begin
      {$I-} Close (F); {$I+}
      if MessageBox (FName+' already exists.  Erase and continue?',
      nil,mfConfirmation or mfYesNoCancel) = cmYes then
        TreeFileName := FName
      else
        TreeFileName := ''
    end
    else
      TreeFileName := FName {doesn't exist, so return name}
  end
end;

{
Load CGF file and store in table.
}

procedure LoadChrFile (F : PathStr; ChrTbl : byte);

var

  ChrFile : TChrGenFile;

begin
  ChrFile.Init;
  ChrFile.OpenRead (F);
  if (ChrFile.IoError = 0) and
  (ChrFile.Header.Height = DefChrHeight) then
  begin
    ChrFile.ReadChrTable;
    LoadFontTable (
    ChrFile.ChrTablePtr,ChrTbl,ChrFile.Header.Height,
    ChrFile.Header.StartChr,ChrFile.Header.TotalChrs)
  end
  else
    MessageBox (#3'Problem reading font file.',nil,mfOkButton+mfError);
  ChrFile.FreeChrTable;
  ChrFile.Done
end;

{
Save CGF file from table.
}

procedure SaveChrFile (F : PathStr);

var

  ChrFile : TChrGenFile;

begin
  ChrFile.Init;
  HideMouse;
  AccessFontMem;
  ChrFile.GetFontTable (FontTable2,
  FirstChr,(LastChr-FirstChr)+1,DefChrHeight);
  AccessScreenMem;
  ShowMouse;
  ChrFile.OpenWrite (F);
  if ChrFile.IoError = 0 then
    ChrFile.WriteChrTable
  else
    MessageBox (#3'Problem writing font file.',nil,mfOkButton+mfError);
  ChrFile.FreeChrTable;
  ChrFile.Done
end;

{
Load .CGF file.
}

procedure LoadFontFile (TW : PDirWindow);

var

  F : PathStr;

begin
  F := TreeFileName (TW,'CGF',true);
  if F <> '' then
    LoadChrFile (F,FontTable2)
end;

{
Save .CGF file.
}

procedure SaveFontFile (TW : PDirWindow);

var

  F : PathStr;

begin
  F := TreeFileName (TW,'CGF',false);
  if F <> '' then
    SaveChrFile (F)
end;

{
Decode and view 2 color PCX file up to 640 X 480.  Actual viewing area is
determined by graphics window size.
}

procedure LoadPCXFile (TW : PDirWindow);

var

  F : PathStr;
  Decode : TPCXToChrTable;

begin
  F := TreeFileName (TW,'PCX',true);
  if F <> '' then
  begin
    HideMouse; {no screen writes during font mem access}
    Decode.Init (F,appGraphWinX,appGraphWinY,
    DefChrHeight,vgaChrTableLoc[FontTable2]);
    ShowMouse;
    if Decode.ReadError <> 0 then
      MessageBox (#3'Problem reading PCX file.',nil,mfOkButton+mfError);
    Decode.Done
  end
end;

{
Encode graphics window and save as 2 color PCX file.
}

procedure SavePCXFile (TW : PDirWindow);

var

  F : PathStr;
  Encode : TChrTableToPCX;

begin
  F := TreeFileName (TW,'PCX',false);
  if F <> '' then
  begin
    HideMouse; {no screen writes during font mem access}
    Encode.Init (F,appGraphWinX,appGraphWinY,
    DefChrHeight,vgaChrTableLoc[FontTable2]);
    ShowMouse;
    if Encode.WriteError <> 0 then
      MessageBox (#3'Problem writing PCX file.',nil,mfOkButton+mfError);
    Encode.Done
  end
end;

{
Change DOS directory.
}

procedure ChangeDir;

var

  D: PChDirDialog;

begin
  D := New (PChDirDialog,Init (cdNormal,101));
  D^.HelpCtx := hcChDirDialog;
  ExecuteDialog (D,nil)
end;

{
Shell to DOS and preserve font 1 and 2 tables, DAC palette and screen
settings.
}

procedure ShellToDos;

var

  SaveFont1,
  SaveFont2 : vgaChrTablePtr;

begin
  SaveFont1 := SaveFontTable (FontTable1,
  DefChrHeight,0,vgaMaxChrs); {save current font 1}
  SaveFont2 :=
  SaveFontTable (FontTable2,
  DefChrHeight,0,vgaMaxChrs); {save current font 2}
  if (not LowMemory) and
  (SaveFont1 <> nil) and
  (SaveFont2 <> nil) then
  begin
    SetVideoMode (StartUpMode);  {reset custom setup using bios}
    DosShell
  end
  else
    OutOfMemory;
  if SaveFont1 <> nil then     {restore font 1 and 2 tables and free mem}
  begin
    LoadFontTable (SaveFont1,FontTable1,DefChrHeight,0,vgaMaxChrs);
    FreeMem (SaveFont1,DefChrHeight*vgaMaxChrs)
  end;
  if SaveFont2 <> nil then
  begin
    LoadFontTable (SaveFont2,FontTable2,DefChrHeight,0,vgaMaxChrs);
    FreeMem (SaveFont2,DefChrHeight*vgaMaxChrs)
  end;
  SetCustomScreen; {reset screen mode and dac palette}
  ShowMouse
end;

{
View any text file.
}

procedure ViewTextFile (FileName : PathStr);

var

  T : PTextWindow;
  R : TRect;

begin
  GetExtent (R);
  R.Grow (-5,-4);
  T := New (PTextWindow, Init (R,FileName));
  T^.Options := T^.Options or ofCentered;
  T^.Palette := wpGrayWindow;
  T^.HelpCtx := hcViewDoc;
  InsertWindow (T)
end;

{
Screen options dialog.
}

procedure ScreenOptions;

var

  D : PScrOptsDlg;

begin
  with ScrData do
  begin
    SMode := AppOptions and appScrOpts; {use only screen options}
    FontMapVal (GetSeqCont (vgaSeqChrMapSel),byte (FntTbl1),byte (FntTbl2));
    FChr := IntToStr (FirstChr);
    LChr := IntToStr (LastChr);
    D := New (PScrOptsDlg,Init);
    D^.Options := D^.Options or ofCentered;
    D^.HelpCtx := hcScreenDialog;
    if ExecuteDialog (D,@ScrData) <> cmCancel then
    begin
      AppOptions := (AppOptions and not appScrOpts)
      or SMode; {clear all scr opts bits and set bits returned from dialog}
      FontTable1 := FntTbl1;
      FontTable2 := FntTbl2;
      FirstChr := StrToInt (FChr);
      LastChr := StrToInt (LChr);
      SetCustomScreen; {set screen with new settings}
      CharSelector
    end
  end
end;

procedure Colors;

{custom color items}
function DlgColorItems (Palette: Word; const Next: PColorItem) : PColorItem;

const

  COffset : array[dpBlueDialog..dpGrayDialog] of Byte = (64, 96, 32);

var

  Offset : Byte;

begin
  Offset := COffset[Palette];
  DlgColorItems :=
    ColorItem ('Frame passive',     Offset,
    ColorItem ('Frame active',      Offset + 1,
    ColorItem ('Frame icons',       Offset + 2,
    ColorItem ('Scroll bar page',   Offset + 3,
    ColorItem ('Scroll bar icons',  Offset + 4,
    ColorItem ('Static text',       Offset + 5,

    ColorItem ('Label normal',      Offset + 6,
    ColorItem ('Label selected',    Offset + 7,
    ColorItem ('Label shortcut',    Offset + 8,

    ColorItem ('Button normal',     Offset + 9,
    ColorItem ('Button default',    Offset + 10,
    ColorItem ('Button selected',   Offset + 11,
    ColorItem ('Button disabled',   Offset + 12,
    ColorItem ('Button shortcut',   Offset + 13,
    ColorItem ('Button shadow',     Offset + 14,

    ColorItem ('Cluster normal',    Offset + 15,
    ColorItem ('Cluster selected',  Offset + 16,
    ColorItem ('Cluster shortcut',  Offset + 17,

    ColorItem ('Input normal',      Offset + 18,
    ColorItem ('Input selected',    Offset + 19,
    ColorItem ('Input arrow',       Offset + 20,

    ColorItem ('History button',    Offset + 21,
    ColorItem ('History sides',     Offset + 22,
    ColorItem ('History bar page',  Offset + 23,
    ColorItem ('History bar icons', Offset + 24,

    ColorItem ('List normal',       Offset + 25,
    ColorItem ('List focused',      Offset + 26,
    ColorItem ('List selected',     Offset + 27,
    ColorItem ('List divider',      Offset + 28,

    ColorItem('Information pane',  Offset + 29,
    Next))))))))))))))))))))))))))))));
end;

function HelpColorItems(const Next: PColorItem): PColorItem;

begin
  HelpColorItems :=
    ColorItem ('Frame passive',     128,
    ColorItem ('Frame active',      129,
    ColorItem ('Frame icons',       130,
    ColorItem ('Scroll bar page',   131,
    ColorItem ('Scroll bar icons',  132,
    ColorItem ('Normal text',       133,
    ColorItem ('Key word',          134,
    ColorItem ('Select key word',   135,
    Next))))))))
end;

function CharColorItems (const Next: PColorItem) : PColorItem;

begin
  CharColorItems :=
    ColorItem ('Character window', 136,
    Next)
end;

function SysColorItems (const Next: PColorItem) : PColorItem;

begin
  SysColorItems :=
    ColorItem ('Shadow',       137,
    ColorItem ('System error', 138,
    ColorItem ('Index error',  139,
    Next)))
end;

var

  D : PColorDialog;

begin
  D := New (PColorDialog,Init ('',
  ColorGroup ('Desktop',     DesktopColorItems(nil),
  ColorGroup ('Menus',       MenuColorItems(nil),
  ColorGroup ('Gray Windows',WindowColorItems(wpGrayWindow,nil),
  ColorGroup ('Blue Windows',WindowColorItems(wpBlueWindow,nil),
  ColorGroup ('Cyan Windows',WindowColorItems(wpCyanWindow,nil),
  ColorGroup ('Gray Dialogs',DlgColorItems(dpGrayDialog,nil),
  ColorGroup ('Blue Dialogs',DlgColorItems(dpBlueDialog,nil),
  ColorGroup ('Cyan Dialogs',DlgColorItems(dpCyanDialog,nil),
  ColorGroup ('Help',        HelpColorItems(nil),
  ColorGroup ('Selector',  CharColorItems(nil),
  ColorGroup ('System',      SysColorItems(nil),
  nil)))))))))))));
  D^.HelpCtx := hcColorDialog;
  if ExecuteDialog (D,Application^.GetPalette) <> cmCancel then
  begin
    DoneMemory; {dispose all group buffers}
    ReDraw;     {redraw application with new palette}
    ShadowAttr := GetColor (137);   {tv shadow color}
    SysColorAttr := (GetColor (138) shl 8) or
    GetColor (138);                 {tv system error color}
    ErrorAttr := GetColor (139)     {tv palette index error color}
  end
end;

{
Adjust 16 text colors at DAC level.
}

procedure AdjustPalette;

var

  D : PPalDlg;

begin
  D := New (PPalDlg,Init);
  D^.Options := D^.Options or ofCentered;
  D^.HelpCtx := hcPaletteDialog;
  if ExecuteDialog (D,nil) <> cmCancel then
    GetDACBlock (@DacPalette,0,256)
end;

{
Load .CFG file.
}

procedure LoadConfigFile (TW : PDirWindow);

var

  F : PathStr;

begin
  F := TreeFileName (TW,'CFG',true);
  if F <> '' then
    RestoreDeskTop (F)
end;

{
Save .CFG file.
}

procedure SaveConfigFile (TW : PDirWindow);

var

  F : PathStr;

begin
  F := TreeFileName (TW,'CFG',false);
  if F <> '' then
    SaveDeskTop (F)
end;

PROCEDURE CHAREDIT (D :PCHRSETEDITDLG );VAR I :INTEGER ;P :PCHREDITDLG ;BEGIN P :=
NEW (PCHREDITDLG , INIT (D ^. CHRVIEW ^. CHRVAL , FONTTABLE2 ));HIDEMOUSE ;ACCESSFONTMEM ;FOR I := 0 TO DEFCHRHEIGHT - 1
 DO P ^. CHREDITOR ^. FONTARRAY [ I ] := VGACHRTABLEPTR (VGACHRTABLELOC [ FONTTABLE2 ] )^[ D ^. CHRVIEW ^. CHRVAL *
VGAMAXCHRHEIGHT + I ] ;ACCESSSCREENMEM ;SHOWMOUSE ;P ^. HELPCTX := HCCHAREDITOR ;INSERTWINDOW (P );END ;
PROCEDURE CHARDELETE (D :PCHRSETEDITDLG );VAR I :INTEGER ;BEGIN HIDEMOUSE ;ACCESSFONTMEM ;FOR I := 0 TO DEFCHRHEIGHT - 1
 DO VGACHRTABLEPTR (VGACHRTABLELOC [ FONTTABLE2 ] )^[ D ^. CHRVIEW ^. CHRVAL * VGAMAXCHRHEIGHT + I ] := 0 ;
ACCESSSCREENMEM ;SHOWMOUSE END ;PROCEDURE CHARPASTE (D :PCHRSETEDITDLG );VAR I :INTEGER ;BEGIN HIDEMOUSE ;
ACCESSFONTMEM ;FOR I := 0 TO DEFCHRHEIGHT - 1  DO VGACHRTABLEPTR (VGACHRTABLELOC [ FONTTABLE2 ] )^[ D ^. CHRVIEW ^.
CHRVAL * VGAMAXCHRHEIGHT + I ] := VGACHRTABLEPTR (VGACHRTABLELOC [ FONTTABLE2 ] )^[ D ^. PASTECHR * VGAMAXCHRHEIGHT + I ]
;ACCESSSCREENMEM ;SHOWMOUSE END ;PROCEDURE CHARCHANGED (D :PCHREDITDLG );VAR I :INTEGER ;BEGIN HIDEMOUSE ;
ACCESSFONTMEM ;FOR I := 0 TO DEFCHRHEIGHT - 1  DO VGACHRTABLEPTR (VGACHRTABLELOC [ D ^. FONTTABLE ] )^[ D ^. CHRVAL *
VGAMAXCHRHEIGHT + I ] := D ^. CHREDITOR ^. FONTARRAY [ I ] ;ACCESSSCREENMEM ;SHOWMOUSE END ;PROCEDURE CHARINVERT
(D :PCHRSETEDITDLG );VAR I :INTEGER ;BEGIN HIDEMOUSE ;ACCESSFONTMEM ;FOR I := 0 TO DEFCHRHEIGHT - 1
 DO VGACHRTABLEPTR (VGACHRTABLELOC [ FONTTABLE2 ] )^[ D ^. CHRVIEW ^. CHRVAL * VGAMAXCHRHEIGHT + I ] :=
VGACHRTABLEPTR (VGACHRTABLELOC [ FONTTABLE2 ] )^[ D ^. CHRVIEW ^. CHRVAL * VGAMAXCHRHEIGHT + I ] XOR $ff ;
ACCESSSCREENMEM ;SHOWMOUSE END ;PROCEDURE CHARLEFT (D :PCHRSETEDITDLG );VAR I :INTEGER ;BEGIN HIDEMOUSE ;ACCESSFONTMEM ;
FOR I := 0 TO DEFCHRHEIGHT - 1  DO VGACHRTABLEPTR (VGACHRTABLELOC [ FONTTABLE2 ] )^[ D ^. CHRVIEW ^. CHRVAL *
VGAMAXCHRHEIGHT + I ] := VGACHRTABLEPTR (VGACHRTABLELOC [ FONTTABLE2 ] )^[ D ^. CHRVIEW ^. CHRVAL * VGAMAXCHRHEIGHT + I ]
SHL 1 ;ACCESSSCREENMEM ;SHOWMOUSE END ;PROCEDURE CHARRIGHT (D :PCHRSETEDITDLG );VAR I :INTEGER ;BEGIN HIDEMOUSE ;
ACCESSFONTMEM ;FOR I := 0 TO DEFCHRHEIGHT - 1  DO VGACHRTABLEPTR (VGACHRTABLELOC [ FONTTABLE2 ] )^[ D ^. CHRVIEW ^.
CHRVAL * VGAMAXCHRHEIGHT + I ] := VGACHRTABLEPTR (VGACHRTABLELOC [ FONTTABLE2 ] )^[ D ^. CHRVIEW ^. CHRVAL *
VGAMAXCHRHEIGHT + I ] SHR 1 ;ACCESSSCREENMEM ;SHOWMOUSE END ;PROCEDURE CHARUP (D :PCHRSETEDITDLG );VAR I :INTEGER ;
BEGIN HIDEMOUSE ;ACCESSFONTMEM ;FOR I := 0 TO DEFCHRHEIGHT - 2  DO VGACHRTABLEPTR (VGACHRTABLELOC [ FONTTABLE2 ] )^[ D ^.
CHRVIEW ^. CHRVAL * VGAMAXCHRHEIGHT + I ] := VGACHRTABLEPTR (VGACHRTABLELOC [ FONTTABLE2 ] )^[ D ^. CHRVIEW ^. CHRVAL *
VGAMAXCHRHEIGHT + I + 1 ] ;VGACHRTABLEPTR (VGACHRTABLELOC [ FONTTABLE2 ] )^[ D ^. CHRVIEW ^. CHRVAL * VGAMAXCHRHEIGHT +
DEFCHRHEIGHT - 1 ] := 0 ;ACCESSSCREENMEM ;SHOWMOUSE END ;PROCEDURE CHARDOWN (D :PCHRSETEDITDLG );VAR I :INTEGER ;
BEGIN HIDEMOUSE ;ACCESSFONTMEM ;FOR I := DEFCHRHEIGHT - 1 DOWNTO 1  DO VGACHRTABLEPTR (VGACHRTABLELOC [ FONTTABLE2 ] )^[
D ^. CHRVIEW ^. CHRVAL * VGAMAXCHRHEIGHT + I ] := VGACHRTABLEPTR (VGACHRTABLELOC [ FONTTABLE2 ] )^[ D ^. CHRVIEW ^.
CHRVAL * VGAMAXCHRHEIGHT + I - 1 ] ;VGACHRTABLEPTR (VGACHRTABLELOC [ FONTTABLE2 ] )^[ D ^. CHRVIEW ^. CHRVAL *
VGAMAXCHRHEIGHT ] := 0 ;ACCESSSCREENMEM ;SHOWMOUSE END ;

{
Force all oftileable windows to top.
}

procedure TileableOnTop (P : PView); far;

begin
  if (P^.Options and ofTileable = ofTileable) then
    P^.MakeFirst
end;

begin
  if Event.What = evCommand then
    case Event.Command of
      cmCascade : Desktop^.ForEach (@TileableOnTop);
      cmTile    : Desktop^.ForEach (@TileableOnTop);
      cmExit    : Event.Command := cmQuit
    end;
  inherited HandleEvent (Event);
  case Event.What of
    evCommand:
    begin
      case Event.Command of {process commands}
        cmLoadFont     : TreeWindow ('Load Font File','*.CGF',cmLoadFont);
        cmSaveFont     : TreeWindow ('Save Font File','*.CGF',cmSaveFont);
        cmLoadPCX      : TreeWindow ('Load PCX File','*.PCX',cmLoadPCX);
        cmSavePCX      : TreeWindow ('Save PCX File','*.PCX',cmSavePCX);
        cmSaveConfig   : TreeWindow ('Save Config Stream','*.CFG',cmSaveConfig);
        cmLoadConfig   : TreeWindow ('Load Config Stream','*.CFG',cmLoadConfig);
        cmDirChange    : ChangeDir;
        cmShellToDos   : ShellToDos;
        cmViewDoc      : ViewTextFile (appDocName);
        cmAbout        : AboutBox;
        cmCloseAll     : ClearDeskTop;
        cmCharSelector : CharSelector;
        cmScreenOpts   : ScreenOptions;
        cmColors       : Colors;
        cmAdjPal       : AdjustPalette;
        cmRestoreDef   : RestoreDefFont;
        cmToolBar      : ToolBar;
        cmBarHelp      : PutEvent (Event)
      else
        Exit
      end;
      ClearEvent (Event)
    end;
    evBroadcast :
    begin
      case Event.Command of {process broadcasts}
        cmCharEdit    : CharEdit (PChrSetEditDlg (Event.InfoPtr));
        cmCharDelete  : CharDelete (PChrSetEditDlg (Event.InfoPtr));
        cmCharPaste   : CharPaste (PChrSetEditDlg (Event.InfoPtr));
        cmCharChanged : CharChanged (PChrEditDlg (Event.InfoPtr));
        cmCharInvert  : CharInvert (PChrSetEditDlg (Event.InfoPtr));
        cmCharLeft    : CharLeft (PChrSetEditDlg (Event.InfoPtr));
        cmCharRight   : CharRight (PChrSetEditDlg (Event.InfoPtr));
        cmCharUp      : CharUp (PChrSetEditDlg (Event.InfoPtr));
        cmCharDown    : CharDown (PChrSetEditDlg (Event.InfoPtr));
        cmLoadFont    : LoadFontFile (PDirWindow (Event.InfoPtr));
        cmSaveFont    : SaveFontFIle (PDirWindow (Event.InfoPtr));
        cmLoadPCX     : LoadPCXFile (PDirWindow (Event.InfoPtr));
        cmSavePCX     : SavePCXFile(PDirWindow (Event.InfoPtr));
        cmSaveConfig  : SaveConfigFile (PDirWindow (Event.InfoPtr));
        cmLoadConfig  : LoadConfigFile (PDirWindow (Event.InfoPtr))
      else
        Exit
      end;
      ClearEvent (Event)
    end
  end
end;

{
Assign desk top pattern char, page locations, set default char height from
bios and save current DAC palette.
}

procedure TCyberEdit.InitDeskTop;

begin
  SetScreenMode (smCO80);              {make sure 80x25 active}
  inherited InitDeskTop;
  DeskTop^.Background^.Pattern := ''; {new wall paper}
  Page := vgaPageLoc[1];
  PageOfs := vgaPageOfsLoc[1];
  DefChrHeight := BiosGetChrHeight;
  GetDACBlock (@DacPalette,0,256)      {save current vga palette}
end;

{
Menu.
}

procedure TCyberEdit.InitMenuBar;

var

  R : TRect;

begin
  GetExtent (R);
  R.B.Y := R.A.Y+1;
  MenuBar := New (PMenuBar,Init (R,NewMenu (
    NewSubMenu ('~F~ile',hcFile,NewMenu (
    NewSubMenu ('~L~oad',hcLoadFile,NewMenu (
      NewItem ('~F~ont...','F3',kbF3,cmLoadFont,hcLoadFile,
      NewItem ('~P~CX...','Shift+F3',kbShiftF3,cmLoadPCX,hcLoadFile,
      NewItem ('~C~onfig...','Ctrl+F3',kbCtrlF3,cmLoadConfig,hcLoadFile,
      nil)))),
    NewSubMenu ('~S~ave',hcSaveFile,NewMenu (
      NewItem ('~F~ont...','F2',kbF2,cmSaveFont,hcSaveFile,
      NewItem ('~P~CX...','Shift+F2',kbShiftF2,cmSavePCX,hcSaveFile,
      NewItem ('~C~onfig...','Ctrl+F2',kbCtrlF2,cmSaveConfig,hcSaveFile,
      nil)))),
      NewLine (
      NewItem ('~C~hange dir...','',kbNoKey,cmDirChange,hcChangeDir,
      NewItem ('~D~os shell','F9',kbF9,cmShellToDos,hcDosShell,
      NewItem ('~V~iew doc','',kbNoKey,cmViewDoc,hcViewDoc,
      NewItem ('~A~bout','',kbNoKey,cmAbout,hcAbout,
      NewLine (
      NewItem ('E~x~it','Alt+X',kbAltX,cmQuit,hcExit,
      nil)))))))))),
    NewSubMenu('~W~indow',hcWindows,NewMenu(
      StdWindowMenuItems(
      NewLine (
      NewItem ('Selecto~r~','F7',kbF7,cmCharSelector,hcSelector,
      NewItem ('Tool ~b~ar','Shift+F7',kbShiftF7,cmToolBar,hcToolBar,
      nil))))),
    NewSubMenu ('~O~ptions',hcOptions,NewMenu (
      NewItem ('~S~creen...','',kbNoKey,cmScreenOpts,hcScreen,
      NewItem ('~C~olors...','',kbNoKey,cmColors,hcOColors,
      NewItem ('~A~djust palette...','',kbNoKey,cmAdjPal,hcAdjustPalette,
      NewItem ('~D~efault font','F4',kbNoKey,cmRestoreDef,hcDefaultFont,
      nil))))),nil))))))
end;

{
Status line.
}

procedure TCyberEdit.InitStatusLine;

var

  R : TRect;

begin
  GetExtent (R);
  R.A.Y := R.B.Y-1;
  StatusLine := New (PStatusLine,Init(R,
    NewStatusDef (0,$FFFF,
      NewStatusKey ('~F1~ Help', kbF1, cmHelp,
      NewStatusKey ('~Alt+F3~ Close',kbAltF3,cmClose,
      NewStatusKey ('~Alt+X~ Exit',kbAltX,cmQuit,
      NewStatusKey ('',kbF2,cmSaveFont,
      NewStatusKey ('',kbF3,cmLoadFont,
      NewStatusKey ('',kbShiftF2,cmSavePCX,
      NewStatusKey ('',kbShiftF3,cmLoadPCX,
      NewStatusKey ('',kbCtrlF2,cmSaveConfig,
      NewStatusKey ('',kbCtrlF3,cmLoadConfig,
      NewStatusKey ('',kbF4,cmRestoreDef,
      NewStatusKey ('',kbCtrlF5,cmResize,
      NewStatusKey ('',kbF7,cmCharSelector,
      NewStatusKey ('',kbShiftF7,cmToolBar,
      NewStatusKey ('',kbF10,cmMenu,
      nil)))))))))))))),nil)))
end;

{
Message when safety pool is cut into.
}

procedure TCyberEdit.OutOfMemory;

begin
  MessageBox (#3'Not enough memory available to complete operation.  Try closing some windows!',
  nil,mfError+mfOkButton)
end;

{
Load desk top from stream.
}

procedure TCyberEdit.LoadDesktop (var S : TStream);

var

  Pal : PString;

begin
  Pal := S.ReadStr;
  if Pal <> nil then
  begin
    Application^.GetPalette^ := Pal^;
    DoneMemory;
    DisposeStr (Pal)
  end
end;

{
Store desk top on stream.
}

procedure TCyberEdit.StoreDesktop(var S: TStream);

var

  Pal: PString;

begin
  Pal := @Application^.GetPalette^;
  S.WriteStr (Pal)
end;

{
If VGA is present then start TV app else print error message.
}

var

  CFApp : TCyberEdit;

begin
  if VGACardActive then
  begin
    CFApp.Init;
    SysErrorFunc := AppSystemError;
    CFApp.Run;
    CFApp.Done
  end
  else
    PrintStr (#13#10'VGA display required to run CyberEdit!'#13#10);
end.
