program SS_Base;
{
  To make  a new screen saver based on this screen saver,
  copy SS_BASE.PAS to a new source file, and SS_BASE.RES to a new resource file.
  After compiling, rename SS_BASE.EXE to your NEW_NAME.SCR.

  Thanks to  Manfred Keul, CIS [100031,12] for his SSAVEDEM.PAS demo program.

  This program copyright 1994 by Robert J. Norton, CIS [70017,1765]
  You may use this program freely for any non-commercial use.
}

uses
   OWindows, ODialogs, Wintypes, Winprocs, strings, SS_Unit;

{ ************* modify for a new type of screen saver ************* }
{$R ss_base.res        }     { configuration dialog resource        }
{$D SCRNSAVE Tuber RJN }     { name of saver for control panel      }
const AppName: pChar = 'Screen Saver.Tuber_RJN';
{ ***** after compiling, rename SS_BASE.EXE to (new name).SCR ***** }


type

   { Screen saving application type }
   TScreenSaverApp = object (TApplication)
      procedure InitMainWindow; virtual;
      function IdleAction: boolean; virtual;
      end;

   { Screen saver window type }
   PMySaverWin = ^TMySaverWin;
   TMySaverWin = Object(TSaverWin)
      Fog: integer;          { How much fog? }
      Phase: integer;        { Modulo count of disks. }
      zx, zy: integer;       { Highest legal values for X and Y. }
      cx, cy: integer;       { Corner of disk in X and Y }
      d, R, G, B: integer;   { Diameter, and color of disk. }
      vx, vy: integer;       { Velocity of disk. }
      NewPalette: hPalette;  { special palette for 8 bit, or 0 }
      constructor Init(aParent: PWindowsObject; aTitle:PChar);
      procedure Animate; virtual;
      destructor Done; virtual;
      end;

   { Screen saver configuration dialog }
   PMyConfigDlg = ^TMyConfigDlg;
   TMyConfigDlg = object(TConfigDlg)
      procedure SetUpWindow; virtual;
      procedure Ok(var Msg: Tmessage); virtual id_first + id_ok;
      end;

   { Dummy application type for configuration dialog. }
   TSaverConfigApp = object(TApplication)
      procedure InitMainWindow; virtual;
      end;


{ ************** TScreenSaverApp methods ********************************* }
procedure TScreenSaverApp.InitMainWindow;
begin
   MainWindow := new(PMySaverWin, init(nil, AppName));
   end;

{ Use up surplus CPU cycles amusing the user. }
function TScreenSaverApp.IdleAction: boolean;
begin
   PMySaverWin (MainWindow)^.Animate;         { invoke animation routine }
   IdleAction := true;                        { request more invokations }
   end;

{ ************** TMySaverWin methods *********************************}
constructor TMySaverWin.Init;
var
   TheDC: hDC;               { Display context of the screen. }
   MyLogPal: record          { local allocation TLogPal equivalent.}
      palVersion: Word;
      palNumEntries: Word;
      palPalEntry: array[0..215] of TPaletteEntry;  { 6*6*6 = 216 }
      end;
   Ri, Gi, Bi: integer;      { Working color. }
begin
   inherited Init (aParent, aTitle);
   randomize;                { Reshuffle random number generator }

   { Load into local variables some of the constants needed for operation }
   Fog := GetPrivateProfileInt(AppName, 'Fog', 0, 'CONTROL.INI');
   zx := GetSystemMetrics (SM_CXSCREEN) ;        { get screen dimensions }
   zy := GetSystemMetrics (SM_CYSCREEN) ;
   cx := zx div 2;                     { set starting position }
   cy := zy div 2;
   vx := 3;                            { set speed }
   vy := 3;
   d  := 80;                           { diameter }
   Phase := 0;                         { start of ring count. }
   R := 128;                           { Start at center of color cube }
   G := 128;
   B := 128;

   { Build special color cube palette if in 8 bit color mode. }
   TheDC := GetDC (hWindow);
   if GetDeviceCaps(TheDC, BitsPixel) = 8        { 256 color mode? }
   then begin                                    { build cheap color cube }
      MyLogPal.palVersion := 768; {=300h for Windows 3.0? }
      MyLogPal.palNumEntries := 216;
      for Ri := 0 to 5 do for Gi := 0 to 5 do for Bi := 0 to 5 do begin
         MyLogPal.palPalEntry[(Ri * 6 * 6) + (Gi * 6) + Bi ].peRed   := Ri * 51;
         MyLogPal.palPalEntry[(Ri * 6 * 6) + (Gi * 6) + Bi ].peGreen := Gi * 51;
         MyLogPal.palPalEntry[(Ri * 6 * 6) + (Gi * 6) + Bi ].peBlue  := Bi * 51;
         MyLogPal.palPalEntry[(Ri * 6 * 6) + (Gi * 6) + Bi ].peFlags := 0;
         end;
     NewPalette := CreatePalette(PLogPalette(@MyLogPal)^); { make it into an hPalette }
     if NewPalette = 0
     then messagebox(0, 'We failed to get a palette.', 'Error', MB_OK);
     end
   else NewPalette := 0;
   ReleaseDC (hWindow, TheDC);

   end;


{ This is the method done while passing time. }
procedure TMySaverWin.Animate;
  { Local function to wander a variable around the cube. }
  function Wander(OldVal: integer): integer;
  var
     Temp: integer;
  begin
     Temp := abs(OldVal + random(11) - 5);
     if Temp > 255 then Temp := 255 - (Temp - 255);
     Wander := Temp;
     end;
var
   TheDC: hDC;                         { Display context of screen. }
   OldBrush, NewBrush: hBrush;         { Brushes. }
   OldPen, NewPen: hPen;               { Pens. }
   OldPalette: hPalette;               { Temporary palette save. }
   Color: TColorRef;                   { Current disk color. }
   i: integer;
begin
   inherited Animate;
   Phase := (Phase + 1) mod 10;
   TheDC := GetDC (hWindow);

   if cx <= 5 then vx := abs(vx);         { reflect at boundaries }
   if cy <= 5 then vy := abs(vy);
   if (cx+d) >= (zx - 5) then vx := -abs(vx);
   if (cy+d) >= (zy - 5) then vy := -abs(vy);
   cx := cx + vx;                                   { calculate new position }
   cy := cy + vy;
   if random(100) < 10 then cx := cx - 1;
   if random(100) > 89 then cx := cx + 1;
   if random(100) < 10 then cy := cy - 1;
   if random(100) > 89 then cy := cy + 1;

   R := Wander(R);
   G := Wander(G);
   B := Wander(B);
   Color := RGB(R, G, B);

   { Fix up palette, build new brush and pen }
   if NewPalette <> 0 then begin
      OldPalette := SelectPalette(TheDC, NewPalette, false);
      RealizePalette(TheDC);
      NewBrush := CreateSolidBrush(PaletteRGB(R, G, B));
      if phase > 0 then NewPen := CreatePen(PS_SOLID, 1, PaletteRGB(R, G, B));
      end
   else begin
      NewBrush := CreateSolidBrush(GetNearestColor(TheDC, Color));
      if phase > 0 then NewPen := CreatePen(PS_SOLID, 1, GetNearestColor(TheDC, Color));
      end;

   { Select new brush and pen }
   OldBrush := SelectObject (TheDC, NewBrush);
   if Phase > 0 then OldPen   := SelectObject (TheDC, NewPen);

   for i := 1 to Fog         { Add fog if user asks for it. }
   do SetPixel(TheDC, random(Zx), random(Zy), 0);  { black fog }

   Ellipse(TheDC, cx, cy, cx+d, cy+d);             { paint disk }

   { Restore old brush and pen }
   SelectObject(TheDC, OldBrush);
   if phase > 0 then SelectObject(TheDC, OldPen);
   DeleteObject(NewBrush);
   if phase > 0 then DeleteObject(NewPen);

   if NewPalette <> 0 then begin  { Restore old palette if needed }
      SelectPalette(TheDC, OldPalette, false);
      end;

   ReleaseDC(hWindow, TheDC);
   end;

{ Fix up everything, the show is over. }
destructor TMySaverWin.Done;           { cleans up }
begin
   DeleteObject(NewPalette);
   inherited done;
   end;


{************************* TMyConfigDlg methods **************** }
{ Specific setup for this dialog. }
procedure TMyConfigDlg.SetUpWindow;
var
   FogValue: integer;        { Amount of fog. }
begin
   inherited SetUpWindow;
   FogValue := GetPrivateProfileInt(AppName, 'Fog', 0, 'CONTROL.INI');
   SetEditInteger(100, FogValue);      { preload box with current value }
   end;

{ When the Ok button is hit, check answer, update if acceptable. }
procedure TMyConfigDlg.Ok(var Msg: Tmessage);
var
   FogValue: integer;        { Amount of fog. }
   FogStr: string;           { Text of fog number for CONTROL.INI }
begin
   FogValue := GetEditInteger(100);
   if (0 <= FogValue) and (FogValue <= 1000)     { 1000% is a lot!}
   then begin
      Str(FogValue, FogStr);
      FogStr := FogStr + #0; { Make it PChar compatable. }
      WritePrivateProfileString(AppName, 'Fog', @FogStr[1], 'CONTROL.INI');
      inherited Ok(Msg);
      end
   else MessageBox(hWindow, 'Try a number from 0 to 100.', 'Fog value?', mb_ok);
   end;


{ ********TSaverConfigApp methods ****** }
procedure TSaverConfigApp.InitMainWindow;
begin
   MainWindow := new(PMyConfigDlg, init(AppName, 'CONFIG_DLG'));
   end;

var
   ScrSavApp: TScreenSaverApp;         { Main screen saver application. }
   ConfigApp: TSaverConfigApp;         { Dummy configuration application. }

begin
   if hPrevInst <> 0 then halt;        { don't start twice }

   if (pos('c', ParamStr(1)) <> 0)     { 's' for saver, 'c' for config }
   or (pos('C', ParamStr(1)) <> 0)
   then begin
      ConfigApp.Init(AppName);
      ConfigApp.Run;
      ConfigApp.Done;
      end
   else begin
      ScrSavApp.Init(AppName);
      ScrSavApp.Run;
      ScrSavApp.Done;
      end;
   end.

