{$I SHDEFINE.INC}

{$IFDEF Gen87}
  {$N+,E+}
{$ELSE}
  {$N-}
{$ENDIF}

{$IFNDEF EmulationOK}
  {$E-}
{$ENDIF}

program TestCmdL;
{
                       To test the ShCmdLin unit

                  Copyright 1991 Madison & Associates
                          All Rights Reserved

         This program source file and the associated executable
         file may be  used and distributed  only in  accordance
         with the  provisions  described  on  the title page of
                  the accompanying documentation file
                              SKYHAWK.DOC
}

uses
{$IFDEF OverlaysOK}
  OverCmdl,
  Overlay,
{$ENDIF}

  TpDos,
  TpCrt,
  ShCmdLin,
  ShList,
  ShUtilPk;

{$IFDEF OverlaysOK}
  {$F+}
  {$O SHCMDLIN.TPU}
  {$O SHLIST.TPU}
  {$O TPDOS.TPU}
{$ENDIF}


const
  VT  : array[VtStr..VtInt] of string = ('String ',
                                         'Real   ',
                                         'Integer');

var
  S1      : string;
  Y       : SwRec;
  Err     : Integer;
  OT      : text;

procedure AnyKey;
  begin
    if HandleIsConsole(1) then begin
      Write('Any key to continue...');
      if ReadKey = #0 then ;
      WriteLn;
      end;
    end;

function ValStr : string;
  var
    S2  : string;
  begin
    case Y.SwVal of
      VtStr   : ValStr := Y.StrVal;
      VtReal  : begin
                  Str(Y.RealVal, S2);
                  ValStr := S2;
                  end;
      VtInt   : begin
                  Str(Y.IntVal, S2);
                  ValStr := S2;
                  end;
      end;
    end; {ValStr}

begin

  if not OpenStdDev(OT, 1) then begin
    WriteLn('Can''t open console device.');
    Halt(1);
    end;
  S1  := string(Ptr(PrefixSeg, $80)^);
  WriteLn(OT, ^M^J^M^J,'':8,'The command tail is');
  WriteLn(OT, '':8, S1);
  WriteLn(OT, '':8,'MaxAvail = ',MaxAvail);
  WriteLn(OT, '':8,'MemAvail = ',MemAvail);
  WriteLn(OT);
  ClInit;
  ClParse(Nil, false, [';', '-']+[ReadSwCh], [':', '='], Err);
  WriteLn(OT, '':10, 'Error return = ', Err);
  if ExistFile('DoPop') then
    while PopSwitch(Y) do begin
      WriteLn(OT, '':10, 'Name = ', Y.Name);
      WriteLn(OT, '':10, 'Value type = ', VT[Y.SwVal]);
      WriteLn(OT, '':10, 'Switch Value = ', ValStr);
      WriteLn(OT, '':10, 'MaxAvail = ',MaxAvail);
      WriteLn(OT, '':10, 'MemAvail = ',MemAvail);
      WriteLn(OT);
      AnyKey;
      end {while}
  else begin
    while GetSwitch(Y) do begin
      WriteLn(OT, '':10, 'Name = ', Y.Name);
      WriteLn(OT, '':10, 'Value type = ', VT[Y.SwVal]);
      WriteLn(OT, '':10, 'Switch Value = ', ValStr);
      WriteLn(OT, '':10, 'MaxAvail = ',MaxAvail);
      WriteLn(OT, '':10, 'MemAvail = ',MemAvail);
      WriteLn(OT);
      AnyKey;
      end; {while}
    ClClose;
    end; {else}
  WriteLn(OT, '':8, 'Final memory values:');
  WriteLn(OT, '':10,'MaxAvail = ',MaxAvail);
  WriteLn(OT, '':10,'MemAvail = ',MemAvail);
  if Err <> 0 then begin
    WriteLn(OT);
      AnyKey;
    end;
  Flush(OT);
  end.
