{ This is a demonstration of the equipment routines
  provided by the Pascal Wizard's Library }



{$M $2000,0,0 }          { stack size, min heap, max heap (bytes) }
{$D-}                    { debug info off }
{$A-}                    { word alignment off (so use byte alignment) }
{$I-}                    { don't crash on errors }



USES
   Equipment, Mouse;

VAR
   Long1, Long2: LongInt;    { generic variable names for this simple demo }
   Int1, Int2: Integer;
   Bool1: Boolean;

BEGIN
   WriteLn('EQUIPMT  Demo for the PasWiz Library equipment unit');
   WriteLn;

   Write('CPU type: ');
   CASE Processor OF
      0: WriteLn('NEC V20');
      1: WriteLn('8088 or 8086');
      2: WriteLn('80186');
      3: WriteLn('80286');
      4: WriteLn('80386');
      5: WriteLn('80486');
      ELSE WriteLn('Unknown');
   END;
   WriteLn;

   WriteLn('Total extended memory: ', AllExtMem, ' Kb');
   WriteLn('Current extended mem : ', GetExtM, ' Kb');
   GetXMSm(Long1, Long2);
   WriteLn('Available XMS memory : ', Long2, ' Kb');
   WriteLn;
   GetEMSm(Int1, Int2);
   WriteLn('Total EMS memory : ', Int1 * 16, ' Kb');
   WriteLn('Available EMS mem: ', Int2 * 16, ' Kb');
   WriteLn;

   IF EnhKbd THEN
      WriteLn('Enhanced (101-key) keyboard')
   ELSE
      WriteLn('Old-style keyboard');
   WriteLn;

   FloppyType(Int1, Int2);
   Write('Drive A: ');
   CASE Int1 OF
      0: WriteLn('doesn''t exist');
      1: WriteLn('360K');
      2: WriteLn('1.2M');
      3: WriteLn('720K');
      4: WriteLn('1.44M');
      5: WriteLn('2.88M');
      ELSE WriteLn('unknown type');
   END;
   Write('Drive B: ');
   CASE Int2 OF
      0: WriteLn('doesn''t exist');
      1: WriteLn('360K');
      2: WriteLn('1.2M');
      3: WriteLn('720K');
      4: WriteLn('1.44M');
      5: WriteLn('2.88M');
      ELSE WriteLn('unknown type');
   END;
   IF CDROM > 0 THEN
      WriteLn('CD-ROM attached');
   WriteLn;

   GetDisplay(Int1, Bool1);
   Write('Display: ');
   IF Bool1 THEN
      Write('Mono ')
   ELSE
      Write('Color ');
   CASE Int1 OF
      1: WriteLn('MDA');
      2: WriteLn('Hercules');
      3: WriteLn('CGA');
      4: WriteLn('EGA');
      5: WriteLn('MCGA');
      6: WriteLn('VGA');
      ELSE WriteLn('Unknown display type');
   END;
   WriteLn;

   WriteLn('COM ports: ', CommPorts);
   WriteLn('LPT ports: ', PrtPorts);
   WriteLn;

   Int1 := Mouse.Init;
   IF Int1 > 0 THEN
      WriteLn(Int1, '-button mouse')
   ELSE
      WriteLn('No mouse');

END.
