UNIT OdbcSQL;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

{$A+,I-,R-,S-,V-,B-,G+,X+,W-}

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

INTERFACE

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

USES

   WinTypes,
   WinProcs;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

CONST

   {From SQL}

   {-Generally useful constants}
   SQLNTS                =  -3; (* NTS = Null Terminated String  *)
   SQL_SQLSTATE_SIZE      =   5; (* size of SQLSTATE              *)
   SQL_MAX_MESSAGE_LENGTH = 512; (* message buffer size           *)
   SQL_MAX_DSN_LENGTH     =  32; (* maximum data source name size *)

   {-RetCodes}
   SQLError           = -1;
   SQLInvalidHandle   = -2;
   SQLNeedData        = 99;
   SQLNoDataFound     = 100;
   SQLSuccess         = 0;
   SQLSuccessWithInfo = 1;

   {-SQLFreeStmt defines}
   SQLClose        = 0;
   SQLDrop         = 1;
   SQLUnbind       = 2;
   SQLResetParams  = 3;

   {-SQLSetParam defines}
   SQL_C_DEFAULT = 99;

   {-SQLTransact defines}
   SQL_COMMIT   = 0;
   SQL_ROLLBACK = 1;

   {-Standard SQL datatypes, using ANSI type numbering}
   SQLChar     = 1;
   SQLNumeric  = 2;
   SQLDecimal  = 3;
   SQLInteger  = 4;
   SQLSmallInt = 5;
   SQLFloat    = 6;
   SQLReal     = 7;
   SQLDouble   = 8;
   SQLVarChar  = 12;

   {SQL_TYPE_MIN  = 1; Overridden below}
   SQL_TYPE_NULL = 0;
   SQL_TYPE_MAX  = 12;

   {-C datatype to SQL datatype mapping}
   SQL_C_CHAR   = SQLCHAR;      (* CHAR, VARCHAR, DECIMAL, NUMERIC *)
   SQL_C_LONG   = SQLInteger;   (* Integer          *)
   SQL_C_SHORT  = SQLSMALLINT;  (* SMALLINT         *)
   SQL_C_FLOAT  = SQLREAL;      (* REAL             *)
   SQL_C_DOUBLE = SQLDOUBLE;    (* FLOAT, DOUBLE    *)

   {-NULL status constants.  These are used in SQLColumns, SQLColAttributes,
   SQLDescribeCol, and SQLSpecialColumns to describe the nullablity of a
   column in a table.  SQL_NULLABLE_UNKNOWN can be returned only by
   SQLDescribeCol or SQLColAttributes.  It is used when the DBMS's meta-data
   does not contain this info}
   SQL_NO_NULLS         = 0;
   SQL_NULLABLE         = 1;
   SQL_NULLABLE_UNKNOWN = 2;

   {-Special length values}
   SQL_NULL_DATA      = -1;
   SQL_DATA_AT_EXEC   = -2;

   {-SQLColAttributes defines}
   SQL_COLUMN_COUNT          = 0;
   SQL_COLUMN_NAME           = 1;
   SQL_COLUMN_TYPE           = 2;
   SQL_COLUMN_LENGTH         = 3;
   SQL_COLUMN_PRECISION      = 4;
   SQL_COLUMN_SCALE          = 5;
   SQL_COLUMN_DISPLAY_SIZE   = 6;
   SQL_COLUMN_NULLABLE       = 7;
   SQL_COLUMN_UNSIGNED       = 8;
   SQL_COLUMN_MONEY          = 9;
   SQL_COLUMN_UPDATABLE      = 10;
   SQL_COLUMN_AUTO_INCREMENT = 11;
   SQL_COLUMN_CASE_SENSITIVE = 12;
   SQL_COLUMN_SEARCHABLE     = 13;
   SQL_COLUMN_TYPE_NAME      = 14;

   {-SQLColAttributes subdefines for SQL_COLUMN_UPDATABLE}
   SQL_ATTR_READONLY          = 0;
   SQL_ATTR_WRITE             = 1;
   SQL_ATTR_READWRITE_UNKNOWN = 2;

   {-SQLColAttributes subdefines for SQL_COLUMN_SEARCHABLE, also used
    by SQLGetInfo}
   SQL_UNSEARCHABLE    = 0;
   SQL_LIKE_ONLY       = 1;
   SQL_ALL_EXCEPT_LIKE = 2;
   SQL_SEARCHABLE      = 3;

   {-SQLError defines}
   SQLNullHEnv  = NIL;
   SQLNullHDbc  = NIL;
   SQLNullHStmt = NIL;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

TYPE

   TRetCode = Integer;
   HEnv = Pointer;
   HDbc = Pointer;
   HStmt = Pointer;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

CONST

   {From SQLExt}

(* Additional return codes *)
   SQLStillExecuting = 2;

(* SQL extended datatypes *)
   SQLDate          = 9;
   SQLTime          = 10;
   SQLTimeStamp     = 11;
   SQLLongVarChar   = -1;
   SQLBinary        = -2;
   SQLVarBinary     = -3;
   SQLLongVarBinary = -4;
   SQLBigInt        = -5;
   SQLTinyInt       = -6;
   SQLBit           = -7;

(* C datatype to SQL datatype mapping *)
   SQL_C_DATE      = SQLDate;
   SQL_C_TIME      = SQLTime;
   SQL_C_TIMESTAMP = SQLTimeStamp;
   SQL_C_BINARY    = SQLBinary;
   SQL_C_BIT       = SQLBit;
   SQL_C_TINYINT   = SQLTinyInt;

(* overrides const in the SQL unit *)
   SQL_TYPE_MIN    = -7;
   SQLAllTypes   = 0;

(* Access modes *)
   SQL_MODE_READ_WRITE  = 0;
   SQL_MODE_READ_ONLY   = 1;

(* Options for SQLDriverConnect *)
   SQLDriverNoPrompt         = 0;
   SQLDriverComplete         = 1;
   SQLDriverPrompt			  = 2;
   SQLDriverCompleteRequired = 3;

(* Special return values for SQLGetData *)
   SQL_NO_TOTAL   = -4;

(* Defines for SQLGetFunctions *)
   SQL_API_SQLALLOCCONNECT     = 1;    (* Core Functions           *)
   SQL_API_SQLALLOCENV         = 2;
   SQL_API_SQLALLOCSTMT        = 3;
   SQL_API_SQLBINDCOL          = 4;
   SQL_API_SQLCANCEL           = 5;
   SQL_API_SQLCOLATTRIBUTES    = 6;
   SQL_API_SQLCONNECT          = 7;
   SQL_API_SQLDESCRIBECOL      = 8;
   SQL_API_SQLDISCONNECT       = 9;
   SQL_API_SQLERROR            = 10;
   SQL_API_SQLEXECDIRECT       = 11;
   SQL_API_SQLEXECUTE          = 12;
   SQL_API_SQLFETCH            = 13;
   SQL_API_SQLFREECONNECT      = 14;
   SQL_API_SQLFREEENV          = 15;
   SQL_API_SQLFREESTMT         = 16;
   SQL_API_SQLGETCURSORNAME    = 17;
   SQL_API_SQLNUMRESULTCOLS    = 18;
   SQL_API_SQLPREPARE          = 19;
   SQL_API_SQLROWCOUNT         = 20;
   SQL_API_SQLSETCURSORNAME    = 21;
   SQL_API_SQLSETPARAM         = 22;
   SQL_API_SQLTRANSACT         = 23;

   SQL_NUM_FUNCTIONS           = 23;

   SQL_EXT_API_START           = 40;

   SQL_API_SQLCOLUMNS          = 40;   (* Level 1 Functions        *)
   SQL_API_SQLDRIVERCONNECT    = 41;
   SQL_API_SQLGETCONNECTOPTION = 42;
   SQL_API_SQLGETDATA          = 43;
   SQL_API_SQLGETFUNCTIONS     = 44;
   SQL_API_SQLGETINFO          = 45;
   SQL_API_SQLGETSTMTOPTION    = 46;
   SQL_API_SQLGETTYPEINFO      = 47;
   SQL_API_SQLPARAMDATA        = 48;
   SQL_API_SQLPUTDATA          = 49;
   SQL_API_SQLSETCONNECTOPTION = 50;
   SQL_API_SQLSETSTMTOPTION    = 51;
   SQL_API_SQLSPECIALCOLUMNS   = 52;
   SQL_API_SQLSTATISTICS       = 53;
   SQL_API_SQLTABLES           = 54;

   SQL_API_SQLBROWSECONNECT    = 55;    (* Level 2 Functions        *)
   SQL_API_SQLCOLUMNPRIVILEGES = 56;
   SQL_API_SQLDATASOURCES      = 57;
   SQL_API_SQLDESCRIBEPARAM    = 58;
   SQL_API_SQLEXTENDEDFETCH    = 59;
   SQL_API_SQLFOREIGNKEYS      = 60;
   SQL_API_SQLMORERESULTS      = 61;
   SQL_API_SQLNATIVESQL        = 62;
   SQL_API_SQLNUMPARAMS        = 63;
   SQL_API_SQLPARAMOPTIONS     = 64;
   SQL_API_SQLPRIMARYKEYS      = 65;
   SQL_API_SQLPROCEDURECOLUMNS = 66;
   SQL_API_SQLPROCEDURES       = 67;
   SQL_API_SQLSETPOS           = 68;
   SQL_API_SQLSETSCROLLOPTIONS = 69;
   SQL_API_SQLTABLEPRIVILEGES  = 70;

   SQL_EXT_API_LAST            = 70;

   SQL_NUM_EXTENSIONS = SQL_EXT_API_LAST - SQL_EXT_API_START + 1;

(* Defines for SQLGetInfo *)
   SQL_INFO_FIRST                       = 0;
   SQLActiveConnections                 = 0;
   SQLActiveStatements                  = 1;
   SQL_DATA_SOURCE_NAME                 = 2;
   SQL_DRIVER_HDBC                      = 3;
   SQL_DRIVER_HENV                      = 4;
   SQL_DRIVER_HSTMT                     = 5;
   SQL_DRIVER_NAME                      = 6;
   SQL_DRIVER_VER                       = 7;
   SQL_FETCH_DIRECTION                  = 8;
   SQL_ODBC_API_CONFORMANCE             = 9;
   SQL_ODBC_VER                        = 10;
   SQL_ROW_UPDATES                     = 11;
   SQL_ODBC_SAG_CLI_CONFORMANCE        = 12;
   SQL_SERVER_NAME                     = 13;
   SQL_SEARCH_PATTERN_ESCAPE           = 14;
   SQL_ODBC_SQL_CONFORMANCE            = 15;

   SQL_DATABASE_NAME                   = 16;
   SQL_DBMS_NAME                       = 17;
   SQL_DBMS_VER                        = 18;

   SQL_ACCESSIBLE_TABLES               = 19;
   SQL_ACCESSIBLE_PROCEDURES           = 20;
   SQL_PROCEDURES                      = 21;
   SQL_CONCAT_NULL_BEHAVIOR            = 22;
   SQL_CURSOR_COMMIT_BEHAVIOR          = 23;
   SQL_CURSOR_ROLLBACK_BEHAVIOR        = 24;
   SQL_DATA_SOURCE_READ_ONLY           = 25;
   SQL_DEFAULT_TXN_ISOLATION           = 26;
   SQL_EXPRESSIONS_IN_ORDERBY          = 27;
   SQL_IDENTIFIER_CASE                 = 28;
   SQL_IDENTIFIER_QUOTE_CHAR           = 29;
   SQL_MAX_COLUMN_NAME_LEN             = 30;
   SQL_MAX_CURSOR_NAME_LEN             = 31;
   SQL_MAX_OWNER_NAME_LEN              = 32;
   SQL_MAX_PROCEDURE_NAME_LEN          = 33;
   SQL_MAX_QUALIFIER_NAME_LEN          = 34;
   SQL_MAX_TABLE_NAME_LEN              = 35;
   SQL_MULT_RESULT_SETS                = 36;
   SQL_MULTIPLE_ACTIVE_TXN             = 37;
   SQL_OUTER_JOINS                     = 38;
   SQL_OWNER_TERM                      = 39;
   SQL_PROCEDURE_TERM                  = 40;
   SQL_QUALIFIER_NAME_SEPARATOR        = 41;
   SQL_QUALIFIER_TERM                  = 42;
   SQL_SCROLL_CONCURRENCY              = 43;
   SQL_SCROLL_OPTIONS                  = 44;
   SQL_TABLE_TERM                      = 45;
   SQL_TXN_CAPABLE                     = 46;
   SQL_USER_NAME                       = 47;

   SQL_CONVERT_FUNCTIONS               = 48;
   SQL_NUMERIC_FUNCTIONS               = 49;
   SQL_STRING_FUNCTIONS                = 50;
   SQL_SYSTEM_FUNCTIONS                = 51;
   SQL_TIMEDATE_FUNCTIONS              = 52;

   SQL_CONVERT_BIGINT                  = 53;
   SQL_CONVERT_BINARY                  = 54;
   SQL_CONVERT_BIT                     = 55;
   SQL_CONVERT_CHAR                    = 56;
   SQL_CONVERT_DATE                    = 57;
   SQL_CONVERT_DECIMAL                 = 58;
   SQL_CONVERT_DOUBLE                  = 59;
   SQL_CONVERT_FLOAT                   = 60;
   SQL_CONVERT_INTEGER                 = 61;
   SQL_CONVERT_LONGVARCHAR             = 62;
   SQL_CONVERT_NUMERIC                 = 63;
   SQL_CONVERT_REAL                    = 64;
   SQL_CONVERT_SMALLINT                = 65;
   SQL_CONVERT_TIME                    = 66;
   SQL_CONVERT_TIMESTAMP               = 67;
   SQL_CONVERT_TINYINT                 = 68;
   SQL_CONVERT_VARBINARY               = 69;
   SQL_CONVERT_VARCHAR                 = 70;
   SQL_CONVERT_LONGVARBINARY           = 71;

   SQL_TXN_ISOLATION_OPTION            = 72;
   SQL_ODBC_SQL_OPT_IEF                = 73;

   SQL_INFO_LAST                       = 73;
   SQL_INFO_DRIVER_START               = 1000;

(* "SQL_CONVERT_" return value bitmasks *)

   SQL_CVT_CHAR                        = $00000001;
   SQL_CVT_NUMERIC                     = $00000002;
   SQL_CVT_DECIMAL                     = $00000004;
   SQL_CVT_INTEGER                     = $00000008;
   SQL_CVT_SMALLINT                    = $00000010;
   SQL_CVT_FLOAT                       = $00000020;
   SQL_CVT_REAL                        = $00000040;
   SQL_CVT_DOUBLE                      = $00000080;
   SQL_CVT_VARCHAR                     = $00000100;
   SQL_CVT_LONGVARCHAR                 = $00000200;
   SQL_CVT_BINARY                      = $00000400;
   SQL_CVT_VARBINARY                   = $00000800;
   SQL_CVT_BIT                         = $00001000;
   SQL_CVT_TINYINT                     = $00002000;
   SQL_CVT_BIGINT                      = $00004000;
   SQL_CVT_DATE                        = $00008000;
   SQL_CVT_TIME                        = $00010000;
   SQL_CVT_TIMESTAMP                   = $00020000;
   SQL_CVT_LONGVARBINARY               = $00040000;

(* Conversion functions *)
   SQL_FN_CVT_CONVERT                  = $00000001;

(* String functions *)

   SQL_FN_STR_CONCAT                   = $00000001;
   SQL_FN_STR_INSERT                   = $00000002;
   SQL_FN_STR_LEFT                     = $00000004;
   SQL_FN_STR_LTRIM                    = $00000008;
   SQL_FN_STR_LENGTH                   = $00000010;
   SQL_FN_STR_LOCATE                   = $00000020;
   SQL_FN_STR_LCASE                    = $00000040;
   SQL_FN_STR_REPEAT                   = $00000080;
   SQL_FN_STR_REPLACE                  = $00000100;
   SQL_FN_STR_RIGHT                    = $00000200;
   SQL_FN_STR_RTRIM                    = $00000400;
   SQL_FN_STR_SUBSTRING                = $00000800;
   SQL_FN_STR_UCASE                    = $00001000;
   SQL_FN_STR_ASCII                    = $00002000;
   SQL_FN_STR_CHAR                     = $00004000;

(* Numeric functions *)

   SQL_FN_NUM_ABS                      = $00000001;
   SQL_FN_NUM_ACOS                     = $00000002;
   SQL_FN_NUM_ASIN                     = $00000004;
   SQL_FN_NUM_ATAN                     = $00000008;
   SQL_FN_NUM_ATAN2                    = $00000010;
   SQL_FN_NUM_CEILING                  = $00000020;
   SQL_FN_NUM_COS                      = $00000040;
   SQL_FN_NUM_COT                      = $00000080;
   SQL_FN_NUM_EXP                      = $00000100;
   SQL_FN_NUM_FLOOR                    = $00000200;
   SQL_FN_NUM_LOG                      = $00000400;
   SQL_FN_NUM_MOD                      = $00000800;
   SQL_FN_NUM_SIGN                     = $00001000;
   SQL_FN_NUM_SIN                      = $00002000;
   SQL_FN_NUM_SQRT                     = $00004000;
   SQL_FN_NUM_TAN                      = $00008000;
   SQL_FN_NUM_PI                       = $00010000;
   SQL_FN_NUM_RAND                     = $00020000;

(* Time/date functions *)

   SQL_FN_TD_NOW                       = $00000001;
   SQL_FN_TD_CURDATE                   = $00000002;
   SQL_FN_TD_DAYOFMONTH                = $00000004;
   SQL_FN_TD_DAYOFWEEK                 = $00000008;
   SQL_FN_TD_DAYOFYEAR                 = $00000010;
   SQL_FN_TD_MONTH                     = $00000020;
   SQL_FN_TD_QUARTER                   = $00000040;
   SQL_FN_TD_WEEK                      = $00000080;
   SQL_FN_TD_YEAR                      = $00000100;
   SQL_FN_TD_CURTIME                   = $00000200;
   SQL_FN_TD_HOUR                      = $00000400;
   SQL_FN_TD_MINUTE                    = $00000800;
   SQL_FN_TD_SECOND                    = $00001000;

(* System functions *)

   SQL_FN_SYS_USERNAME                 = $00000001;
   SQL_FN_SYS_DBNAME                   = $00000002;
   SQL_FN_SYS_IFNULL                   = $00000004;

(* Scroll option masks *)

   SQL_SO_FORWARD_ONLY                 = $00000001;
   SQL_SO_KEYSET_DRIVEN                = $00000002;
   SQL_SO_DYNAMIC                      = $00000004;
   SQL_SO_MIXED                        = $00000008;

(* Scroll concurrency option masks *)

   SQL_SCCO_READ_ONLY                  = $00000001;
   SQL_SCCO_LOCK                       = $00000002;
   SQL_SCCO_OPT_TIMESTAMP              = $00000004;
   SQL_SCCO_OPT_VALUES                 = $00000008;

(* Fetch direction option masks *)

   SQL_FD_FETCH_NEXT                   = $00000001;
   SQL_FD_FETCH_FIRST                  = $00000002;
   SQL_FD_FETCH_LAST                   = $00000004;
   SQL_FD_FETCH_PREV                   = $00000008;
   SQL_FD_FETCH_ABSOLUTE               = $00000010;
   SQL_FD_FETCH_RELATIVE               = $00000020;
   SQL_FD_FETCH_RESUME                 = $00000040;

(* Transaction isolation option masks *)

   SQL_TXN_READ_UNCOMMITTED            = $00000001;
   SQL_TXN_READ_COMMITTED              = $00000002;
   SQL_TXN_REPEATABLE_READ             = $00000004;
   SQL_TXN_SERIALIZABLE                = $00000008;
   SQL_TXN_VERSIONING                  = $00000010;

(* options for SQLGetStmtOption/SQLSetStmtOption *)
   SQL_QUERY_TIMEOUT       = 0;
   SQL_MAX_ROWS            = 1;
   SQL_NOSCAN              = 2;
   SQL_MAX_LENGTH          = 3;
   SQL_ASYNC_ENABLE        = 4;
   SQL_BIND_TYPE           = 5;

   SQL_BIND_BY_COLUMN      = 0;    (* Suboption for SQL_BIND_TYPE *)

(* options for SQLSetConnectOption/SQLGetConnectOption *)
   SQL_ACCESS_MODE         = 101;
   SQL_AUTOCOMMIT          = 102;
   SQL_LOGIN_TIMEOUT       = 103;
   SQL_OPT_TRACE           = 104;
   SQL_OPT_TRACEFILE       = 105;
   SQL_TRANSLATE_DLL       = 106;
   SQL_TRANSLATE_OPTION    = 107;
   SQL_TXN_ISOLATION       = 108;
   SQL_CONNECT_OPT_DRVR_START  = 1000;

(*  Column types and scopes in SQLSpecialColumns.  *)
   SQL_BEST_ROWID = 1;
   SQL_ROWVER     = 2;

   SQL_SCOPE_CURROW       = 0;
   SQL_SCOPE_TRANSACTION  = 1;
   SQL_SCOPE_SESSION      = 2;

(* SQLExtendedFetch "fFetchType" values *)
   SQLFetchNext      = 1;
   SQLFetchFirst     = 2;
   SQLFetchLast      = 3;
   SQLFetchPrev      = 4;
   SQLFetchAbsolute  = 5;
   SQLFetchRelative  = 6;
   SQLFetchResume    = 7;

(* SQLExtendedFetch "rgfRowStatus" element values *)
   SQL_ROW_SUCCESS     = 0;
   SQL_ROW_DELETED     = 1;
   SQL_ROW_UPDATED     = 2;
   SQL_ROW_NOROW       = 3;

(* Defines for SQLForeignKeys (returned in result set) *)
   SQL_CASCADE         = 0;
   SQL_RESTRICT        = 1;
   SQL_SET_NULL        = 2;

(* Defines for SQLProcedureColumns (returned in the result set) *)
   SQL_PARAM_TYPE_UNKNOWN  = 0;
   SQL_PARAM_INPUT         = 1;
   SQL_PARAM_INPUT_OUTPUT  = 2;
   SQL_RESULT_COL          = 3;

(* Defines for SQLSetScrollOptions *)
   SQL_CONCUR_READ_ONLY    = 1;
   SQL_CONCUR_LOCK         = 2;
   SQL_CONCUR_TIMESTAMP    = 3;
   SQL_CONCUR_VALUES       = 4;

   SQL_SCROLL_FORWARD_ONLY   = 0;
   SQL_SCROLL_KEYSET_DRIVEN  = -1;
   SQL_SCROLL_DYNAMIC        = -2;

(* Defines for SQLStatistics *)
   SQL_INDEX_UNIQUE    = 0;
   SQL_INDEX_ALL       = 1;
   SQL_ENSURE          = 1;
   SQL_QUICK           = 0;

(* Defines for SQLStatistics (returned in the result set) *)
   SQL_TABLE_STAT      = 0;
   SQL_INDEX_CLUSTERED = 1;
   SQL_INDEX_HASHED    = 2;
   SQL_INDEX_OTHER     = 3;

(* Defines for SQLSetPos *)
   SQL_ENTIRE_ROWSET   = 0;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

type

   date_struct = record
                    year : integer;
                    month : word;
                    day : word;
                 end;
   time_struc = record
                   hour : word;
                   minute : word;
                   second : word;
                end;
   timestamp_struct = record
                         year : integer;
                         month : word;
                         day : word;
                         hour : word;
                         minute : word;
                         second : word;
                         fraction : longint;
                      end;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

TYPE

   {Mine}
   {From SQL}
   TSQLAllocConnect = FUNCTION(Env : hEnv;
                              VAR Dbc : hDbc) : TRetCode;

   TSQLAllocEnv = FUNCTION(VAR Env : hEnv) : TRetCode;

   TSQLAllocStmt = FUNCTION (Dbc : hDbc;
                            VAR Stmt : hStmt) : TRetCode;

   TSQLBindCol = FUNCTION (Stmt : hStmt;
                    ColumnNo : Word;
                    FCType : Integer;
                    DataPtr : Pointer;
                    DataLen : LongInt;
                    VAR DataLenReturned : LongInt) : TRetCode;

   TSQLCancel = FUNCTION(Stmt : hStmt) : TRetCode;

   TSQLColAttributes = FUNCTION (Stmt : hStmt;
                          ICol : Word;
                          FDescType : Word;
                          RGBDesc : Pointer;
                          CBDescMax : Integer;
                          VAR CBDesc : Integer;
                          VAR FDesc : LongInt) : TRetCode;

   TSQLConnect = FUNCTION(Dbc : hDbc;
                    szDSN : PChar;
                    cbdsn : Integer;
                    szuid : PChar;
                    cbuid : Integer;
                    szauthstr : PChar;
                    cbauthstr : Integer) : TRetCode;

   TSQLDescribeCol = FUNCTION (Stmt : hStmt;
                        ICol : Word;
                        szcolname : PChar;
                        cbcolnamemax : Integer;
                        VAR cbcolname : Integer;
                        VAR pfsqltype : Integer;
                        VAR cbcoldef : LongInt;
                        VAR ibscale : Integer;
                        VAR fnullable : Integer) : TRetCode;

   TSQLDisconnect = FUNCTION (Dbc : hDbc) : TRetCode;

   TSQLGetError = FUNCTION (Env : hEnv;
                   Dbc : hDbc;
                   Stmt : hStmt;
                   szsqlstate : PChar;
                   VAR fnativeerror : LongInt;
                   szerrormsg : PChar;
                   cberrormsgmax : Integer;
                   VAR cberrormsg : Integer) : TRetCode;

   TSQLExecDirect = FUNCTION (Stmt : hStmt;
                        szsqlstr : PChar;
                        cbsqlstr : LongInt) : TRetCode;

   TSQLExecute = FUNCTION(Stmt : hStmt) : TRetCode;

   TSQLFetch = FUNCTION(Stmt : hStmt) : TRetCode;

   TSQLFreeConnect = FUNCTION(Dbc : hDbc) : TRetCode;

   TSQLFreeEnv = FUNCTION(Env : hEnv) : TRetCode;

   TSQLFreeStmt = FUNCTION(Stmt : hStmt;
                      foption : Word) : TRetCode;

   TSQLGetCursorName = FUNCTION(Stmt : hStmt;
                           szcursor : PChar;
                           cbcursormax : Integer;
                           VAR cbcursor : Integer) : TRetCode;

   TSQLNumResultCols = FUNCTION(Stmt : hStmt;
                           VAR ccol : Integer) : TRetCode;

   TSQLPrepare = FUNCTION(Stmt : hStmt;
                     szsqlstr : PChar;
                     cbsqlstr : LongInt) : TRetCode;

   TSQLRowCount = FUNCTION(Stmt : hStmt;
                           VAR crow : LongInt) : TRetCode;

   TSQLSetCursorName = FUNCTION(Stmt : hStmt;
                           szcursor : PChar;
                           cbcursor : Integer) : TRetCode;

   TSQLSetParam = FUNCTION(Stmt : hStmt;
                     ipar : Word;
                     FCType : Integer;
                     fsqltype : Integer;
                     cbcoldef : LongInt;
                     ibscale : Integer;
                     RGBValue : Pointer;
                     VAR PCBValue : LongInt) : TRetCode;

   TSQLTransact = FUNCTION(Env : hEnv;
                     Dbc : hDbc;
                     ftype : Word) : TRetCode;

   {From SQLExt}

   TSQLColumns = FUNCTION(stmt : hstmt;
                        szTableQualifier : pchar;
                        cbTableQualifier : integer;
                        szTableOwner : pchar;
                        cbTableOwner : integer;
                        szTableName : pchar;
                        cbTableName : integer;
                        szColumnName : pchar;
                        cbColumnName : integer) : Tretcode;

   TSQLDriverConnect = FUNCTION(dbc : hdbc;
                              wnd : hwnd;
                              szConnStrIn : pchar;
                              cbConnStrIn : integer;
                              szConnStrOut : pchar;
                              cbConnStrOutMax : integer;
                              var cbConnStrOut : integer;
                              fDriverCompletion : word) : TRetCode;

   TSQLGetConnectOption = FUNCTION(dbc : hdbc;
                                 fOption : word;
                                 pvParam : pointer) : TRetCode;

   TSQLGetData = FUNCTION(stmt : hstmt;
                        icol : word;
                        fCType : integer;
                        rgbValue : pointer;
                        cbValueMax : longint;
                        var cbValue : longint) : TRetCode;

   TSQLGetFunctions = FUNCTION(dbc : hdbc;
                             fFunction : word;
                             var fExists : word) : TRetCode;

   TSQLGetInfo = FUNCTION(dbc : hdbc;
                        fInfoType : word;
                        rgbInfoValue : pointer;
                        cbInfoValueMax : integer;
                        var cbInfoValue : integer) : TRetCode;

   TSQLGetStmtOption = FUNCTION(stmt : hstmt;
                              fOption : word;
                              pvParam : pointer) : TRetCode;

   TSQLGetTypeInfo = FUNCTION(stmt : hstmt;
                            fTSQLType : integer) : TRetCode;

   TSQLParamData = FUNCTION(stmt : hstmt;
                          var rgbValue) : TRetCode;

   TSQLPutData = FUNCTION(stmt : hstmt;
                        rgbValue : pointer;
                        cbValue : longint) : TRetCode;

   TSQLSetConnectOption = FUNCTION(dbc : hdbc;
                                 fOption : word;
                                 vParam : LongInt) : TRetCode;

   TSQLSetStmtOption = FUNCTION(stmt : hstmt;
                              fOption : word;
                              vParam : LongInt) : TRetCode;

   TSQLSpecialColumns = FUNCTION(stmt : hstmt;
                               fColType : word;
                               szTableQualifier : pchar;
                               cbTableQualifier : integer;
                               szTableOwner : pchar;
                               cbTableOwner : integer;
                               szTableName : pchar;
                               cbTableName : integer;
                               fScope : word;
                               fNullable : word) : TRetCode;

   TSQLStatistics = FUNCTION(stmt : hstmt;
                           szTableQualifier : pchar;
                           cbTableQualifier : integer;
                           szTableOwner : pchar;
                           cbTableOwner : integer;
                           szTableName : pchar;
                           cbTableName : integer;
                           fUnique : word;
                           fAccuracy : word) : TRetCode;

   TSQLTables = FUNCTION(stmt : hstmt;
                       szTableQualifier : pchar;
                       cbTableQualifier : integer;
                       szTableOwner : pchar;
                       cbTableOwner : integer;
                       szTableName : pchar;
                       cbTableName : integer;
                       szTableType : pchar;
                       cbTableType : integer) : TRetCode;

   TSQLBrowseConnect = FUNCTION(dbc : hdbc;
                              szConnStrIn : pchar;
                              cbConnStrIn : integer;
                              szConnStrOut : pchar;
                              cbConnStrOutMax : integer;
                              var cbConnStrOut : integer) : TRetCode;

   TSQLColumnPrivileges = FUNCTION(stmt : hstmt;
                                 szTableQualifier : pchar;
                                 cbTableQualifier : integer;
                                 szTableOwner : pchar;
                                 cbTableOwner : integer;
                                 szTableName : pchar;
                                 cbTableName : integer;
                                 szColumnName : pchar;
                                 cbColumnName : integer) : TRetCode;

   TSQLDataSources= FUNCTION(Env : HEnv;
                           fDirection : Word;
                           DataSourceName : PChar;
                           DataSourceNameLen : Integer;
                           VAR DataSourceNameLenReturned : Integer;
                           Description : PChar;
                           DescriptionLen : Integer;
                           VAR DescriptionLenReturned : integer) : TRetCode;


   TSQLDescribeParam = FUNCTION(stmt : hstmt;
                              ipar : word;
                              var fTSQLType : integer;
                              var cbColDef : LongInt;
                              var ibScale : integer;
                              var fNullable : integer) : TRetCode;

   TSQLExtendedFetch = FUNCTION(stmt : hstmt;
                              fFetchType : word;
                              irow : longint;
                              var crow : LongInt;
                              var rgfRowStatus : word) : TRetCode;

   TSQLForeignKeys = FUNCTION(stmt : hstmt;
                            szPkTableQualifier : pchar;
                            cbPkTableQualifier : integer;
                            szPkTableOwner : pchar;
                            cbPkTableOwner : integer;
                            szPkTableName : pchar;
                            cbPkTableName : integer;
                            szFkTableQualifier : pchar;
                            cbFkTableQualifier : integer;
                            szFkTableOwner : pchar;
                            cbFkTableOwner : integer;
                            szFkTableName : pchar;
                            cbFkTableName : integer) : TRetCode;

   TSQLMoreResults = FUNCTION(stmt : hstmt) : TRetCode;

   TSQLNumParams = FUNCTION(stmt : hstmt;
                          var cpar : integer) : TRetCode;

   TSQLParamOptions = FUNCTION(stmt : hstmt;
                             crow : LongInt;
                             var irow : LongInt) : TRetCode;

   TSQLNativeSQL = FUNCTION(Dbc : HDbc;
   								 szSQLStrIn : PChar;
                            cbSQLStrIn : LongInt;
                            szSQLStr : PChar;
                            cbSQLStrMax : LongInt;
                            VAR cbSQLStr : LongInt) : TRetCode;


   TSQLPrimaryKeys = FUNCTION(stmt : hstmt;
                            szTableQualifier : pchar;
                            cbTableQualifier : integer;
                            szTableOwner : pchar;
                            cbTableOwner : integer;
                            szTableName : pchar;
                            cbTableName : integer) : TRetCode;

   TSQLProcedureColumns = FUNCTION(stmt : hstmt;
                                 szProcQualifier : pchar;
                                 cbProcQualifier : integer;
                                 szProcOwner : pchar;
                                 cbProcOwner : integer;
                                 szProcName : pchar;
                                 cbProcName : integer;
                                 szColumnName : pchar;
                                 cbColumnName : integer) : TRetCode;

   TSQLProcedures = FUNCTION(stmt : hstmt;
                           szProcQualifier : pchar;
                           cbProcQualifier : integer;
                           szProcOwner : pchar;
                           cbProcOwner : integer;
                           szProcName : pchar;
                           cbProcName : integer) : TRetCode;

   TSQLSetPos = FUNCTION(stmt : hstmt;
                       irow : word;
                       fRefresh : bool;
                       fLock : bool) : TRetCode;

   TSQLSetScrollOptions = FUNCTION(stmt : hstmt;
                                 fConcurrency : word;
                                 crowKeyset : longint;
                                 crowRowset : word) : TRetCode;

   TSQLTablePrivileges = FUNCTION(stmt : hstmt;
                                szTableQualifier : pchar;
                                cbTableQualifier : integer;
                                szTableOwner : pchar;
                                cbTableOwner : integer;
                                szTableName : pchar;
                                cbTableName : integer) : TRetCode;


{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

TYPE

   POdbcDLLRec = ^TOdbcDLLRec;
   TOdbcDLLRec = RECORD
   	TheHandle : THandle;   {to the DLL}
      GEnv : HEnv;           {Environment handle}
      RetCode : TRetCode;    {Last result}
      {SQL}
      SQLAllocConnect : TSQLAllocConnect;
      SQLAllocEnv : TSQLAllocEnv;
      SQLAllocStmt : TSQLAllocStmt;
      SQLBindCol : TSQLBindCol;
      SQLCancel : TSQLCancel;
      SQLColAttributes : TSQLColAttributes;
      SQLConnect : TSQLConnect;
      SQLDescribeCol : TSQLDescribeCol;
      SQLDisconnect : TSQLDisconnect;
      SQLGetError : TSQLGetError;
      SQLExecDirect : TSQLExecDirect;
      SQLExecute : TSQLExecute;
      SQLFetch : TSQLFetch;
      SQLFreeConnect : TSQLFreeConnect;
      SQLFreeEnv : TSQLFreeEnv;
      SQLFreeStmt : TSQLFreeStmt;
      SQLGetCursorName : TSQLGetCursorName;
      SQLNumResultCols : TSQLNumResultCols;
      SQLPrepare : TSQLPrepare;
      SQLRowCount : TSQLRowCount;
      SQLSetCursorName : TSQLSetCursorName;
      SQLSetParam : TSQLSetParam;
      SQLTransact : TSQLTransact;
      {SQLExt}
      SQLGETDATA : TSQLGETDATA;
      SQLCOLUMNPRIVILEGES : TSQLCOLUMNPRIVILEGES;
      SQLPRIMARYKEYS : TSQLPRIMARYKEYS;
      SQLMORERESULTS : TSQLMORERESULTS;
      SQLPUTDATA : TSQLPUTDATA;
      SQLGETSTMTOPTION : TSQLGETSTMTOPTION;
      SQLSETSTMTOPTION : TSQLSETSTMTOPTION;
      SQLNUMPARAMS : TSQLNUMPARAMS;
      SQLSTATISTICS : TSQLSTATISTICS;
      SQLGETINFO : TSQLGETINFO;
      SQLGETCONNECTOPTION : TSQLGETCONNECTOPTION;
      SQLPARAMOPTIONS : TSQLPARAMOPTIONS;
      SQLNATIVESQL : TSQLNATIVESQL;
      SQLGETFUNCTIONS : TSQLGETFUNCTIONS;
      SQLSETSCROLLOPTIONS : TSQLSETSCROLLOPTIONS;
      SQLSETCONNECTOPTION : TSQLSETCONNECTOPTION;
      SQLDRIVERCONNECT : TSQLDRIVERCONNECT;
      SQLTABLES : TSQLTABLES;
      SQLBROWSECONNECT : TSQLBROWSECONNECT;
      SQLDESCRIBEPARAM : TSQLDESCRIBEPARAM;
      SQLTABLEPRIVILEGES : TSQLTABLEPRIVILEGES;
      SQLFOREIGNKEYS : TSQLFOREIGNKEYS;
      SQLPROCEDURECOLUMNS : TSQLPROCEDURECOLUMNS;
      SQLCOLUMNS : TSQLCOLUMNS;
      SQLDATASOURCES : TSQLDATASOURCES;
      SQLEXTENDEDFETCH : TSQLEXTENDEDFETCH;
      SQLPARAMDATA : TSQLPARAMDATA;
      SQLSPECIALCOLUMNS : TSQLSPECIALCOLUMNS;
      SQLGETTYPEINFO : TSQLGETTYPEINFO;
      SQLSETPOS : TSQLSETPOS;
      SQLPROCEDURES : TSQLPROCEDURES;
   END;

CONST

   OdbcDLL : POdbcDLLRec = NIL;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

FUNCTION  LoadOdbcDLL : INTEGER;
PROCEDURE UnloadOdbcDLL;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

FUNCTION sSQLAllocConnect(Env : hEnv;
                          VAR Dbc : hDbc) : TRetCode;

FUNCTION sSQLAllocEnv(VAR Env : hEnv) : TRetCode;

FUNCTION sSQLAllocStmt(Dbc : hDbc;
                       VAR Stmt : hStmt) : TRetCode;

FUNCTION sSQLBindCol(Stmt : hStmt;
                     ColumnNo : Word;
                     FCType : Integer;
                     DataPtr : Pointer;
                     DataLen : LongInt;
                     VAR DataLenReturned : LongInt) : TRetCode;

FUNCTION sSQLCancel(Stmt : hStmt) : TRetCode;

FUNCTION sSQLColAttributes(Stmt : hStmt;
                           ICol : Word;
                           FDescType : Word;
                           RGBDesc : Pointer;
                           CBDescMax : Integer;
                           VAR CBDesc : Integer;
                           VAR FDesc : LongInt) : TRetCode;

FUNCTION sSQLConnect(Dbc : hDbc;
                     szDSN : PChar;
                     cbdsn : Integer;
                     szuid : PChar;
                     cbuid : Integer;
                     szauthstr : PChar;
                     cbauthstr : Integer) : TRetCode;

FUNCTION sSQLDescribeCol(Stmt : hStmt;
                         ICol : Word;
                         szcolname : PChar;
                         cbcolnamemax : Integer;
                         VAR cbcolname : Integer;
                         VAR pfsqltype : Integer;
                         VAR cbcoldef : LongInt;
                         VAR ibscale : Integer;
                         VAR fnullable : Integer) : TRetCode;

FUNCTION sSQLDisconnect(Dbc : hDbc) : TRetCode;

FUNCTION sSQLGetError(Env : hEnv;
                      Dbc : hDbc;
                      Stmt : hStmt;
                      szsqlstate : PChar;
                      VAR fnativeerror : LongInt;
                      szerrormsg : PChar;
                      cberrormsgmax : Integer;
                      VAR cberrormsg : Integer) : TRetCode;

FUNCTION sSQLExecDirect(Stmt : hStmt;
                        szsqlstr : PChar;
                        cbsqlstr : LongInt) : TRetCode;

FUNCTION sSQLExecute(Stmt : hStmt) : TRetCode;

FUNCTION sSQLFetch(Stmt : hStmt) : TRetCode;

FUNCTION sSQLFreeConnect(Dbc : hDbc) : TRetCode;

FUNCTION sSQLFreeEnv(Env : hEnv) : TRetCode;

FUNCTION sSQLFreeStmt(Stmt : hStmt;
                      foption : Word) : TRetCode;

FUNCTION sSQLGetCursorName(Stmt : hStmt;
                           szcursor : PChar;
                           cbcursormax : Integer;
                           VAR cbcursor : Integer) : TRetCode;

FUNCTION sSQLNumResultCols(Stmt : hStmt;
                           VAR ccol : Integer) : TRetCode;

FUNCTION sSQLPrepare(Stmt : hStmt;
                     szsqlstr : PChar;
                     cbsqlstr : LongInt) : TRetCode;

FUNCTION sSQLRowCount(Stmt : hStmt;
                      VAR crow : LongInt) : TRetCode;

FUNCTION sSQLSetCursorName(Stmt : hStmt;
                           szcursor : PChar;
                           cbcursor : Integer) : TRetCode;

FUNCTION sSQLSetParam(Stmt : hStmt;
                      ipar : Word;
                      FCType : Integer;
                      fsqltype : Integer;
                      cbcoldef : LongInt;
                      ibscale : Integer;
                      RGBValue : Pointer;
                      VAR PCBValue : LongInt) : TRetCode;

FUNCTION sSQLTransact(Env : hEnv;
                      Dbc : hDbc;
                      ftype : Word) : TRetCode;

{From SQLExt}

FUNCTION sSQLColumns(stmt : hstmt;
                     szTableQualifier : pchar;
                     cbTableQualifier : integer;
                     szTableOwner : pchar;
                     cbTableOwner : integer;
                     szTableName : pchar;
                     cbTableName : integer;
                     szColumnName : pchar;
                     cbColumnName : integer) : Tretcode;

FUNCTION sSQLDriverConnect(dbc : hdbc;
                           wnd : hwnd;
                           szConnStrIn : pchar;
                           cbConnStrIn : integer;
                           szConnStrOut : pchar;
                           cbConnStrOutMax : integer;
                           var cbConnStrOut : integer;
                           fDriverCompletion : word) : TRetCode;

FUNCTION sSQLGetConnectOption(dbc : hdbc;
                              fOption : word;
                              pvParam : pointer) : TRetCode;

FUNCTION sSQLGetData(stmt : hstmt;
                     icol : word;
                     fCType : integer;
                     rgbValue : pointer;
                     cbValueMax : longint;
                     var cbValue : longint) : TRetCode;

FUNCTION sSQLGetFunctions(dbc : hdbc;
                          fFunction : word;
                          var fExists : word) : TRetCode;

FUNCTION sSQLGetInfo(dbc : hdbc;
                     fInfoType : word;
                     rgbInfoValue : pointer;
                     cbInfoValueMax : integer;
                     var cbInfoValue : integer) : TRetCode;

FUNCTION sSQLGetStmtOption(stmt : hstmt;
                           fOption : word;
                           pvParam : pointer) : TRetCode;

FUNCTION sSQLGetTypeInfo(stmt : hstmt;
                         fTSQLType : integer) : TRetCode;

FUNCTION sSQLParamData(stmt : hstmt;
                       var rgbValue) : TRetCode;

FUNCTION sSQLPutData(stmt : hstmt;
                     rgbValue : pointer;
                     cbValue : longint) : TRetCode;

FUNCTION sSQLSetConnectOption(dbc : hdbc;
                              fOption : word;
                              vParam : LongInt) : TRetCode;

FUNCTION sSQLSetStmtOption(stmt : hstmt;
                           fOption : word;
                           vParam : LongInt) : TRetCode;

FUNCTION sSQLSpecialColumns(stmt : hstmt;
                            fColType : word;
                            szTableQualifier : pchar;
                            cbTableQualifier : integer;
                            szTableOwner : pchar;
                            cbTableOwner : integer;
                            szTableName : pchar;
                            cbTableName : integer;
                            fScope : word;
                            fNullable : word) : TRetCode;

FUNCTION sSQLStatistics(stmt : hstmt;
                        szTableQualifier : pchar;
                        cbTableQualifier : integer;
                        szTableOwner : pchar;
                        cbTableOwner : integer;
                        szTableName : pchar;
                        cbTableName : integer;
                        fUnique : word;
                        fAccuracy : word) : TRetCode;

FUNCTION sSQLTables(stmt : hstmt;
                    szTableQualifier : pchar;
                    cbTableQualifier : integer;
                    szTableOwner : pchar;
                    cbTableOwner : integer;
                    szTableName : pchar;
                    cbTableName : integer;
                    szTableType : pchar;
                    cbTableType : integer) : TRetCode;

FUNCTION sSQLBrowseConnect(dbc : hdbc;
                           szConnStrIn : pchar;
                           cbConnStrIn : integer;
                           szConnStrOut : pchar;
                           cbConnStrOutMax : integer;
                           var cbConnStrOut : integer) : TRetCode;

FUNCTION sSQLColumnPrivileges(stmt : hstmt;
                              szTableQualifier : pchar;
                              cbTableQualifier : integer;
                              szTableOwner : pchar;
                              cbTableOwner : integer;
                              szTableName : pchar;
                              cbTableName : integer;
                              szColumnName : pchar;
                              cbColumnName : integer) : TRetCode;

FUNCTION sSQLDataSources(Env : HEnv;
                         fDirection : Word;
                         DataSourceName : PChar;
                         DataSourceNameLen : Integer;
                         VAR DataSourceNameLenReturned : Integer;
                         Description : PChar;
                         DescriptionLen : Integer;
                         VAR DescriptionLenReturned : integer) : TRetCode;

FUNCTION sSQLDescribeParam(stmt : hstmt;
                           ipar : word;
                           var fTSQLType : integer;
                           var cbColDef : LongInt;
                           var ibScale : integer;
                           var fNullable : integer) : TRetCode;

FUNCTION sSQLExtendedFetch(stmt : hstmt;
                           fFetchType : word;
                           irow : longint;
                           var crow : LongInt;
                           var rgfRowStatus : word) : TRetCode;

FUNCTION sSQLForeignKeys(stmt : hstmt;
                         szPkTableQualifier : pchar;
                         cbPkTableQualifier : integer;
                         szPkTableOwner : pchar;
                         cbPkTableOwner : integer;
                         szPkTableName : pchar;
                         cbPkTableName : integer;
                         szFkTableQualifier : pchar;
                         cbFkTableQualifier : integer;
                         szFkTableOwner : pchar;
                         cbFkTableOwner : integer;
                         szFkTableName : pchar;
                         cbFkTableName : integer) : TRetCode;

FUNCTION sSQLMoreResults(stmt : hstmt) : TRetCode;

FUNCTION sSQLNumParams(stmt : hstmt;
                       var cpar : integer) : TRetCode;

FUNCTION sSQLParamOptions(stmt : hstmt;
                          crow : LongInt;
                          var irow : LongInt) : TRetCode;

FUNCTION sSQLNativeSQL(Dbc : HDbc;
   						  szSQLStrIn : PChar;
                       cbSQLStrIn : LongInt;
                       szSQLStr : PChar;
                       cbSQLStrMax : LongInt;
                       VAR cbSQLStr : LongInt) : TRetCode;


FUNCTION sSQLPrimaryKeys(stmt : hstmt;
                         szTableQualifier : pchar;
                         cbTableQualifier : integer;
                         szTableOwner : pchar;
                         cbTableOwner : integer;
                         szTableName : pchar;
                         cbTableName : integer) : TRetCode;

FUNCTION sSQLProcedureColumns(stmt : hstmt;
                              szProcQualifier : pchar;
                              cbProcQualifier : integer;
                              szProcOwner : pchar;
                              cbProcOwner : integer;
                              szProcName : pchar;
                              cbProcName : integer;
                              szColumnName : pchar;
                              cbColumnName : integer) : TRetCode;

FUNCTION sSQLProcedures(stmt : hstmt;
                        szProcQualifier : pchar;
                        cbProcQualifier : integer;
                        szProcOwner : pchar;
                        cbProcOwner : integer;
                        szProcName : pchar;
                        cbProcName : integer) : TRetCode;

FUNCTION sSQLSetPos(stmt : hstmt;
                    irow : word;
                    fRefresh : bool;
                    fLock : bool) : TRetCode;

FUNCTION sSQLSetScrollOptions(stmt : hstmt;
                              fConcurrency : word;
                              crowKeyset : longint;
                              crowRowset : word) : TRetCode;

FUNCTION sSQLTablePrivileges(stmt : hstmt;
                             szTableQualifier : pchar;
                             cbTableQualifier : integer;
                             szTableOwner : pchar;
                             cbTableOwner : integer;
                             szTableName : pchar;
                             cbTableName : integer) : TRetCode;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

IMPLEMENTATION

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

USES

   OtherStk;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

CONST

   stEnv  : hENV = NIL;
   stDbc  : hDBC = NIL;
   stStmt : hSTMT = NIL;
   stRetCode : TRetCode = 0;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

FUNCTION LoadOdbcDLL : INTEGER;
VAR
   L : INTEGER;
   DLLName : PChar;
BEGIN
   L := 0;
   IF OdbcDLL = NIL THEN
   BEGIN
      GetMem(DLLName,255);
      L := LoadLibrary('ODBC.DLL');
      FreeMem(DLLName,255);
      IF L < 32 THEN
         L := -L
      ELSE
      BEGIN
         OdbcDLL := New(POdbcDLLRec);
         WITH OdbcDLL^ DO
         BEGIN
            TheHandle := L;
            @SQLEXECUTE := GetProcAddress(TheHandle, PChar(12));
            @SQLROWCOUNT := GetProcAddress(TheHandle, PChar(20));
            @SQLALLOCEnv := GetProcAddress(TheHandle, PChar(2));
            @SQLGetERROR := GetProcAddress(TheHandle, PChar(10));
            @SQLDESCRIBECOL := GetProcAddress(TheHandle, PChar(8));
            @SQLBINDCOL := GetProcAddress(TheHandle, PChar(4));
            @SQLFREEEnv := GetProcAddress(TheHandle, PChar(15));
            @SQLALLOCCONNECT := GetProcAddress(TheHandle, PChar(1));
            @SQLCOLATTRIBUTES := GetProcAddress(TheHandle, PChar(6));
            @SQLCANCEL := GetProcAddress(TheHandle, PChar(5));
            @SQLPREPARE := GetProcAddress(TheHandle, PChar(19));
            @SQLALLOCStmt := GetProcAddress(TheHandle, PChar(3));
            @SQLGETCURSORNAME := GetProcAddress(TheHandle, PChar(17));
            @SQLCONNECT := GetProcAddress(TheHandle, PChar(7));
            @SQLSETCURSORNAME := GetProcAddress(TheHandle, PChar(21));
            @SQLFREECONNECT := GetProcAddress(TheHandle, PChar(14));
            @SQLEXECDIRECT := GetProcAddress(TheHandle, PChar(11));
            @SQLFETCH := GetProcAddress(TheHandle, PChar(13));
            @SQLDISCONNECT := GetProcAddress(TheHandle, PChar(9));
            @SQLTRANSACT := GetProcAddress(TheHandle, PChar(23));
            @SQLFREEStmt := GetProcAddress(TheHandle, PChar(16));
            @SQLSETPARAM := GetProcAddress(TheHandle, PChar(22));
            @SQLNUMRESULTCOLS := GetProcAddress(TheHandle, PChar(18));
            @SQLGETDATA := GetProcAddress(TheHandle, PChar(43));
            @SQLCOLUMNPRIVILEGES := GetProcAddress(TheHandle, PChar(56));
            @SQLPRIMARYKEYS := GetProcAddress(TheHandle, PChar(65));
            @SQLMORERESULTS := GetProcAddress(TheHandle, PChar(61));
            @SQLPUTDATA := GetProcAddress(TheHandle, PChar(49));
            @SQLGETSTMTOPTION := GetProcAddress(TheHandle, PChar(46));
            @SQLSETSTMTOPTION := GetProcAddress(TheHandle, PChar(51));
            @SQLNUMPARAMS := GetProcAddress(TheHandle, PChar(63));
            @SQLSTATISTICS := GetProcAddress(TheHandle, PChar(53));
            @SQLGETINFO := GetProcAddress(TheHandle, PChar(45));
            @SQLGETCONNECTOPTION := GetProcAddress(TheHandle, PChar(42));
            @SQLPARAMOPTIONS := GetProcAddress(TheHandle, PChar(64));
            @SQLNATIVESQL := GetProcAddress(TheHandle, PChar(62));
            @SQLGETFUNCTIONS := GetProcAddress(TheHandle, PChar(44));
            @SQLSETSCROLLOPTIONS := GetProcAddress(TheHandle, PChar(69));
            @SQLSETCONNECTOPTION := GetProcAddress(TheHandle, PChar(50));
            @SQLDRIVERCONNECT := GetProcAddress(TheHandle, PChar(41));
            @SQLTABLES := GetProcAddress(TheHandle, PChar(54));
            @SQLBROWSECONNECT := GetProcAddress(TheHandle, PChar(55));
            @SQLDESCRIBEPARAM := GetProcAddress(TheHandle, PChar(58));
            @SQLTABLEPRIVILEGES := GetProcAddress(TheHandle, PChar(70));
            @SQLFOREIGNKEYS := GetProcAddress(TheHandle, PChar(60));
            @SQLPROCEDURECOLUMNS := GetProcAddress(TheHandle, PChar(66));
            @SQLCOLUMNS := GetProcAddress(TheHandle, PChar(40));
            @SQLDATASOURCES := GetProcAddress(TheHandle, PChar(57));
            @SQLEXTENDEDFETCH := GetProcAddress(TheHandle, PChar(59));
            @SQLPARAMDATA := GetProcAddress(TheHandle, PChar(48));
            @SQLSPECIALCOLUMNS := GetProcAddress(TheHandle, PChar(52));
            @SQLGETTYPEINFO := GetProcAddress(TheHandle, PChar(47));
            @SQLSETPOS := GetProcAddress(TheHandle, PChar(68));
            @SQLPROCEDURES := GetProcAddress(TheHandle, PChar(67));
         END;
         IF OdbcDLL = NIL THEN
			   L := -1
         ELSE
         WITH OdbcDLL^ DO
         BEGIN
            L := 0;
			   IF SQLAllocEnv(GEnv) <> SQLSuccess THEN
            BEGIN
               MessageBox(GetActiveWindow, 'Unable to load ODBC', '', mb_IconHand OR mb_Ok);
               FreeLibrary(OdbcDLL^.TheHandle);
               DISPOSE(OdbcDLL);
               OdbcDLL := NIL;
            END
         END;
      END
   END;
   LoadOdbcDLL := L;
END;

{ ------------------------------------------------------------------------ }

PROCEDURE UnloadOdbcDLL;
BEGIN
   IF OdbcDLL <> NIL THEn
   BEGIN
      FreeLibrary(OdbcDLL^.TheHandle);
      DISPOSE(OdbcDLL);
      OdbcDLL := NIL;
   END
END;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

FUNCTION sSQLAllocConnect(Env     : hEnv;
                          VAR Dbc : hDbc) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLAllocConnect := SQLERROR
   ELSE
   BEGIN
      stEnv := Env;
      stDbc := Dbc;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.sqlAllocConnect(stEnv,stDbc);
      SwitchStackBack;
      Dbc := stDbc;
      sSqlAllocConnect := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLAllocEnv(VAR Env : hEnv) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLAllocEnv := SQLERROR
   ELSE
   BEGIN
      stEnv := Env;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.sqlAllocEnv(stEnv);
      SwitchStackBack;
      Env := StEnv;
      sSqlAllocEnv := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLAllocStmt(Dbc : hDbc;
                       VAR Stmt : hStmt) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLAllocStmt := SQLERROR
   ELSE
   BEGIN
      stDbc := Dbc;
      stStmt := Stmt;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLAllocStmt(stDbc,stStmt);
      SwitchStackBack;
      Stmt := stStmt;
      sSQLAllocStmt := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLBindCol(Stmt : hStmt;
                     ColumnNo : Word;
                     FCType : Integer;
                     DataPtr : Pointer;
                     DataLen : LongInt;
                     VAR DataLenReturned : LongInt) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLBindCol := SQLERROR
   ELSE
   BEGIN
      stStmt := Stmt;
      stWORD1 := ColumnNo;
      stINTEGER1 := FCType;
      stPTR1 := DataPtr;
      stLONG1 := DataLen;
      stLONG2 := DataLenReturned;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLBindCol(stStmt,
                                       stWORD1,
                                       stINTEGER1,
                                       stPTR1,
                                       stLONG1,
                                       stLONG2);
      SwitchStackBack;
      DataLenReturned := stLong2;
      sSQLBindCol := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLCancel(Stmt : hStmt) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLCancel := SQLERROR
   ELSE
   BEGIN
      stStmt := Stmt;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLCancel(stStmt);
      SwitchStackBack;
      sSQLCancel := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLColAttributes(Stmt : hStmt;
                           ICol : Word;
                           FDescType : Word;
                           RGBDesc : Pointer;
                           CBDescMax : Integer;
                           VAR CBDesc : Integer;
                           VAR FDesc : LongInt) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLColAttributes := SQLERROR
   ELSE
   BEGIN
      stStmt := Stmt;
      stWORD1 := ICol;
      stWORD2 := FDescType;
      stPTR1 := RGBDesc;
      stINTEGER1 := CBDescMax;
      stINTEGER2 := CBDesc;
      stLONG1 := FDesc;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLColAttributes(stStmt,
                                             stWORD1,
                                             stWORD2,
                                             stPTR1,
                                             stINTEGER1,
                                             stINTEGER2,
                                             stLONG1);
      SwitchStackBack;
      CBDesc := stINTEGER2;
      FDesc := stLONG1;
      sSQLColAttributes := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLConnect(Dbc : hDbc;
                     szDSN : PChar;
                     cbdsn : Integer;
                     szuid : PChar;
                     cbuid : Integer;
                     szauthstr : PChar;
                     cbauthstr : Integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLConnect := SQLERROR
   ELSE
   BEGIN
      stDbc := Dbc;
      stPChar1 := szDSN;
      stINTEGER1 := cbdsn;
      stPChar2 := szUid;
      stINTEGER2 := cbuid;
      stPChar3 := szAuthStr;
      stINTEGER3 := cbAuthStr;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLConnect(stDBC,
                                       stPChar1,
                                       stINTEGER1,
                                       stPChar2,
                                       stINTEGER2,
                                       stPChar3,
                                       stINTEGER3);
      SwitchStackBack;
      sSQLConnect := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLDescribeCol(Stmt : hStmt;
                         ICol : Word;
                         szcolname : PChar;
                         cbcolnamemax : Integer;
                         VAR cbcolname : Integer;
                         VAR pfsqltype : Integer;
                         VAR cbcoldef : LongInt;
                         VAR ibscale : Integer;
                         VAR fnullable : Integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLDescribeCol := SQLERROR
   ELSE
   BEGIN
      stStmt := Stmt;
      stWORD1 := ICol;
      stPChar1 := szColName;
      stINTEGER1 := cbColNameMax;
      stINTEGER2 := cbColName;
      stINTEGER3 := pfSqlType;
      stLONG1 := cbColDef;
      stINTEGER4 := ibScale;
      stINTEGER5 := fNullable;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLDescribeCol(stStmt,
                                           stWORD1,
                                           stPChar1,
                                           stINTEGER1,
                                           stINTEGER2,
                                           stINTEGER3,
                                           stLONG1,
                                           stINTEGER4,
                                           stINTEGER5);
      SwitchStackBack;
      cbColName := stINTEGER2;
      pfSqlType := stINTEGER3;
      cbColDef := stLONG1;
      ibScale := stINTEGER4;
      fNullable := stINTEGER5;
      sSQLDescribeCol := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLDisconnect(Dbc : hDbc) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLDisconnect := SQLERROR
   ELSE
   BEGIN
      stDbc := Dbc;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLDisconnect(stDBC);
      SwitchStackBack;
      sSQLDisconnect := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLGetError(Env : hEnv;
                      Dbc : hDbc;
                      Stmt : hStmt;
                      szsqlstate : PChar;
                      VAR fnativeerror : LongInt;
                      szerrormsg : PChar;
                      cberrormsgmax : Integer;
                      VAR cberrormsg : Integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLGetError := SQLERROR
   ELSE
   BEGIN
      stEnv := Env;
      stDbc := Dbc;
      stStmt := Stmt;
      stPChar1 := szSqlState;
      stLONG1 := fNativeError;
      stPChar2 := szErrorMsg;
      stINTEGER1 := cbErrorMsgMax;
      stINTEGER2 := cbErrorMsg;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLGetError(stEnv,
                                        stDBC,
                                        stStmt,
                                        stPChar1,
                                        stLONG1,
                                        stPChar2,
                                        stINTEGER1,
                                        stINTEGER2);
      SwitchStackBack;
      fNativeError := stLONG1;
      cbErrorMsg := stINTEGER2;
      sSQLGetError := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLExecDirect(Stmt : hStmt;
                        szsqlstr : PChar;
                        cbsqlstr : LongInt) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLExecDirect := SQLERROR
   ELSE
   BEGIN
      stStmt := Stmt;
      stPChar1 := szSqlStr;
      stLONG1 := cbSqlStr;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLExecDirect(stStmt,stPChar1,stLONG1);
      SwitchStackBack;
      sSQLExecDirect := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLExecute(Stmt : hStmt) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLExecute := SQLERROR
   ELSE
   BEGIN
      stStmt := Stmt;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLExecute(stStmt);
      SwitchStackBack;
      sSQLExecute := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLFetch(Stmt : hStmt) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLFetch := SQLERROR
   ELSE
   BEGIN
      stStmt := Stmt;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLFetch(stStmt);
      SwitchStackBack;
      sSQLFetch := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLFreeConnect(Dbc : hDbc) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLFreeConnect := SQLERROR
   ELSE
   BEGIN
      stDbc := Dbc;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLFreeConnect(stDbc);
      SwitchStackBack;
      sSQLFreeConnect := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLFreeEnv(Env : hEnv) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLFreeEnv := SQLERROR
   ELSE
   BEGIN
      stEnv := Env;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLFreeEnv(stEnv);
      SwitchStackBack;
      sSQLFreeEnv := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLFreeStmt(Stmt : hStmt;
                      foption : Word) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLFreeStmt := SQLERROR
   ELSE
   BEGIN
      stStmt := Stmt;
      stWORD1 := fOption;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLFreeStmt(stStmt,fOption);
      SwitchStackBack;
      sSQLFreeStmt := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLGetCursorName(Stmt : hStmt;
                           szcursor : PChar;
                           cbcursormax : Integer;
                           VAR cbcursor : Integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLGetCursorName := SQLERROR
   ELSE
   BEGIN
      stStmt := Stmt;
      stPChar1 := szCursor;
      stINTEGER1 := cbCursorMax;
      stINTEGER2 := cbCursor;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLGetCursorName(stStmt,
                                             stPChar1,
                                             stINTEGER1,
                                             stINTEGER2);
      SwitchStackBack;
      cbCursor := stINTEGER2;
      sSQLGetCursorName := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLNumResultCols(Stmt : hStmt;
                           VAR ccol : Integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLNumResultCols := SQLERROR
   ELSE
   BEGIN
      stStmt := Stmt;
      stINTEGER1 := ccol;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLNumResultCols(stStmt,
                                             stINTEGER1);
      SwitchStackBack;
      ccol := stINTEGER1;
      sSQLNumResultCols := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLPrepare(Stmt : hStmt;
                     szsqlstr : PChar;
                     cbsqlstr : LongInt) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLPrepare := SQLERROR
   ELSE
   BEGIN
      stStmt := Stmt;
      stPChar1 := szSqlStr;
      stLONG1 := cbSqlStr;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLPrepare(stStmt,
                                       stPChar1,stLONG1);
      SwitchStackBack;
      sSQLPrepare := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLRowCount(Stmt : hStmt;
                      VAR crow : LongInt) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLRowCount := SQLERROR
   ELSE
   BEGIN
      stStmt := Stmt;
      stLONG1 := crow;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLRowCount(stStmt,
                                        stLONG1);
      SwitchStackBack;
      crow := stLONG1;
      sSQLRowCount := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLSetCursorName(Stmt : hStmt;
                           szcursor : PChar;
                           cbcursor : Integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLSetCursorName := SQLERROR
   ELSE
   BEGIN
      stStmt := Stmt;
      stPChar1 := szCursor;
      stINTEGER1 := cbCursor;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLSetCursorName(stStmt,stPChar1,stINTEGER1);
      SwitchStackBack;
      sSQLSetCursorName := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLSetParam(Stmt : hStmt;
                      ipar : Word;
                      FCType : Integer;
                      fsqltype : Integer;
                      cbcoldef : LongInt;
                      ibscale : Integer;
                      RGBValue : Pointer;
                      VAR PCBValue : LongInt) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLSetParam := SQLERROR
   ELSE
   BEGIN
      stStmt := Stmt;
      stWORD1 := ipar;
      stINTEGER1 := fcType;
      stINTEGER2 := fSQLType;
      stLONG1 := cbColDef;
      stINTEGER3 := ibScale;
      stPTR1 := RGBValue;
      stLONG2 := pcbValue;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLSetParam(stStmt,
                                        stWORD1,
                                        stINTEGER1,
                                        stINTEGER2,
                                        stLONG1,
                                        stINTEGER3,
                                        stPTR1,
                                        stLONG2);
      SwitchStackBack;
      sSQLSetParam := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLTransact(Env : hEnv;
                      Dbc : hDbc;
                      ftype : Word) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLTransact := SQLERROR
   ELSE
   BEGIN
      stEnv := Env;
      stDbc := Dbc;
      stWORD1 := fType;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLTransact(stEnv,stDbc,stWORD1);
      SwitchStackBack;
      sSQLTransact := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLColumns(stmt : hstmt;
                     szTableQualifier : pchar;
                     cbTableQualifier : integer;
                     szTableOwner : pchar;
                     cbTableOwner : integer;
                     szTableName : pchar;
                     cbTableName : integer;
                     szColumnName : pchar;
                     cbColumnName : integer) : Tretcode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLColumns := SQLERROR
   ELSE
   BEGIN
      stStmt := Stmt;
      stPChar1 := szTableQualifier;
      stINTEGER1 := cbTableQualifier;
      stPChar2 := szTableOwner;
      stINTEGER2 := cbTableOwner;
      stPChar3 := szTableName;
      stINTEGER3 := cbTableName;
      stPChar4 := szColumnName;
      stINTEGER4 := cbColumnName;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLColumns(stStmt,
                                       stPChar1,
                                       stINTEGER1,
                                       stPChar2,
                                       stINTEGER2,
                                       stPChar3,
                                       stINTEGER3,
                                       stPChar4,
                                       stINTEGER4);
      SwitchStackBack;
      sSQLColumns := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLDriverConnect(dbc : hdbc;
                           wnd : hwnd;
                           szConnStrIn : pchar;
                           cbConnStrIn : integer;
                           szConnStrOut : pchar;
                           cbConnStrOutMax : integer;
                           var cbConnStrOut : integer;
                           fDriverCompletion : word) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLDriverConnect := SQLERROR
   ELSE
   BEGIN
      stDbc := dbc;
      stParent := Wnd;
      stPChar1 := szConnStrIn;
      stINTEGER1 := cbConnStrIn;
      stPChar2 := szConnStrOut;
      stINTEGER2 := cbConnStrOutMax;
      stINTEGER3 := cbConnStrOut;
      stWORD1 := fDriverCompletion;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLDriverConnect(stDBc,
                                             stParent,
                                             stPChar1,
                                             stINTEGER1,
                                             stPChar2,
                                             stINTEGER2,
                                             stINTEGER3,
                                             stWORD1);
      SwitchStackBack;
      cbConnStrOut := stINTEGER3;
      sSQLDriverConnect := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLGetConnectOption(dbc : hdbc;
                              fOption : word;
                              pvParam : pointer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLGetConnectOption := SQLERROR
   ELSE
   BEGIN
      stDbc := dbc;
      stWORD1 := fOption;
      stPTR1 := pvParam;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLGetConnectOption(stDBC,stWORD1,stPTR1);
      SwitchStackBack;
      sSQLGetConnectOption := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLGetData(stmt : hstmt;
                     icol : word;
                     fCType : integer;
                     rgbValue : pointer;
                     cbValueMax : longint;
                     var cbValue : longint) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLGetData := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stWORD1 := icol;
      stINTEGER1 := fcType;
      stPTR1 := rgbvalue;
      stLONG1 := cbValueMax;
      stLONG2 := cbValue;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLGetData(stStmt,
                                       stWORD1,
                                       stINTEGER1,
                                       stPTR1,
                                       stLONG1,
                                       stLONG2);
      SwitchStackBack;
      cbValue := stLONG2;
      sSQLGetData := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLGetFunctions(dbc : hdbc;
                          fFunction : word;
                          var fExists : word) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLGetFunctions := SQLERROR
   ELSE
   BEGIN
      stDbc := dbc;
      stWORD1 := fFunction;
      stWORD2 := fExists;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLGetFunctions(stDBC,stWORD1,stWORD2);
      SwitchStackBack;
      fExists := stWORD2;
      sSQLGetFunctions := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLGetInfo(dbc : hdbc;
                     fInfoType : word;
                     rgbInfoValue : pointer;
                     cbInfoValueMax : integer;
                     var cbInfoValue : integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLGetInfo := SQLERROR
   ELSE
   BEGIN
      stDbc := dbc;
      stWORD1 := fInfoType;
      stPTR1 := rgbInfoValue;
      stINTEGER1 := cbInfoValueMax;
      stINTEGER2 := cbInfoValue;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLGetInfo(stDBC,
                                       stWORD1,
                                       stPTR1,
                                       stINTEGER1,
                                       stINTEGER2);
      SwitchStackBack;
      cbInfovalue := stINTEGER2;
      sSQLGetInfo := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLGetStmtOption(stmt : hstmt;
                           fOption : word;
                           pvParam : pointer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLGetStmtOption := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stWORD1 := fOption;
      stPTR1 := pvParam;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLGetStmtOption(stStmt,stWORD1,stPTR1);
      SwitchStackBack;
      sSQLGetStmtOption := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLGetTypeInfo(stmt : hstmt;
                         fTSQLType : integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLGetTypeInfo := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stINTEGER1 := ftSQLType;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLGetTypeInfo(stStmt,stINTEGER1);
      SwitchStackBack;
      sSQLGetTypeInfo := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLParamData(stmt : hstmt;
                       var rgbValue) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLParamData := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stPTR1 := POINTER(rgbvalue);
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLParamData(stStmt,stPTR1);
      SwitchStackBack;
      sSQLParamData := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLPutData(stmt : hstmt;
                     rgbValue : pointer;
                     cbValue : longint) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLPutData := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stPTR1 := rgbValue;
      stLONG1 := cbValue;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLPutData(stStmt,stPTR1,stLONG1);
      SwitchStackBack;
      sSQLPutData := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLSetConnectOption(dbc : hdbc;
                              fOption : word;
                              vParam : LongInt) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLSetConnectOption := SQLERROR
   ELSE
   BEGIN
      stDbc := dbc;
      stWORD1 := fOption;
      stLONG1 := vParam;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLSetConnectOption(stDBC,stWORD1,stLONG1);
      SwitchStackBack;
      sSQLSetConnectOption := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLSetStmtOption(stmt : hstmt;
                           fOption : word;
                           vParam : LongInt) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLSetStmtOption := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stWORD1 := fOption;
      stLONG1 := vParam;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLSetStmtOption(stStmt,stWORD1,stLONG1);
      SwitchStackBack;
      sSQLSetStmtOption := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLSpecialColumns(stmt : hstmt;
                            fColType : word;
                            szTableQualifier : pchar;
                            cbTableQualifier : integer;
                            szTableOwner : pchar;
                            cbTableOwner : integer;
                            szTableName : pchar;
                            cbTableName : integer;
                            fScope : word;
                            fNullable : word) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLSpecialColumns := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stWORD1 := fColType;
      stPChar1 := szTableQualifier;
      stINTEGER1 := cbTableQualifier;
      stPChar2 := szTableOwner;
      stINTEGER2 := cbTableOwner;
      stPChar3 := szTableName;
      stINTEGER3 := cbTableName;
      stWORD2 := fScope;
      stWORD3 := fNullable;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLSpecialColumns(stStmt,
                                              stWORD1,
                                              stPChar1,
                                              stINTEGER1,
                                              stPChar2,
                                              stINTEGER2,
                                              stPChar3,
                                              stINTEGER3,
                                              stWORD2,
                                              stWORD3);
      SwitchStackBack;
      sSQLSpecialColumns := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLStatistics(stmt : hstmt;
                        szTableQualifier : pchar;
                        cbTableQualifier : integer;
                        szTableOwner : pchar;
                        cbTableOwner : integer;
                        szTableName : pchar;
                        cbTableName : integer;
                        fUnique : word;
                        fAccuracy : word) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLStatistics := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stPChar1 := szTableQualifier;
      stINTEGER1 := cbTableQualifier;
      stPChar2 := szTableOwner;
      stINTEGER2 := cbTableOwner;
      stPChar3 := szTableName;
      stINTEGER3 := cbTableName;
      stWORD1 := fUnique;
      stWORD2 := fAccuracy;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLStatistics(stStmt,
                                          stPChar1,
                                          stINTEGER1,
                                          stPChar2,
                                          stINTEGER2,
                                          stPChar3,
                                          stINTEGER3,
                                          stWORD1,
                                          stWORD2);
      SwitchStackBack;
      sSQLStatistics := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLTables(stmt : hstmt;
                    szTableQualifier : pchar;
                    cbTableQualifier : integer;
                    szTableOwner : pchar;
                    cbTableOwner : integer;
                    szTableName : pchar;
                    cbTableName : integer;
                    szTableType : pchar;
                    cbTableType : integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLTables := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stPChar1 := szTableQualifier;
      stINTEGER1 := cbTableQualifier;
      stPChar2 := szTableOwner;
      stINTEGER2 := cbTableOwner;
      stPChar3 := szTableName;
      stINTEGER3 := cbTableName;
      stPChar4 := szTableType;
      stINTEGER4 := cbTableType;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLTables(stStmt,
                                      stPChar1,
                                      stINTEGER1,
                                      stPChar2,
                                      stINTEGER2,
                                      stPChar3,
                                      stINTEGER3,
                                      stPChar4,
                                      stINTEGER4);
      SwitchStackBack;
      sSQLTables := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLBrowseConnect(dbc : hdbc;
                           szConnStrIn : pchar;
                           cbConnStrIn : integer;
                           szConnStrOut : pchar;
                           cbConnStrOutMax : integer;
                           var cbConnStrOut : integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLBrowseConnect := SQLERROR
   ELSE
   BEGIN
      stDbc := dbc;
      stPChar1 := szConnStrIn;
      stINTEGER1 := cbConnStrIn;
      stPChar2 := szConnStrOut;
      stINTEGER2 := cbConnStrOutMax;
      stINTEGER3 := cbConnStrOut;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLBrowseConnect(stDbc,
                                             stPChar1,
                                             stINTEGER1,
                                             stPChar2,
                                             stINTEGER2,
                                             stINTEGER3);
      SwitchStackBack;
      cbConnStrOut := stINTEGER3;
      sSQLBrowseConnect := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLColumnPrivileges(stmt : hstmt;
                              szTableQualifier : pchar;
                              cbTableQualifier : integer;
                              szTableOwner : pchar;
                              cbTableOwner : integer;
                              szTableName : pchar;
                              cbTableName : integer;
                              szColumnName : pchar;
                              cbColumnName : integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLColumnPrivileges := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stPChar1 := szTableQualifier;
      stINTEGER1 := cbtableQualifier;
      stPChar2 := szTableOwner;
      stINTEGER2 := cbTableOwner;
      stPChar3 := szTableName;
      stINTEGER3 := cbTableName;
      stPChar4 := szColumnName;
      stINTEGER4 := cbColumnName;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLColumnPrivileges(stStmt,
                                                stPChar1,
                                                stINTEGER1,
                                                stPChar2,
                                                stINTEGER2,
                                                stPChar3,
                                                stINTEGER3,
                                                stPChar4,
                                                stINTEGER4);
      SwitchStackBack;
      sSQLColumnPrivileges := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLDataSources(Env : HEnv;
                         fDirection : Word;
                         DataSourceName : PChar;
                         DataSourceNameLen : Integer;
                         VAR DataSourceNameLenReturned : Integer;
                         Description : PChar;
                         DescriptionLen : Integer;
                         VAR DescriptionLenReturned : integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLDataSources := SQLERROR
   ELSE
   BEGIN
      stEnv := Env;
      stWORD1 := fDirection;
      stPChar1 := DataSourceName;
      stINTEGER1 := DataSourceNameLen;
      stINTEGER2 := DataSourceNameLenReturned;
      stPChar2 := Description;
      stINTEGER3 := DescriptionLen;
      stINTEGER4 := DescriptionLenReturned;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLDataSources(stEnv,
                                           stWORD1,
                                           stPChar1,
                                           stINTEGER1,
                                           stINTEGER2,
                                           stPChar2,
                                           stINTEGER3,
                                           stINTEGER4);
      SwitchStackBack;
      DataSourceNameLenReturned := stINTEGER2;
      DescriptionLenReturned := stINTEGER4;
      sSQLDataSources := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLDescribeParam(stmt : hstmt;
                           ipar : word;
                           var fTSQLType : integer;
                           var cbColDef : LongInt;
                           var ibScale : integer;
                           var fNullable : integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLDescribeParam := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stWORD1 := ipar;
      stINTEGER1 := ftSqlType;
      stLONG1 := cbColDef;
      stINTEGER2 := ibScale;
      stINTEGER3 := fNullable;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLDescribeParam(stStmt,
                                             stWORD1,
                                             stINTEGER1,
                                             stLONG1,
                                             stINTEGER2,
                                             stINTEGER3);
      SwitchStackBack;
      ftSqlType := stINTEGER1;
      cbColDef := stLONG1;
      ibScale := stINTEGER2;
      fNullable := stINTEGER3;
      sSQLDescribeParam := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLExtendedFetch(stmt : hstmt;
                           fFetchType : word;
                           irow : longint;
                           var crow : LongInt;
                           var rgfRowStatus : word) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLExtendedFetch := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stWORD1 := fFetchType;
      stLONG1 := irow;
      stLONG2 := crow;
      stWORD1 := rgfRowStatus;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLExtendedFetch(stStmt,
                                             stWORD1,
                                             stLONG1,
                                             stLONG2,
                                             stWORD1);

      SwitchStackBack;
      crow := stLONG2;
      rgfRowStatus := stWORD1;
      sSQLExtendedFetch := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLForeignKeys(stmt : hstmt;
                         szPkTableQualifier : pchar;
                         cbPkTableQualifier : integer;
                         szPkTableOwner : pchar;
                         cbPkTableOwner : integer;
                         szPkTableName : pchar;
                         cbPkTableName : integer;
                         szFkTableQualifier : pchar;
                         cbFkTableQualifier : integer;
                         szFkTableOwner : pchar;
                         cbFkTableOwner : integer;
                         szFkTableName : pchar;
                         cbFkTableName : integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLForeignKeys := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stPChar1 := szPkTableQualifier;
      stINTEGER1 := cbPktableQualifier;
      stPChar2 :=  szPkTableOwner;
      stINTEGER2 := cbPkTableOwner;
      stPChar3 := szPkTableName;
      stINTEGER3 := cbPkTableName;
      stPChar4 := szFkTableQualifier;
      stINTEGER4 := cbFkTableQualifier;
      stPChar5 := szFkTableOwner;
      stINTEGER5 := cbFkTableOwner;
      stPChar6 := szFkTableName;
      stINTEGER6 := cbFkTableName;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLForeignKeys(stStmt,
                                           stPChar1,
                                           stINTEGER1,
                                           stPChar2,
                                           stINTEGER2,
                                           stPChar3,
                                           stINTEGER3,
                                           stPChar4,
                                           stINTEGER4,
                                           stPChar5,
                                           stINTEGER5,
                                           stPChar6,
                                           stINTEGER6);
      SwitchStackBack;
      sSQLForeignKeys := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLMoreResults(stmt : hstmt) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLMoreResults := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLMoreResults(stStmt);
      SwitchStackBack;
      sSQLMoreResults := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLNativeSQL(dbc : hdbc;
                       szSQLStrIn : pchar;
                       cbSQLStrIn : longint;
                       szSQLStr : pchar;
                       cbSQLStrMax : longint;
                       var cbSQLStr : longint) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLNativeSQL := SQLERROR
   ELSE
   BEGIN
      stDbc := dbc;
      stPChar1 := szSQLStrIn;
      stLONG1 := cbSQLStrIn;
      stPChar2 := szSQLStr;
      stLONG2 := cbSQLStrmax;
      stLONG3 := cbSQLStr;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLNativeSQL(stDBC,
                                         stPChar1,
                                         stLONG1,
                                         stPChar2,
                                         stLONG2,
                                         stLONG3);
      SwitchStackBack;
      cbSQLStr := stLONG3;
      sSQLNativeSQL := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLNumParams(stmt : hstmt;
                       var cpar : integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLNumParams := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stINTEGER1 := cpar;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLNumParams(stStmt,stINTEGER1);
      SwitchStackBack;
      cpar := stINTEGER1;
      sSQLNumParams := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLParamOptions(stmt : hstmt;
                          crow : LongInt;
                          var irow : LongInt) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLParamOptions := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stLONG1 := crow;
      stLONG2 := irow;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLParamOptions(stStmt,stLONG1,stLONG2);
      SwitchStackBack;
      irow := stLONG2;
      sSQLParamOptions := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLPrimaryKeys(stmt : hstmt;
                         szTableQualifier : pchar;
                         cbTableQualifier : integer;
                         szTableOwner : pchar;
                         cbTableOwner : integer;
                         szTableName : pchar;
                         cbTableName : integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLPrimaryKeys := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stPChar1 := szTableQualifier;
      stINTEGER1 := cbTableQualifier;
      stPChar2 := szTableOwner;
      stINTEGER2 := cbTableOwner;
      stPChar3 := szTableName;
      stINTEGER3 := cbTableName;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLPrimaryKeys(stStmt,
                                           stPChar1,
                                           stINTEGER1,
                                           stPChar2,
                                           stINTEGER2,
                                           stPChar3,
                                           stINTEGER3);
      SwitchStackBack;
      sSQLPrimaryKeys := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLProcedureColumns(stmt : hstmt;
                              szProcQualifier : pchar;
                              cbProcQualifier : integer;
                              szProcOwner : pchar;
                              cbProcOwner : integer;
                              szProcName : pchar;
                              cbProcName : integer;
                              szColumnName : pchar;
                              cbColumnName : integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLProcedureColumns := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stPChar1 := szProcQualifier;
      stINTEGER1 := cbProcQualifier;
      stPChar2 := szProcOwner;
      stINTEGER2 := cbProcOwner;
      stPChar3 := szProcName;
      stINTEGER3 := cbProcName;
      stPChar4 := szColumnName;
      stINTEGER4 := cbColumnName;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLProcedureColumns(stStmt,
                                                stPChar1,
                                                stINTEGER1,
                                                stPChar2,
                                                stINTEGER2,
                                                stPChar3,
                                                stINTEGER3,
                                                stPChar4,
                                                stINTEGER4);
      SwitchStackBack;
      sSQLProcedureColumns := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLProcedures(stmt : hstmt;
                        szProcQualifier : pchar;
                        cbProcQualifier : integer;
                        szProcOwner : pchar;
                        cbProcOwner : integer;
                        szProcName : pchar;
                        cbProcName : integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLProcedures := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stPChar1 := szProcQualifier;
      stINTEGER1 := cbProcQualifier;
      stPChar2 := szProcOwner;
      stINTEGER2 := cbProcOwner;
      stPChar3 := szProcName;
      stINTEGER3 := cbProcName;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLProcedures(stStmt,
                                          stPChar1,
                                          stINTEGER1,
                                          stPChar2,
                                          stINTEGER2,
                                          stPChar3,
                                          stINTEGER3);
      SwitchStackBack;
      sSQLProcedures := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLSetPos(stmt : hstmt;
                    irow : word;
                    fRefresh : bool;
                    fLock : bool) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLSetPos := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stWORD1 := irow;
      stBOOL1 := fRefresh;
      stBOOL2 := fLock;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLSetPos(stStmt,
                                      stWORD1,
                                      stBOOL1,
                                      stBOOL2);
      SwitchStackBack;
      sSQLSetPos := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLSetScrollOptions(stmt : hstmt;
                              fConcurrency : word;
                              crowKeyset : longint;
                              crowRowset : word) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLSetScrollOptions := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stWORD1 := fConCurrency;
      stLONG1 := crowKeySet;
      stWORD2 := crowRowSet;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLSetScrollOptions(stStmt,
                                                stWORD1,
                                                stLONG1,
                                                stWORD2);
      SwitchStackBack;
      sSQLSetScrollOptions := stRetCode;
   END
END;

{ ----------------------------------------------------------------------- }

FUNCTION sSQLTablePrivileges(stmt : hstmt;
                             szTableQualifier : pchar;
                             cbTableQualifier : integer;
                             szTableOwner : pchar;
                             cbTableOwner : integer;
                             szTableName : pchar;
                             cbTableName : integer) : TRetCode;
BEGIN
   IF OdbcDLL = NIL THEN
      sSQLTablePrivileges := SQLERROR
   ELSE
   BEGIN
      stStmt := stmt;
      stPChar1 := szTableQualifier;
      stINTEGER1 := cbTableQualifier;
      stPChar2 := szTableOwner;
      stINTEGER2 := cbTableOwner;
      stPChar3 := szTableName;
      stINTEGER3 := cbTableName;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stRetCode := odbcDLL^.SQLTablePrivileges(stStmt,
                                               stPChar1,
                                               stINTEGER1,
                                               stPChar2,
                                               stINTEGER2,
                                               stPChar3,
                                               stINTEGER3);
      SwitchStackBack;
      sSQLTablePrivileges := stRetCode;
   END
END;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

BEGIN
END.

