(***************************************************************************************)
(*  ODLIST.PAS   - Everything you ever wanted to know about owner-drawn list boxes,    *)
(*                 but were afraid to as because the answer was so nasty.              *)
(*  Brad Stowers - Internet:   bstowers@ix.netcom.com                                  *)
(*                 CompuServe: 72733, 3374                                             *)
(*  Version 0.90 - Not everything is finished quite yet.                               *)
(*  Last updated - 08/31/94, Brad Stowers, Initial release.                            *)
(***************************************************************************************)
(*  This work is in no way copyrighted, protected, or even claimed by the author.      *)
(*  You may use this in any way you see fit, for whatever purposes you want, and will  *)
(*  NOT hold the author responsible for ANYTHING when it blows up in your face.        *)
(*  Most of the bitmap work was gleaned from Peter Gruhn and various magazines.  A lot *)
(*  of the general form and structure was learned from other O/D Listboxes in BPascal. *)
(*  The text drawing was a lot of digging around in the API.                           *)
(***************************************************************************************)


{-------------------------------------}
{         TO DO / BROKEN LIST         }
{-------------------------------------}
{ * WILL NOT WORK WITH SORT!!!!!!!!!  }
{                                     }
{ * CLIPPED IS FREAKED OUT!!!!!!!!!!  }
{   Make sure you have ClipToRect Set }
{                                     }
{ * Bitmaps only work on left align   }
{                                     }
{ * If the listbox is owned by a dlg  }
{   and you set the visible flag,     }
{   it'll go wacky.  Also, if you set }
{   a font name and size, it'll go    }
{   wacky in the same manner.         }
{-------------------------------------}

unit ODList;

interface

uses OWindows, ODialogs, WinProcs, WinTypes;

type

  { Handy array type to have.  Many of the messages will be passing pIntArrays around in lParam }
  pIntArray = ^tIntArray;
  tIntArray = array [0..32766] of integer;

  { The options that can be specified for the listbox.                                           }
  {     Horizontal  - Horizontal dotted lines should be drawn below ever item in the listbox.    }
  {     Vertical    - Vertial dotted lines should be drawn after each item (tabstop) in a line.  }
  {     LeftAlign  \                                                                             }
  {     RightAlign  - The default alignment for each text item (tabstop) in a line.              }
  {     CenterAlign/                                                                             }
  tODOptions = (Horizontal, Vertical, LeftAlign, CenterAlign, RightAlign, ClipToCell);
  tODOptsSet = set of tODOptions;

const
  { The formatting characters allowed in each cell's string.  These overide the defaults that   }
  { were specified in the Init, InitResource or ResetOptions constructor.  By using these, you  }
  { can have all strings right aligned by default, with certain ones centered or left align,    }
  { for example.  Also, using fmtBitmap followed by the bitmap handle, you can embed a bitmap   }
  { at the left of the cell, and still have text displayed with it in the default alignment.    }
  { See the demo for an easy way to insert bitmap handles.                                      }
  fmtLeft   = #1;  { Align text left   }
  fmtCenter = #2;  { Align text right  }
  fmtRight  = #3;  { Align text center }
  fmtBitmap = #4;  { 5 characters following this will be the handle to a bitmap in decimal }
  { #4nnnn = Bitmap handle as a 5 digit 0 padded string. ( 09381 ) }
  {          Use WVSPrintF(BmpStr, '%05u', BmpHandle);             }

  FormatChars    = [fmtLeft .. fmtBitmap];  { Handy set for checking for format characters }

type
  { The listbox object }
  pODListBox = ^tODListBox;
  tODListBox = object(tListBox)
    constructor Init(AParent: PWindowsObject;             { The owner of the listbox   }
                     AnId,                                { The ID of the listbox      }
                     X,Y,W,H,                             { Coordinates                }
                     AMaxChars,                           { Maximum chars between tabs }
                     AMaxTabs: Integer;                   { Maximum number of tabs     }
                     ATabArray: pIntArray;                { Pointer to the tab array   }
                     AOpts: tODOptsSet;                   { Options for the listbox    }
                     AMaskColor: TColorRef);              { Color in bmps to be invis. }

    constructor InitResource(AParent: PWindowsObject;     { The owner of the listbox   }
                             AnID,                        { The ID of the listbox      }
                             AMaxChars,                   { Maximum chars between tabs }
                             AMaxTabs: Integer;           { Maximum number of tabs     }
                             ATabArray: pIntArray;        { Pointer to the tab array   }
                             AOpts: tODOptsSet;           { Options for the listbox    }
                             AMaskColor: TColorRef);      { Color in bmps to be invis. }
    procedure   SetupWindow;                              virtual;
    destructor  Done;                                     virtual;

    { Get the options currently assigned to the listbox.                               }
    procedure   GetOptions(var TheOpts: tODOptsSet);
    { Change the options initially specified for the listbox.  It will redraw itself   }
    procedure   ResetOptions(NewOpts: tODOptsSet);

    procedure   lbSetTabStops(var Msg: TMessage);         virtual wm_First + lb_SetTabStops;
    procedure   lbSetHorizontalExtent(var Msg: TMessage); virtual wm_First + lb_SetHorizontalExtent;

    procedure   wmMeasureItem(var Msg: TMessage);         virtual wm_First + wm_MeasureItem;
    procedure   DrawItem(CtrlID: integer;
                      DrawItemStruct: PDrawItemStruct);   virtual;
    procedure   wmDrawItem(var Msg:TMessage);             virtual wm_First + wm_DrawItem;
  private
    Opts: tODOptsSet;             { The desired options                                }
    MaxTabs,                      { Maxiumum number of tab stops                       }
    MaxChars: integer;            { Maximum number of characters between tab stops     }
    TabStopArray,                 { Pointer to the tabs stop array                     }
    PixelStopArray: pIntArray;    { Pointer to the tabs stop array converted to pixels }
    MaskColor: TColorRef;         { The color in bitmaps to be treated as invisible    }

    function    GetHorizExtent: word;                     { Returns the max width of a line  }
    procedure   CreatePixelArray(AMaxTabs: word);         { Converts the tab stops to pixels }
  end;



implementation

uses Strings;

const
  { ROP_DSPDxax is a Raster OPeration code, like SRCCOPY, to be used in BitBlt calls.         }
  { I found this in July '93 Windows Tech Journal.  It didn't explain anything about it, but  }
  { Chapter 11 of the Windows API Volume II does.  Reverse Polish Notation...  Has to do with }
  { pushing items like the source bitmap and selected brushes (Capital letters) on a stack,   }
  { and then doing binary operations (the lowercase letters) on the top two items and push    }
  { that result back on to the stack.  All very twisted, but the result is something close to }
  { a transparent BitBlt.  Very useful to know.                                               }
  ROP_DSPDxax           = $00E20746;
  { Will be used as a parameter in a LB_SETHORIZONTALEXTENT message to identify a special     }
  { circumstance where processing is not needed.                                              }
  SKIP_PIXEL_PROCESSING = $B8AD;

constructor tODListBox.Init(AParent: PWindowsObject; AnId,X,Y,W,H,AMaxChars, AMaxTabs: Integer;
                            ATabArray: pIntArray; AOpts: tODOptsSet; AMaskColor: TColorRef);
begin
  { Basic stuff }
  inherited Init(AParent, AnID, X, Y, W, H);
  Attr.Style := Attr.Style or LBS_OWNERDRAWFIXED or LBS_HASSTRINGS;
  Opts := AOpts;
  MaxChars := AMaxChars;
  MaxTabs := AMaxTabs;
  TabStopArray := ATabArray;
  PixelStopArray := NIL;
  MaskColor := AMaskColor;
end;

constructor tODListBox.InitResource(AParent: PWindowsObject; AnID, AMaxChars, AMaxTabs: Integer;
                                    ATabArray: pIntArray; AOpts: tODOptsSet; AMaskColor: TColorRef);
begin
  { Basic stuff }
  inherited InitResource(AParent, AnID);
  Opts := AOpts;
  MaxChars := AMaxChars;
  MaxTabs := AMaxTabs;
  TabStopArray := ATabArray;
  PixelStopArray := NIL;
  MaskColor := AMaskColor;
end;

procedure tODListBox.SetupWindow;
begin
  inherited SetupWindow;
  { Have to wait until we have a valid hWindow before we can set the tab stops }
  SendMessage(hWindow, lb_SetTabStops, MaxTabs, LongInt(TabStopArray));
end;

destructor tODListBox.Done;
begin
  { We allocated the memory for the pixel array, so we better get rid of it }
  if Assigned(PixelStopArray) then FreeMem(PixelStopArray, (MaxTabs+1)*SizeOf(Integer));
  inherited Done;
end;

{ Would have rather used a function, but you can't return set types in BP }
procedure tODListBox.GetOptions(var TheOpts: tODOptsSet);
begin
  TheOpts := Opts;
end;

procedure tODListBox.ResetOptions(NewOpts: tODOptsSet);
begin
  { Set new options }
  Opts := NewOpts;
  { Need to redraw it all. }
  InvalidateRect(hWindow, NIL, FALSE);
end;

{ Converts all tab stops into their corresponding pixel stops.  I used this approach to  }
{ try to speed things up.  Instead of having to calculate the points to use for drawing  }
{ separator lines and such, we'll already have them available.  It's not much, but every }
{ little bit counts.                                                                     }
procedure tODListBox.CreatePixelArray(AMaxTabs: word);
var
  X: integer;
begin
  { Free up memory from old array }
  if Assigned(PixelStopArray) then FreeMem(PixelStopArray, (MaxTabs+1)*SizeOf(Integer));
  { Set new number of tab stops }
  MaxTabs := AMaxTabs;
  { Get some memory }
  GetMem(PixelStopArray, (MaxTabs+1)*SizeOf(Integer));
  { Loop through all the tab stops... }
  for X := 0 to MaxTabs-1 do begin
    {... converting each into its pixel representation }
    PixelStopArray^[X] := (((TabStopArray^[X]) * LoWord(GetDialogBaseUnits)) div 4)+X;
  end;
  { And setting the last pixel stop to the horizontal extent of a line, plus a bit }
  PixelStopArray^[MaxTabs] := GetHorizExtent + X;
end;

{ Calculate the maximum length, in pixels, of a line }
function tODListBox.GetHorizExtent: word;
var
  DC: HDC;
  TestStr: pChar;
  X,
  TestLen: word;
begin
  { Need 2 characters for each tabstop (a character and the tab) plus the maximum }
  { number of characters in one cell, plus a null terminator                      }
  TestLen := (MaxTabs*2)+MaxChars+1;
  GetMem(TestStr, TestLen);
  TestStr[0] := #0;
  { Use W's since they're about as big as they'll get. }
  for X := 1 to MaxTabs do
    StrCat(TestStr, 'W'#9);
  FillChar(TestStr[MaxTabs*2], MaxChars, 'W');
  { Now TestStr should look something like:    'W'#9'W'#9'W'#9'WWWWWWWWWWWWWWWWWW' }
  DC := GetDC(hWindow);
  { Uset API function GetTabbedTextExtent to measure the lenght of our test string }
  GetHorizExtent := LoWord(GetTabbedTextExtent(DC, TestStr, TestLen-1, MaxTabs, PixelStopArray^));
  ReleaseDC(hWindow, DC);
  FreeMem(TestStr, TestLen);
end;

{ Have to intercept lbSetTabStops messages because we need to update our pixel array. }
procedure tODListBox.lbSetTabStops(var Msg: TMessage);
begin
  TabStopArray := pIntArray(Msg.lParam);
  DefWndProc(Msg);
  CreatePixelArray(Msg.wParam);
  { Update the horizontal extents of the listbox.  We pass a special lParam to let the ourselves }
  { know that we want the default windows processing to occur ONLY.  }
  SendMessage(hWindow, lb_SetHorizontalExtent, PixelStopArray^[MaxTabs], SKIP_PIXEL_PROCESSING);
end;

procedure tODListBox.lbSetHorizontalExtent(var Msg: TMessage);
begin
  { Only do this if we're not coming from lbSetTabStops }
  if Msg.lParam <> SKIP_PIXEL_PROCESSING then begin
    CreatePixelArray(MaxTabs);
    Msg.wParam := GetHorizExtent;
    PixelStopArray^[MaxTabs] := integer(Msg.wParam);
    Msg.lParam := 0;
  end;
  DefWndProc(Msg);
end;

procedure tODListBox.wmMeasureItem(var Msg: TMessage);
var
  DC: HDC;
  TextMetrics: TTextMetric;
  Result: boolean;
begin
  DC := GetDC(hWindow);
  Result := GetTextMetrics(DC, TextMetrics);
  ReleaseDC(hWindow, DC);
  with TextMetrics, PMeasureItemStruct(Msg.LParam)^ do begin
    if Result then
      ItemHeight := tmHeight + tmExternalLeading
    else
      ItemHeight := 20;
    if Horizontal in Opts then Inc(ItemHeight);
  end;
  Msg.Result := 1;
end;


{ The preparation for drawing an item }
procedure tODListBox.wmDrawItem(var Msg:TMessage);
var
  OldColor: TColorRef;
  OldBkGnd: TColorRef;
  Brush: HBrush;
  FR: tRect;
begin
  with PDrawItemStruct(Msg.LParam)^ do begin
    { Make a copy of the supplied rectange because we want to modify it }
    FR := rcItem;
    { Move the bottom of the rectangle up a pixel if we have horizontal separators on. }
    if Horizontal in Opts then
      dec(FR.Bottom);
    { Draw the focus rectangle }
    DrawFocusRect(hDC, FR);
    if (itemAction and (oda_DrawEntire or oda_Select )) <> 0 then begin
      if (itemState and ods_Selected) <> 0 then begin
      { if the item is selected, it needs the highlight color }
        OldColor := SetTextColor(hDC, GetSysColor(COLOR_HIGHLIGHTTEXT));
        OldBkGnd := SetBkColor(hDC, GetSysColor(COLOR_HIGHLIGHT));
        Brush    := CreateSolidBrush(GetSysColor(COLOR_HIGHLIGHT));
      end else begin
      { otherwise it needs the regular window color           }
        OldColor := SetTextColor(hDC, GetSysColor(COLOR_WINDOWTEXT));
        OldBkGnd := SetBkColor(hDC, GetSysColor(COLOR_WINDOW));
        Brush    := CreateSolidBrush(GetSysColor(COLOR_WINDOW));
      end;
      { Fill the rectangle with the appropriate background color }
      FillRect(hDC, rcItem, Brush);
      { Draw the item }
      DrawItem(CtlID, PDrawItemStruct(Msg.LParam));
      { Restor colors and clean up resources }
      SetTextColor(hDC, OldColor);
      SetBkColor(hDC, OldBkGnd);
      DeleteObject(Brush);
    end;
  end;
  Msg.Result := 1;
end;

{ Thanks to Sean Palmer for the asm }
function maxIntOf(X,Y:Integer):Integer;
label Done;
begin asm  { Return value goes in ax }
  pop ax   { y }
  pop dx   { x }
  cmp ax,dx
  jge Done
  mov ax, dx
  Done:
  end;
end;

function minIntOf(X,Y:Integer):Integer;
label Done;
begin asm  { Return value goes in ax }
  pop ax   { y }
  pop dx   { x }
  cmp ax,dx
  jle Done
  mov ax, dx
  Done:
  end;
end;

{ Here's the guts of the whole thing.  It gets sticky in places but I'll comment }
{ as best I can.  Could still stand some optimization, so please, suggest away.  }
procedure tODListBox.DrawItem(CtrlID: integer; DrawItemStruct: PDrawItemStruct);
var
  TabScan,
  LBString,
  TheString: pChar;
  ClipOpts,
  Alignment,
  TheLen: word;
  Counter,
  X: integer;
  R: TRect;
  MemBM: TBitmap;
  BmpHandle: tHandle;
  BmpStr: array[0..5] of char;
  FormatChar: char;
  GrayPen: hPen;
label
  INC_STRING_AND_LOOP;  { That's right, I'm gonna use a goto.  It's used responsibly, }
                        { so nobody should get hurt.                                  }

  { Draw a separator line between cells.  I've localized here so that it's easy to find }
  { and change if you don't like the line style I chose.                                }
  procedure DrawSep(X1, Y1, X2, Y2: integer);
  var
    OldObject: THandle;
  begin
    with DrawItemStruct^ do begin
      { We could be drawing several of these lines during one DrawItem, so I created }
      { the pen at the start of DrawItem.  Saves a few nanoseconds                   }
      OldObject := SelectObject(hDC, GrayPen);
      MoveTo(hDC, X1, Y1);
      LineTo(hDC, X2, Y2);
      SelectObject(hDC, OldObject);
    end;
  end;

  { Calculate coords for ExtTextOut, accounting for Text Alignment. }
  function CalcLeftCoord(DC: hDC; Left, Right: integer): Integer;
  var
    NewX: Integer;
    Align: word;
  begin
    { Use current alignment so we can change it on the fly }
    Align := GetTextAlign(DC);
    NewX := Left;
    { Center alignment wants X to be the exact center of the rectangle }
    if (TA_CENTER and Align) = TA_CENTER then
      Inc(NewX, ((Right-Left) div 2))
    { Right alignment wants X to be the right side of the rectangle, plus a bit of margin }
    else if (TA_RIGHT and Align) = TA_RIGHT then
      NewX := Right-2;
    { else default to current pos }
    CalcLeftCoord := NewX;
  end;

  { Find the next highest pixel stop from the pixel passed in. }
  function NextStopUp(X: integer): integer;
  var
    Next,
    I: integer;
  begin
    { Default to the last stop }
    NextStopUp := PixelStopArray^[MaxTabs];
    { loop through the array }
    for I := 0 to MaxTabs-1 do
      { See if current iteration is bigger }
      if PixelStopArray^[I] > X then begin
        { It is, so set it and exit now }
        NextStopUp := PixelStopArray^[I];
        exit;
      end;
    { Never found one, so use default set above. }
  end;

  { Draw a bitmap masking out the specified color.  This is not a true transparent blt as it will }
  { not leave existing pixels alone, but it does do what we need here (leaves background color).  }
  { OPTIMIZE ME }
  procedure DrawBmp(TheDC: hDC; BmpHandle: hBitmap; MemBM: TBitmap; R: TRect; MASKCOLOR: tColorRef);
  var
    MaskDC,
    MemDC : HDC;
    OldTxtColor,
    OldBkColor: tColorRef;
    MaskBmp: hBitmap;
    OldObject: tHandle;
    YOff: integer;
  begin
    { Create a DC for the bitmap and for a mask of the bitmap }
    MemDC := CreateCompatibleDC(TheDC);
    MaskDC := CreateCompatibleDC(TheDC);
    { Create a copy of the bitmap to use a the mask }
    with MemBM do MaskBmp := CreateCompatibleBitmap(MaskDC, bmWidth, bmHeight);
    { Put the bitmap into the memory DC }
    SelectObject(MemDC, BmpHandle);
    { Put the copy into the mask DC }
    SelectObject(MaskDC, MaskBmp);
    { Set the memory DC background to the mask color }
    OldBkColor := SetBkColor(MemDC, MASKCOLOR);
    { Blt the memory bitmap into the mask DC }
    with MemBM do BitBlt(MaskDC, 0, 0, bmWidth, bmHeight, MemDC, 0, 0, SRCCOPY);
    { restore the background color }
    SetBkColor(MemDC, OldBkColor);
    { find an offset so we can vertically center the bitmap }
    YOff := (((R.Bottom - R.Top) - MemBM.bmHeight) div 2)+1;
    { blt the memory bitmap into the real DC }
    with MemBM do BitBlt(TheDC, R.Left, R.Top+YOff, bmWidth, bmHeight, MemDC, 0, 0, SRCCOPY);
    { create and select a brush that is our background color into the real DC }
    OldObject := SelectObject(TheDC, CreateSolidBrush(GetBkColor(TheDC)));
    { Set the text color to black }
    OldTxtColor := SetTextColor(TheDC, 0);
    { Set the background color to white }
    OldBkColor := SetBkColor(TheDC, RGB(255,255,255));
    { Blt the mask bitmap onto the real DC using our special raster operation.  See above }
    with MemBM do BitBlt(TheDC, R.Left, R.Top+YOff, bmWidth, bmHeight, MaskDC, 0, 0, ROP_DSPDxax);
    { Clean up our brush }
    DeleteObject(SelectObject(TheDC, OldObject));
    { restore our colors }
    SetTextColor(TheDC, OldTxtColor);
    SetBkColor(TheDC, OldBkColor);
    { clean up our DCs }
    DeleteDC(MemDC);
    DeleteDC(MaskDC);
    { delete our mask copy of the bitmap }
    DeleteObject(MaskBmp);
  end;

begin
  { Create a gray pen to draw the separator lines with. }
  GrayPen := CreatePen(PS_SOLID, 1, RGB(128,128,128));
  with DrawItemStruct^, rcItem do begin
    { Get memory for the listbox string }
    GetMem(LBString, 1024);
    { Make a copy of the string }
    SendMessage(hwndItem, LB_GETTEXT, ItemId, longint(LBString));

    { Make sure we are transparent... *OPT* do we have to be since we draw lines after? }
    { Don't seem to need this after all. }
    { SetBkMode(hDC, Transparent);}

    { Set the default Alignment mode. }
    if CenterAlign in Opts then
      Alignment := TA_CENTER
    else if RightAlign in Opts then
      Alignment := TA_RIGHT
    else
      Alignment := TA_LEFT;                 { Defalt to left alignment       }
    SetTextAlign(hDC, Alignment);

    { Get everything initialized }
    TheString := LBString;
    Counter := 0;
    R := rcItem;
    R.Left := Left+2;  { Plus 2 for a bit of margin }
    { Draw each item. }
    repeat
      { Find the string for this cell by searching for the next tab }
      TabScan := StrScan(TheString, #9);
      { Pointer math to calculate the string len....  Yeechhhhh.    }
      if Assigned(TabScan) then TheLen := TabScan-TheString
      { otherwise there are no more tabs, just a terminating null.  }
      else TheLen := StrLen(TheString);

      { Set up Right boundary and see if we even need to display this string. }
      R.Right := NextStopUp(R.Left);
      if R.Left > rcItem.Right then break;        { No sense drawing it if it ain't in the DC      }
                                                  { Past right margin, so we're done with the loop }

      if R.Right < rcItem.Left then GOTO INC_STRING_AND_LOOP; { Don't draw if it ain't on the DC   }
                                                  { Coming in from left, still need to check rest  }

      { Assume that there is not a bitmap in the string. }
      BmpHandle := 0;
      { Check for formatting or bitmap handle characters }
      FormatChar := TheString[0];
      if FormatChar in FormatChars then begin
        Inc(TheString); { Skip the pointer up to the next character in the string, past format char}
        Dec(TheLen);    { Don't forget to adjust the string length because we calculated it above. }
        case FormatChar of
          #1: { Left align cell }
              Alignment := SetTextAlign(hDC, TA_LEFT);        { Save old alignment }
          #2: { Center align cell }
              Alignment := SetTextAlign(hDC, TA_CENTER);      { Save old alignment }
          #3: { Right align cell }
              Alignment := SetTextAlign(hDC, TA_RIGHT);       { Save old alignment }
          #4: { Bitmap Handle }
            begin
              StrLCopy(BmpStr, TheString, 5);     { Get the bitmap handle          }
              Inc(TheString, 5);                  { Jump past the handle chars     }
              Dec(TheLen, 5);                     { Adjust the string lenght       }
              Val(BmpStr, BmpHandle, X);          { Make the string a number       }
              if X <> 0 then BmpHandle := 0;      { Invalid bitmap if couldn't Val }
            end;
        else
          { no formatting characters, do nothing special. should not even get here }
        end;
      end; { of format character checking }

      { Non-clipped cells don't work yet... }
      { Set clipping options. }
      if {ClipToCell in Opts} TRUE then ClipOpts := ETO_CLIPPED or ETO_OPAQUE
      else ClipOpts := ETO_OPAQUE;

      { Did we have a bitmap? }
      if BmpHandle <> 0 then begin
        { Get some size info about the bitmap. }
        GetObject(BmpHandle, Sizeof(MemBM), @MemBM);
        { Draw the sucker. }
        DrawBmp(hDC, BmpHandle, MemBM, R, MASKCOLOR);
        { Update start of rect so we don't draw text over the bitmap. }
        Inc(R.Left, MemBM.bmWidth+2);
      end;

      { Draw the text }
      ExtTextOut(hDC, CalcLeftCoord(hDC, R.Left, R.Right), R.Top, ClipOpts, @R, TheString, TheLen, NIL);

      { Draw the vertical seperator if we want one. }
      { This is going to screw up when I try to put in clip to cell }
      if {ClipToCell in Opts} TRUE then begin
        if (Vertical in Opts) and (Counter < MaxTabs) then
          DrawSep(R.Right-1, R.Top, R.Right-1, R.Bottom);
      end;

      {Restore Default alignment }
      SetTextAlign(hDC, Alignment);

      { Set up next left boundary }
      R.Left := R.Right+1;

{ ******************* Non-clipping still doesn't work right...... ***************************** }
    (*else begin
        This is NOT going to work if it goes past 1 tab stop... MaxTabs-Count+1, Array[Count]???}
        TestLen := R.Left + LoWord(GetTabbedTextExtent(
                   hDC, TheString, TheLen+1, 1, PixelStopArray^[Counter]));
        R.Left := R.Right+1;
        while TestLen > R.Left do begin
          R.Left := NextStopUp(R.Left)+1;
        end;
      end;*)
{ ******************* Non-clipping still doesn't work right...... ***************************** }

INC_STRING_AND_LOOP:          { Quick jump to get string ready for next repeat loop   }
      TheString := TabScan+1; { Next string starts at one character past the next tab }
      inc(Counter);
    until TabScan = NIL;      { No more strings to draw. }

(* This is more stuff for non-working, non-clipped cells....
    if Vertical in Opts then { Don't bother if we don't need them }
      if (Counter < MaxTabs) and (LoWord(GetCurrentPosition(hDC)) < rcItem.Right) then
        for x := Counter to MaxTabs-1 do begin
{         TabStop := PixelStopArray^[x];
          if x>0 then Dec(TabStop,PixelStopArray^[x-1]);
          Inc(CurLeft,TabStop);
          MoveTo(hDC, CurLeft, Top);
          DrawVertSep;}
        end;
*)

    { Don't forget the last separator (Horizontally speaking) }
    if (Horizontal in Opts) then
       DrawSep(rcItem.Left, rcItem.Bottom-1, rcItem.Right, R.Bottom-1);
  end;
  { Free the memory we allocated for the string }
  FreeMem(LBString, 1024);
  { Clean up our separator brush }
  DeleteObject(GrayPen);
end;

end. { o' the file }


