Unit SlideBox;
{ an owner draw slidebox, by Scott Stephenson }
{ 6 July 94 }


interface

uses Objects,
     OWindows,
     ODialogs,
     WinTypes,
     WinProcs,
     strings;

type pSlideBox = ^tSlideBox;
     TSlideBox = object(TButton)
     low          : longint;
     high         : longint;
     increment    : longint;
     labelinterval: longint;
     markInterval : longint;
     where        : longint;
     oneUnit      : real;
     bkColor      : tcolorref;
     r            : trect;
     sliderTitle  : string;
     timerrightset,
     timerleftset : boolean;
     leftrect     ,
     rightrect    ,
     innerrect    : trect;
     texthigh     : integer;
     function  GetClassName: PChar; virtual;
     procedure wmlbuttondown  (var msg: tmessage); virtual wm_first + wm_lbuttondown;
     procedure wmlbuttonup    (var msg: tmessage); virtual wm_first + wm_lbuttonup;
     procedure wmmousemove    (var msg: tmessage); virtual wm_first + wm_mousemove;
     procedure WMPaint        (var Msg: TMessage); virtual wm_First + wm_Paint;
     procedure DrawSlideBox;
     procedure setup(xlow, xhigh, xincrement, xlabelinterval, xmarkInterval: longint;
                     title: string; abkcolor: tcolorref);
     procedure setpos(x: longint);
     function  getpos: longint;
     procedure WMTimer    (var Msg: TMessage); virtual wm_First + Wm_Timer;
     end;


implementation

var buttonDown: boolean;
const timerleft = 2;
const timerright = 3;


function tSlidebox.GetClassName: PChar;
begin
getclassname:= 'SLIDEBOX';
end;

procedure tSlideBox.WMTimer      (var Msg: TMessage);
var x: longint;
    s: array[0..10] of char;
begin
case msg.wparam of
  timerleft  : begin
               if (where + low) > low then dec(where);
               drawslidebox;
               end;
  timerright : begin
               if (where + low) < high then inc(where);
               drawslidebox;
               end;
  else end;
end;


procedure tSlideBox.wmlbuttondown(var msg: tmessage);
var point: tpoint;
begin
point.x:= msg.lparamlo;
point.y:= msg.lparamhi;
if ptinrect(innerrect,point) then
  begin
  where:= round((msg.lparamlo - leftrect.right) / oneunit);
  drawSlideBox;
  buttondown:= true;
  setcapture(Hwindow);
  end
else if ptinrect(leftrect,point) then
  begin
  if (where + low) > low then dec(where);
  drawSlideBox;
  if not timerleftset then settimer(hwindow,timerleft,100,nil);
  timerleftset:= true;
  end
else if ptinrect(rightrect,point) then
  begin
  if (where + low) < high then inc(where);
  drawSlideBox;
  if not timerrightset then settimer(hwindow,timerright,100,nil);
  timerrightset:= true;
  end
else defchildproc(msg);
end;

function tSlideBox.Getpos: longint;
begin
getpos:= where + low;
end;


procedure tSlideBox.wmlbuttonup(var msg: tmessage);
begin
buttondown    := false;
timerrightset := false;
timerleftset  := false;
releasecapture;
killtimer(hwindow,timerleft);
killtimer(hwindow,timerright);
defchildproc(msg);
end;

procedure tSlideBox.wmmousemove(var msg: tmessage);
var point: tpoint;
begin
if timerleftset  then killtimer(hwindow,timerleft);
if timerrightset then killtimer(hwindow,timerright);
timerrightset:= false;
timerleftset:= false;
point.x:= integer(msg.lparamlo);
point.y:= integer(msg.lparamhi);
if ptinrect(innerrect,point) and buttondown then
  begin
  where:= round((msg.lparamlo - leftrect.right)/ oneunit);
  drawSlideBox;
  end;
defchildproc(msg);
end;



procedure tSlidebox.setup(xlow, xhigh, xincrement, xlabelinterval, xmarkInterval: longint;
                     title: string; abkcolor: tcolorref);
begin
bkColor       := abkColor;
slidertitle   := title;
timerleftset  := false;
timerrightset := false;
buttonDown    := false;
where         := 0;
low           := xlow;
high          := xhigh;
labelinterval := xlabelinterval;
markinterval  := xmarkinterval;
increment     := xincrement;
getclientrect(hwindow,r);
innerrect:= r;
with innerrect do
  begin
  left := left  + r.bottom;
  right:= right - r.bottom;
  end;
leftrect:= r;
with leftrect do
  begin
  right:= r.bottom;
  end;
rightrect:= r;
with rightrect do
  begin
  left:= right - bottom;
  end;
oneunit:= (innerrect.right  - innerrect.left) / (high - low);
end;

procedure tslideBox.setpos(x: longint);
begin
where:= x - low;
drawSlideBox;
end;

procedure tSlideBox.DrawSlideBox;
var circleRect : trect;
    textrect   : trect;
    oldRect    : trect;
    oldbitmap,
    copybitmap: hbitmap;
    dc,
    memdc      : hdc;
    count      : integer;
    oldpen     : hpen;
    oldbrush   : hbrush;
    backgroundbrush  : hbrush;
    wherebrush : hbrush;
    junk : integer;
    oldclip,
    newclip    : hrgn;
    s,s1: array[0..100] of char;
    OldFont,sliderfont:Hfont;
    sliderFontRec: TLogFont;
    polyarray: array [1..4] of tpoint;

begin
{ set up tools for drawing }
dc       := getdc(hwindow);
MemDC    := CreateCompatibleDC(DC);
texthigh:= round(hiword(gettextextent(memdc,'0',1)));
oldpen   := selectobject(memdc,getstockobject(black_pen));
oldbrush := selectobject(memdc,getstockobject(white_brush));
backgroundbrush  := createsolidbrush(bkColor);
wherebrush := createsolidbrush(rgb(255,0,0));
{ set up metrics for drawing }
CopyBitmap := CreateCompatibleBitmap(DC, r.right, r.bottom);
oldbitmap:= selectobject(memdc,copybitmap);
{ set the clipping region }
getclipbox(memdc,oldrect);
oldclip:= createrectrgn(oldrect.left,oldrect.top,oldrect.right,oldrect.bottom);
newclip:= createrectrgn(r.left  ,
                        r.top   ,
                        r.right  ,
                        r.bottom );
selectcliprgn(memdc,newclip);

(***************)
{ prepare fonts }
(***************)
FillChar(sliderFontRec, SizeOf(sliderFontRec), 0);
with sliderFontRec do
  begin
  lfHeight := -8 * GetDeviceCaps(memDC, LogPixelsY) div 72;  { 8 Point };
  StrpCopy(lfFaceName,'Arial');
  lfWeight := fw_normal;
  end;
sliderFont:= CreateFontIndirect(sliderFontRec);
oldfont:= SelectObject(memdc, sliderfont);


{ draw a shadowed border rectangle }
selectobject(memdc,backgroundbrush);
with r do
  begin
  rectangle(memdc,left,top,right,bottom);
  selectobject(memdc,getstockobject(white_pen));
  moveto(memdc,right - 2, top + 1);
  lineto(memdc,left + 1, top + 1);
  lineto(memdc,left + 1, bottom - 2);
  selectobject(memdc,getstockobject(black_pen));
  lineto(memdc,right - 2, bottom - 2);
  lineto(memdc,right - 2, top + 1);
  end;

{ draw the increment text and dots }
setbkmode(memdc,transparent);
for count:= low to high do
  begin
  str(count,s);
  {calculate a rectangle for scale text }
  with textrect do
    begin
    top:= 1;
    bottom:= round(innerrect.bottom / 2);
    left := leftrect.right + round(oneUnit * (count - low)) - texthigh;
    right:= leftrect.right + round(oneUnit * (count - low)) + texthigh;
    end;
  if (count - low) mod labelinterval = 0 then drawtext(memdc,s,strlen(s),textrect,dt_center or dt_top);
  if (count - low) mod markinterval = 0 then
    begin
    { draw the black index line }
    selectobject(memdc,getstockobject(black_pen));
    moveto(memdc,leftrect.right + round(oneunit * (count - low)),round(innerrect.bottom/2) );
    lineto(memdc,leftrect.right + round(oneunit * (count - low)),round(innerrect.bottom/2) - 5);
    { index line highlights don't look good, so don't draw them }
    end;
  end;

{ write the title and current value }
strpcopy(s,slidertitle);
textout(memdc,leftrect.right + 1,r.bottom- texthigh,s,strlen(s));
str(where + low,s);
junk:= round(loword(gettextextent(memdc,s,strlen(s))));
textout(memdc,rightrect.left - junk,r.bottom- texthigh,s,strlen(s));

{ draw the left arrow }
selectobject(memdc,getstockobject(black_pen));
selectobject(memdc,getstockobject(black_brush));
with leftRect do
  begin
  polyarray[1].x:= round(right / 2);
  polyarray[1].y:= top + round(bottom / 3);
  polyarray[2].x:= 3;
  polyarray[2].y:= round(bottom /2);
  polyarray[3].x:= polyarray[1].x;
  polyarray[3].y:= bottom - round(bottom / 3);
  polygon(memdc,polyarray,3);
  end;
{ draw the right arrow }
with rightRect do
  begin
  polyarray[1].x:= left + round((right - left) / 2);
  polyarray[1].y:= top + round(bottom / 3);
  polyarray[2].x:= right - 4;
  polyarray[2].y:= round(bottom /2);
  polyarray[3].x:= polyarray[1].x;
  polyarray[3].y:= bottom - round(bottom / 3);
  polygon(memdc,polyarray,3);
  end;

{ draw the center line }
with innerRect do
  begin
  selectobject(memdc,getstockobject(black_pen));
  moveto(memdc, left, round(bottom /2));
  lineto(memdc, right, round(bottom /2));
  selectobject(memdc,getstockobject(white_pen));
  moveto(memdc, left, round(bottom /2) + 1);
  lineto(memdc, right, round(bottom /2) + 1);
  end;

{ draw the currentposition }
selectobject(memdc,getstockobject(black_pen));
moveto(memdc,innerrect.left + round(where * oneUnit) - 2, r.bottom - 3);
lineto(memdc,innerrect.left + round(where * oneunit) - 2, round(r.bottom / 2) + 3);
lineto(memdc,innerrect.left + round(where * oneunit)    , round(r.bottom / 2) + 1);
lineto(memdc,innerrect.left + round(where * oneunit) + 2, round(r.bottom / 2) + 3);
lineto(memdc,innerrect.left + round(where * oneUnit) + 2, r.bottom - 3);
lineto(memdc,innerrect.left + round(where * oneUnit) - 2, r.bottom - 3);

{ white highlight }
selectobject(memdc,getstockobject(white_pen));
moveto(memdc,innerrect.left + round(where * oneUnit) - 1, r.bottom - 4);
lineto(memdc,innerrect.left + round(where * oneunit) - 1, round(r.bottom / 2) + 2);

{ black highlight }
selectobject(memdc,getstockobject(black_pen));
moveto(memdc,innerrect.left + round(where * oneUnit) + 1, r.bottom - 4);
lineto(memdc,innerrect.left + round(where * oneunit) + 1, round(r.bottom / 2) + 2);

setbkmode(memdc,opaque);
setbkmode(memdc,transparent);

{ draw an x at the center }
BitBlt(DC, 0, 0, r.right, r.bottom, memDC, 0, 0, srcCopy);
{ clean up }
selectcliprgn(memdc,oldclip);
selectobject(memdc,oldpen);
selectobject(memdc,oldbitmap);
selectobject(memdc,oldbrush);
selectobject(memdc,oldfont);
deleteobject(sliderFont);
deleteobject(copybitmap);
deleteobject(oldclip);
deleteobject(backgroundbrush);
deleteobject(wherebrush);
deleteobject(newclip);
releasedc(hwindow,dc);
deletedc(memdc);
end;

procedure tSlideBox.WMPaint(var Msg: TMessage);
begin
drawSlideBox;
defchildproc(msg);
end;


begin
end.